/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twaver.AlarmSeverity;
import twaver.AlarmState;
import twaver.Data;
import twaver.Defaults;
import twaver.IData;
import twaver.IElement;
import twaver.IStyle;
import twaver.Styles;
import twaver.XMLSerializer;

public class Element
extends Data
implements IElement {
    private Object layerID = Defaults.LAYER_DEFAULT_ID;
    private AlarmState alarmState = new AlarmState(this);
    private Map<String, Object> styleMap = null;

    public Element() {
        this(null);
    }

    public Element(Object id) {
        super(id);
    }

    @Override
    public Object getLayerID() {
        return this.layerID;
    }

    @Override
    public void setLayerID(Object layerID) {
        Object oldValue = this.layerID;
        this.layerID = layerID;
        this.dispatchPropertyChangeEvent("layerID", oldValue, layerID);
    }

    @Override
    public AlarmState getAlarmState() {
        return this.alarmState;
    }

    @Override
    public boolean isAdjustedToBottom() {
        return false;
    }

    @Override
    public Class<?> getElementUIClass() {
        return null;
    }

    @Override
    public Object getStyle(String styleProp) {
        return this.getStyle(styleProp, true);
    }

    @Override
    public Object getStyle(String styleProp, boolean returnDefaultIfNull) {
        Object value = null;
        if (this.styleMap != null) {
            value = this.styleMap.get(styleProp);
        }
        if (value == null) {
            return Styles.getStyle(styleProp);
        }
        return value;
    }

    public IStyle setStyle(String styleProp, int newValue) {
        return this.setStyle(styleProp, (Object)newValue);
    }

    public IStyle setStyle(String styleProp, double newValue) {
        return this.setStyle(styleProp, (Object)newValue);
    }

    public IStyle setStyle(String styleProp, boolean newValue) {
        return this.setStyle(styleProp, (Object)newValue);
    }

    @Override
    public IStyle setStyle(String styleProp, Object newValue) {
        if (styleProp == null) {
            throw new NullPointerException("styleProp");
        }
        if (this.styleMap == null) {
            this.styleMap = Collections.synchronizedMap(new HashMap());
        }
        Object oldValue = this.styleMap.get(styleProp);
        if (newValue == null) {
            this.styleMap.remove(styleProp);
        } else {
            this.styleMap.put(styleProp, newValue);
        }
        if (this.dispatchPropertyChangeEvent("S:" + styleProp, oldValue, newValue)) {
            this.onStyleChanged(styleProp, oldValue, newValue);
        }
        return this;
    }

    protected void onStyleChanged(String styleProp, Object oldValue, Object newValue) {
    }

    public Map<String, Object> getStyleProperties() {
        return this.styleMap;
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        if (this.styleMap != null) {
            for (Map.Entry<String, Object> entry : this.styleMap.entrySet()) {
                this.serializeStyle(serializer, entry.getKey().toString(), newInstance);
            }
        }
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "layerID", newInstance);
        if (this.alarmState.getHighestNativeAlarmSeverity() != null && "alarmState".equals(serializer.getSettings().getPropertyType("alarmState"))) {
            int count;
            AlarmSeverity severity;
            int i;
            serializer.getXmlString().append("\t<p n='alarmState'>\n");
            List<AlarmSeverity> list = AlarmSeverity.getSeverities();
            int size = list.size();
            for (i = 0; i < size; ++i) {
                severity = list.get(i);
                count = this.alarmState.getNewAlarmCount(severity);
                if (count <= 0) continue;
                serializer.getXmlString().append("\t\t<n n='" + severity.getName() + "' c='" + count + "'/>\n");
            }
            for (i = 0; i < size; ++i) {
                severity = list.get(i);
                count = this.alarmState.getAcknowledgedAlarmCount(severity);
                if (count <= 0) continue;
                serializer.getXmlString().append("\t\t<a n='" + severity.getName() + "' c='" + count + "'/>\n");
            }
            serializer.getXmlString().append("\t</p>\n");
        }
    }

    protected void serializeStyle(XMLSerializer serializer, String stylePrope, IData newInstance) {
        serializer.serializeStyle(this, stylePrope, (IStyle)((Object)newInstance));
    }

    @Override
    public void deserializeXML(XMLSerializer serializer, String prefix, String prop, Node pNode) {
        super.deserializeXML(serializer, prefix, prop, pNode);
        this.deserializeStyle(serializer, prop, pNode);
    }

    protected void deserializeStyle(XMLSerializer serializer, String prop, Node pNode) {
        serializer.deserializeStyle(this, prop, pNode);
    }

    @Override
    protected void deserializeProperty(XMLSerializer serializer, String prop, Node pNode) {
        if ("alarmState".equals(prop)) {
            if ("alarmState".equals(serializer.getSettings().getPropertyType("alarmState"))) {
                NodeList list = pNode.getChildNodes();
                int len = list.getLength();
                for (int i = 0; i < len; ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.deserializeAlarm(node);
                }
            }
        } else {
            super.deserializeProperty(serializer, prop, pNode);
        }
    }

    private void deserializeAlarm(Node aNode) {
        String text = aNode.getNodeName();
        String type = aNode.getAttributes().getNamedItem("n").getNodeValue();
        AlarmSeverity severity = AlarmSeverity.getByName(type);
        int count = Integer.parseInt(aNode.getAttributes().getNamedItem("c").getNodeValue());
        if (count != -1) {
            if ("n".equals(text)) {
                this.getAlarmState().setNewAlarmCount(severity, count);
            } else {
                this.getAlarmState().setAcknowledgedAlarmCount(severity, count);
            }
        }
    }
}

