/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import twaver.DataBox;
import twaver.IData;
import twaver.IElement;
import twaver.ILayer;
import twaver.IStyle;
import twaver.Layer;
import twaver.LayerBox;
import twaver.Styles;
import twaver.XMLSerializer;

public class ElementBox
extends DataBox
implements IStyle {
    private final LayerBox layerBox;
    private Map<String, Object> styleMap = null;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public ElementBox() {
        this("ElementBox");
    }

    public ElementBox(String name) {
        super(name);
        this.layerBox = new LayerBox(this);
    }

    @Override
    public void add(IData element, int index) {
        if (!(element instanceof IElement)) {
            throw new IllegalArgumentException("Only IElement can be added into ElementBox");
        }
        super.add(element, index);
    }

    public LayerBox getLayerBox() {
        return this.layerBox;
    }

    public IElement getElementByID(Object elementID) {
        IData obj = this.getDataByID(elementID);
        if (obj != null && obj instanceof IElement) {
            return (IElement)obj;
        }
        return null;
    }

    @Override
    public Object getStyle(String styleProp) {
        return this.getStyle(styleProp, true);
    }

    public Map<String, Object> getStyleProperties() {
        return this.styleMap;
    }

    public Object getStyle(String styleProp, boolean returnDefaultIfNull) {
        Object value = null;
        if (this.styleMap != null) {
            value = this.styleMap.get(styleProp);
        }
        if (value == null) {
            return Styles.getStyle(styleProp);
        }
        return value;
    }

    @Override
    public IStyle setStyle(String styleProp, Object newValue) {
        if (styleProp == null) {
            throw new NullPointerException("styleProp");
        }
        if (this.styleMap == null) {
            this.styleMap = Collections.synchronizedMap(new HashMap());
        }
        if (newValue == null) {
            this.styleMap.remove(styleProp);
        } else {
            this.styleMap.put(styleProp, newValue);
        }
        return this;
    }

    public IStyle setStyle(String styleProp, int newValue) {
        return this.setStyle(styleProp, (Object)newValue);
    }

    public IStyle setStyle(String styleProp, double newValue) {
        return this.setStyle(styleProp, (Object)newValue);
    }

    public IStyle setStyle(String styleProp, boolean newValue) {
        return this.setStyle(styleProp, (Object)newValue);
    }

    @Override
    public void serializeXML(XMLSerializer serializer, DataBox newInstance) {
        serializer.getXmlString().append("\t<layerBox>\n");
        List<?> datas = this.layerBox.getDatas();
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            Layer layer = (Layer)datas.get(i);
            if (this.layerBox.getDefaultLayer() == layer) {
                serializer.getXmlString().append("\t\t<layer ");
            } else {
                serializer.getXmlString().append("\t\t<layer id='" + layer.getID() + "' ");
            }
            if (layer.getName() != null) {
                serializer.getXmlString().append("name='" + layer.getName() + "' ");
            }
            serializer.getXmlString().append("visible='" + layer.isVisible() + "' editable='" + layer.isEditable() + "' movable='" + layer.isMovable() + "'/>\n");
        }
        serializer.getXmlString().append("\t</layerBox>\n");
        if (this.styleMap != null && newInstance instanceof IStyle) {
            for (Map.Entry<String, Object> entry : this.styleMap.entrySet()) {
                this.serializeStyle(serializer, entry.getKey().toString(), (IStyle)((Object)newInstance));
            }
        }
        super.serializeXML(serializer, newInstance);
    }

    @Override
    public void serializeCommonXML(XMLSerializer serializer, DataBox newInstance) {
        List<?> datas = this.layerBox.getDatas();
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            Layer layer = (Layer)datas.get(i);
            if (this.layerBox.getDefaultLayer() == layer) {
                serializer.getXmlString().append("<layer ");
            } else {
                serializer.getXmlString().append("<layer id='" + layer.getID() + "' ");
            }
            if (layer.getName() != null) {
                serializer.getXmlString().append("name='" + layer.getName() + "' ");
            }
            serializer.getXmlString().append("visible='" + layer.isVisible() + "' editable='" + layer.isEditable() + "' movable='" + layer.isMovable() + "'/>\n");
        }
        if (this.styleMap != null && newInstance instanceof IStyle) {
            for (Map.Entry<String, Object> entry : this.styleMap.entrySet()) {
                this.serializeStyle(serializer, entry.getKey().toString(), (IStyle)((Object)newInstance));
            }
        }
        super.serializeCommonXML(serializer, newInstance);
    }

    protected void serializeStyle(XMLSerializer serializer, String stylePrope, IStyle newInstance) {
        serializer.serializeStyle(this, stylePrope, newInstance);
    }

    @Override
    public void deserializeXML(XMLSerializer serializer, String prefix, String prop, Node pNode) {
        super.deserializeXML(serializer, prefix, prop, pNode);
        if (prefix.equals("layerBox")) {
            this.layerBox.clear();
            NodeList list = pNode.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node item = list.item(i);
                if (item.getNodeType() != 1) continue;
                try {
                    this.deserializeLayer(serializer, item);
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
        if (!prefix.equals("s")) {
            return;
        }
        this.deserializeStyle(serializer, prop, pNode);
    }

    protected void deserializeLayer(XMLSerializer serializer, Node lNode) throws Exception {
        ILayer layer;
        NamedNodeMap attributes = lNode.getAttributes();
        Node idItem = attributes.getNamedItem("id");
        Node nameItem = attributes.getNamedItem("name");
        Node visibleItem = attributes.getNamedItem("visible");
        Node editableItem = attributes.getNamedItem("editable");
        Node movableItem = attributes.getNamedItem("movable");
        if (idItem == null) {
            layer = this.layerBox.getDefaultLayer();
            this.layerBox.moveToBottom(layer);
        } else {
            String idStr = idItem.getNodeValue();
            String idType = serializer.getSettings().getPropertyType("layerID");
            Object id = null;
            if ("string".equals(idType)) {
                id = idStr;
            } else if ("number".equals(idType)) {
                id = Double.valueOf(idStr);
            } else if ("int".equals(idType) || "uint".equals(idType)) {
                id = Integer.valueOf(idStr);
            } else {
                this.log.error((Object)("Unsupported id type '" + idType + "'"));
            }
            Class<?> newoneClass = Class.forName(Layer.class.getName());
            Class[] argsClass = new Class[]{Object.class};
            Constructor<?> cons = newoneClass.getConstructor(argsClass);
            layer = (Layer)cons.newInstance(id);
            this.layerBox.add(layer);
        }
        if (nameItem != null) {
            layer.setName(nameItem.getNodeValue());
        }
        if (visibleItem != null) {
            layer.setVisible(Boolean.parseBoolean(visibleItem.getNodeValue()));
        }
        if (editableItem != null) {
            layer.setEditable(Boolean.parseBoolean(editableItem.getNodeValue()));
        }
        if (movableItem != null) {
            layer.setMovable(Boolean.parseBoolean(movableItem.getNodeValue()));
        }
    }

    protected void deserializeStyle(XMLSerializer serializer, String prop, Node pNode) {
        serializer.deserializeStyle(this, prop, pNode);
    }
}

