/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import twaver.Grid;
import twaver.IData;
import twaver.Node;
import twaver.Utils;
import twaver.XMLSerializer;

public class Follower
extends Node {
    private static final String[] IS_INTERESTED_HOST_GRID_PROPERTY = new String[]{"location", "width", "height", "S:grid.row.count", "S:grid.column.count", "S:grid.row.percents", "S:grid.column.percents", "S:grid.border", "S:grid.border.left", "S:grid.border.right", "S:grid.border.top", "S:grid.border.bottom", "S:grid.padding", "S:grid.padding.left", "S:grid.padding.right", "S:grid.padding.top", "S:grid.padding.bottom"};
    private static final String[] IS_INTERESTED_FOLLOWER_STYLE = new String[]{"follower.row.index", "follower.column.index", "follower.row.span", "follower.column.span", "follower.padding", "follower.padding.left", "follower.padding.right", "follower.padding.top", "follower.padding.bottom"};
    private Node host = null;
    private boolean isUpdatingLocation = false;
    private boolean isUpdatingFollower = false;

    public Follower() {
        this(null);
    }

    public Follower(Object id) {
        super(id);
    }

    public Node getHost() {
        return this.host;
    }

    public void setHost(Node value) {
        if (this == value || this.host == value) {
            return;
        }
        Node oldValue = this.host;
        if (oldValue != null) {
            oldValue.removeFollower(this);
        }
        this.host = value;
        this.dispatchPropertyChangeEvent("host", oldValue, value);
        this.updateFollowerImpl("host", oldValue, value);
    }

    public boolean isHostOn(Node node) {
        if (node == null) {
            return false;
        }
        HashMap<Object, Node> dic = new HashMap<Object, Node>();
        Node tmpHost = this.host;
        while (tmpHost != null && tmpHost != this && !dic.containsKey(tmpHost.getID())) {
            if (tmpHost == node) {
                return true;
            }
            dic.put(tmpHost.getID(), tmpHost);
            if (tmpHost instanceof Follower) {
                tmpHost = ((Follower)tmpHost).getHost();
                continue;
            }
            tmpHost = null;
        }
        return false;
    }

    public boolean isLoopedHostOn(Follower follower) {
        if (follower == null) {
            return false;
        }
        return this.isHostOn(follower) && follower.isHostOn(this);
    }

    @Override
    protected void onStyleChanged(String styleProp, Object oldValue, Object newValue) {
        super.onStyleChanged(styleProp, oldValue, newValue);
        this.updateFollowerImpl(styleProp, oldValue, newValue);
    }

    private boolean isInterestedFollowerStyle(String property) {
        for (String value : IS_INTERESTED_FOLLOWER_STYLE) {
            if (!value.equals(property)) continue;
            return true;
        }
        return false;
    }

    private boolean isInterestedHostGridProperty(String property) {
        for (String value : IS_INTERESTED_HOST_GRID_PROPERTY) {
            if (!value.equals(property)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLocation(Point2D location) {
        if (this.isUpdatingLocation) {
            return;
        }
        this.isUpdatingLocation = true;
        super.setLocation(location);
        this.isUpdatingLocation = false;
    }

    protected void updateFollowerImpl(String property, Object oldV, Object newV) {
        if (this.isUpdatingFollower || Utils.isDeserializingXML()) {
            return;
        }
        this.isUpdatingFollower = true;
        Node h = this.getHost();
        if (!(h instanceof Grid)) {
            if (property.equals("location")) {
                Point2D oldLocation = (Point2D)oldV;
                Point2D newLocation = (Point2D)newV;
                Point2D location = this.getLocation();
                this.setLocation(location.getX() + (newLocation.getX() - oldLocation.getX()), location.getY() + (newLocation.getY() - oldLocation.getY()));
            }
        } else {
            Grid grid = (Grid)h;
            if (this.isInterestedFollowerStyle(property) || this.isInterestedHostGridProperty(property) || property.equals("host")) {
                Rectangle2D rect2;
                int columnIndex;
                int rowIndex = (int)Double.parseDouble("" + this.getStyle("follower.row.index"));
                Rectangle2D rect = grid.getCellRect(rowIndex, columnIndex = (int)Double.parseDouble("" + this.getStyle("follower.column.index")));
                if (rect == null) {
                    return;
                }
                int rowSpan = (int)Double.parseDouble("" + this.getStyle("follower.row.span"));
                int columnSpan = (int)Double.parseDouble("" + this.getStyle("follower.column.span"));
                if ((rowSpan != 1 || columnSpan != 1) && (rect2 = grid.getCellRect(rowIndex + rowSpan - 1, columnIndex + columnSpan - 1)) != null) {
                    Rectangle2D.union(rect, rect2, rect);
                }
                Utils.addPadding(rect, this, "follower.padding");
                this.setLocation(rect.getX(), rect.getY());
                this.setWidth(rect.getWidth());
                this.setHeight(rect.getHeight());
            }
        }
        this.isUpdatingFollower = false;
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "host", newInstance);
    }
}

