/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import twaver.Follower;
import twaver.IData;
import twaver.Node;
import twaver.Utils;
import twaver.XMLSerializer;

public class Group
extends Follower {
    private boolean isUpdateLocationFromChildren = false;
    private boolean isAdjusting = false;
    private boolean isExpanded = false;

    public Group() {
        this(null);
    }

    public Group(Object id) {
        super(id);
        this.setIcon("group_icon");
        this.setImage("group_image");
    }

    @Override
    protected void onChildAdded(IData child, int index) {
        super.onChildAdded(child, index);
        this.updateLocationFromChildren();
    }

    @Override
    protected void onChildRemoved(IData child, int index) {
        super.onChildRemoved(child, index);
        this.updateLocationFromChildren();
    }

    public void updateLocationFromChildren() {
        if (this.isAdjusting || Utils.isDeserializingXML()) {
            return;
        }
        RectangularShape rect = null;
        int size = this.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IData child = this.getChildAt(i);
            if (!(child instanceof Node)) continue;
            if (rect != null) {
                ((Rectangle2D)rect).add(((Node)child).getRect());
                continue;
            }
            rect = ((Node)child).getRect();
        }
        if (rect != null) {
            this.isUpdateLocationFromChildren = true;
            this.setLocation(rect.getX() + rect.getWidth() / 2.0 - this.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0 - this.getHeight() / 2.0);
            this.isUpdateLocationFromChildren = false;
        }
    }

    @Override
    public void setLocation(Point2D value) {
        if (this.isAdjusting) {
            return;
        }
        if (!Utils.isDeserializingXML() && !this.isUpdateLocationFromChildren) {
            this.isAdjusting = true;
            double dx = value.getX() - this.getX();
            double dy = value.getY() - this.getY();
            Utils.moveElements(this.getChildren(), dx, dy);
            this.isAdjusting = false;
        }
        super.setLocation(value);
    }

    public void reverseExpanded() {
        this.setExpanded(!this.isExpanded());
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean value) {
        if (this.isExpanded == value) {
            return;
        }
        boolean oldValue = this.isExpanded;
        this.isExpanded = value;
        this.dispatchPropertyChangeEvent("expanded", oldValue, value);
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "expanded", newInstance);
    }
}

