/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import twaver.Element;
import twaver.IData;
import twaver.Node;
import twaver.XMLSerializer;

public class Link
extends Element {
    private Node fromNode = null;
    private Node toNode = null;

    public Link() {
        this(null);
    }

    public Link(Object id) {
        this(id, null, null);
    }

    public Link(Node fromNode, Node toNode) {
        this(null, fromNode, toNode);
    }

    public Link(Object id, Node fromNode, Node toNode) {
        super(id);
        this.setFromNode(fromNode);
        this.setToNode(toNode);
        this.setStyle("select.distance", 2);
        this.setIcon("link_icon");
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(Node value) {
        if (this.fromNode == value) {
            return;
        }
        Node oldValue = this.fromNode;
        if (oldValue != null) {
            oldValue.removeFromLink(this);
        }
        this.fromNode = value;
        if (this.fromNode != null) {
            this.fromNode.addFromLink(this);
        }
        this.dispatchPropertyChangeEvent("fromNode", oldValue, value);
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setToNode(Node value) {
        if (this.toNode == value) {
            return;
        }
        Node oldValue = this.toNode;
        if (oldValue != null) {
            oldValue.removeToLink(this);
        }
        this.toNode = value;
        if (this.toNode != null) {
            this.toNode.addToLink(this);
        }
        this.dispatchPropertyChangeEvent("toNode", oldValue, value);
    }

    public boolean isLooped() {
        return this.fromNode == this.toNode && this.fromNode != null && this.toNode != null;
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "fromNode", newInstance);
        this.serializeProperty(serializer, "toNode", newInstance);
    }
}

