/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import twaver.Element;
import twaver.Follower;
import twaver.Group;
import twaver.IData;
import twaver.Link;
import twaver.Utils;
import twaver.XMLSerializer;

public class Node
extends Element {
    private List followers = null;
    private List fromLinks = null;
    private List toLinks = null;
    private List links = null;
    private List allLinks = null;
    private List loopedLinks = null;
    private String image = "node_image";
    private double width = -1.0;
    private double height = -1.0;
    private Point2D location = new Point2D.Double();

    public Node() {
        this(null);
    }

    public Node(Object id) {
        super(id);
        this.setIcon("node_icon");
    }

    public List getLoopedLinks() {
        return this.loopedLinks;
    }

    public List getLinks() {
        return this.links;
    }

    public List getFollowers() {
        return this.followers;
    }

    void addFollower(Follower follower) {
        if (this.followers == null) {
            this.followers = new ArrayList();
        }
        this.followers.add(follower);
    }

    void removeFollower(Follower follower) {
        this.followers.remove(follower);
        if (this.followers.size() == 0) {
            this.followers = null;
        }
    }

    public List getFromLinks() {
        return this.fromLinks;
    }

    public List getToLinks() {
        return this.toLinks;
    }

    void addFromLink(Link link) {
        if (this.allLinks == null) {
            this.allLinks = new ArrayList();
        }
        if (this.fromLinks == null) {
            this.fromLinks = new ArrayList();
        }
        this.allLinks.add(link);
        this.fromLinks.add(link);
        this.resetLinkSet();
    }

    void addToLink(Link link) {
        if (this.allLinks == null) {
            this.allLinks = new ArrayList();
        }
        if (this.toLinks == null) {
            this.toLinks = new ArrayList();
        }
        this.allLinks.add(link);
        this.toLinks.add(link);
        this.resetLinkSet();
    }

    void removeFromLink(Link link) {
        this.allLinks.remove(link);
        this.fromLinks.remove(link);
        if (this.allLinks.size() == 0) {
            this.allLinks = null;
        }
        if (this.fromLinks.size() == 0) {
            this.fromLinks = null;
        }
        this.resetLinkSet();
    }

    void removeToLink(Link link) {
        this.allLinks.remove(link);
        this.toLinks.remove(link);
        if (this.allLinks.size() == 0) {
            this.allLinks = null;
        }
        if (this.toLinks.size() == 0) {
            this.toLinks = null;
        }
        this.resetLinkSet();
    }

    void resetLinkSet() {
        this.loopedLinks = null;
        if (this.allLinks == null || this.allLinks.size() == 0) {
            this.links = null;
            return;
        }
        this.links = Utils.filterDuplicate(this.allLinks);
        int size = this.links.size();
        for (int i = 0; i < size; ++i) {
            Link link = (Link)this.links.get(i);
            if (!link.isLooped()) continue;
            if (this.loopedLinks == null) {
                this.loopedLinks = new ArrayList();
            }
            this.loopedLinks.add(link);
        }
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String value) {
        double oldWidth = this.getWidth();
        double oldHeight = this.getHeight();
        String oldValue = this.image;
        this.image = value;
        this.dispatchPropertyChangeEvent("image", oldValue, value);
        this.dispatchPropertyChangeEvent("width", oldWidth, this.getWidth());
        this.dispatchPropertyChangeEvent("height", oldHeight, this.getHeight());
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setLocation(Point2D value) {
        Point2D oldValue = this.location;
        if (oldValue.equals(value)) {
            return;
        }
        this.location = value;
        this.dispatchPropertyChangeEvent("location", oldValue, this.location);
    }

    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    public void setCenterLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x - this.getWidth() / 2.0, y - this.getHeight() / 2.0));
    }

    public Point2D getCenterLocation() {
        return new Point2D.Double(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight() / 2.0);
    }

    public void setCenterLocation(Point2D value) {
        this.setLocation(new Point2D.Double(value.getX() - this.getWidth() / 2.0, value.getY() - this.getHeight() / 2.0));
    }

    public void translate(double dx, double dy) {
        this.setLocation(new Point2D.Double(this.getX() + dx, this.getY() + dy));
    }

    public double getWidth() {
        if (this.width >= 0.0) {
            return this.width;
        }
        Dimension size = Utils.getImageSize(this.getImage());
        if (size != null) {
            return size.width;
        }
        return 0.0;
    }

    public void setWidth(double value) {
        double oldValue = this.width;
        this.width = value;
        this.dispatchPropertyChangeEvent("width", oldValue, value);
    }

    public double getHeight() {
        if (this.height >= 0.0) {
            return this.height;
        }
        Dimension size = Utils.getImageSize(this.getImage());
        if (size != null) {
            return size.height;
        }
        return 0.0;
    }

    public void setHeight(double value) {
        double oldValue = this.height;
        this.height = value;
        this.dispatchPropertyChangeEvent("height", oldValue, value);
    }

    public Dimension getSize() {
        return new Dimension((int)this.getWidth(), (int)this.getHeight());
    }

    public void setSize(Dimension value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    public void setSize(double width0, double height0) {
        this.setWidth(width0);
        this.setHeight(height0);
    }

    public Rectangle2D getRect() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected void onStyleChanged(String styleProp, Object oldValue, Object newValue) {
        super.onStyleChanged(styleProp, oldValue, newValue);
        if (this.followers != null) {
            int size = this.followers.size();
            for (int i = 0; i < size; ++i) {
                Follower follower = (Follower)this.followers.get(i);
                follower.updateFollowerImpl("S:" + styleProp, oldValue, newValue);
            }
        }
    }

    @Override
    protected void onPropertyChanged(String property, Object oldValue, Object newValue) {
        IData parent;
        super.onPropertyChanged(property, oldValue, newValue);
        if (this.followers != null) {
            int size = this.followers.size();
            for (int i = 0; i < size; ++i) {
                Follower follower = (Follower)this.followers.get(i);
                follower.updateFollowerImpl(property, oldValue, newValue);
            }
        }
        if ((parent = this.getParent()) == null || !(parent instanceof Group) || !"location".equals(property) && !"width".equals(property) && !"height".equals(property)) {
            return;
        }
        ((Group)parent).updateLocationFromChildren();
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "image", newInstance);
        this.serializeProperty(serializer, "location", newInstance);
        if (this.getWidth() > 0.0) {
            this.serializeProperty(serializer, "width", newInstance);
        }
        if (this.getHeight() > 0.0) {
            this.serializeProperty(serializer, "height", newInstance);
        }
    }
}

