/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ReflectUtils {
    private static Map<Class<?>, Method[]> classMethod = new HashMap();
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    private ReflectUtils() {
    }

    public static Object getObject(Object object, String name) {
        if (object == null) {
            return null;
        }
        Method method = ReflectUtils.getJavaBeanReadMethod(object.getClass(), name);
        if (method != null) {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        } else {
            log.error((Object)("can not find '" + name + "' read method in '" + object + "'"));
        }
        return null;
    }

    public static Method getJavaBeanReadMethod(Class<? extends Object> clazz, String propertyName) {
        Method readMethod = null;
        if (propertyName == null || propertyName.equals("")) {
            log.error((Object)("Property Name of " + clazz.getName() + " is Empty."));
            return readMethod;
        }
        String capitalizeName = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        try {
            readMethod = clazz.getMethod("get" + capitalizeName, new Class[0]);
        }
        catch (Exception localException) {
            log.error((Object)localException);
        }
        if (readMethod == null) {
            try {
                readMethod = clazz.getMethod("is" + capitalizeName, new Class[0]);
            }
            catch (Exception localException1) {
                log.error((Object)localException1);
            }
        }
        return readMethod;
    }

    public static void writeValue(Object bean, Method writeMethod, String propertyName, Object value) {
        if (bean == null || writeMethod == null) {
            return;
        }
        try {
            if (writeMethod.getParameterTypes().length == 1) {
                writeMethod.invoke(bean, value);
            } else {
                writeMethod.invoke(bean, propertyName, value);
            }
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
        }
    }

    public static Method getWriteMethod(Class<?> clazz, String propertyName, Class<?> propertyClass) {
        Method method = ReflectUtils.getJavaBeanWriteMethod(clazz, propertyName, propertyClass);
        return method;
    }

    public static Method getJavaBeanWriteMethod(Class<?> clazz, String propertyName, Class<?> propertyClass) {
        Method writeMethod = null;
        if (propertyName == null || propertyName.equals("")) {
            log.error((Object)("Property Name of " + clazz.getName() + " is Empty."));
            return writeMethod;
        }
        String capitalizeName = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        try {
            Method[] methods;
            Method[] object = classMethod.get(clazz);
            if (object == null) {
                methods = clazz.getMethods();
                classMethod.put(clazz, methods);
            } else {
                methods = object;
            }
            for (Method method : methods) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals("set" + capitalizeName) || !(parameterTypes = method.getParameterTypes())[0].isAssignableFrom(propertyClass)) continue;
                return method;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return writeMethod;
    }
}

