/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import twaver.Utils;

public class SerializationSettings {
    public static final boolean GLOBALDATABOXSERIALIZABLE = true;
    public static final boolean GLOBALLAYERBOXSERIALIZABLE = true;
    public static final boolean GLOBALSTYLESERIALIZABLE = true;
    public static final boolean GLOBALCLIENTSERIALIZABLE = true;
    public static final boolean DATABOXSERIALIZABLE = true;
    public static final boolean LAYERBOXSERIALIZABLE = true;
    public static final boolean STYLESERIALIZABLE = true;
    public static final boolean CLIENTSERIALIZABLE = true;
    private static final Map GLOBALPROPERTYMAP = Collections.synchronizedMap(new HashMap());
    private static final Map GLOBALPROPERTYCDATA = Collections.synchronizedMap(new HashMap());
    private static final Map GLOBALSTYLEMAP = Collections.synchronizedMap(new HashMap());
    private static final Map GLOBALSTYLECDATA = Collections.synchronizedMap(new HashMap());
    private static final Map GLOBALCLIENTMAP = Collections.synchronizedMap(new HashMap());
    private static final Map GLOBALCLIENTCDATA = Collections.synchronizedMap(new HashMap());
    private Map<String, Comparable> propertyMap = Utils.clone(GLOBALPROPERTYMAP);
    private Map<String, Comparable> propertyCdata = Utils.clone(GLOBALPROPERTYCDATA);
    private Map<String, Comparable> styleMap = Utils.clone(GLOBALSTYLEMAP);
    private Map<String, Comparable> styleCdata = Utils.clone(GLOBALSTYLECDATA);
    private Map<String, Comparable> clientMap = Utils.clone(GLOBALCLIENTMAP);
    private Map<String, Comparable> clientCdata = Utils.clone(GLOBALCLIENTCDATA);

    public static String getGlobalPropertyType(String property) {
        return SerializationSettings.toString(GLOBALPROPERTYMAP.get(property));
    }

    public static void registerGlobalProperty(String property, String type) {
        SerializationSettings.registerGlobalProperty(property, type, false);
    }

    public static void registerGlobalProperty(String property, String type, boolean cdata) {
        SerializationSettings.registerGlobalProperty(property, type, cdata, true);
    }

    public static void registerGlobalProperty(String property, String type, boolean cdata, boolean overrideExist) {
        if (!overrideExist && GLOBALPROPERTYMAP.containsKey(property)) {
            return;
        }
        GLOBALPROPERTYMAP.put(property, type);
        GLOBALPROPERTYCDATA.put(property, cdata);
    }

    public static String getGlobalStyleType(String styleProp) {
        return SerializationSettings.toString(GLOBALSTYLEMAP.get(styleProp));
    }

    public static void registerGlobalStyle(String styleProp, String type) {
        SerializationSettings.registerGlobalStyle(styleProp, type, false);
    }

    public static void registerGlobalStyle(String styleProp, String type, boolean cdata) {
        SerializationSettings.registerGlobalStyle(styleProp, type, cdata, true);
    }

    public static void registerGlobalStyle(String styleProp, String type, boolean cdata, boolean overrideExist) {
        if (!overrideExist && GLOBALSTYLEMAP.containsKey(styleProp)) {
            return;
        }
        GLOBALSTYLEMAP.put(styleProp, type);
        GLOBALSTYLECDATA.put(styleProp, cdata);
    }

    public static String getGlobalClientType(String clientProp) {
        return SerializationSettings.toString(GLOBALCLIENTMAP.get(clientProp));
    }

    public static void registerGlobalClient(String clientProp, String type) {
        SerializationSettings.registerGlobalClient(clientProp, type, false);
    }

    public static void registerGlobalClient(String clientProp, String type, boolean cdata) {
        SerializationSettings.registerGlobalClient(clientProp, type, cdata, true);
    }

    public static void registerGlobalClient(String clientProp, String type, boolean cdata, boolean overrideExist) {
        GLOBALCLIENTMAP.put(clientProp, type);
        GLOBALCLIENTCDATA.put(clientProp, cdata);
    }

    public static boolean isGlobalPropertyCdata(String property) {
        return SerializationSettings.toBoolean(GLOBALPROPERTYCDATA.get(property));
    }

    public static boolean isGlobalStyleCdata(String property) {
        return SerializationSettings.toBoolean(GLOBALSTYLECDATA.get(property));
    }

    public static boolean isGlobalClientCdata(String property) {
        return SerializationSettings.toBoolean(GLOBALCLIENTCDATA.get(property));
    }

    public String getPropertyType(String property) {
        return SerializationSettings.toString(this.propertyMap.get(property));
    }

    public void registerProperty(String property, String type) {
        this.registerProperty(property, type, false);
    }

    public void registerProperty(String property, String type, boolean cdata) {
        this.propertyMap.put(property, (Comparable)((Object)type));
        this.propertyCdata.put(property, Boolean.valueOf(cdata));
    }

    public String getStyleType(String styleProp) {
        return SerializationSettings.toString(this.styleMap.get(styleProp));
    }

    public void registerStyle(String styleProp, String type) {
        this.registerStyle(styleProp, type, false);
    }

    public void registerStyle(String styleProp, String type, boolean cdata) {
        this.styleMap.put(styleProp, (Comparable)((Object)type));
        this.styleCdata.put(styleProp, Boolean.valueOf(cdata));
    }

    public String getClientType(String clientProp) {
        return SerializationSettings.toString(this.clientMap.get(clientProp));
    }

    public void registerClient(String clientProp, String type) {
        this.registerClient(clientProp, type, false);
    }

    public void registerClient(String clientProp, String type, boolean cdata) {
        this.clientMap.put(clientProp, (Comparable)((Object)type));
        this.clientCdata.put(clientProp, Boolean.valueOf(cdata));
    }

    public boolean isPropertyCdata(String property) {
        return SerializationSettings.toBoolean(this.propertyCdata.get(property));
    }

    public boolean isStyleCdata(String property) {
        return SerializationSettings.toBoolean(this.styleCdata.get(property));
    }

    public boolean isClientCdata(String property) {
        return SerializationSettings.toBoolean(this.clientCdata.get(property));
    }

    public static boolean toBoolean(Object obj) {
        if (obj == null || !(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

