/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import twaver.IData;
import twaver.Link;
import twaver.Node;
import twaver.XMLSerializer;

public class ShapeLink
extends Link {
    protected List<Point2D> points = new ArrayList<Point2D>();

    public ShapeLink() {
    }

    public ShapeLink(Object id) {
        super(id);
    }

    public ShapeLink(Node fromNode, Node toNode) {
        super(fromNode, toNode);
    }

    public ShapeLink(Object id, Node fromNode, Node toNode) {
        super(id, fromNode, toNode);
    }

    public void dispatchPointsChangeEvent() {
        this.dispatchPropertyChangeEvent("points", null, this.points);
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point2D> value) {
        if (this.points == value) {
            return;
        }
        if (value == null) {
            value = new ArrayList<Point2D>();
        }
        this.points = value;
        this.dispatchPointsChangeEvent();
    }

    public void addPoint(Point2D point) {
        this.points.add(point);
        this.dispatchPointsChangeEvent();
    }

    public void addPointAt(Point2D point, int index) {
        this.points.add(index, point);
        this.dispatchPointsChangeEvent();
    }

    public void setPointAt(Point2D point, int index) {
        this.points.set(index, point);
        this.dispatchPointsChangeEvent();
    }

    public void removePoint(Point2D point) {
        if (this.points.remove(point)) {
            this.dispatchPointsChangeEvent();
        }
    }

    public void removePointAt(int index) {
        this.points.remove(index);
        this.dispatchPointsChangeEvent();
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "points", newInstance);
    }
}

