/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import twaver.ClassGenerator;
import twaver.Element;
import twaver.Follower;
import twaver.Group;
import twaver.IData;
import twaver.IElement;
import twaver.IdentifierFactory;
import twaver.Node;

public class Utils {
    public static final ClassGenerator CLASSGENERATOR = new ClassGenerator(){

        public String generate(Class clazz) {
            return clazz.getName();
        }

        @Override
        public Class<?> generate(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    };
    private static boolean isDeserializingXML = false;
    private static IdentifierFactory identifierFactory = IdentifierFactory.getInstance();
    private static Map imageMap = Collections.synchronizedMap(new HashMap());

    private Utils() {
    }

    public static String getVersion() {
        return "2.0";
    }

    public static Map clone(Map<?, ?> object) {
        Map<?, ?> newObject = Collections.synchronizedMap(new HashMap());
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            newObject.put(entry.getKey(), entry.getValue());
        }
        return newObject;
    }

    public static void registImageSize(Object key, Dimension size) {
        imageMap.put(key, size);
    }

    public static Dimension getImageSize(Object key) {
        Object object = imageMap.get(key);
        if (object != null && object instanceof Dimension) {
            return (Dimension)object;
        }
        return null;
    }

    public static IdentifierFactory getIdentifierFactory() {
        return identifierFactory;
    }

    public static Object getIdentifier(Object object) {
        return identifierFactory.getIdentifier(object);
    }

    public static ImageIcon getImage(String image) {
        return null;
    }

    public static Integer valueOf(int i) {
        if (i >= -128 && i <= 127) {
            return IntegerCache.CACHE[i + 128];
        }
        return i;
    }

    public static List filterDuplicate(List list) {
        Map map = Collections.synchronizedMap(new HashMap());
        ArrayList newList = new ArrayList();
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object obj = list.get(i);
                if (map.containsKey(obj)) continue;
                map.put(obj, null);
                newList.add(obj);
            }
        }
        return newList;
    }

    public static Rectangle2D getRect(List points) {
        if (points == null || points.isEmpty()) {
            return null;
        }
        Point2D point = (Point2D)points.get(0);
        Rectangle2D.Double rect = new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0);
        for (int i = 1; i < points.size(); ++i) {
            rect.add((Point2D)points.get(i));
        }
        return rect;
    }

    private static void inflate(Rectangle2D rect, double dx, double dy) {
        double nx = rect.getX() - dx;
        double ny = rect.getY() - dy;
        double nw = rect.getWidth() + 2.0 * dx;
        double nh = rect.getHeight() + 2.0 * dy;
        rect.setRect(nx, ny, nw, nh);
    }

    public static void addPadding(Rectangle2D rect, IElement element, String styleProp) {
        double padding = Double.parseDouble("" + element.getStyle(styleProp));
        if (padding != 0.0) {
            Utils.inflate(rect, -padding, -padding);
        }
        if ((padding = Double.parseDouble("" + element.getStyle(String.valueOf(styleProp) + ".left"))) != 0.0) {
            rect.setRect(rect.getX() + padding, rect.getY(), rect.getWidth() - padding, rect.getHeight());
        }
        if ((padding = Double.parseDouble("" + element.getStyle(String.valueOf(styleProp) + ".right"))) != 0.0) {
            rect.setRect(rect.getX(), rect.getY(), rect.getWidth() - padding, rect.getHeight());
        }
        if ((padding = Double.parseDouble("" + element.getStyle(String.valueOf(styleProp) + ".top"))) != 0.0) {
            rect.setRect(rect.getX(), rect.getY() + padding, rect.getWidth(), rect.getHeight() - padding);
        }
        if ((padding = Double.parseDouble("" + element.getStyle(String.valueOf(styleProp) + ".bottom"))) != 0.0) {
            rect.setRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight() - padding);
        }
        if (rect.getWidth() < 0.0) {
            rect.setRect(rect.getX() + rect.getWidth(), rect.getY(), -rect.getWidth(), rect.getHeight());
        }
        if (rect.getHeight() < 0.0) {
            rect.setRect(rect.getX(), rect.getY() + rect.getHeight(), rect.getWidth(), -rect.getHeight());
        }
    }

    public static void moveElements(List elements, double dx, double dy) {
        List list = Utils.filterMovingElements(elements);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object t = list.get(i);
            if (!(t instanceof Node)) continue;
            Node node = (Node)t;
            node.translate(dx, dy);
        }
    }

    public static List filterMovingElements(List elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)elements.get(i);
            if (!(element instanceof Node)) continue;
            boolean needToMove = true;
            ArrayList array = new ArrayList(list);
            int len = array.size();
            for (int j = 0; j < len; ++j) {
                Element e = (Element)array.get(j);
                if (needToMove && e instanceof Follower && element instanceof Follower && ((Follower)element).isLoopedHostOn((Follower)e)) {
                    needToMove = false;
                    continue;
                }
                if (e instanceof Follower && ((Follower)e).isHostOn((Node)element)) {
                    list.remove(e);
                    continue;
                }
                if (needToMove && element instanceof Follower && e instanceof Node && ((Follower)element).isHostOn((Node)e)) {
                    needToMove = false;
                    continue;
                }
                if (Utils.isDescendantOfGroup(e, element)) {
                    list.remove(e);
                    continue;
                }
                if (!needToMove || !Utils.isDescendantOfGroup(element, e)) continue;
                needToMove = false;
            }
            if (!needToMove) continue;
            list.add(element);
        }
        return list;
    }

    public static boolean isDescendantOfGroup(IData element, IData group) {
        if (element == null || !(group instanceof Group)) {
            return false;
        }
        if (!group.hasChildren()) {
            return false;
        }
        element = element.getParent();
        while (element instanceof Group) {
            if (element == group) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public static String getColorHexString(Color c, boolean isAlpha) {
        String rgb = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        String alpha = Integer.toHexString(c.getAlpha());
        String result = "#000000".substring(0, 7 - rgb.length()).concat(rgb);
        if (isAlpha) {
            return (result + "00".substring(0, 2 - alpha.length()).concat(alpha)).toUpperCase(Locale.ENGLISH);
        }
        return result.toUpperCase(Locale.ENGLISH);
    }

    public static String getColorHexString(String c, boolean isAlpha) {
        return Utils.getColorHexString(Color.decode(c), isAlpha);
    }

    public static boolean isDeserializingXML() {
        return isDeserializingXML;
    }

    public static void setDeserializingXML(boolean isDeserializing) {
        isDeserializingXML = isDeserializing;
    }

    private static class IntegerCache {
        static final Integer[] CACHE = new Integer[256];

        private IntegerCache() {
        }

        static {
            for (int i = 0; i < CACHE.length; ++i) {
                IntegerCache.CACHE[i] = i - 128;
            }
        }
    }
}

