/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.i18n;

import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class I18nMrgImpl
implements I18nMrg,
InitializingBean {
    private static final int PREFIX_LENTH = 0;
    private static Log log = LogFactory.getInstance(Module.ATIC_CORE_BASE);
    private Map<Locale, List<ResourceBundle>> resMap = new HashMap<Locale, List<ResourceBundle>>();

    @Override
    public String getString(String key, Locale local) {
        String value = key;
        if (null == this.resMap || this.resMap.isEmpty()) {
            return value;
        }
        List<ResourceBundle> list = this.resMap.get(local);
        if (null == list || list.isEmpty()) {
            return value;
        }
        for (ResourceBundle resourceBundle : list) {
            if (!resourceBundle.containsKey(key)) continue;
            value = resourceBundle.getString(key.trim());
            return value;
        }
        return value;
    }

    @Override
    public String getString(String key) {
        Locale local = new Locale("en");
        return this.getString(key, local);
    }

    @Override
    public String getString(String key, Locale local, String[] agrs) {
        String oldValue = this.getString(key, local);
        if (!oldValue.equalsIgnoreCase(key)) {
            oldValue = MessageFormat.format(oldValue, agrs);
        }
        return oldValue;
    }

    @Override
    public String getString(String key, String[] agrs) {
        String oldValue = this.getString(key);
        if (!oldValue.equalsIgnoreCase(key)) {
            oldValue = MessageFormat.format(oldValue, agrs);
        }
        return oldValue;
    }

    public void afterPropertiesSet() {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource r : resources = resourcePatternResolver.getResources("classpath*:/*_*.properties")) {
                Locale locale = null;
                String fileName = r.getFilename();
                int c = fileName.indexOf("_");
                if (c <= 0) continue;
                if (fileName.contains("_en")) {
                    log.info("Reading i18 file " + r.toString());
                    fileName = fileName.substring(0, c);
                    locale = new Locale("en");
                    this.setResourceBundle(fileName, locale);
                    continue;
                }
                if (!fileName.contains("_zh")) continue;
                log.info("Reading i18 file " + r.toString());
                locale = new Locale("zh", "CN");
                fileName = fileName.substring(0, c);
                this.setResourceBundle(fileName, locale);
            }
        }
        catch (IOException e) {
            log.warn("I18nMrg get locale's properties file failed!" + e.toString());
        }
    }

    private void setResourceBundle(String fileName, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(fileName, locale);
        List<ResourceBundle> bundleLst = this.resMap.get(locale);
        if (null == bundleLst) {
            bundleLst = new ArrayList<ResourceBundle>();
            bundleLst.add(resourceBundle);
            this.resMap.put(locale, bundleLst);
        } else {
            bundleLst.add(resourceBundle);
            this.resMap.put(locale, bundleLst);
        }
    }
}

