/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.send;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.log.CrashThreadHandler;
import com.hs.lego.core.notify.send.SyslogServer;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.model.SyslogBean;
import com.huawei.secsyslog.SysLogClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public final class SyslogSendThread
extends Thread {
    public static final Log LOG = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private static SyslogSendThread instance = new SyslogSendThread();
    private final Object lockSysLog = new Object();
    private final Object lockLogServer = new Object();
    private List<SyslogServer> logServerList = new ArrayList<SyslogServer>();
    private List<SyslogServer> logServerListTmp = new ArrayList<SyslogServer>();
    private SysLogClient sysLogClient = null;
    private ConcurrentMap<String, List<SyslogBean>> syslogList = new ConcurrentHashMap<String, List<SyslogBean>>();
    private ConcurrentMap<String, List<SyslogBean>> syslogListTmp = new ConcurrentHashMap<String, List<SyslogBean>>();

    private SyslogSendThread() {
        this.setName("SyslogThread");
    }

    public static SyslogSendThread getInstance() {
        if (!instance.isAlive()) {
            instance.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Iterator iterator = this.lockSysLog;
                    synchronized (iterator) {
                        if (!this.syslogListTmp.isEmpty()) {
                            this.syslogList = this.syslogListTmp;
                            this.syslogListTmp = new ConcurrentHashMap<String, List<SyslogBean>>();
                        }
                    }
                    iterator = this.lockLogServer;
                    synchronized (iterator) {
                        this.logServerList = this.logServerListTmp;
                    }
                    if (!this.logServerList.isEmpty() && !this.syslogList.isEmpty()) {
                        LOG.info("syslogList.size():" + this.syslogList.size());
                        for (Map.Entry serverMap : this.syslogList.entrySet()) {
                            ArrayList<byte[]> dataList = new ArrayList<byte[]>();
                            String ipPort = (String)serverMap.getKey();
                            for (SyslogBean sysLog : (List)serverMap.getValue()) {
                                dataList.add(sysLog.getBytes());
                            }
                            if (null == this.sysLogClient) continue;
                            this.sysLogClient.addSysLogList(ipPort, dataList);
                            this.syslogList.remove(ipPort);
                        }
                    }
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                LOG.error("syslogsend catch Exception: ", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogServers(List<SyslogServer> syslogServerList) {
        if (syslogServerList != null) {
            Object object = this.lockLogServer;
            synchronized (object) {
                this.logServerListTmp.clear();
                this.logServerListTmp.addAll(syslogServerList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSyslog(String keyIpPort, SyslogBean logBean) {
        if (logBean != null) {
            Object object = this.lockSysLog;
            synchronized (object) {
                if (null == this.syslogListTmp.get(keyIpPort)) {
                    ArrayList<SyslogBean> lst = new ArrayList<SyslogBean>();
                    lst.add(logBean);
                    this.syslogListTmp.put(keyIpPort, lst);
                } else {
                    ((List)this.syslogListTmp.get(keyIpPort)).add(logBean);
                }
            }
        }
    }

    public SysLogClient getSysLogClient() {
        return this.sysLogClient;
    }

    public void setSysLogClient(SysLogClient sysLogClient) {
        this.sysLogClient = sysLogClient;
    }
}

