/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public final class ServiceContext {
    private static Log log = LogFactory.getInstance(Module.ATIC_CORE_BASE);
    private static volatile WebApplicationContext webApplicationContext = null;

    private ServiceContext() {
        this.init();
    }

    private void init() {
        try {
            ServiceContext.setWebApplicationContext(ContextLoader.getCurrentWebApplicationContext());
        }
        catch (Exception e) {
            ServiceContext.setWebApplicationContext(null);
        }
    }

    public static ServiceContext getInstance() {
        return ServiceContextHolder.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(String serviceName, Class<T> clazz) {
        if (null == webApplicationContext) {
            ServiceContext serviceContext = ServiceContextHolder.context;
            synchronized (serviceContext) {
                if (null == webApplicationContext) {
                    ServiceContext.setWebApplicationContext(ContextLoader.getCurrentWebApplicationContext());
                }
            }
            if (null == webApplicationContext) {
                log.error("Can not find Service " + serviceName + "! Because spring has not been initialized!");
                return null;
            }
        }
        try {
            return (T)webApplicationContext.getBean(serviceName, clazz);
        }
        catch (BeansException e) {
            log.error("Can not find Service " + serviceName + "! ", e);
            return null;
        }
    }

    public static WebApplicationContext getWebApplicationContext() {
        return webApplicationContext;
    }

    public static void setWebApplicationContext(WebApplicationContext webApplicationContext) {
        ServiceContext.webApplicationContext = webApplicationContext;
    }

    private static class ServiceContextHolder {
        private static ServiceContext context = new ServiceContext();

        private ServiceContextHolder() {
        }
    }
}

