/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.exception;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ExceptionInforLoader {
    private static final Object LOCK = new Object();
    private static ExceptionInforLoader instance;
    private String name = "exception.properties";
    private Properties props;
    private transient Log log = LogFactory.getInstance(Module.ATIC_CORE_BASE);

    private ExceptionInforLoader() {
        this.props = new Properties();
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(this.name);
            this.props.load(stream);
        }
        catch (IOException e) {
            this.log.error("IOException error");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.log.error("IOException error");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExceptionInforLoader getLoader() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new ExceptionInforLoader();
            }
            return instance;
        }
    }

    public Properties getProperties() {
        return this.props;
    }
}

