/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.exception;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;

public class LegoUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static LegoUncaughtExceptionHandler sInstance = null;
    private final Log logger = LogFactory.getInstance(Module.ATIC_CORE_BASE);

    public static LegoUncaughtExceptionHandler getInstance() {
        if (null == sInstance) {
            sInstance = new LegoUncaughtExceptionHandler();
        }
        return sInstance;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        StringBuffer errorBuf = new StringBuffer();
        errorBuf.append("\r\n");
        errorBuf.append(">>>>>>>>>>lego uncaught exception>>>>>>>>>");
        errorBuf.append("\r\n");
        errorBuf.append("Thread name: ");
        errorBuf.append(t.getName());
        errorBuf.append("\r\n");
        errorBuf.append("Thread ContextClassLoader:");
        errorBuf.append(t.getContextClassLoader());
        errorBuf.append("\r\n");
        this.logger.error(errorBuf.toString(), e);
    }
}

