/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.log.CrashThreadHandler;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CertFileUtil;
import com.huawei.secsyslog.SysLogObj;
import com.huawei.secsyslog.TCPSysLogServerThread;
import com.huawei.secsyslog.ThreadInfoObj;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SysLogServer
extends Thread {
    private static final int SERVER_SOCKET_BACKLOG = 50;
    protected final transient Log logger = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private boolean flag = true;
    private String protocol = "udp";
    private String serverIp = null;
    private int serverPort = 514;
    private String keystorePath = null;
    private StringBuffer keystorePass = null;
    private BlockingQueue<String> whiteList = new LinkedBlockingQueue<String>();
    private BlockingQueue<SysLogObj> msgList = new LinkedBlockingQueue<SysLogObj>(100000);
    private SSLContext context = null;
    private ServerSocket serverSocket = null;
    private DatagramSocket udpSocket = null;
    private Socket tcpSocket = null;
    private BlockingQueue<ThreadInfoObj> threadList = new LinkedBlockingQueue<ThreadInfoObj>();
    private int averageNum = 0;

    public SysLogServer(String protocol, String keystorePath, String keystorePass, int serverPort) {
        this.logger.info("SysLogServer-enter SysLogServer(), protocol is " + this.getcleanedMessage(protocol) + ", port is " + serverPort + ", keystorePath is ");
        this.setName("SysLogServer");
        this.keystorePath = keystorePath;
        this.keystorePass = new StringBuffer();
        if (null != keystorePass) {
            this.keystorePass.append(keystorePass);
        }
        if (null != protocol && !"".equals(protocol.trim())) {
            this.protocol = protocol;
        }
        if (serverPort >= 1 && serverPort <= 65535) {
            this.serverPort = serverPort;
        }
        this.setServerIp(System.getProperty("nms.server.host"));
    }

    public String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            this.serverPort = 3514;
        }
        this.logger.info("SysLogServer-enter run, protocol is " + this.protocol + ", port is " + this.serverPort);
        Map<String, String> map = this.getConfigData();
        String average = map.get("averageNum");
        this.averageNum = !"".equals(average) && null != average ? Integer.parseInt(average) : 500;
        try {
            if ("tcp".equals(this.protocol)) {
                this.logger.info("SysLogServer-enter tcp workflow");
                this.startTcpServer();
            } else {
                this.logger.info("SysLogServer-enter udp workflow");
                String srcIp = null;
                String msg = null;
                this.getUdpSocket();
                if (null == this.udpSocket) {
                    this.logger.error("SysLogServer-udpSocket is null, SysLogServer will exit!");
                    this.interrupt();
                    return;
                }
                this.udpSocket.setReceiveBufferSize(0xA00000);
                while (this.flag) {
                    byte[] buf = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    if (this.udpSocket != null) {
                        this.udpSocket.receive(packet);
                    }
                    if (!this.isLegalAddress(srcIp = packet.getAddress().getHostAddress())) continue;
                    msg = new String(packet.getData(), 0, packet.getLength(), "UTF-8");
                    this.addMsgList(srcIp, msg);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("SysLogServer-run error", e);
        }
        finally {
            this.stopServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTcpServer() {
        try {
            TCPSysLogServerThread serverThread = null;
            if (null == this.getSSLContext()) {
                this.logger.error("SysLogServer-getSSLContext() is null, SysLogServer will exit!");
                this.interrupt();
                return;
            }
            this.getServerSocket();
            if (null == this.serverSocket) {
                this.logger.error("SysLogServer-serverSocket is null, SysLogServer will exit!");
                this.interrupt();
                return;
            }
            if (this.serverSocket instanceof SSLServerSocket) {
                ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"});
                ((SSLServerSocket)this.serverSocket).setEnabledProtocols(new String[]{"TLSv1.2"});
            }
            while (this.flag) {
                this.tcpSocket = this.serverSocket.accept();
                String address = this.tcpSocket.getInetAddress().getHostName();
                if (!this.isLegalAddress(address)) {
                    this.logger.info("SysLogServer-The address is illegal : " + address);
                    continue;
                }
                if (this.threadList.size() >= 50) {
                    this.logger.info("SysLogServer-threadMap is full, can not accept new thread!");
                    continue;
                }
                serverThread = new TCPSysLogServerThread(this, this.tcpSocket, this.threadList);
                serverThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                serverThread.start();
                if (this.threadList.isEmpty()) {
                    this.addThread(address, serverThread);
                    continue;
                }
                boolean isExist = false;
                for (ThreadInfoObj threadObj : this.threadList) {
                    if (!address.equals(threadObj.getIp())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                this.addThread(address, serverThread);
            }
        }
        catch (IOException e) {
            this.logger.error("SysLogServer-startTcpServer error", e);
        }
        finally {
            this.stopServer();
        }
    }

    private void getServerSocket() {
        SSLContext sslContext = this.getSSLContext();
        if (null == sslContext) {
            this.logger.error("SysLogServer-SSLContext is null");
            return;
        }
        SSLServerSocketFactory ssf = sslContext.getServerSocketFactory();
        try {
            this.serverSocket = null == this.serverIp ? ssf.createServerSocket(this.serverPort) : ssf.createServerSocket(this.serverPort, 50, InetAddress.getByName(this.serverIp));
        }
        catch (IOException e) {
            this.logger.error("SysLogServer-getServerSocket error", e);
        }
    }

    private void getUdpSocket() {
        try {
            this.udpSocket = null == this.serverIp ? new DatagramSocket(this.serverPort) : new DatagramSocket(this.serverPort, InetAddress.getByName(this.serverIp));
        }
        catch (IOException e) {
            this.logger.error("SysLogServer-getUdpSocket error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getConfigData() {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream iStream = null;
        try {
            iStream = SysLogServer.class.getResourceAsStream("/conf.properties");
            Properties properties = new Properties();
            properties.load(iStream);
            String maxNum = properties.getProperty("sysLogMaxNumber");
            String limitNum = properties.getProperty("sysLogLimitNuber");
            String sysAverageNum = properties.getProperty("sysLogAverageNumber");
            map.put("maxNum", maxNum);
            map.put("limitNum", limitNum);
            map.put("averageNum", sysAverageNum);
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileInputStream is  error.");
        }
        catch (IOException e) {
            this.logger.error("properties load data is error.");
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error("InputStream close is error.");
            }
        }
        return map;
    }

    private void addThread(String ip, TCPSysLogServerThread serverThread) {
        try {
            ThreadInfoObj thread = new ThreadInfoObj();
            thread.setIp(ip);
            thread.setServerThread(serverThread);
            this.threadList.put(thread);
        }
        catch (InterruptedException e) {
            this.logger.error("SysLogServer-addThread error", e);
        }
    }

    private boolean isLegalAddress(String address) {
        boolean result = false;
        if (null == this.whiteList || this.whiteList.isEmpty()) {
            return false;
        }
        if (address == null || "".equals(address)) {
            return result;
        }
        for (String add : this.whiteList) {
            if (null == add || "".equals(add) || !add.equals(address)) continue;
            return true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLContext getSSLContext() {
        InputStream is = null;
        if (null != this.context) {
            return this.context;
        }
        try {
            Properties properties = CertFileUtil.getInstance().loadLegoCertInfoProperties();
            if (null == this.keystorePath) {
                is = new FileInputStream(CertFileUtil.getInstance().getCertPath() + File.separator + "mc_keystore");
                this.logger.info("SysLogServer-keystorePath is null, default keystorePath will be use!");
            } else {
                is = new FileInputStream(this.keystorePath);
            }
            if (null == this.keystorePass || "".equals(this.keystorePass.toString())) {
                this.keystorePass = new StringBuffer(EncryptData.getInstanse().decryptInitdata(properties.getProperty("keystore.mc.password")));
                this.logger.info("SysLogServer-keystorePass is null, default keystorePass will be use!");
                if (null == this.keystorePass || "".equals(this.keystorePass.toString())) {
                    this.keystorePass = new StringBuffer(EncryptData.getInstanse().decryptInitdata(properties.getProperty("keystore.mc.password")));
                }
                if (null == this.keystorePass || "".equals(this.keystorePass.toString())) {
                    this.logger.error("SysLogServer-sdpDecryptInitDataBuffer failed");
                    this.interrupt();
                    SSLContext sSLContext = null;
                    return sSLContext;
                }
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(is, this.keystorePass.toString().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, this.keystorePass.toString().toCharArray());
            KeyManager[] km = kmf.getKeyManagers();
            this.context = SSLContext.getInstance("TLSv1.2");
            this.context.init(km, null, null);
        }
        catch (Throwable e) {
            this.logger.error("SysLogServer-getSSLConext error", e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.error("SysLogServer-getSSLConext error", e);
                }
            }
        }
        return this.context;
    }

    public List<SysLogObj> fetchMsgList() {
        ArrayList<SysLogObj> dataList = new ArrayList<SysLogObj>();
        this.msgList.drainTo(dataList);
        return dataList;
    }

    public void addMsgList(String srcIp, String msg) {
        SysLogObj obj = new SysLogObj();
        obj.setSrcIp(srcIp);
        obj.setMsg(msg);
        try {
            if (this.msgList.size() < this.averageNum) {
                this.msgList.put(obj);
            } else {
                this.logger.error("msgList size is: " + this.averageNum + ", this syslogobj dropped, scrcIP is:" + srcIp + ",and msg is:" + msg);
            }
        }
        catch (InterruptedException e) {
            this.logger.error("SysLogServer-addMsgList error", e);
        }
    }

    public void stopServer() {
        this.flag = false;
        if (null != this.tcpSocket) {
            try {
                this.tcpSocket.close();
            }
            catch (IOException e) {
                this.logger.error("SysLogServer-stopServer error", e);
            }
        }
        if (null != this.serverSocket) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.logger.error("SysLogServer-stopServer error", e);
            }
        }
        if (null != this.udpSocket) {
            this.udpSocket.close();
        }
        if (null != this.context) {
            this.context = null;
        }
    }

    private void refreshThreadList() {
        Iterator iterator = this.threadList.iterator();
        while (iterator.hasNext()) {
            ThreadInfoObj thread = (ThreadInfoObj)iterator.next();
            if (this.whiteList.contains(thread.getIp())) continue;
            thread.getServerThread().stopThread();
            iterator.remove();
        }
    }

    public void setWhiteList(List<String> whiteData) {
        this.whiteList.clear();
        for (String string : whiteData) {
            try {
                this.whiteList.put(string);
            }
            catch (InterruptedException e) {
                this.logger.error("SysLogServer-setWhiteList error", e);
            }
        }
        this.refreshThreadList();
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }
}

