/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocketFactory;

public abstract class SyslogClientAbstrat
extends Thread {
    private static final Log LOGGER = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private BlockingQueue<byte[]> sysLogList = new LinkedBlockingQueue<byte[]>();
    private List<byte[]> dataList = new ArrayList<byte[]>();
    private String serverIp;
    private int serverPort;
    private SyslogServerEntity syslogServerEntity;
    private boolean flag = true;
    private SSLSocketFactory ssf = null;

    public SyslogClientAbstrat(String ip, int port) {
        this.setServerIp(ip);
        this.setServerPort(port);
    }

    public void addSysLogList(List<byte[]> data) {
        for (byte[] bs : data) {
            try {
                this.sysLogList.put(bs);
            }
            catch (InterruptedException e) {
                LOGGER.error("TCPSysLogClientThread-addSysLogList", e);
            }
        }
    }

    public void fetchSysLogList() {
        this.sysLogList.drainTo(this.dataList);
    }

    public void clearSyslogList() {
        this.sysLogList.clear();
    }

    public void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            LOGGER.error("sleep time=" + time + " error.", e);
        }
    }

    public abstract void stopClient();

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public SyslogServerEntity getSyslogServerEntity() {
        return this.syslogServerEntity;
    }

    public void setSyslogServerEntity(SyslogServerEntity syslogServerEntity) {
        this.syslogServerEntity = syslogServerEntity;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public List<byte[]> getDataList() {
        return this.dataList;
    }

    public SSLSocketFactory getSsf() {
        return this.ssf;
    }

    public void setSsf(SSLSocketFactory ssf) {
        this.ssf = ssf;
    }
}

