/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.secsyslog.IpTransformer;
import com.huawei.secsyslog.ServerInfoObj;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TCPSysLogClientThread
extends SyslogClientAbstrat {
    public static final int SLEEP_TIME1 = 60000;
    public static final int SLEEP_TIME2 = 200;
    public static final int SLEEP_TIME3 = 2;
    public static final int SLEEP_TIME4 = 5000;
    public static final int NUMBER_LOGS = 50;
    private static Log logger = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private Socket socket = null;
    private OutputStream output = null;
    private BufferedOutputStream bos = null;
    private SSLSocketFactory ssf = null;
    private ServerInfoObj serverInfoObj = null;

    public TCPSysLogClientThread(SSLSocketFactory ssf, ServerInfoObj serverInfoObj) {
        super(serverInfoObj.getIp(), serverInfoObj.getPort());
        logger.debug("TCPSysLogClientThread-enter TCPSysLogClientThread(), server ip is: " + serverInfoObj.getIp());
        Random ran = new Random();
        this.setName("TCPSysLogClientThread" + this.getServerIp() + "_" + this.getServerPort() + "_" + ran.nextInt());
        this.ssf = ssf;
        this.serverInfoObj = serverInfoObj;
    }

    @Override
    public void run() {
        if (!IpTransformer.checkIpInvaild(this.serverInfoObj.getIp())) {
            logger.error("input serverIP is error, creat TCPSysLogClientThread failed.");
            return;
        }
        logger.info("TCPSysLogClientThread-enter run, server ip is " + this.serverInfoObj.getIp() + ", server port is " + this.serverInfoObj.getPort());
        this.sendTCPSysLog();
    }

    private void sendTCPSysLog() {
        try {
            while (this.isFlag()) {
                if (null == this.socket || !this.socket.isConnected() || null == this.bos) {
                    this.bos = this.connect();
                }
                this.fetchSysLogList();
                if (null == this.bos) {
                    logger.error("tcp connect failed to server=" + this.getServerIp() + ", serverPort=" + this.getServerPort() + ". Clear syslog list and try to reconnect after 60s.");
                    this.getDataList().clear();
                    this.sleep(60000);
                    continue;
                }
                List<byte[]> dataList = this.getDataList();
                if (dataList.isEmpty()) {
                    this.sleep(200);
                    continue;
                }
                int index = 0;
                for (byte[] sysLog : dataList) {
                    logger.info("TCPSysLogClientThread-to be send dataList size is" + dataList.size());
                    StringBuffer dataBuffer = new StringBuffer();
                    String dataStr = new String(sysLog, "UTF-8");
                    dataBuffer.append(dataStr.length());
                    dataBuffer.append(' ');
                    dataBuffer.append(dataStr);
                    this.bos.write(dataBuffer.toString().getBytes("UTF-8"));
                    this.bos.flush();
                    logger.info("TCPSysLogClientThread-TCP:" + this.serverInfoObj.getIp() + ':' + this.serverInfoObj.getPort() + '-' + this.getcleanedMessage(dataBuffer.toString()));
                    if (index++ % 50 != 0) continue;
                    this.sleep(2);
                }
                this.getDataList().clear();
            }
        }
        catch (IOException e) {
            this.closeConnect();
            logger.error(e.getMessage() + '-' + this.serverInfoObj.getIp(), e);
            this.getDataList().clear();
            this.sleep(5000);
            this.sendTCPSysLog();
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private BufferedOutputStream connect() {
        logger.info("TCPSysLogClientThread-enter connect() begin");
        try {
            this.socket = this.ssf.createSocket(this.serverInfoObj.getIp(), this.serverInfoObj.getPort());
            if (this.socket instanceof SSLSocket) {
                ((SSLSocket)this.socket).setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"});
                ((SSLSocket)this.socket).setEnabledProtocols(new String[]{"TLSv1.2"});
            }
            this.output = this.socket.getOutputStream();
            if (null != this.output) {
                logger.info("TCPSysLogClientThread-enter connect() sucess.");
                return new BufferedOutputStream(this.output);
            }
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage() + '-' + this.getServerIp(), e);
        }
        catch (IOException e) {
            logger.error(e.getMessage() + '-' + this.getServerIp(), e);
        }
        return null;
    }

    @Override
    public void stopClient() {
        logger.info("stop TCPSysLogClientThread,threadName:" + Thread.currentThread().getName());
        this.setFlag(false);
        this.closeConnect();
    }

    private void closeConnect() {
        if (null != this.bos) {
            try {
                this.bos.close();
                this.bos = null;
            }
            catch (IOException e) {
                logger.error(e.getMessage() + '-' + this.getServerIp(), e);
            }
        }
        if (null != this.output) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (IOException e) {
                logger.error(e.getMessage() + '-' + this.getServerIp(), e);
            }
        }
        if (null != this.socket) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                logger.error(e.getMessage() + '-' + this.getServerIp(), e);
            }
        }
    }
}

