/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.tags.bean;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.jsp.IteratorStatus;

public abstract class BaseGrid
extends UIBean {
    private static Log log = LogFactory.getLog(BaseGrid.class);
    protected Boolean renderHead = true;
    private Iterator<?> iterator;
    private IteratorStatus status;
    private Object oldStatus;
    private IteratorStatus.StatusState statusState;
    private String statusAttr;
    private String list;
    private String hideColumn;
    private Integer index = -1;
    private boolean hasData = true;

    public BaseGrid(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public void setCompId(String compId) {
        if (this.id == null || this.id.trim().isEmpty()) {
            this.id = this.name == null || this.name.trim().isEmpty() ? compId : this.name.replaceAll("\\.", "_");
        }
    }

    public boolean start(Writer writer) {
        this.evaluateParams();
        this.loadTemplate(writer, "grid-table");
        if (this.statusAttr != null) {
            this.statusState = new IteratorStatus.StatusState();
            this.status = new IteratorStatus(this.statusState);
        }
        if (this.list == null) {
            this.list = "top";
        }
        this.iterator = MakeIterator.convert((Object)this.findValue(this.list));
        if (this.renderHead.booleanValue()) {
            this.addParameter("listStatus", this.statusAttr == null ? "st" : this.statusAttr);
            this.addParameter("list", this.list);
            this.loadTemplate(writer, "grid-head-tr");
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.procIteratorNext(writer);
            return true;
        }
        this.hasData = false;
        if (this.renderHead.booleanValue()) {
            return true;
        }
        this.writeHtml(writer, "</table></div>");
        return false;
    }

    private void procIteratorNext(Writer writer) {
        if (!this.renderHead.booleanValue()) {
            this.loadTemplate(writer, "grid-body-tr");
        }
        Object currentValue = this.iterator.next();
        Integer n = this.index;
        Integer n2 = this.index = Integer.valueOf(this.index + 1);
        this.stack.push(currentValue);
        String id = this.getId();
        if (id != null && currentValue != null) {
            this.stack.getContext().put(id, currentValue);
        }
        if (this.statusAttr != null) {
            this.statusState.setLast(!this.iterator.hasNext());
            this.oldStatus = this.stack.getContext().get(this.statusAttr);
            this.stack.getContext().put(this.statusAttr, this.status);
        }
    }

    public boolean end(Writer writer, String body) {
        ValueStack stack = this.getStack();
        if (this.iterator != null && this.hasData) {
            if (this.renderHead.booleanValue()) {
                this.renderHead = false;
                this.writeHtml(writer, "</tr>");
                this.loadTemplate(writer, "grid-body-tr");
                return true;
            }
            stack.pop();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            Object currentValue = this.iterator.next();
            Integer n = this.index;
            Integer n2 = this.index = Integer.valueOf(this.index + 1);
            stack.push(currentValue);
            String id = this.getId();
            if (id != null && currentValue != null) {
                stack.getContext().put(id, currentValue);
            }
            if (this.status != null) {
                this.statusState.next();
                this.statusState.setLast(!this.iterator.hasNext());
            }
            this.writeHtml(writer, "</tr>");
            this.loadTemplate(writer, "grid-body-tr");
            return true;
        }
        if (this.status != null) {
            if (this.oldStatus == null) {
                stack.getContext().put(this.statusAttr, null);
            } else {
                stack.getContext().put(this.statusAttr, this.oldStatus);
            }
        }
        this.writeHtml(writer, "</tr>");
        this.writeHtml(writer, "</table></div>");
        if (!this.hasData) {
            this.loadTemplate(writer, "grid-table-end");
        } else {
            this.loadTemplate(writer, "grid-table-endnone");
        }
        return super.end(writer, "", true);
    }

    private void loadTemplate(Writer writer, String template) {
        try {
            Template tp = new Template(this.getTemplateDir(), "lego/grid", template);
            this.mergeTemplate(writer, tp);
        }
        catch (Exception e) {
            log.error((Object)"loadTemplate error:", (Throwable)e);
        }
    }

    private void writeHtml(Writer writer, String html) {
        try {
            writer.write(html);
        }
        catch (IOException e) {
            log.error((Object)"writeHtml error");
        }
    }

    protected String getDefaultTemplate() {
        return null;
    }

    @StrutsTagAttribute(description="status", type="Boolean", defaultValue="false")
    public void setStatus(String status) {
        this.statusAttr = status;
    }

    @StrutsTagAttribute(description="list")
    public void setList(String list) {
        this.list = list;
    }

    public Boolean getRenderHead() {
        return this.renderHead;
    }

    @StrutsTagAttribute(description="renderHead")
    public void setRenderHead(Boolean renderHead) {
        this.renderHead = renderHead;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getHideColumn() {
        return this.hideColumn;
    }

    public void setHideColumn(String hideColumn) {
        this.hideColumn = hideColumn;
    }
}

