/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.tags.bean;

import com.hs.lego.ui.tag.tools.IAuthHandler;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="column", tldTagClass="com.hs.lego.tags.tag.ColumnTag", description="Column")
public class Column
extends UIBean {
    private static Log log = LogFactory.getLog(Column.class);
    private String sortField;
    private String width;
    private String hidden;
    private String sortForm;
    private String needAuth;
    private Boolean noAuth = null;
    private String head;
    private String align;
    private String drag;
    private String title;

    public Column(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected void evaluateExtraParams() {
        if (this.sortField != null) {
            this.addParameter("sortField", this.findString(this.sortField));
        }
        if (this.width != null) {
            this.addParameter("width", this.findString(this.width));
        }
        if (this.hidden != null) {
            this.addParameter("hidden", this.findString(this.hidden));
        }
        if (this.sortForm != null) {
            this.addParameter("sortForm", this.findString(this.sortForm));
        }
        if (this.head != null) {
            this.addParameter("head", this.findString(this.head));
        }
        if (this.align != null) {
            this.addParameter("align", this.findString(this.align));
        }
        if (this.drag != null) {
            this.addParameter("drag", this.findString(this.drag));
        }
        if (this.title != null) {
            String temp = this.findString(this.title);
            temp = temp.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&#46;", ".").replaceAll("&#40;", "(").replaceAll("&#41;", ")").replaceAll("&#58;", ":");
            this.addParameter("title", temp);
        }
    }

    public boolean start(Writer writer) {
        if (this.isAuth()) {
            return false;
        }
        try {
            this.evaluateParams();
            Template tp = new Template(this.getTemplateDir(), "lego/grid", "grid-body-td");
            this.mergeTemplate(writer, tp);
        }
        catch (Exception e) {
            log.error((Object)"renderHead error:", (Throwable)e);
        }
        return true;
    }

    private boolean isAuth() {
        if (this.noAuth == null) {
            IAuthHandler authHandler;
            this.noAuth = this.needAuth == null ? Boolean.valueOf(false) : ((authHandler = (IAuthHandler)this.request.getSession().getAttribute("auth_handler")) == null ? Boolean.valueOf(true) : Boolean.valueOf(!authHandler.isAuthority(this.needAuth)));
        }
        return this.noAuth;
    }

    public void renderHead(Writer writer) {
        if (this.isAuth()) {
            return;
        }
        try {
            this.evaluateParams();
            Template tp = new Template(this.getTemplateDir(), "lego/grid", "grid-head-td");
            this.mergeTemplate(writer, tp);
        }
        catch (Exception e) {
            log.error((Object)"renderHead error:", (Throwable)e);
        }
    }

    public boolean end(Writer writer, String body) {
        if (this.isAuth()) {
            return super.end(writer, "", true);
        }
        return super.end(writer, "</span></td>", true);
    }

    protected String getDefaultTemplate() {
        return null;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHidden(String hidden) {
        this.hidden = hidden;
    }

    public void setSortForm(String sortForm) {
        this.sortForm = sortForm;
    }

    @StrutsTagAttribute(description="This is the authchecker!", defaultValue="")
    public void setNeedAuth(String needAuth) {
        this.needAuth = needAuth;
    }

    public void setHead(String head) {
        this.head = head;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDrag(String drag) {
        this.drag = drag;
    }
}

