/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.tag.ctrls;

import com.hs.lego.ui.tag.tools.ICustomHandler;
import com.hs.lego.ui.tag.tools.TagConfig;
import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

public class SwebHead
extends UIBean {
    public static final String TEMPLATE = "swebhead";
    private String locale;
    private String extend;
    private String extLib;
    private String debug;
    private String skin = null;
    private String cache;
    private String customStyle;

    public SwebHead(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
        ICustomHandler customHandler = (ICustomHandler)request.getSession().getAttribute("auth_handler");
        if (customHandler != null) {
            this.skin = customHandler.getCustomCss();
        }
    }

    public String getCustomStyle() {
        return this.customStyle;
    }

    public void setCustomStyle(String customStyle) {
        this.customStyle = customStyle;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.skin != null) {
            this.addParameter("skin", this.skin);
        }
        if (TagConfig.hasConfig()) {
            String moduleName = (String)this.request.getAttribute("com.hs.lego.moduleName");
            if (TagConfig.getConfig(moduleName, "head.cache") != null) {
                this.addParameter("cache", TagConfig.getConfig(moduleName, "head.cache"));
            }
            if (TagConfig.getConfig(moduleName, "head.extJS") != null) {
                this.addParameter("extJS", TagConfig.getConfig(moduleName, "head.extJS"));
            }
            if (TagConfig.getConfig(moduleName, "head.extCSS") != null) {
                this.addParameter("extCSS", TagConfig.getConfig(moduleName, "head.extCSS"));
            }
            if (TagConfig.getConfig("customStyle", "style") != null) {
                this.addParameter("customStyle", TagConfig.getConfig("customStyle", "style"));
            }
        }
        if (this.cache != null) {
            this.addParameter("cache", this.cache);
        }
        if (this.locale != null) {
            this.addParameter("locale", this.findString(this.locale));
        }
        if (this.extend != null) {
            this.addParameter("extend", this.findString(this.extend));
        }
        this.evaluateExtraParams2();
    }

    private void evaluateExtraParams2() {
        if (this.extLib != null) {
            this.addParameter("extLib", this.findValue(this.extLib, Boolean.class));
        } else {
            this.addParameter("extLib", true);
        }
        if (this.debug != null) {
            this.addParameter("debug", this.findValue(this.debug, Boolean.class));
        } else {
            this.addParameter("debug", false);
        }
    }

    @StrutsTagAttribute(description="The locale of the ExtHead.")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @StrutsTagAttribute(description="The extLib of the ExtHead.")
    public void setExtLib(String extLib) {
        this.extLib = extLib;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }
}

