/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.tag.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TagConfig {
    private static Log log = LogFactory.getLog(TagConfig.class);
    private static final int START = 5;
    private static boolean sNonInitFlag = true;
    private static boolean sIsConfig = false;
    private static Map<String, Properties> props = new HashMap<String, Properties>();

    private TagConfig() {
    }

    public static boolean hasConfig() {
        if (sNonInitFlag) {
            TagConfig.init();
        }
        return sIsConfig;
    }

    private static void init() {
        try {
            TagConfig.readConfig();
            TagConfig.readCustomStyle();
            sIsConfig = true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            sNonInitFlag = false;
        }
        sNonInitFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfig() throws IOException {
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("legoTag.conf");
        while (urls.hasMoreElements()) {
            String modulename;
            URL url;
            block13: {
                url = urls.nextElement();
                modulename = null;
                ZipFile jf = null;
                try {
                    Manifest mani;
                    if (!"jar".equals(url.getProtocol())) break block13;
                    String path = url.getPath();
                    if (path.indexOf("!") > 5) {
                        path = path.substring(5, path.indexOf("!"));
                    }
                    if (null != (mani = ((JarFile)(jf = new JarFile(URLDecoder.decode(path, "utf-8")))).getManifest())) {
                        Attributes attr = mani.getMainAttributes();
                        if (null != attr) {
                            modulename = attr.getValue("Module-Name");
                        }
                        break block13;
                    }
                    throw new IOException();
                }
                finally {
                    try {
                        if (null != jf) {
                            jf.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException error");
                    }
                }
            }
            Properties prop = new Properties();
            prop.load(url.openStream());
            if (log.isDebugEnabled()) {
                log.debug((Object)("modulename=" + modulename + "; URL=" + url.getPath()));
            }
            props.put(modulename, prop);
        }
    }

    private static void readCustomStyle() throws IOException {
        Properties prop1 = new Properties();
        ClassLoader loader = null;
        URL url = null;
        try {
            loader = TagConfig.class.getClassLoader();
            if (null != loader) {
                url = loader.getResource("../custom.conf");
            }
            if (url == null) {
                return;
            }
            File f = new File(URLDecoder.decode(url.getPath(), "utf-8"));
            if (f.exists()) {
                prop1.load(url.openStream());
                props.put("customStyle", prop1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"read CustomStyle do.");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"IOException error");
        }
    }

    public static String getConfig(String moduleName, String configParam) {
        Properties p = props.get(moduleName);
        if (p == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("modulename=" + moduleName + "; key=" + configParam + "; value=" + p.getProperty(configParam)));
        }
        return p.getProperty(configParam);
    }
}

