/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.util.BisConstants;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.PacketBisUtil;
import com.hs.atic.bis.util.RadioBean;
import com.hs.atic.sdk.bis.form.AclRuleForm;
import com.hs.atic.sdk.bis.form.PacketTaskForm;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.sdk.bis.form.VpnForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class PacketTaskAction
extends BaseAction {
    public static final int CAPTURE_LENGTH_HEADER = 1;
    public static final int CAPTURE_LENGTH_ALL = 2;
    public static final int CAPTURE_LENGTH_USER_DEFINE = 3;
    public static final int FINGER_FILTER_DISABLE = 0;
    public static final int FINGER_FILTER_ENABLE = 1;
    static Comparator<AticDevice> comparator = new Comparator<AticDevice>(){

        @Override
        public int compare(AticDevice fw1, AticDevice fw2) {
            return fw1.getName().toLowerCase(Locale.ENGLISH).compareTo(fw2.getName().toLowerCase(Locale.ENGLISH));
        }
    };
    static Comparator<AticDevice> comparator2 = new Comparator<AticDevice>(){

        @Override
        public int compare(AticDevice fw1, AticDevice fw2) {
            return fw1.getName().compareTo(fw2.getName());
        }
    };
    private static final long serialVersionUID = -3353340243513824783L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private String defaultTabPage;
    private transient IPacketTaskService packetTaskService;
    private Long deviceId;
    private List<VpnForm> vpnForms;
    private String neVpnName;
    private String deviceVpn;
    private String sortType;
    private String sortField;
    private String zoneName;
    private String deviceName;
    private String devId;
    private String pcapType;
    private String zoneId;
    private String deviceIdList;
    private List<AticDevice> firewallList;
    private List<PacketTaskForm> packetTaskFormList;
    private PacketTaskForm packetTaskForm;
    private PacketTaskForm addPacketTaskForm;
    private List<ZoneInfoForm> queryZoneFormList;
    private ZoneInfoForm zoneInfoForm;
    private Long id;
    private Long[] ids;
    private String[] names;
    private String[] states;
    private String[] aclTypes;
    private List<LangPair> listDeviceName;
    private List<LangPair> listZoneName;
    private LangPair langPair = new LangPair("", "");
    private String record;
    private AclRuleForm aclRuleForm;
    private String aclRuleTypeDisplay;
    private String aclRuleIpTypeDisplay;
    private String hasRule;
    private String creatStart;
    private String submitType;
    private String aclRuleInfo;
    private List<AclRuleForm> listAclRuleForm;
    private String deviceDisplay;
    private List<LangPair> strListDeviceSearchComb;
    private String stateDisplay;
    private String zoneDisplay;
    private String typeDisplay;
    private String combTypeDisplay;
    private String combPercentDisplay;
    private String allQueryDisplay;
    private List<LangPair> pcapTypeData;
    private List<LangPair> packetTaskStateData;
    private StringBuffer submitToken = new StringBuffer();
    private Long dashBoardZoneId;
    private Long dashBoardDeviceId;
    private List<String> offlineCollectorIp = new ArrayList<String>();
    private String forceDelete = "";
    private String forceStop = "";
    private String neIds;
    private String zoneIds;
    private String source;
    private String selectZoneId;
    private String listZoneSel;
    private Integer captureModeValue = 1;
    private Integer fingerFilterValue = 0;
    private Integer pcapLength = 0;
    private List<RadioBean> captureLengthCombData;
    private List<RadioBean> fingerFilterCombData;
    private Integer forwardStatus;
    private String neIps;

    public String listPacketTab() {
        return "list";
    }

    public String selectDeviceVpn() {
        this.vpnForms = new ArrayList<VpnForm>();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        String selectedVpnName = "";
        if (null != this.deviceVpn) {
            selectedVpnName = this.deviceVpn.trim();
        }
        Paging paging = aticDeviceService.queryByPageVpnForm(this.getDeviceId().longValue(), "", this.start, Integer.MAX_VALUE);
        this.vpnForms = paging.getData();
        if (null == this.vpnForms) {
            logger.error((Object)"no vpns in this device,vpnForms is null!!");
            return "success";
        }
        for (VpnForm vpnForm : this.vpnForms) {
            if (null == vpnForm.getVname() || !selectedVpnName.equalsIgnoreCase(vpnForm.getVname().trim())) continue;
            vpnForm.setIsSelect(Boolean.valueOf(true));
        }
        this.total = this.vpnForms.size();
        return "success";
    }

    public String listPacketTask() {
        this.loadSearchComb();
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        Paging page = this.packetTaskService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        List tmpList = page.getData();
        this.packetTaskFormList = new ArrayList<PacketTaskForm>();
        for (PacketTaskForm form : tmpList) {
            Long zoneid = form.getZoneId();
            if (null != zoneid && 0L != zoneid) {
                Long moId = PacketBisUtil.getMoidByZoneid(zoneid);
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(moId);
                BisUtil.checkUserSecurity(moIdList);
            }
            form.getPcapType();
            IZoneService zoneService = PacketBisUtil.getZoneService();
            this.zoneName = null == zoneid || 0L == zoneid ? "--" : (null == zoneService.getById(zoneid) ? this.getText("atic.analysis.common.unknown") + zoneid : zoneService.getById(zoneid).getZoneDesc());
            if (null == form.getForwardStatus() || 0 == form.getForwardStatus()) {
                form.setForwardStatus(Integer.valueOf(0));
            }
            form.setZoneName(this.zoneName);
            Long deviceid = form.getPcapDeviceId();
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(deviceid);
            BisUtil.checkUserSecurity(deviceList);
            IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
            AticDevice firewall = firewallService.getDeviceByMoid(deviceid.longValue());
            this.deviceName = null == firewall ? this.getText("atic.analysis.common.unknown") + deviceid : firewall.getName();
            form.setPcapDeviceName(this.deviceName);
            this.packetTaskFormList.add(form);
        }
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.setTotal(page.getCount());
        return "list";
    }

    public void loadSearchComb() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        IAticDeviceService service = PacketBisUtil.getIFirewallService();
        ArrayList firewalls = service.getAntiDDoSDevice(currentUser.getUserID());
        if (null == firewalls) {
            firewalls = new ArrayList();
        }
        Collections.sort(firewalls, comparator);
        this.strListDeviceSearchComb = new ArrayList<LangPair>();
        LangPair ld1 = new LangPair("", this.getText("atic.bis.packet.task.all"));
        this.strListDeviceSearchComb.add(ld1);
        if (!firewalls.isEmpty()) {
            for (int i = 0; i < firewalls.size(); ++i) {
                AticDevice firewall = (AticDevice)firewalls.get(i);
                if (null == firewall) continue;
                LangPair ld = new LangPair(String.valueOf(firewall.getMoId()), firewall.getName());
                this.strListDeviceSearchComb.add(ld);
            }
        }
        this.allQueryDisplay = this.getText("atic.public.query.all");
        this.pcapTypeData = PacketBisUtil.getPcapTypeCombData(true);
        this.packetTaskStateData = PacketBisUtil.getPacketTaskStateCombData();
    }

    public String addPacketTask() {
        this.pcapTypeData = PacketBisUtil.getPcapTypeCombData(false);
        this.initcaptureComb();
        this.initFingerFilter();
        this.submitToken = new StringBuffer(UUID.randomUUID().toString());
        return "add";
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String processDeviceName(String deviceNameStr) {
        if (deviceNameStr.indexOf("[") > -1 || deviceNameStr.indexOf("]") > -1) {
            deviceNameStr = deviceNameStr.replace("[", " ");
            deviceNameStr = deviceNameStr.replace("]", " ");
        }
        return deviceNameStr;
    }

    private void addDataToList(List<Long> moIDList) {
        if (!"".equals(this.zoneIds)) {
            String[] zoneIdsArray;
            for (String item : zoneIdsArray = this.zoneIds.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)item)) continue;
                moIDList.add(PacketBisUtil.getMoidByZoneid(Long.parseLong(item)));
            }
        }
        if (!"".equals(this.neIds)) {
            String[] neIdsArray;
            for (String item : neIdsArray = this.neIds.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)item.split(";")[0])) continue;
                moIDList.add(Long.parseLong(item.split(";")[0]));
            }
        }
    }

    public void deployPacketTask() {
        ArrayList<Long> moIDList = new ArrayList<Long>();
        this.addDataToList(moIDList);
        BisUtil.checkUserSecurity(moIDList);
        this.addPacketTaskForm.setZoneIds(this.zoneIds);
        this.addPacketTaskForm.setPcapDeviceIds(this.neIds);
        this.addPacketTaskForm.setPcapTaskState(Integer.valueOf(0));
        this.disposalAclRuleForm();
        this.addPacketTaskForm.setListAclRuleForm(this.listAclRuleForm);
        this.addPacketTaskForm.setFilterStatus(this.fingerFilterValue);
        this.addPacketTaskForm.setForwardStatus(this.forwardStatus);
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        if (this.paramsNotValid()) {
            logger.error((Object)"paramsNotValid failed!");
            this.getOperateLog().normal("atic.bis.pcap.task.add", "lego.dic.module.AticBis", null, false, "atic.bis.packetTask.addSummary.failed", null);
            throw new LegoCheckedException(570505L);
        }
        if (!this.checkPacketTaskCount()) {
            logger.error((Object)"packetTaskNum more than 10000");
            this.responseResult("574002");
            return;
        }
        IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
        if (null != this.addPacketTaskForm.getForwardStatus() && null != this.addPacketTaskForm.getPcapType() && 1 == this.addPacketTaskForm.getForwardStatus() && 1 == this.addPacketTaskForm.getPcapType() && !StringUtils.isEmpty((CharSequence)this.neIps)) {
            String[] neIpsStr = this.neIps.split(",");
            for (int i = 0; i < neIpsStr.length; ++i) {
                AticDevice aticDeviceACL = firewallService.getDeviceByIp(neIpsStr[i]);
                if (0 == aticDeviceACL.getDdosType() || 2 == aticDeviceACL.getDdosType()) continue;
                logger.error((Object)"ACL packet task device is not 0 or 2");
                this.responseResult("575003");
                return;
            }
        }
        if (!this.packetNumValidOfV1()) {
            logger.error((Object)"packetNum more than 10000 in v1r1 !");
            this.getOperateLog().normal("atic.bis.pcap.task.add", "lego.dic.module.AticBis", null, false, "atic.bis.packetTask.addSummary.failed", null);
            throw new LegoCheckedException(571506L);
        }
        if (this.packetTaskService.isTaskExistByFuzzyQuery(this.addPacketTaskForm.getPcapTaskName())) {
            logger.error((Object)("packet task had existed! task name: " + PacketTaskAction.getcleanedMessage(this.addPacketTaskForm.getPcapTaskName())));
            this.getOperateLog().normal("atic.bis.pcap.task.add", "lego.dic.module.AticBis", null, false, "atic.bis.packetTask.addSummary.failed", null);
            throw new LegoCheckedException(571501L);
        }
        if (AticUtil.isReSubmit((HttpSession)this.getSession(), (StringBuffer)this.submitToken)) {
            this.getOperateLog().normal("atic.bis.pcap.task.add", "lego.dic.module.AticBis", null, false, "atic.bis.packetTask.addSummary.failed", null);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "";
        terminalIp = null != request ? request.getRemoteAddr() : "127.0.0.1";
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        if ("true".equals(this.creatStart)) {
            this.batchOperationResult = this.packetTaskService.deployAndStartPacketTask(this.addPacketTaskForm, currentUser.getUserID(), isAdmin, terminalIp, currentUser.getUserName());
            if (null != this.batchOperationResult) {
                for (BatchOperation bo : this.batchOperationResult.getResult()) {
                    this.getOperateLog().normal("atic.bis.pcap.task.start", "lego.dic.module.AticBis", bo.getTargetName(), false, bo.getOptDetail(), bo.getDetailParam());
                }
            }
            this.bathResult(this.batchOperationResult);
        } else {
            this.packetTaskService.deployPacketTask(this.addPacketTaskForm, currentUser.getUserID(), isAdmin, terminalIp, currentUser.getUserName());
            this.responseResult("success");
        }
    }

    public String getZone() {
        User currentUser;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.sortField == null && this.sortType == null) {
            queryMap.put("sortName", "zoneName");
            queryMap.put("sortType", "ASC");
        } else {
            queryMap.put("sortName", this.sortField);
            queryMap.put("sortType", this.sortType);
        }
        if (null != this.zoneInfoForm && null != this.zoneInfoForm.getZoneName()) {
            queryMap.put("zoneName", this.zoneInfoForm.getZoneName());
        }
        if (null != (currentUser = (User)this.getSession().getAttribute("currentUser"))) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        IZoneService service = PacketBisUtil.getZoneService();
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        Paging page = service.getPageDeployZoneInfo(queryMap, this.getStart(), this.getPageSize());
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoForm", (Object)this.zoneInfoForm);
        this.getSession().setAttribute("sortField", (Object)this.sortField);
        this.getSession().setAttribute("sortType", (Object)this.sortType);
        this.setZoneValue();
        return "list";
    }

    private void setZoneValue() {
        if (this.selectZoneId != null) {
            String[] selZoneArr = null;
            this.listZoneSel = ",";
            selZoneArr = this.selectZoneId.equals("") ? new String[]{} : this.selectZoneId.split(";");
            int gridIndex = 0;
            for (ZoneInfoForm zoneInfoForms : this.queryZoneFormList) {
                for (String role1 : selZoneArr) {
                    if (!role1.equals(zoneInfoForms.getZoneId().toString())) continue;
                    this.listZoneSel = this.listZoneSel + gridIndex + ",";
                    break;
                }
                ++gridIndex;
            }
        }
    }

    public void deletePacketTask() {
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        this.getOperateLog().warning("atic.bis.pcap.task.delete", "lego.dic.module.AticBis");
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            this.checkUltraVires(this.ids[i]);
            bo.setTargetId(this.ids[i].longValue());
            String deviceNameStr = this.processDeviceName(this.names[i]);
            bo.setTargetName(deviceNameStr);
            PacketTaskForm form = this.packetTaskService.findById(this.ids[i]);
            if (null == form) {
                logger.error((Object)("form is null! id :" + this.ids[i]));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
            AticDevice firewall = firewallService.getDeviceByMoid(form.getPcapDeviceId().longValue());
            if (null == firewall) {
                logger.error((Object)("firewall is null! id :" + this.ids[i]));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            Long deviceIda = firewall.getMoId();
            Long collectorId = PacketBisUtil.getICollectorDeviceService().getCollectorIdByDevId(deviceIda);
            if (null == collectorId) {
                logger.error((Object)("collectorId is null! deviceId :" + deviceIda));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            CollectorInfo collector = PacketBisUtil.getICollectorService().getCollectorInfo(collectorId.longValue());
            if (null == collector) {
                logger.error((Object)("collector is null! collectorId :" + collectorId));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            if (2 == collector.getStatus() && "no".equals(this.forceDelete) && (this.offlineCollectorIp.isEmpty() || !this.offlineCollectorIp.contains(collector.getIpAddress()))) {
                this.offlineCollectorIp.add(collector.getIpAddress());
            }
            bo.setOptDetail(collector.getIpAddress());
            batchOpList.add(bo);
        }
        if (!this.offlineCollectorIp.isEmpty() && "no".equals(this.forceDelete)) {
            this.responseResult(this.offlineCollectorIp.toString());
            return;
        }
        this.batchOperationResult = this.packetTaskService.batchDelPacketTask(batchOpList, false, this.forceDelete);
        this.bathResult(this.batchOperationResult);
    }

    public String viewPacketTask() {
        this.checkUltraVires(this.id);
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        this.packetTaskForm = this.packetTaskService.findById(this.id);
        if (null != this.packetTaskForm) {
            FWDefenceAbnormalForm form;
            Long deviceid = this.packetTaskForm.getPcapDeviceId();
            IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
            AticDevice firewall = firewallService.getDeviceByMoid(deviceid.longValue());
            if (null == firewall) {
                this.packetTaskForm.setPcapDeviceName(this.getText("atic.analysis.common.unknown") + deviceid);
            } else {
                this.packetTaskForm.setPcapDeviceName(firewall.getName());
            }
            Long zoneid = this.packetTaskForm.getZoneId();
            if (null == zoneid || 0L == zoneid) {
                this.packetTaskForm.setZoneName("--");
            } else {
                IZoneService zoneService = PacketBisUtil.getZoneService();
                ZoneInfoForm zoneForm = zoneService.getById(zoneid);
                this.zoneName = null == zoneForm ? this.getText("atic.analysis.common.unknown") + zoneid : zoneForm.getZoneDesc();
                this.packetTaskForm.setZoneName(this.zoneName);
            }
            this.initTypeAndPercent(this.packetTaskForm);
            this.initFingerFilter();
            this.setFingerFilterValue(this.packetTaskForm.getFilterStatus());
            this.initcaptureComb();
            IFWDefenceAbnormalService service = PacketBisUtil.getIFWDefenceAbnormalService();
            if (null != firewall && null != (form = service.queryByDeviceId(Long.valueOf(firewall.getMoId())))) {
                this.setPcapLength(form.getPcapLength());
                this.setCaptureModeValue(form.getPcapMode());
            }
        } else {
            logger.error((Object)"packetTaskForm is null");
        }
        return "view";
    }

    public void startPacketTask() {
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        this.getOperateLog().normal("atic.bis.pcap.task.start", "lego.dic.module.AticBis");
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            this.checkUltraVires(this.ids[i]);
            bo.setTargetId(this.ids[i].longValue());
            String deviceNameStr = this.processDeviceName(this.names[i]);
            bo.setTargetName(deviceNameStr);
            PacketTaskForm form = this.packetTaskService.findById(this.ids[i]);
            if (null == form) {
                bo.setOptDetail(null);
                batchOpList.add(bo);
                logger.error((Object)("pcap task had not existed! pcap id:" + this.ids[i]));
                continue;
            }
            Long deviceIda = form.getPcapDeviceId();
            Long collectorId = PacketBisUtil.getICollectorDeviceService().getCollectorIdByDevId(deviceIda);
            if (null == collectorId) {
                bo.setOptDetail(null);
            } else {
                String ipaddress = PacketBisUtil.getICollectorService().getCollectorInfo(collectorId.longValue()).getIpAddress();
                bo.setOptDetail(ipaddress);
            }
            batchOpList.add(bo);
        }
        this.batchOperationResult = this.packetTaskService.batchStartPacketTask(batchOpList);
        this.bathResult(this.batchOperationResult);
    }

    private void checkUltraVires(Long packetTaskId) {
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        PacketTaskForm packFrom = this.packetTaskService.findById(packetTaskId);
        if (null == packFrom) {
            throw new LegoCheckedException(570506L);
        }
        Long deviceIda = packFrom.getPcapDeviceId();
        Long zoneID = packFrom.getZoneId();
        if (null != deviceIda) {
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(deviceIda);
            BisUtil.checkUserSecurity(deviceList);
        }
        if (null != zoneID && 0L != zoneID) {
            Long moId = PacketBisUtil.getMoidByZoneid(zoneID);
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(moId);
            BisUtil.checkUserSecurity(moIdList);
        }
    }

    public void stopPacketTask() {
        this.packetTaskService = PacketBisUtil.getPacketTaskService();
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
        this.getOperateLog().normal("atic.bis.pcap.task.stop", "lego.dic.module.AticBis");
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            this.checkUltraVires(this.ids[i]);
            bo.setTargetId(this.ids[i].longValue());
            String deviceNameStr = this.processDeviceName(this.names[i]);
            bo.setTargetName(deviceNameStr);
            PacketTaskForm form = this.packetTaskService.findById(this.ids[i]);
            if (null == form) {
                logger.error((Object)("form is null! id :" + this.ids[i]));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            AticDevice firewall = firewallService.getDeviceByMoid(form.getPcapDeviceId().longValue());
            if (null == firewall) {
                logger.error((Object)("firewall is null! id :" + this.ids[i]));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            Long deviceIda = firewall.getMoId();
            Long collectorId = PacketBisUtil.getICollectorDeviceService().getCollectorIdByDevId(deviceIda);
            if (null == collectorId) {
                logger.error((Object)("collectorId is null! deviceId :" + deviceIda));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            CollectorInfo collector = PacketBisUtil.getICollectorService().getCollectorInfo(collectorId.longValue());
            if (null == collector) {
                logger.error((Object)("collector is null! collectorId :" + collectorId));
                bo.setOptDetail(null);
                batchOpList.add(bo);
                continue;
            }
            if (2 == collector.getStatus() && "no".equals(this.forceStop) && (this.offlineCollectorIp.isEmpty() || !this.offlineCollectorIp.contains(collector.getIpAddress()))) {
                this.offlineCollectorIp.add(collector.getIpAddress());
            }
            bo.setOptDetail(collector.getIpAddress());
            batchOpList.add(bo);
        }
        if (!this.offlineCollectorIp.isEmpty() && "no".equals(this.forceStop)) {
            this.responseResult(this.offlineCollectorIp.toString());
            return;
        }
        this.batchOperationResult = new BatchOperationResult();
        this.batchOperationResult = this.packetTaskService.batchStopPacketTask(batchOpList, this.forceStop, this.batchOperationResult, false);
        this.bathResult(this.batchOperationResult);
    }

    private void initTypeAndPercent(PacketTaskForm packetTaskForm01) {
        this.combTypeDisplay = this.getText((String)BisConstants.getMapPacketTaskType().get(packetTaskForm01.getPcapType()));
        this.combPercentDisplay = this.getText((String)BisConstants.getMapPacketTaskPrecent().get(packetTaskForm01.getSamplingPercent()));
    }

    public void disposalAclRuleForm() {
        this.listAclRuleForm = new ArrayList<AclRuleForm>();
        if (!"".equals(this.aclRuleInfo)) {
            String[] aclRule = this.aclRuleInfo.split(";");
            for (int i = 0; i < aclRule.length; ++i) {
                AclRuleForm form = new AclRuleForm();
                String[] attrAclRule = aclRule[i].split(",");
                if (7 != attrAclRule.length) continue;
                form.setAclRuleId(Long.valueOf(Long.parseLong(attrAclRule[0])));
                form.setAclRuleType(attrAclRule[5]);
                if (!"/".equals(attrAclRule[1])) {
                    form.setSourceIpAndMask(attrAclRule[1]);
                }
                if (!"/".equals(attrAclRule[2])) {
                    form.setSourcePort(Integer.valueOf(Integer.parseInt(attrAclRule[2])));
                }
                if (!"/".equals(attrAclRule[3])) {
                    form.setDestIpAndMask(attrAclRule[3]);
                }
                if (!"/".equals(attrAclRule[4])) {
                    form.setDestPort(Integer.valueOf(Integer.parseInt(attrAclRule[4])));
                }
                form.setAclRuleIpType(attrAclRule[6]);
                this.listAclRuleForm.add(form);
            }
        }
    }

    public boolean validatePcapTaskName() {
        if (this.addPacketTaskForm != null && null != this.addPacketTaskForm.getPcapTaskName()) {
            String pcapTaskName = this.addPacketTaskForm.getPcapTaskName().trim();
            String pcapTaskNameRegex = "^(?!null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\!|\\@|\\#|\\$|\\*|\\^|\\+|\\-|\\_|\\=|\\|\\}|\\{|\\]|\\[|\\;|\\?|\\/|\\.]*$";
            if (pcapTaskName.length() > 64) {
                return false;
            }
            if (pcapTaskName.equalsIgnoreCase("null")) {
                return false;
            }
            if (!pcapTaskName.matches(pcapTaskNameRegex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validatePcapType() {
        return this.addPacketTaskForm == null || null == this.addPacketTaskForm.getPcapType() || this.addPacketTaskForm.getPcapType() >= 0 && this.addPacketTaskForm.getPcapType() <= 3;
    }

    public boolean validateSamplingPercent() {
        return this.addPacketTaskForm == null || null == this.addPacketTaskForm.getSamplingPercent() || this.addPacketTaskForm.getSamplingPercent() <= 15;
    }

    public boolean paramsNotValid() {
        boolean returnResultBool;
        boolean bool1 = this.addPacketTaskForm == null || null == this.addPacketTaskForm.getPcapNumber() || "".equals(String.valueOf(this.addPacketTaskForm.getPcapNumber())) || null == this.addPacketTaskForm.getPcapTaskName() || "".equals(this.addPacketTaskForm.getPcapTaskName());
        boolean bool2 = this.addPacketTaskForm == null || null == this.addPacketTaskForm.getPcapType() || "".equals(String.valueOf(this.addPacketTaskForm.getPcapType())) || null == this.addPacketTaskForm.getSamplingPercent() || "".equals(String.valueOf(this.addPacketTaskForm.getSamplingPercent()));
        boolean bl = returnResultBool = bool1 || bool2;
        if (!returnResultBool) {
            String pcapTaskName = this.addPacketTaskForm.getPcapTaskName().trim();
            String pcapTaskNameRegex = "^(?!(?i)null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\!|\\@|\\#|\\$|\\*|\\^|\\+|\\-|\\_|\\=|\\|\\}|\\{|\\]|\\[|\\;|\\?|\\/|\\.]*$";
            if (pcapTaskName.length() > 64) {
                throw new LegoCheckedException(570505L);
            }
            if (!pcapTaskName.matches(pcapTaskNameRegex)) {
                throw new LegoCheckedException(570505L);
            }
        }
        if (null == this.addPacketTaskForm || null == this.addPacketTaskForm.getSamplingPercent() || null == this.addPacketTaskForm.getPcapType()) {
            return returnResultBool;
        }
        if (this.addPacketTaskForm.getSamplingPercent() > 15) {
            throw new LegoCheckedException(570505L);
        }
        if (this.addPacketTaskForm.getPcapType() < 0 || this.addPacketTaskForm.getPcapType() > 3) {
            throw new LegoCheckedException(570505L);
        }
        if (this.forwardStatus != 0 && this.forwardStatus != 1) {
            throw new LegoCheckedException(570505L);
        }
        return returnResultBool;
    }

    private boolean checkPacketTaskCount() {
        String[] neIdsArray = this.neIds.split(",");
        Paging page = this.packetTaskService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        return page.getCount() + neIdsArray.length <= 10000;
    }

    public boolean packetNumValidOfV1() {
        if (this.addPacketTaskForm.getPcapNumber() < 1 || this.addPacketTaskForm.getPcapNumber() > 100000) {
            return false;
        }
        if (this.addPacketTaskForm.getPcapNumber() > 10000) {
            String[] arrNeId = this.neIds.split(",");
            IAticDeviceService aticDeviceService = PacketBisUtil.getIFirewallService();
            for (String iD : arrNeId) {
                AticDevice aticDevice = aticDeviceService.getDeviceByMoid(Long.parseLong(iD.substring(0, iD.indexOf(";"))));
                if (!aticDevice.getVersion().startsWith("V100R001")) continue;
                return false;
            }
        }
        return true;
    }

    public String addAclRule() {
        this.aclRuleTypeDisplay = "IP";
        this.submitType = "add";
        return "add";
    }

    public String editAclRule() {
        this.submitType = "edit";
        String[] recordAttr = this.record.split(",");
        if (recordAttr.length != 7) {
            return "error";
        }
        if (AticUtil.isNull((String)recordAttr[1]) || !recordAttr[1].matches("^(IP|TCP|UDP|ICMP)$")) {
            return "error";
        }
        try {
            int destPort;
            int sourcePort;
            if (!("/".equals(recordAttr[3]) || (sourcePort = Integer.parseInt(recordAttr[3])) >= 0 && sourcePort <= 65535)) {
                return "error";
            }
            if (!("/".equals(recordAttr[5]) || (destPort = Integer.parseInt(recordAttr[5])) >= 0 && destPort <= 65535)) {
                return "error";
            }
        }
        catch (NumberFormatException e) {
            return "error";
        }
        this.aclRuleForm = new AclRuleForm();
        this.aclRuleForm.setAclRuleId(Long.valueOf(Long.parseLong(recordAttr[0])));
        this.aclRuleForm.setAclRuleType(recordAttr[1]);
        this.setAclRuleTypeDisplay(recordAttr[1]);
        if (!"/".equals(recordAttr[2])) {
            this.aclRuleForm.setSourceIpAndMask(recordAttr[2]);
        }
        if (!"/".equals(recordAttr[3])) {
            this.aclRuleForm.setSourcePort(Integer.valueOf(Integer.parseInt(recordAttr[3])));
        }
        if (!"/".equals(recordAttr[4])) {
            this.aclRuleForm.setDestIpAndMask(recordAttr[4]);
        }
        if (!"/".equals(recordAttr[5])) {
            this.aclRuleForm.setDestPort(Integer.valueOf(Integer.parseInt(recordAttr[5])));
        }
        this.aclRuleForm.setAclRuleIpType(recordAttr[6]);
        this.setAclRuleIpTypeDisplay(recordAttr[6]);
        this.hasRule = "true";
        return "edit";
    }

    public boolean validateEditAclRule() {
        if (AticUtil.isNull((String)this.record)) {
            return false;
        }
        String[] recordAttr = this.record.split(",");
        if (recordAttr.length != 7) {
            return false;
        }
        if (AticUtil.isNull((String)recordAttr[1]) || !recordAttr[1].matches("^(IP|TCP|UDP|ICMP)$")) {
            return false;
        }
        if (!this.checkRecordAttr(recordAttr[2])) {
            return false;
        }
        if (!this.checkRecordAttr(recordAttr[4])) {
            return false;
        }
        try {
            int destPort;
            int sourcePort;
            if (!("/".equals(recordAttr[3]) || (sourcePort = Integer.parseInt(recordAttr[3])) >= 0 && sourcePort <= 65535)) {
                return false;
            }
            if (!("/".equals(recordAttr[5]) || (destPort = Integer.parseInt(recordAttr[5])) >= 0 && destPort <= 65535)) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean checkRecordAttr(String recordAttr) {
        if (!AticUtil.isNullForVpn((String)recordAttr) && !"/".equals(recordAttr)) {
            String[] recordTemp = recordAttr.split("/");
            if (!AticUtil.validateIpv4((String)recordTemp[0]) && !IPUtil.isIpv6(recordTemp[0])) {
                return false;
            }
            if (recordTemp.length != 2 || !recordTemp[1].matches("^(([0-9])|([1-2][0-9])|(3[0-2]))$")) {
                return false;
            }
        }
        return true;
    }

    public Map<String, String> createQueryMap() {
        ArrayList<Long> moIDList = new ArrayList<Long>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.packetTaskForm) {
            if (null != this.packetTaskForm.getPcapDeviceId()) {
                queryMap.put("pcapDeviceId", String.valueOf(this.packetTaskForm.getPcapDeviceId()));
                if (0L != this.packetTaskForm.getPcapDeviceId()) {
                    moIDList.add(this.packetTaskForm.getPcapDeviceId());
                }
            }
            if (null != this.packetTaskForm.getPcapTaskState()) {
                queryMap.put("pcapTaskState", String.valueOf(this.packetTaskForm.getPcapTaskState()));
            }
            if (null != this.packetTaskForm.getPcapType()) {
                queryMap.put("pcapType", String.valueOf(this.packetTaskForm.getPcapType()));
            }
            if (null != this.packetTaskForm.getZoneId()) {
                queryMap.put("zoneId", String.valueOf(this.packetTaskForm.getZoneId()));
                if (0L != this.packetTaskForm.getZoneId()) {
                    moIDList.add(PacketBisUtil.getMoidByZoneid(this.packetTaskForm.getZoneId()));
                }
            }
            if (null != this.packetTaskForm.getPcapTaskName()) {
                queryMap.put("taskName", this.packetTaskForm.getPcapTaskName());
            }
            BisUtil.checkUserSecurity(moIDList);
        } else {
            this.processDashBoardPacket(queryMap);
        }
        queryMap.put("sortName", this.sortField);
        queryMap.put("sortType", this.sortType);
        BisUtil.checkUserSecurity(moIDList);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private void processDashBoardPacket(Map<String, String> queryMap) {
        if (null != this.dashBoardZoneId) {
            if (null == this.packetTaskForm) {
                this.packetTaskForm = new PacketTaskForm();
            }
            queryMap.put("zoneId", String.valueOf(this.dashBoardZoneId));
            this.packetTaskForm.setZoneId(this.dashBoardZoneId);
            IZoneService zoneService = PacketBisUtil.getZoneService();
            ZoneInfoForm zoneInfo = zoneService.getById(this.dashBoardZoneId);
            if (null != zoneInfo) {
                this.packetTaskForm.setZoneName(zoneInfo.getZoneDesc());
                this.zoneDisplay = zoneInfo.getZoneDesc();
            }
        }
        if (null != this.dashBoardDeviceId) {
            if (null == this.packetTaskForm) {
                this.packetTaskForm = new PacketTaskForm();
            }
            queryMap.put("pcapDeviceId", String.valueOf(this.dashBoardDeviceId));
            IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
            AticDevice firewall = firewallService.getDeviceByMoid(this.dashBoardDeviceId.longValue());
            if (null != firewall) {
                this.packetTaskForm.setPcapDeviceName(firewall.getName());
                this.deviceDisplay = firewall.getName();
            }
            this.packetTaskForm.setPcapDeviceId(this.dashBoardDeviceId);
        }
    }

    private void dealRelNe(Set<Long> deviceSet) {
        String[] deviceArray;
        ArrayList<Long> moIdList = new ArrayList<Long>(deviceSet);
        BisUtil.checkUserSecurity(moIdList);
        if (StringUtils.isEmpty((CharSequence)this.deviceIdList)) {
            return;
        }
        for (String devid : deviceArray = this.deviceIdList.split(",")) {
            if (StringUtils.isEmpty((CharSequence)devid) || !PacketTaskAction.isNumeric(devid)) continue;
            deviceSet.add(Long.parseLong(devid));
        }
    }

    private static boolean isNumeric(String s) {
        if (s != null && !"".equals(s.trim())) {
            return s.matches("^[0-9]*$");
        }
        return false;
    }

    public String loadDeviceByPcapType() {
        AticDevice firewall;
        ArrayList<AticDevice> fwList;
        List lstDevId;
        ArrayList<Long> lZoneIds;
        IZoneMgrNorthSerice zoneMgrNorthSerice;
        HashSet<Long> deviceSet = new HashSet<Long>();
        this.dealRelNe(deviceSet);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        IAticDeviceService firewallService = PacketBisUtil.getIFirewallService();
        if (0 == Integer.parseInt(this.pcapType)) {
            this.firewallList = firewallService.getCleanDevice(currentUser.getUserID());
        } else if (1 == Integer.parseInt(this.pcapType)) {
            List wallList = null;
            this.firewallList = new ArrayList<AticDevice>();
            if (this.forwardStatus == 1) {
                wallList = firewallService.getCleanDevice(currentUser.getUserID());
                for (int i = 0; i < wallList.size(); ++i) {
                    if (((AticDevice)wallList.get(i)).getDdosType() != 0 && ((AticDevice)wallList.get(i)).getDdosType() != 2) continue;
                    this.firewallList.add((AticDevice)wallList.get(i));
                }
            } else {
                this.firewallList = firewallService.getAntiDDoSDevice(currentUser.getUserID());
            }
        } else if (2 == Integer.parseInt(this.pcapType)) {
            if (null != this.zoneId) {
                zoneMgrNorthSerice = PacketBisUtil.getZoneMgrNorthSerice();
                String[] strZoneIds = this.zoneId.split(",");
                lZoneIds = new ArrayList<Long>();
                for (int i = 0; i < strZoneIds.length; ++i) {
                    lZoneIds.add(Long.parseLong(strZoneIds[i]));
                }
                lstDevId = zoneMgrNorthSerice.getDevByZone4Secutity(lZoneIds, isAdmin, Long.valueOf(currentUser.getUserID()));
                fwList = new ArrayList<AticDevice>();
                for (Long devID : lstDevId) {
                    firewall = firewallService.getDeviceByMoid(devID.longValue());
                    if (null == firewall || 0 != firewall.getDdosType() && 2 != firewall.getDdosType()) continue;
                    fwList.add(firewall);
                }
                this.firewallList = fwList;
            }
        } else if (3 == Integer.parseInt(this.pcapType) && null != this.zoneId) {
            zoneMgrNorthSerice = PacketBisUtil.getZoneMgrNorthSerice();
            String[] strZoneIds = this.zoneId.split(",");
            lZoneIds = new ArrayList();
            for (int i = 0; i < strZoneIds.length; ++i) {
                lZoneIds.add(Long.parseLong(strZoneIds[i]));
            }
            lstDevId = zoneMgrNorthSerice.getDevByZone4Secutity(lZoneIds, isAdmin, Long.valueOf(currentUser.getUserID()));
            fwList = new ArrayList();
            for (Long devID : lstDevId) {
                firewall = firewallService.getDeviceByMoid(devID.longValue());
                if (null == firewall || firewall.getDeviceType() == 5) continue;
                fwList.add(firewall);
            }
            this.firewallList = fwList;
        }
        if (this.firewallList == null || this.firewallList.isEmpty()) {
            return "list";
        }
        ArrayList<AticDevice> list = new ArrayList<AticDevice>();
        for (AticDevice bean : this.firewallList) {
            long moId = bean.getMoId();
            if (deviceSet.contains(moId)) continue;
            list.add(bean);
        }
        this.firewallList = list;
        Collections.sort(this.firewallList, comparator2);
        return "list";
    }

    private void initcaptureComb() {
        this.captureLengthCombData = new ArrayList<RadioBean>();
        RadioBean bean1 = new RadioBean();
        bean1.setKey(1);
        bean1.setLabel(this.getText("com.hs.vsm.secservice.neglobal.capture.mode.hearder"));
        this.captureLengthCombData.add(bean1);
        RadioBean bean2 = new RadioBean();
        bean2.setKey(2);
        bean2.setLabel(this.getText("com.hs.vsm.secservice.neglobal.capture.mode.all"));
        this.captureLengthCombData.add(bean2);
        RadioBean bean3 = new RadioBean();
        bean3.setKey(3);
        bean3.setLabel(this.getText("com.hs.vsm.secservice.neglobal.capture.mode.user"));
        this.captureLengthCombData.add(bean3);
    }

    private void initFingerFilter() {
        this.fingerFilterCombData = new ArrayList<RadioBean>();
        RadioBean bean1 = new RadioBean();
        bean1.setKey(0);
        bean1.setLabel(this.getText("atic.bis.pcap.task.finger.filter.disable"));
        this.fingerFilterCombData.add(bean1);
        RadioBean bean2 = new RadioBean();
        bean2.setKey(1);
        bean2.setLabel(this.getText("atic.bis.pcap.task.finger.filter.enable"));
        this.fingerFilterCombData.add(bean2);
    }

    public List<PacketTaskForm> getPacketTaskFormList() {
        return this.packetTaskFormList;
    }

    public PacketTaskForm getPacketTaskForm() {
        return this.packetTaskForm;
    }

    public void setPacketTaskForm(PacketTaskForm packetTaskForm) {
        this.packetTaskForm = packetTaskForm;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public List<LangPair> getListDeviceName() {
        return this.listDeviceName;
    }

    public void setListDeviceName(List<LangPair> listDeviceName) {
        this.listDeviceName = listDeviceName;
    }

    public LangPair getLangPair() {
        return this.langPair;
    }

    public void setLangPair(LangPair langPair) {
        this.langPair = langPair;
    }

    public List<LangPair> getListZoneName() {
        return this.listZoneName;
    }

    public void setListZoneName(List<LangPair> listZoneName) {
        this.listZoneName = listZoneName;
    }

    public String getRecord() {
        return this.record;
    }

    public void setRecord(String record) {
        this.record = record;
    }

    public AclRuleForm getAclRuleForm() {
        return this.aclRuleForm;
    }

    public void setAclRuleForm(AclRuleForm aclRuleForm) {
        this.aclRuleForm = aclRuleForm;
    }

    public String getAclRuleTypeDisplay() {
        if (null == this.aclRuleTypeDisplay) {
            return null;
        }
        return this.aclRuleTypeDisplay.trim();
    }

    public void setAclRuleTypeDisplay(String aclRuleTypeDisplay) {
        this.aclRuleTypeDisplay = aclRuleTypeDisplay;
    }

    public String getSubmitType() {
        if (null == this.submitType) {
            return null;
        }
        return this.submitType.trim();
    }

    public void setSubmitType(String submitType) {
        this.submitType = submitType;
    }

    public PacketTaskForm getAddPacketTaskForm() {
        return this.addPacketTaskForm;
    }

    public void setAddPacketTaskForm(PacketTaskForm addPacketTaskForm) {
        this.addPacketTaskForm = addPacketTaskForm;
    }

    public String getAclRuleInfo() {
        return this.aclRuleInfo;
    }

    public void setAclRuleInfo(String aclRuleInfo) {
        this.aclRuleInfo = aclRuleInfo;
    }

    public Long[] getIds() {
        if (null != this.ids) {
            return (Long[])this.ids.clone();
        }
        return new Long[0];
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public String[] getNames() {
        if (null != this.names) {
            return (String[])this.names.clone();
        }
        return new String[0];
    }

    public void setNames(String[] names) {
        this.names = null != names ? (String[])names.clone() : null;
    }

    public List<LangPair> getStrListDeviceSearchComb() {
        if (null == this.strListDeviceSearchComb) {
            return null;
        }
        return this.strListDeviceSearchComb;
    }

    public void setStrListDeviceSearchComb(List<LangPair> strListDeviceSearchComb) {
        this.strListDeviceSearchComb = strListDeviceSearchComb;
    }

    public String getStateDisplay() {
        if (null == this.stateDisplay) {
            return null;
        }
        return this.stateDisplay.trim();
    }

    public void setStateDisplay(String stateDisplay) {
        this.stateDisplay = stateDisplay;
    }

    public String getZoneDisplay() {
        if (null == this.zoneDisplay) {
            return null;
        }
        return this.zoneDisplay.trim();
    }

    public void setZoneDisplay(String zoneDisplay) {
        this.zoneDisplay = zoneDisplay;
    }

    public String getTypeDisplay() {
        if (null == this.typeDisplay) {
            return null;
        }
        return this.typeDisplay.trim();
    }

    public void setTypeDisplay(String typeDisplay) {
        this.typeDisplay = typeDisplay;
    }

    public String getDeviceDisplay() {
        if (null == this.deviceDisplay) {
            return null;
        }
        return this.deviceDisplay.trim();
    }

    public void setDeviceDisplay(String deviceDisplay) {
        this.deviceDisplay = deviceDisplay;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCombTypeDisplay() {
        if (null == this.combTypeDisplay) {
            return null;
        }
        return this.combTypeDisplay.trim();
    }

    public void setCombTypeDisplay(String combTypeDisplay) {
        this.combTypeDisplay = combTypeDisplay;
    }

    public String getCombPercentDisplay() {
        if (null == this.combPercentDisplay) {
            return null;
        }
        return this.combPercentDisplay.trim();
    }

    public void setCombPercentDisplay(String combPercentDisplay) {
        this.combPercentDisplay = combPercentDisplay;
    }

    public String[] getAclTypes() {
        if (null != this.aclTypes) {
            return (String[])this.aclTypes.clone();
        }
        return new String[0];
    }

    public void setAclTypes(String[] aclTypes) {
        this.aclTypes = null != aclTypes ? (String[])aclTypes.clone() : null;
    }

    public String[] getStates() {
        if (null != this.states) {
            return (String[])this.states.clone();
        }
        return new String[0];
    }

    public void setStates(String[] states) {
        this.states = null != states ? (String[])states.clone() : null;
    }

    public String getDefaultTabPage() {
        return this.defaultTabPage;
    }

    public void setDefaultTabPage(String defaultTabPage) {
        this.defaultTabPage = defaultTabPage;
    }

    public String getDevId() {
        return this.devId;
    }

    public List<LangPair> getPacketTaskStateData() {
        return this.packetTaskStateData;
    }

    public void setPacketTaskStateData(List<LangPair> packetTaskStateData) {
        this.packetTaskStateData = packetTaskStateData;
    }

    public void setDevId(String devId) {
        this.devId = devId;
    }

    public String getAllQueryDisplay() {
        if (null == this.allQueryDisplay) {
            return null;
        }
        return this.allQueryDisplay.trim();
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public List<LangPair> getPcapTypeData() {
        return this.pcapTypeData;
    }

    public void setPcapTypeData(List<LangPair> pcapTypeData) {
        this.pcapTypeData = pcapTypeData;
    }

    public String getPcapType() {
        return this.pcapType;
    }

    public void setPcapType(String pcapType) {
        this.pcapType = pcapType;
    }

    public String getSubmitToken() {
        return this.submitToken.toString();
    }

    public void setSubmitToken(String submitToken) {
        this.submitToken = new StringBuffer(submitToken);
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public int getPageSize() {
        try {
            return null == this.fetchRequest().getParameter("pageSize") && null == this.packetTaskForm ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
        }
        catch (RuntimeException e) {
            return this.pageSize;
        }
    }

    public boolean validateIds() {
        if (null == this.ids) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateTempStr(String idd) {
        if (null != idd) {
            if ("".equals(idd)) {
                return true;
            }
            if (!StringUtils.isEmpty((CharSequence)idd)) {
                String[] idStrs;
                for (String idm : idStrs = idd.split(",")) {
                    if (!AticUtil.isNull((String)idm) && Integer.parseInt(idm) >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateTempStrNe(String idd) {
        if (null != idd) {
            if ("".equals(idd)) {
                return true;
            }
            if (!StringUtils.isEmpty((CharSequence)idd)) {
                String[] idStrs;
                String regex = "(^[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\/|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\-|\\[|\\]]*$)";
                for (String idm : idStrs = idd.split(",")) {
                    if (AticUtil.isNull((String)idm) || AticUtil.isNull((String)idm.split(";")[0]) || Integer.parseInt(idm.split(";")[0]) < 0) {
                        return false;
                    }
                    if (idm.split(";").length == 2 && idm.split(";")[1].matches(regex)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateTempStrNeIp(String neIp) {
        if (!StringUtils.isEmpty((CharSequence)neIp)) {
            String[] idStrs;
            for (String idm : idStrs = neIp.split(",")) {
                if (IPUtil.isIpv4(idm.trim()) || IPUtil.isIpv6(idm.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public List<ZoneInfoForm> getQueryZoneFormList() {
        return this.queryZoneFormList;
    }

    public void setQueryZoneFormList(List<ZoneInfoForm> queryZoneFormList) {
        this.queryZoneFormList = queryZoneFormList;
    }

    public ZoneInfoForm getZoneInfoForm() {
        return this.zoneInfoForm;
    }

    public void setZoneInfoForm(ZoneInfoForm zoneInfoForm) {
        this.zoneInfoForm = zoneInfoForm;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public void setForceDelete(String forceDelete) {
        this.forceDelete = forceDelete;
    }

    public String getForceDelete() {
        return this.forceDelete;
    }

    public String getForceStop() {
        return this.forceStop;
    }

    public void setForceStop(String forceStop) {
        this.forceStop = forceStop;
    }

    public Integer getCaptureModeValue() {
        return this.captureModeValue;
    }

    public void setCaptureModeValue(Integer captureModeValue) {
        this.captureModeValue = captureModeValue;
    }

    public Integer getPcapLength() {
        return this.pcapLength;
    }

    public void setPcapLength(Integer pcapLength) {
        this.pcapLength = pcapLength;
    }

    public List<RadioBean> getCaptureLengthCombData() {
        return this.captureLengthCombData;
    }

    public void setCaptureLengthCombData(List<RadioBean> captureLengthCombData) {
        this.captureLengthCombData = captureLengthCombData;
    }

    public String getAclRuleIpTypeDisplay() {
        return this.aclRuleIpTypeDisplay;
    }

    public void setAclRuleIpTypeDisplay(String aclRuleIpTypeDisplay) {
        this.aclRuleIpTypeDisplay = aclRuleIpTypeDisplay;
    }

    public String getHasRule() {
        return this.hasRule;
    }

    public void setHasRule(String hasRule) {
        this.hasRule = hasRule;
    }

    public List<RadioBean> getFingerFilterCombData() {
        return this.fingerFilterCombData;
    }

    public void setFingerFilterCombData(List<RadioBean> fingerFilterCombData) {
        this.fingerFilterCombData = fingerFilterCombData;
    }

    public Integer getFingerFilterValue() {
        return this.fingerFilterValue;
    }

    public void setFingerFilterValue(Integer fingerFilterValue) {
        this.fingerFilterValue = fingerFilterValue;
    }

    public String getNeIds() {
        return this.neIds;
    }

    public void setNeIds(String neIds) {
        this.neIds = neIds;
    }

    public String getZoneIds() {
        return this.zoneIds;
    }

    public void setZoneIds(String zoneIds) {
        this.zoneIds = zoneIds;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSelectZoneId() {
        return this.selectZoneId;
    }

    public void setSelectZoneId(String selectZoneId) {
        this.selectZoneId = selectZoneId;
    }

    public String getListZoneSel() {
        return this.listZoneSel;
    }

    public void setListZoneSel(String listZoneSel) {
        this.listZoneSel = listZoneSel;
    }

    public Long getDashBoardZoneId() {
        return this.dashBoardZoneId;
    }

    public void setDashBoardZoneId(Long dashBoardZoneId) {
        this.dashBoardZoneId = dashBoardZoneId;
    }

    public Long getDashBoardDeviceId() {
        return this.dashBoardDeviceId;
    }

    public void setDashBoardDeviceId(Long dashBoardDeviceId) {
        this.dashBoardDeviceId = dashBoardDeviceId;
    }

    public String getCreatStart() {
        return this.creatStart;
    }

    public void setCreatStart(String creatStart) {
        this.creatStart = creatStart;
    }

    public boolean validatePcapDeviceId() {
        if (null == this.packetTaskForm) {
            return true;
        }
        if (null == this.packetTaskForm.getPcapDeviceId()) {
            return true;
        }
        return this.packetTaskForm.getPcapDeviceId() > 0L;
    }

    public boolean validatePcapTaskState() {
        if (null == this.packetTaskForm) {
            return true;
        }
        if (null == this.packetTaskForm.getPcapTaskState()) {
            return true;
        }
        return this.packetTaskForm.getPcapTaskState() == 0 || this.packetTaskForm.getPcapTaskState() == 1;
    }

    public boolean validatePacketTaskFormZoneId() {
        if (null == this.packetTaskForm) {
            return true;
        }
        if (null == this.packetTaskForm.getZoneId()) {
            return true;
        }
        return this.packetTaskForm.getZoneId() > 0L;
    }

    public boolean validatePacketTaskFormPcapType() {
        if (null == this.packetTaskForm) {
            return true;
        }
        if (null == this.packetTaskForm.getPcapType()) {
            return true;
        }
        return this.packetTaskForm.getPcapType() >= 0;
    }

    public boolean validatePacketTaskName(String taskNameTemp) {
        String pcapTaskName = this.fetchRequest().getParameter(taskNameTemp);
        if (null != pcapTaskName) {
            String pcapTaskNameRegex = "^(?!null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\!|\\@|\\#|\\$|\\*|\\^|\\+|\\-|\\_|\\=|\\|\\}|\\{|\\]|\\[|\\;|\\?|\\/|\\.]*$";
            if (pcapTaskName.length() > 64) {
                return false;
            }
            if (pcapTaskName.trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (!pcapTaskName.matches(pcapTaskNameRegex)) {
                return false;
            }
        }
        return true;
    }

    public Boolean validateNames() {
        if (null == this.names) {
            return false;
        }
        for (String nameTemp : this.names) {
            if (this.validatePacketTaskName(nameTemp)) continue;
            return false;
        }
        return true;
    }

    public boolean validateZoneDesc() {
        if (null == this.zoneDisplay || "".equals(this.zoneDisplay.trim())) {
            return true;
        }
        if (this.zoneDisplay.length() > 64) {
            return false;
        }
        if (this.zoneDisplay.trim().equalsIgnoreCase("null")) {
            return false;
        }
        String nameRegex = "^(?!null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|.|+|\\}|\\{]*$";
        return this.zoneDisplay.matches(nameRegex);
    }

    public List<VpnForm> getVpnForms() {
        return this.vpnForms;
    }

    public void setVpnForms(List<VpnForm> vpnForms) {
        this.vpnForms = vpnForms;
    }

    public String getNeVpnName() {
        return this.neVpnName;
    }

    public void setNeVpnName(String neVpnName) {
        this.neVpnName = neVpnName;
    }

    public String getDeviceVpn() {
        return this.deviceVpn;
    }

    public void setDeviceVpn(String deviceVpn) {
        this.deviceVpn = deviceVpn;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Integer getForwardStatus() {
        return this.forwardStatus;
    }

    public void setForwardStatus(Integer forwardStatus) {
        this.forwardStatus = forwardStatus;
    }

    public String getNeIps() {
        return this.neIps;
    }

    public void setNeIps(String neIps) {
        this.neIps = neIps;
    }

    public String getDeviceIdList() {
        return this.deviceIdList;
    }

    public void setDeviceIdList(String deviceIdList) {
        this.deviceIdList = deviceIdList;
    }
}

