/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.dao;

import com.hs.atic.bis.model.PacketTask;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class PacketTaskDao
extends CommonDaoImpl {
    public PacketTask get(long id) {
        String hql = "from PacketTask where id = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (PacketTask)result.get(0);
    }

    public void remove(long id) {
        String hql = "delete from PacketTask where id = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public boolean isPacketTaskExists(String packetName) {
        if (packetName == null) {
            return false;
        }
        String hql = "from PacketTask where lower(pcapTaskName) = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, packetName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public boolean isTaskExistByFuzzyQuery(String packetName) {
        if (packetName == null) {
            return false;
        }
        String hql = "from PacketTask where lower(pcapTaskName) = ? or lower(pcapTaskName) like ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, packetName.trim().toLowerCase(Locale.ENGLISH));
        param.put(1, (packetName.trim() + "\\_").toLowerCase(Locale.ENGLISH) + "%");
        List result = this.findByHql(hql, param);
        return result != null && !result.isEmpty();
    }

    public List<PacketTask> findPacketTaskByName(String packetName) {
        if (packetName == null) {
            return new ArrayList<PacketTask>();
        }
        String hql = "from PacketTask where lower(pcapTaskName) = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, packetName.trim().toLowerCase(Locale.ENGLISH));
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<PacketTask>();
        }
        return result;
    }

    public List<PacketTask> findPacketTaskByDevId(Long deviceId) {
        if (deviceId == null) {
            return new ArrayList<PacketTask>();
        }
        String hql = "from PacketTask where pcapDeviceId = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<PacketTask>();
        }
        return result;
    }

    public List<PacketTask> findPacketTaskByZoneId(Long zoneId) {
        if (zoneId == null) {
            return new ArrayList<PacketTask>();
        }
        String hql = "from PacketTask where zoneId = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<PacketTask>();
        }
        return result;
    }

    public List<PacketTask> findPacketTaskByZoneIdAndDevId(Long zoneId, Long devId) {
        if (zoneId == null || devId == null) {
            return new ArrayList<PacketTask>();
        }
        String hql = "from PacketTask where zoneId = ? and pcapDeviceId = ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, zoneId.toString());
        param.put(1, devId.toString());
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<PacketTask>();
        }
        return result;
    }

    public List<PacketTask> findPacketTaskListByName(String packetName) {
        if (packetName == null) {
            return new ArrayList<PacketTask>();
        }
        String hql = "from PacketTask where lower(pcapTaskName) like ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, "%" + packetName.trim().toLowerCase(Locale.ENGLISH) + "%");
        List result = this.findByHql(hql, param);
        if (result == null) {
            return new ArrayList<PacketTask>();
        }
        return result;
    }

    public boolean isSameTypeTaskStart(Long deviceId, Integer taskType, Long zoneId) {
        List result;
        if (deviceId == null || taskType == null) {
            return false;
        }
        String hql = "from PacketTask where pcapDeviceId=? and pcapType=? and pcapTaskState=1";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, taskType.toString());
        if (taskType > 1 && zoneId != null) {
            hql = hql + "and zoneId=?";
            param.put(2, zoneId.toString());
        }
        return (result = this.findByHql(hql, param)) != null && !result.isEmpty();
    }

    public List<Object> getDistinctDeviceId() {
        String hql = "select distinct pcapDeviceId from PacketTask where pcapDeviceId <> NULL";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<Object>();
        }
        return result;
    }

    public List<Object> getDistinctZoneId() {
        String hql = "select distinct zoneId from PacketTask where zoneId <> NULL";
        List result = this.findByHql(hql);
        if (result == null) {
            return new ArrayList<Object>();
        }
        return result;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        String taskName;
        String zoneId;
        String pcapType;
        String pcapTaskState;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from PacketTask where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        String userId = conditionMap.get("currentUserId");
        if (isAdmin != null && userId != null && isAdmin.equalsIgnoreCase("false")) {
            long uid = Long.parseLong(userId);
            String authSql = CheckChildrenMoUtil.getInstanse().getHql(uid);
            hql = hql + " and pcapDeviceId in (" + authSql + ") and (zoneId is null or zoneId = 0 or zoneId in (select zoneId from ZoneInfo where moId in (" + authSql + ")))";
        }
        int index = 0;
        String pcapDeviceId = conditionMap.get("pcapDeviceId");
        if (!AticUtil.isNull((String)pcapDeviceId)) {
            hql = hql + " and pcapDeviceId = ? ";
            queryMap.put(index++, pcapDeviceId.trim());
        }
        if (!AticUtil.isNull((String)(pcapTaskState = conditionMap.get("pcapTaskState")))) {
            hql = hql + " and pcapTaskState = ? ";
            queryMap.put(index++, pcapTaskState.trim());
        }
        if (!AticUtil.isNull((String)(pcapType = conditionMap.get("pcapType")))) {
            hql = hql + " and pcapType = ? ";
            queryMap.put(index++, pcapType.trim());
        }
        if (!AticUtil.isNull((String)(zoneId = conditionMap.get("zoneId")))) {
            hql = hql + " and zoneId = ? ";
            queryMap.put(index++, zoneId.trim());
        }
        if (!AticUtil.isNull((String)(taskName = conditionMap.get("taskName")))) {
            hql = hql + " and lower(pcapTaskName) like ? ";
            queryMap.put(index++, "%" + taskName.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<PacketTask> getSecurityData(Map<String, String> conditionMap) {
        List result;
        String hql = " from PacketTask where (1=1) ";
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        String userId = conditionMap.get("currentUserId");
        if (isAdmin != null && userId != null && isAdmin.equalsIgnoreCase("false")) {
            long uid = Long.parseLong(userId);
            String authSql = CheckChildrenMoUtil.getInstanse().getHql(uid);
            hql = hql + " and pcapDeviceId in (" + authSql + ") and (zoneId is null or zoneId = 0 or zoneId in (select zoneId from ZoneInfo where moId in (" + authSql + ")))";
        }
        if ((result = this.findByHql(hql)) == null) {
            return new ArrayList<PacketTask>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<PacketTask>();
    }

    public List<Long> getSecurityDataIds(Map<String, String> conditionMap) {
        List result;
        String hql = "select id from PacketTask where (1=1) ";
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        String userId = conditionMap.get("currentUserId");
        if (isAdmin != null && userId != null && isAdmin.equalsIgnoreCase("false")) {
            long uid = Long.parseLong(userId);
            String authSql = CheckChildrenMoUtil.getInstanse().getHql(uid);
            hql = hql + " and pcapDeviceId in (" + authSql + ") and (zoneId is null  or zoneId = 0 or zoneId in (select zoneId from ZoneInfo where moId in (" + authSql + ")))";
        }
        if ((result = this.findByHql(hql)) == null) {
            return new ArrayList<Long>();
        }
        if (result instanceof ArrayList) {
            return (ArrayList)result;
        }
        return new ArrayList<Long>();
    }
}

