/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.dao.PacketTaskDao;
import com.hs.atic.bis.model.DnsPacketInfo;
import com.hs.atic.bis.model.HttpPacketInfo;
import com.hs.atic.bis.model.IpPacketInfo;
import com.hs.atic.bis.model.PacketAnalysis;
import com.hs.atic.bis.model.PacketTask;
import com.hs.atic.bis.model.PcapAnalysisResult;
import com.hs.atic.bis.model.PcapAnalysisResultUdpfinger;
import com.hs.atic.bis.model.PcapAnanlysisObject;
import com.hs.atic.bis.model.TcpPacketInfo;
import com.hs.atic.bis.model.UdpPacketInfo;
import com.hs.atic.collector.entity.log.AttackExactLog;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.collector.entity.pcap.AttackerCount;
import com.hs.atic.collector.entity.pcap.PcapFileQueryObj;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.ProtocolItem;
import com.hs.atic.collector.entity.pcap.UnresolvedProtocol;
import com.hs.atic.collector.entity.pcap.ZonePacket;
import com.hs.atic.collector.entity.zonepacket.ZonePacketInfoObj;
import com.hs.atic.rmi.CapturePcapService;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.PacketCollectorRMIProxy;
import com.hs.atic.rmi.PcapProtocolQueryService;
import com.hs.atic.rmi.ZonePacketService;
import com.hs.atic.sdk.bis.form.AttackLogDetailForm;
import com.hs.atic.sdk.bis.form.AttackerCountForm;
import com.hs.atic.sdk.bis.form.PacketFileForm;
import com.hs.atic.sdk.bis.form.PacketFingerPrintInfoForm;
import com.hs.atic.sdk.bis.form.ProtocolItemForm;
import com.hs.atic.sdk.bis.service.IPacketFileService;
import com.hs.atic.sdk.util.PacketFileSort;
import com.hs.atic.sdk.util.PacketQueryBean;
import com.hs.atic.sdk.util.PcapLogQueryBean;
import com.hs.atic.sdk.util.ReportQueryBean;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PacketFileServiceImpl
implements IPacketFileService {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private static final int MAX_TOP5 = 5;
    private PacketCollectorRMIProxy packetCollectorRMIProxy;
    private IZoneService zoneService;
    private List<ProtocolItem> pcapResolutionDataList;
    private PacketTaskDao packetTaskDao;
    private IAticDeviceService aticDeviceService;
    private int staticStart = 0;
    private int staticPageSize = 0;

    @Override
    public Paging listPacketFile(List<String> collectorIpList, PacketQueryBean packetQueryBean, int start, int pageSize, PacketFileSort<PacketFileForm> sort) {
        this.staticStart = start;
        this.staticPageSize = pageSize;
        logger.info((Object)"begin listPacketFile()...");
        Paging page = new Paging();
        if (null == collectorIpList) {
            logger.error((Object)"collectorIpList is null !");
            return page;
        }
        ArrayList packetFileFormList = new ArrayList();
        ArrayList<PacketFileForm> securityPacketFileDate = new ArrayList<PacketFileForm>();
        int totalSize = this.getAllPcapFile(collectorIpList, packetQueryBean, securityPacketFileDate, sort);
        for (PacketFileForm form : securityPacketFileDate) {
            AticDevice device;
            if (form.getDeviceIp() == null || "".equals(form.getDeviceIp()) || (device = this.aticDeviceService.getDeviceByIp(form.getDeviceIp())) == null) continue;
            form.setDeviceName(device.getName());
        }
        for (int i = 0; i < securityPacketFileDate.size(); ++i) {
            packetFileFormList.add(securityPacketFileDate.get(i));
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("currentUserId", String.valueOf(packetQueryBean.getCurrentUseId()));
        queryMap.put("currentUserIsAdmin", String.valueOf(packetQueryBean.getIsAdmin()));
        List<PacketTask> packetTaskList = this.packetTaskDao.getSecurityData(queryMap);
        if (!packetTaskList.isEmpty()) {
            for (PacketFileForm packetFile : packetFileFormList) {
                for (PacketTask packetTask : packetTaskList) {
                    if (!packetFile.getPcapId().equals(packetTask.getId())) continue;
                    packetFile.setPcapName(packetTask.getPcapTaskName());
                }
            }
        }
        page.setData(packetFileFormList);
        page.setCount(totalSize);
        return page;
    }

    private int getAllPcapFile(List<String> collectorIpList, PacketQueryBean packetQueryBean, List<PacketFileForm> securityPacketFileDate, PacketFileSort<PacketFileForm> sort) {
        int totalSize = 0;
        PcapFileQueryObj pcapFileQueryObj = this.getPcapObj(packetQueryBean);
        ArrayList<ZonePacketInfoObj> zoneAllPacketFileList = new ArrayList<ZonePacketInfoObj>();
        ZonePacketService zonePacketService = null;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("currentUserId", String.valueOf(packetQueryBean.getCurrentUseId()));
        queryMap.put("currentUserIsAdmin", String.valueOf(packetQueryBean.getIsAdmin()));
        List<Object> packetTaskIds = new ArrayList();
        if (null != packetQueryBean.getCurrentUseId() && !packetQueryBean.getIsAdmin().booleanValue()) {
            packetTaskIds = this.packetTaskDao.getSecurityDataIds(queryMap);
        }
        for (String collectorIp : collectorIpList) {
            List<ZonePacketInfoObj> zonePacketFileList = null;
            zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(collectorIp);
            pcapFileQueryObj.setStartPage(this.staticStart);
            pcapFileQueryObj.setPageSize(this.staticPageSize);
            pcapFileQueryObj.setSortField(sort.getSortField());
            pcapFileQueryObj.setSortType(sort.getSortType());
            if (!packetTaskIds.isEmpty()) {
                ArrayList<String> listIds = new ArrayList<String>();
                if (pcapFileQueryObj.getTaskIdList() == null || pcapFileQueryObj.getTaskIdList().isEmpty()) {
                    for (Long l : packetTaskIds) {
                        listIds.add(String.valueOf(l));
                    }
                } else {
                    block4: for (String string : pcapFileQueryObj.getTaskIdList()) {
                        for (Long l : packetTaskIds) {
                            if (!string.equals(String.valueOf(l))) continue;
                            listIds.add(string);
                            continue block4;
                        }
                    }
                }
                if (!listIds.isEmpty()) {
                    pcapFileQueryObj.setTaskIdList(listIds);
                }
            }
            if (null == zonePacketService) continue;
            try {
                zonePacketFileList = zonePacketService.findZonePacketList(pcapFileQueryObj);
                totalSize += zonePacketService.findZonePacketSize(pcapFileQueryObj);
            }
            catch (Exception e) {
                logger.error((Object)"execute findZonePacketList failed in PacketFileServiceImpl ", (Throwable)e);
                return 0;
            }
            if (null == zonePacketFileList || zonePacketFileList.isEmpty()) continue;
            for (ZonePacketInfoObj zonePacketInfo : zonePacketFileList) {
                zonePacketInfo.setFtpAddress(collectorIp);
                zonePacketInfo.setZoneIp(IPUtil4Atic.compressIP((String)zonePacketInfo.getZoneIp()));
            }
            zoneAllPacketFileList.addAll(zonePacketFileList);
        }
        if (!zoneAllPacketFileList.isEmpty()) {
            for (ZonePacketInfoObj packetInfoObj : zoneAllPacketFileList) {
                PacketFileForm packetFileForm = new PacketFileForm();
                AticUtil.copyProperties((Object)packetInfoObj, (Object)packetFileForm);
                securityPacketFileDate.add(packetFileForm);
            }
        }
        return totalSize;
    }

    private PcapFileQueryObj getPcapObj(PacketQueryBean packetQueryBean) {
        logger.info((Object)"begin getPcapObj()...");
        PcapFileQueryObj pcapFileQueryObj = new PcapFileQueryObj();
        if (null == packetQueryBean) {
            logger.error((Object)"packetQueryBean is null !");
            return pcapFileQueryObj;
        }
        String beginTime = packetQueryBean.getBeginTime();
        String endTime = packetQueryBean.getEndTime();
        String pcapType = packetQueryBean.getPcapType();
        String fileState = packetQueryBean.getFileState();
        String fileName = packetQueryBean.getFileName();
        String taskName = packetQueryBean.getTaskName();
        Long beginTimeLong = 0L;
        Long endTimeLong = 0L;
        if (!AticUtil.isNull((String)beginTime)) {
            beginTimeLong = AticUtil.convertTimeString((String)beginTime);
        }
        if (!AticUtil.isNull((String)endTime)) {
            endTimeLong = AticUtil.convertTimeString((String)endTime);
        }
        pcapFileQueryObj.setBeginTime(beginTimeLong);
        pcapFileQueryObj.setEndTime(endTimeLong);
        pcapFileQueryObj.setPcapType(pcapType);
        pcapFileQueryObj.setFileState(fileState);
        pcapFileQueryObj.setFileName(fileName);
        pcapFileQueryObj.setQueryDeviceIp(packetQueryBean.getQueryDeviceIp());
        pcapFileQueryObj.setQueryPacketIp(packetQueryBean.getQueryPacketIp());
        if (null != taskName && !"".equals(taskName)) {
            ArrayList<String> taskIdList = new ArrayList<String>();
            List<PacketTask> listPacketTaskForm = this.packetTaskDao.findPacketTaskListByName(taskName);
            if (!listPacketTaskForm.isEmpty()) {
                for (PacketTask packetTask : listPacketTaskForm) {
                    taskIdList.add(String.valueOf(packetTask.getId()));
                }
                pcapFileQueryObj.setTaskIdList(taskIdList);
            } else {
                taskIdList.add("0");
                pcapFileQueryObj.setTaskIdList(taskIdList);
            }
        }
        return pcapFileQueryObj;
    }

    @Override
    public Paging findAttackSource(String collectorIp, String fileName, Integer attackType, int start, int pageSize) {
        logger.info((Object)"begin findAttackSource()...");
        int totalSize = 0;
        Paging page = new Paging();
        List<Object> attackerCountList = new ArrayList();
        ArrayList<AttackerCountForm> attackerCountFormList = new ArrayList<AttackerCountForm>();
        PcapProtocolQueryService pcapProtocolQueryService = this.packetCollectorRMIProxy.getPcapProtocolQueryService(collectorIp);
        if (null != pcapProtocolQueryService) {
            try {
                attackerCountList = pcapProtocolQueryService.getPcapAttackerInfo(fileName, attackType);
            }
            catch (Exception e) {
                logger.error((Object)"getPcapAttackerInfo failed! ", (Throwable)e);
            }
            if (null != attackerCountList) {
                totalSize = attackerCountList.size();
                for (int i = start; i < start + pageSize && i < totalSize; ++i) {
                    AttackerCount attackerCount = (AttackerCount)attackerCountList.get(i);
                    AttackerCountForm attackerCountForm = new AttackerCountForm();
                    AticUtil.copyProperties((Object)attackerCount, (Object)attackerCountForm);
                    attackerCountFormList.add(attackerCountForm);
                }
            }
        }
        page.setData(attackerCountFormList);
        page.setCount(totalSize);
        return page;
    }

    @Override
    public Paging findPcapResolution(String zonePacketFileName, String ftpAddress, int start, int pageSize) {
        logger.info((Object)"begin findPcapResolution()...");
        int pcapResSize = 0;
        Paging page = new Paging();
        ArrayList<ProtocolItemForm> protocolItemFormList = new ArrayList<ProtocolItemForm>();
        PcapProtocolQueryService pcapProtocolQueryService = this.packetCollectorRMIProxy.getPcapProtocolQueryService(ftpAddress);
        if (null != pcapProtocolQueryService) {
            try {
                this.pcapResolutionDataList = new ArrayList<ProtocolItem>();
                pcapResSize = pcapProtocolQueryService.queryPcapItemSize(zonePacketFileName);
                if (start + pageSize > pcapResSize) {
                    pageSize = pcapResSize - start;
                }
                this.pcapResolutionDataList = pcapProtocolQueryService.queryPcapItemContens(zonePacketFileName, start, pageSize);
            }
            catch (Exception e) {
                logger.error((Object)"Find PcapResolution exception!", (Throwable)e);
            }
        }
        if (null != this.pcapResolutionDataList) {
            for (int i = 0; i < this.pcapResolutionDataList.size() && i < pageSize; ++i) {
                ProtocolItem pcapResolutionData = this.pcapResolutionDataList.get(i);
                ProtocolItemForm protocolItemForm = new ProtocolItemForm();
                pcapResolutionData.setId(i + 1);
                protocolItemForm.setId(i + 1);
                protocolItemForm.setTime(AticUtil.formateTime((long)pcapResolutionData.getTime()));
                protocolItemForm.setSourceIp(pcapResolutionData.getSourceIp());
                protocolItemForm.setDestinationIp(pcapResolutionData.getDestinationIp());
                protocolItemForm.setProtocolName(pcapResolutionData.getProtocolName());
                protocolItemForm.setDescription(pcapResolutionData.getDescription());
                protocolItemFormList.add(protocolItemForm);
            }
        }
        page.setData(protocolItemFormList);
        page.setCount(pcapResSize);
        return page;
    }

    private ProtocolItem getProtocolItem(int num) {
        ProtocolItem protocolItem = new ProtocolItem();
        if (null != this.pcapResolutionDataList) {
            for (ProtocolItem item : this.pcapResolutionDataList) {
                if (item.getId() != num) continue;
                protocolItem = item;
            }
        }
        return protocolItem;
    }

    private String getProtocolResolution(ProtocolItem protocolItem) {
        StringBuffer protocolData = new StringBuffer();
        try {
            Protocol subProtocol = protocolItem.getProtocol();
            while (!(subProtocol.getSubProtocol() instanceof UnresolvedProtocol)) {
                subProtocol = subProtocol.getSubProtocol();
                protocolData.append(subProtocol.getProtocolName());
                protocolData.append(',');
                protocolData.append(subProtocol.getDescription());
                protocolData.append('\r');
                Map<String, String> map = subProtocol.getHeadContent();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    protocolData.append(entry.getKey());
                    if (!entry.getKey().endsWith(":") && !"".equals(entry.getValue())) {
                        protocolData.append(':');
                    }
                    protocolData.append(entry.getValue());
                    protocolData.append('\r');
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"PacketFile parse protocol exception!", (Throwable)e);
        }
        return protocolData.toString();
    }

    private String getResolutionData(ProtocolItem protocolItem) {
        StringBuffer dataString = new StringBuffer();
        if (protocolItem == null) {
            return dataString.toString();
        }
        byte[] pcapBytes = protocolItem.getBytes();
        if (null != pcapBytes) {
            for (byte byteData : pcapBytes) {
                String pcapHex = Integer.toHexString(byteData);
                StringBuffer pcapData = new StringBuffer();
                if (pcapHex.length() == 1) {
                    pcapData.append('0');
                    pcapData.append(pcapHex);
                } else if (8 == pcapHex.length() && "ffffff".equals(pcapHex.substring(0, 6))) {
                    pcapData.append(pcapHex.subSequence(6, 8));
                } else {
                    pcapData.append(pcapHex);
                }
                StringBuffer pcapDataFormat = new StringBuffer();
                for (int i = 0; i < pcapData.length(); ++i) {
                    char singleChar = pcapData.charAt(i);
                    if (i % 2 == 0 && pcapDataFormat.length() != 0) {
                        pcapDataFormat.append(' ');
                    }
                    pcapDataFormat.append(singleChar);
                }
                dataString.append(pcapDataFormat);
                dataString.append(' ');
            }
            return dataString.substring(0, dataString.length() - 1);
        }
        logger.error((Object)"pcapBytes is null");
        return dataString.toString();
    }

    private String getRowsData(String pcapResolution) {
        StringBuffer rowString = new StringBuffer();
        if (pcapResolution == null) {
            return rowString.toString();
        }
        int numlength = pcapResolution.length() / 48;
        if (pcapResolution.length() % 48 != 0) {
            numlength = pcapResolution.length() / 48 + 1;
        }
        for (int i = 0; i < numlength; ++i) {
            if (i < numlength - 1) {
                rowString.append(pcapResolution.substring(i * 48, (i + 1) * 48));
                rowString.append('\r');
            }
            if (i != numlength - 1) continue;
            rowString.append(pcapResolution.substring(i * 48, pcapResolution.length()));
        }
        return rowString.toString();
    }

    public String addZero(int len) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < 4 - len; ++i) {
            buffer.append('0');
        }
        return buffer.toString();
    }

    @Override
    public String findPcapResolutionData(int num) {
        logger.info((Object)"begin findPcapResolutionData()...");
        String protocolData = "";
        String rowsData = "";
        ProtocolItem protocolItem = this.getProtocolItem(num);
        try {
            protocolData = this.getProtocolResolution(protocolItem);
            String pcapResolution = this.getResolutionData(protocolItem);
            rowsData = this.getRowsData(pcapResolution);
        }
        catch (Exception e) {
            logger.error((Object)("Find PcapResolutionData exception, num = " + num), (Throwable)e);
        }
        StringBuffer pcapParseData = new StringBuffer();
        pcapParseData.append(protocolData);
        pcapParseData.append("pcapResolutionIp:");
        pcapParseData.append(rowsData.toUpperCase(Locale.ENGLISH));
        return pcapParseData.toString();
    }

    @Override
    public Paging pcap2AttackLogDetail(PcapLogQueryBean pcapQueryBean, int start, int pageSize) {
        logger.info((Object)"begin pcap2AttackLogDetail()...");
        Paging page = new Paging();
        if (null == pcapQueryBean) {
            logger.error((Object)"pcapQueryBean is null !");
            return page;
        }
        Long zoneId = pcapQueryBean.getZoneId();
        String startTime = pcapQueryBean.getStartTime();
        String endTime = pcapQueryBean.getEndTime();
        String ftpAddress = pcapQueryBean.getFtpAddress();
        int totalSize = 0;
        DataStatService dataStatService = null;
        List attackExactLogList = null;
        List<Object> attackLogDetailFormList = new ArrayList();
        DataStatCondition dataStatCondition = new DataStatCondition();
        try {
            boolean isDefault = this.zoneService.isDefaultZone(zoneId.longValue());
            dataStatCondition.setDefaultZone(isDefault);
            dataStatCondition.setZoneId(zoneId);
            dataStatCondition.setAttackType(pcapQueryBean.getAttackType());
            dataStatCondition.setProtocol(Integer.valueOf(pcapQueryBean.getProtocol()));
            dataStatCondition.setPort(Integer.valueOf(pcapQueryBean.getPort()));
            dataStatCondition.setDeviceIp(pcapQueryBean.getDeviceIp());
            dataStatCondition.setDevSerType(pcapQueryBean.getDeviceType());
            dataStatCondition.setZoneIp(pcapQueryBean.getZoneIp());
            if (!AticUtil.isNull((String)endTime)) {
                dataStatCondition.setEndTime(Long.valueOf(AticUtil.convertTimeString((String)endTime)));
            }
            if (!AticUtil.isNull((String)startTime)) {
                dataStatCondition.setStartTime(Long.valueOf(AticUtil.convertTimeString((String)startTime)));
            }
            if (null != (dataStatService = this.packetCollectorRMIProxy.getDataStatService(ftpAddress))) {
                attackExactLogList = dataStatService.getAttackExactLogToPcap(dataStatCondition);
            }
            if (null != attackExactLogList) {
                totalSize = attackExactLogList.size();
                List<AttackExactLog> pageContent = this.getDataByPage(attackExactLogList, start, pageSize);
                attackLogDetailFormList = this.getPageObjects(pageContent, ftpAddress, zoneId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"pcap2AttackLogDetail error", (Throwable)e);
        }
        page.setData(attackLogDetailFormList);
        page.setCount(totalSize);
        return page;
    }

    private List<AttackExactLog> getDataByPage(List<AttackExactLog> attackExactLogList, int start, int pageSize) {
        ArrayList<AttackExactLog> pageList = new ArrayList<AttackExactLog>();
        if (null != attackExactLogList) {
            for (int i = start; i < attackExactLogList.size() && i < start + pageSize; ++i) {
                pageList.add(attackExactLogList.get(i));
            }
        }
        return pageList;
    }

    private List<AttackLogDetailForm> getPageObjects(List<AttackExactLog> pageContent, String ftpAddress, Long zoneId) {
        logger.info((Object)"begin getPageObjects()...");
        ArrayList<AttackLogDetailForm> attackLogDetailFormList = new ArrayList<AttackLogDetailForm>();
        if (null == pageContent) {
            logger.error((Object)"pageContent is null !");
            return attackLogDetailFormList;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        for (AttackExactLog attackExactLog : pageContent) {
            AttackLogDetailForm attackLogDetailForm = new AttackLogDetailForm();
            this.convertLog2Form(attackExactLog, attackLogDetailForm);
            ZoneInfoForm zoneInfoForm = this.zoneService.getById(zoneId);
            if (zoneInfoForm == null) {
                attackLogDetailForm.setZoneDesc("--");
            } else {
                attackLogDetailForm.setZoneDesc(zoneInfoForm.getZoneDesc());
            }
            if (0 != attackExactLog.getAttackStatus()) {
                attackLogDetailForm.setEndTime("--");
            }
            attackLogDetailForm.setAttackStatus(attackExactLog.getAttackStatus());
            attackLogDetailForm.setDuration(AticUtil.getDuration((long)attackExactLog.getDuration()));
            attackLogDetailForm.setAttackTypeValue(attackExactLog.getAttackTypeValue());
            attackLogDetailForm.setDropPackets(numberFormat.format(attackExactLog.getDropPackets()));
            attackLogDetailForm.setDeviceIp(attackExactLog.getDeviceIp());
            attackLogDetailForm.setCollectorIp(ftpAddress);
            attackLogDetailForm.setZoneId(attackExactLog.getZoneId());
            attackLogDetailForm.setLimitValue(String.valueOf(attackExactLog.getLimit()));
            attackLogDetailForm.setRealValue(String.valueOf(attackExactLog.getCurrent()));
            attackLogDetailForm.setAttackTypeValue(attackExactLog.getAttackTypeValue());
            attackLogDetailForm.setPort(String.valueOf(attackExactLog.getPort()));
            attackLogDetailForm.setProtocol(String.valueOf(attackExactLog.getProtocol()));
            attackLogDetailFormList.add(attackLogDetailForm);
        }
        return attackLogDetailFormList;
    }

    private void convertLog2Form(AttackExactLog attackExactLog, AttackLogDetailForm attackLogDetailForm) {
        if (attackExactLog.getZoneIp().equals("0") && attackExactLog.getBizId() == 0L) {
            attackLogDetailForm.setZoneIp("--");
        } else {
            attackLogDetailForm.setZoneIp(IPUtil4Atic.compressIP((String)attackExactLog.getZoneIp()));
        }
        attackLogDetailForm.setStartTimeAlert(attackExactLog.getDisStartTimeAlert());
        if (null == attackExactLog.getStartTimeAttack() || 0L == attackExactLog.getStartTimeAttack()) {
            attackLogDetailForm.setStartTimeAttack("--");
        } else {
            attackLogDetailForm.setStartTimeAttack(attackExactLog.getDisStartTimeAttack());
        }
        if (null == attackExactLog.getEndTime() || 0L == attackExactLog.getEndTime()) {
            attackLogDetailForm.setEndTime("--");
        } else {
            attackLogDetailForm.setEndTime(attackExactLog.getDisEndTime());
        }
        if (null == attackExactLog.getAttackType() || "".equals(attackExactLog.getAttackType().trim())) {
            attackLogDetailForm.setAttackTypes("--");
            attackLogDetailForm.setSrcIp("--");
        } else {
            attackLogDetailForm.setAttackTypes(attackExactLog.getAttackType());
            attackLogDetailForm.setSrcIp(attackExactLog.getSrcIp().replaceAll(",", ", "));
        }
    }

    @Override
    public String delPacketFiles(String[] zonePacketFileNames, String[] collectorIps) {
        logger.info((Object)"begin delPacketFiles()...");
        HashMap<String, String> zonePacketFileMap = new HashMap<String, String>();
        for (int i = 0; i < collectorIps.length; ++i) {
            if (zonePacketFileMap.containsKey(collectorIps[i])) {
                String packetFileName = (String)zonePacketFileMap.get(collectorIps[i]);
                StringBuffer zonePacketFileStr = new StringBuffer();
                zonePacketFileStr.append(zonePacketFileNames[i]);
                zonePacketFileStr.append(',');
                zonePacketFileStr.append(packetFileName);
                zonePacketFileMap.put(collectorIps[i], zonePacketFileStr.toString());
                continue;
            }
            zonePacketFileMap.put(collectorIps[i], zonePacketFileNames[i]);
        }
        for (Map.Entry zonePacketFile : zonePacketFileMap.entrySet()) {
            String fileName = (String)zonePacketFileMap.get(zonePacketFile.getKey());
            ArrayList<String> zonePacketFileNameList = new ArrayList<String>();
            for (String zonePacketFileName : fileName.split(",")) {
                zonePacketFileNameList.add(zonePacketFileName);
            }
            CapturePcapService capturePcapService = this.packetCollectorRMIProxy.getCapturePcapService((String)zonePacketFile.getKey());
            if (null != capturePcapService) {
                try {
                    if (capturePcapService.queryPcapFiles(zonePacketFileNameList)) {
                        return "failure";
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"queryPcapFiles failed! ", (Throwable)e);
                }
                try {
                    capturePcapService.deletePcapFiles(zonePacketFileNameList);
                }
                catch (Exception e) {
                    logger.error((Object)"deletePcapFiles failed! ", (Throwable)e);
                }
                continue;
            }
            logger.error((Object)"capturePcapService is null! ");
        }
        return "success";
    }

    @Override
    public int delPacketFilesByTime(long time, List<CollectorInfo> collectorList) {
        int num = 0;
        for (CollectorInfo collectorInfo : collectorList) {
            CapturePcapService capturePcapService = this.packetCollectorRMIProxy.getCapturePcapService(collectorInfo.getIpAddress());
            if (null != capturePcapService) {
                try {
                    List<String> fileNameList = capturePcapService.queryPcapFilesByTime(time);
                    if (!fileNameList.isEmpty()) {
                        num += fileNameList.size();
                        capturePcapService.deletePcapFiles(fileNameList);
                        continue;
                    }
                    return num;
                }
                catch (Exception e) {
                    logger.error((Object)"queryPcapFiles and delete failed! ", (Throwable)e);
                    continue;
                }
            }
            logger.error((Object)"capturePcapService is null! ");
        }
        return num;
    }

    @Override
    public List<PacketFingerPrintInfoForm> getFingerPinrt(String fileName, String protocol, String collectorIp) {
        logger.info((Object)"begin getFingerPinrt()...");
        ZonePacketService zonePacketService = null;
        zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(collectorIp);
        ArrayList<PacketFingerPrintInfoForm> fingers = new ArrayList<PacketFingerPrintInfoForm>();
        if (null != zonePacketService) {
            try {
                zonePacketService.getZoneFingerPrint(protocol, fileName);
            }
            catch (Exception e) {
                logger.error((Object)"getFingerPinrt error ", (Throwable)e);
            }
        }
        return fingers;
    }

    @Override
    public PacketAnalysis getPacketAnalysisResult(String fileName, String protocol, String collectorIp) {
        logger.info((Object)"begin getPacketAnalysisResult()...");
        ZonePacketService zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(collectorIp);
        List<PcapAnalysisResult> pcapAnalysisResult = null;
        if (null != zonePacketService) {
            try {
                pcapAnalysisResult = zonePacketService.getZoneFingerPrint(protocol, fileName);
            }
            catch (Exception e) {
                logger.error((Object)"getFingerPinrt error ", (Throwable)e);
            }
        }
        PcapAnalysisResult result = null;
        PacketAnalysis packetAnalysis = null;
        if (null != pcapAnalysisResult && !pcapAnalysisResult.isEmpty()) {
            result = pcapAnalysisResult.get(0);
            packetAnalysis = this.convertPcapAnalysisResult(result);
        }
        return packetAnalysis;
    }

    private PacketAnalysis convertPcapAnalysisResult(PcapAnalysisResult result) {
        int i;
        int i2;
        PacketAnalysis packetAnalysis = new PacketAnalysis();
        ArrayList<IpPacketInfo> ipPacketInfoList = new ArrayList<IpPacketInfo>();
        int ipNum = result.getIpNum();
        if (0 < ipNum) {
            float ipPercent = result.getIpPercent();
            String[] srcIp = result.getSrcIp();
            int[] srcIpNum = result.getSrcIpNum();
            float[] srcIpPercent = result.getSrcIpPercent();
            int[] ipLenNum = result.getIpLenNum();
            float[] ipLenPercent = result.getIpLenPercent();
            String[] ipLength = new String[]{"0~99Byte", "100~299Byte", "300~599Byte", "600~999Byte", "1000~1500Byte"};
            for (i2 = 0; i2 < 5; ++i2) {
                IpPacketInfo ipPacketInfo = new IpPacketInfo();
                ipPacketInfo.setIpNum(ipNum);
                ipPacketInfo.setIpPerecnt(this.floatKeepDecimal(ipPercent * 100.0f));
                ipPacketInfo.setSrcIpAddress(String.valueOf(srcIp[i2]));
                ipPacketInfo.setSrcIpNum(srcIpNum[i2]);
                ipPacketInfo.setSrcIpPercent(this.floatKeepDecimal(srcIpPercent[i2] * 100.0f));
                ipPacketInfo.setIpLength(ipLength[i2]);
                ipPacketInfo.setIpLengthNum(ipLenNum[i2]);
                ipPacketInfo.setIpLengthPercent(this.floatKeepDecimal(ipLenPercent[i2] * 100.0f));
                ipPacketInfoList.add(ipPacketInfo);
            }
        }
        ArrayList<UdpPacketInfo> udpPacketInfoList = new ArrayList<UdpPacketInfo>();
        ArrayList<UdpPacketInfo> udpFingerInfoList = new ArrayList<UdpPacketInfo>();
        int udpNum = result.getUdpNum();
        if (0 < udpNum) {
            float udpPerecnt = result.getUdpPercent();
            int[] udpPort = result.getUdpPort();
            int[] udpPortNum = result.getUdpPortNum();
            float[] udpPortPercent = result.getUdpPortPercent();
            for (i2 = 0; i2 < 5; ++i2) {
                UdpPacketInfo udpPacketInfo = new UdpPacketInfo();
                udpPacketInfo.setUdpNum(udpNum);
                udpPacketInfo.setUdpPerecnt(this.floatKeepDecimal(udpPerecnt * 100.0f));
                udpPacketInfo.setUdpPort(udpPort[i2]);
                udpPacketInfo.setUdpPortNum(udpPortNum[i2]);
                udpPacketInfo.setUdpPortPercent(this.floatKeepDecimal(udpPortPercent[i2] * 100.0f));
                udpPacketInfoList.add(udpPacketInfo);
            }
            PcapAnalysisResultUdpfinger[] udpFingers = result.getUdpFinger();
            String[] fingerAnalysis = new String[]{"first4Byte", "first8Byte", "last4Byte", "last8Byte"};
            for (i = 0; i < udpFingers.length; ++i) {
                PcapAnalysisResultUdpfinger udpFinger = udpFingers[i];
                Integer offset = udpFinger.getOffset();
                String[] contents = udpFinger.getStrFinger();
                int[] fingerNums = udpFinger.getFingerNum();
                float[] fingerPercents = udpFinger.getFingerPercent();
                for (int j = 0; j < 5; ++j) {
                    UdpPacketInfo udpPacketInfo = new UdpPacketInfo();
                    udpPacketInfo.setFingerAnalysis(fingerAnalysis[i]);
                    udpPacketInfo.setContent(contents[j]);
                    udpPacketInfo.setOffset(String.valueOf(offset));
                    udpPacketInfo.setFingerNum(fingerNums[j]);
                    udpPacketInfo.setFingerPercent(this.floatKeepDecimal(fingerPercents[j] * 100.0f));
                    udpFingerInfoList.add(udpPacketInfo);
                }
            }
        }
        ArrayList<TcpPacketInfo> tcpPacketInfoList = new ArrayList<TcpPacketInfo>();
        int tcpNum = result.getTcpNum();
        if (0 < tcpNum) {
            float tcpPercent = result.getTcpPercent();
            int[] tcpPort = result.getTcpPort();
            int[] tcpPortNum = result.getTcpPortNum();
            float[] tcpPortPercent = result.getTcpPortPercent();
            String[] tcpFlagTitle = new String[]{"SYN", "SYN-ACK", "ACK", "FIN", "RST"};
            int[] tcpFlagNum = result.getTcpFlagNum();
            float[] tcpFlagPercent = result.getTcpFlagPercent();
            for (int i3 = 0; i3 < 5; ++i3) {
                TcpPacketInfo tcpPacketInfo = new TcpPacketInfo();
                tcpPacketInfo.setTcpNum(tcpNum);
                tcpPacketInfo.setTcpPerecnt(this.floatKeepDecimal(tcpPercent * 100.0f));
                tcpPacketInfo.setTcpPort(tcpPort[i3]);
                tcpPacketInfo.setTcpPortNum(tcpPortNum[i3]);
                tcpPacketInfo.setTcpPortPercent(this.floatKeepDecimal(tcpPortPercent[i3] * 100.0f));
                tcpPacketInfo.setTcpFlag(tcpFlagTitle[i3]);
                tcpPacketInfo.setTcpFlagNum(tcpFlagNum[i3]);
                tcpPacketInfo.setTcpFlagPercent(this.floatKeepDecimal(tcpFlagPercent[i3] * 100.0f));
                tcpPacketInfoList.add(tcpPacketInfo);
            }
        }
        ArrayList<DnsPacketInfo> dnsPacketInfoList = new ArrayList<DnsPacketInfo>();
        int dnsNum = result.getDnsNum();
        if (0 < dnsNum) {
            float dnsPercent = result.getDnsPercent();
            PcapAnanlysisObject[] dnsDomai = result.getDnsDomain();
            for (i = 0; i < dnsDomai.length; ++i) {
                PcapAnanlysisObject pcapAnanlysisObject = dnsDomai[i];
                short type = pcapAnanlysisObject.getType();
                String[] typeContent = pcapAnanlysisObject.getTypeContent();
                int[] typeNum = pcapAnanlysisObject.getTypeNum();
                float[] typePercent = pcapAnanlysisObject.getTypePercent();
                for (int m = 0; m < 5; ++m) {
                    DnsPacketInfo dnsPacketInfo = new DnsPacketInfo();
                    dnsPacketInfo.setDnsNum(dnsNum);
                    dnsPacketInfo.setDnsPerecnt(this.floatKeepDecimal(dnsPercent * 100.0f));
                    if (type == 9) {
                        dnsPacketInfo.setFirstLevelDomainName(typeContent[m]);
                        dnsPacketInfo.setFirstLevelDomainNameNum(typeNum[m]);
                        dnsPacketInfo.setFirstLevelDomainNamePercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 10) {
                        dnsPacketInfo.setSecondLevelDomainName(typeContent[m]);
                        dnsPacketInfo.setSecondLevelDomainNameNum(typeNum[m]);
                        dnsPacketInfo.setSecondLevelDomainNamePercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 11) {
                        dnsPacketInfo.setThreeLevelDomainName(typeContent[m]);
                        dnsPacketInfo.setThreeLevelDomainNameNum(typeNum[m]);
                        dnsPacketInfo.setThreeLevelDomainNamePercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 12) {
                        dnsPacketInfo.setFourLevelDomainName(typeContent[m]);
                        dnsPacketInfo.setFourLevelDomainNameNum(typeNum[m]);
                        dnsPacketInfo.setFourLevelDomainNamePercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    }
                    dnsPacketInfoList.add(dnsPacketInfo);
                }
            }
        }
        ArrayList<HttpPacketInfo> httpPacketInfoList = new ArrayList<HttpPacketInfo>();
        ArrayList<HttpPacketInfo> httpRequestInfoList = new ArrayList<HttpPacketInfo>();
        int httpNum = result.getHttpNum();
        if (0 < httpNum) {
            float httpPercent = result.getHttpPercent();
            String[] httpMethod = new String[]{"GET", "POST", "OTHER"};
            int[] httpMethodNum = result.getHttpMethodNum();
            float[] httpMethodPercent = result.getHttpMethodPercent();
            for (int i4 = 0; i4 < httpMethod.length; ++i4) {
                HttpPacketInfo httpPacketInfo = new HttpPacketInfo();
                httpPacketInfo.setHttpNum(httpNum);
                httpPacketInfo.setHttpPerecnt(this.floatKeepDecimal(httpPercent * 100.0f));
                httpPacketInfo.setHttpRequest(httpMethod[i4]);
                httpPacketInfo.setHttpRequestNum(httpMethodNum[i4]);
                httpPacketInfo.setHttpRequestPercent(this.floatKeepDecimal(httpMethodPercent[i4] * 100.0f));
                httpRequestInfoList.add(httpPacketInfo);
            }
            PcapAnanlysisObject[] httpAttr = result.getHttpAttr();
            String[] uriName = new String[]{"HTTP_URI_FIRST_SLASH", "HTTP_URI_SECOND_SLASH", "HTTP_URI_THIRD_SLASH", "HTTP_URI_FOURTH_SLASH", "HTTP_URI_FIFTH_SLASH"};
            for (int i5 = 0; i5 < httpAttr.length; ++i5) {
                PcapAnanlysisObject pcapAnanlysisObject = httpAttr[i5];
                short type = pcapAnanlysisObject.getType();
                String[] typeContent = pcapAnanlysisObject.getTypeContent();
                int[] typeNum = pcapAnanlysisObject.getTypeNum();
                float[] typePercent = pcapAnanlysisObject.getTypePercent();
                for (int m = 0; m < 5; ++m) {
                    HttpPacketInfo httpPacketInfo = new HttpPacketInfo();
                    httpPacketInfo.setHttpNum(httpNum);
                    httpPacketInfo.setHttpPerecnt(this.floatKeepDecimal(httpPercent * 100.0f));
                    if (type == 0 || type == 1 || type == 2 || type == 3 || type == 4) {
                        if (i5 < 5) {
                            httpPacketInfo.setUri(uriName[i5]);
                        }
                        httpPacketInfo.setUriContent(typeContent[m]);
                        httpPacketInfo.setUriNum(typeNum[m]);
                        httpPacketInfo.setUriPercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 5) {
                        httpPacketInfo.setHost(typeContent[m]);
                        httpPacketInfo.setHostNum(typeNum[m]);
                        httpPacketInfo.setHostPercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 6) {
                        httpPacketInfo.setUserAgent(typeContent[m]);
                        httpPacketInfo.setUserAgentNum(typeNum[m]);
                        httpPacketInfo.setUserAgentPercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 7) {
                        httpPacketInfo.setCookie(typeContent[m]);
                        httpPacketInfo.setCookieNum(typeNum[m]);
                        httpPacketInfo.setCookiePercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    } else if (type == 8) {
                        httpPacketInfo.setRefer(typeContent[m]);
                        httpPacketInfo.setReferNum(typeNum[m]);
                        httpPacketInfo.setReferPercent(this.floatKeepDecimal(typePercent[m] * 100.0f));
                    }
                    httpPacketInfoList.add(httpPacketInfo);
                }
            }
        }
        packetAnalysis.setIpPacketInfoList(ipPacketInfoList);
        packetAnalysis.setUdpPacketInfoList(udpPacketInfoList);
        packetAnalysis.setUdpFingerInfoList(udpFingerInfoList);
        packetAnalysis.setTcpPacketInfoList(tcpPacketInfoList);
        packetAnalysis.setDnsPacketInfoList(dnsPacketInfoList);
        packetAnalysis.setHttpPacketInfoList(httpPacketInfoList);
        packetAnalysis.setHttpRequestInfoList(httpRequestInfoList);
        return packetAnalysis;
    }

    private float floatKeepDecimal(float number) {
        BigDecimal decimalNumber = new BigDecimal(number);
        return decimalNumber.setScale(3, 4).floatValue();
    }

    @Override
    public Paging getPcapFilesByCollector(String collectorIp, int start, int pageSize, PacketQueryBean packetQueryBean) {
        logger.info((Object)"begin getPcapFilesByCollector()...");
        ZonePacketService zonePacketService = null;
        zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(collectorIp);
        RmiTuple<List<ZonePacketInfoObj>, Long> result = null;
        Paging page = new Paging();
        if (null != zonePacketService) {
            try {
                result = zonePacketService.findAllZonePacketList(start, pageSize, packetQueryBean.getFileName());
                List<ZonePacketInfoObj> securityPacketFileDate = new ArrayList();
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("currentUserId", String.valueOf(packetQueryBean.getCurrentUseId()));
                queryMap.put("currentUserIsAdmin", String.valueOf(packetQueryBean.getIsAdmin()));
                if (null != packetQueryBean.getCurrentUseId() && !packetQueryBean.getIsAdmin().booleanValue()) {
                    List<Long> packetTaskIds = this.packetTaskDao.getSecurityDataIds(queryMap);
                    for (ZonePacketInfoObj zonePacketInfoObj : (List)result.getObjs()) {
                        if (!packetTaskIds.contains(zonePacketInfoObj.getPcapId())) continue;
                        securityPacketFileDate.add(zonePacketInfoObj);
                    }
                } else {
                    securityPacketFileDate = (List)result.getObjs();
                }
                if (securityPacketFileDate != null) {
                    ArrayList<PacketFileForm> formList = new ArrayList<PacketFileForm>();
                    int totalSize = Integer.parseInt(((Long)result.getTotal()).toString());
                    if (start >= 0 && start < totalSize) {
                        for (int i = start; i < totalSize && i < start + pageSize; ++i) {
                            PacketFileForm packetFileForm = new PacketFileForm();
                            AticUtil.copyProperties(securityPacketFileDate.get(i - start), (Object)packetFileForm);
                            formList.add(packetFileForm);
                        }
                    }
                    page.setData(formList);
                    page.setCount(totalSize);
                }
            }
            catch (Exception e) {
                page = new Paging();
                logger.error((Object)"getPcapFilesByCollector error ", (Throwable)e);
            }
        }
        return page;
    }

    public PacketCollectorRMIProxy getPacketCollectorRMIProxy() {
        return this.packetCollectorRMIProxy;
    }

    public void setPacketCollectorRMIProxy(PacketCollectorRMIProxy packetCollectorRMIProxy) {
        this.packetCollectorRMIProxy = packetCollectorRMIProxy;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public PacketTaskDao getPacketTaskDao() {
        return this.packetTaskDao;
    }

    public void setPacketTaskDao(PacketTaskDao packetTaskDao) {
        this.packetTaskDao = packetTaskDao;
    }

    @Override
    public Paging listPcapFileFromReport(ReportQueryBean bean, int start, int pageSize) {
        logger.info((Object)"begin listPcapFileFromReport()...");
        Paging page = new Paging();
        if (null == bean) {
            logger.error((Object)"bean is null !");
            return page;
        }
        ArrayList<PacketFileForm> packetFileFormList = new ArrayList<PacketFileForm>();
        List zonePacketFileList = null;
        ZonePacketService zonePacketService = null;
        zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(bean.getCollectorIp());
        RmiTuple<List<ZonePacketInfoObj>, Long> result = null;
        if (null != zonePacketService) {
            try {
                ZonePacket zonePacket = new ZonePacket();
                zonePacket.setDeviceIp(bean.getDeviceIp());
                zonePacket.setDeviceType(bean.getDeviceType().intValue());
                zonePacket.setZoneId(Integer.parseInt(bean.getZoneId()));
                zonePacket.setZoneIp(bean.getZoneIp());
                zonePacket.setBegintime(bean.getStartTime());
                zonePacket.setEndtime(bean.getEndTime());
                zonePacket.setAttackType(bean.getAttackType().intValue());
                zonePacket.setProtocol(bean.getProtocol());
                zonePacket.setPort(bean.getPort());
                zonePacket.setStart(start);
                zonePacket.setLimit(pageSize);
                result = zonePacketService.findAttackZonePacketList(zonePacket);
            }
            catch (Exception e) {
                logger.error((Object)"execute findAttackZonePacketList failed in PacketFileServiceImpl ", (Throwable)e);
            }
            if (null != result) {
                zonePacketFileList = (List)result.getObjs();
            }
            if (null != zonePacketFileList) {
                for (ZonePacketInfoObj zonePacketInfo : zonePacketFileList) {
                    zonePacketInfo.setFtpAddress(bean.getCollectorIp());
                }
            }
        }
        int totalSize = 0;
        if (zonePacketFileList != null) {
            totalSize = zonePacketFileList.size();
            if (start >= 0 && start < totalSize) {
                for (int i = start; i < totalSize && i < start + pageSize; ++i) {
                    ZonePacketInfoObj zonePacketInfoObj = (ZonePacketInfoObj)zonePacketFileList.get(i);
                    PacketFileForm packetFileForm = new PacketFileForm();
                    AticUtil.copyProperties((Object)zonePacketInfoObj, (Object)packetFileForm);
                    packetFileFormList.add(packetFileForm);
                }
            }
        }
        page.setData(packetFileFormList);
        page.setCount(totalSize);
        return page;
    }

    @Override
    public Boolean findPcapFileByName(String collectorIp, String fileName) {
        logger.info((Object)"find pcapFile exist ...");
        Boolean result = false;
        ZonePacketService zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(collectorIp);
        if (null != zonePacketService) {
            try {
                result = zonePacketService.findPcapFileByName(fileName);
            }
            catch (Exception e) {
                logger.error((Object)"execute findPcapFileByName failed in PacketFileServiceImpl ", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public byte[] downloadPcapFile(String collectorIp, String filename) {
        ZonePacketService zonePacketService = this.packetCollectorRMIProxy.getZonePacketService(collectorIp);
        if (null != zonePacketService) {
            try {
                return zonePacketService.downloadPcapFile(filename);
            }
            catch (Exception e) {
                logger.error((Object)"execute findPcapFileByName failed in PacketFileServiceImpl ", (Throwable)e);
            }
        }
        return new byte[0];
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

