/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.bis.constant.AticConstants;
import com.hs.atic.bis.dao.AclRuleDao;
import com.hs.atic.bis.dao.PacketTaskDao;
import com.hs.atic.bis.model.AclRule;
import com.hs.atic.bis.model.PacketTask;
import com.hs.atic.collector.entity.pcap.PcapTask;
import com.hs.atic.rmi.CapturePcapService;
import com.hs.atic.rmi.PacketCollectorRMIProxy;
import com.hs.atic.sdk.bis.form.AclRuleForm;
import com.hs.atic.sdk.bis.form.PacketTaskForm;
import com.hs.atic.sdk.util.ZonePairCopy;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

public class PacketTaskServiceImpl
implements IPacketTaskService {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private String forceDelete = "no";
    private PacketTaskDao packetTaskDao;
    private AclRuleDao aclRuleDao;
    private PacketCollectorRMIProxy packetCollectorRMIProxy;
    private IAticDeviceService aticDeviceService;
    private String xmlPath = "conf/aticCommands.xml";
    private IZoneService zoneService;
    private ICollectorService collectorService;
    private ICollectorDeviceService collectorDeviceService;
    private ICommonUtilService commonUtilService;
    private IZoneMgrNorthSerice zoneMgrNorthService;

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IZoneMgrNorthSerice getZoneMgrNorthService() {
        return this.zoneMgrNorthService;
    }

    public void setZoneMgrNorthService(IZoneMgrNorthSerice zoneMgrNorthService) {
        this.zoneMgrNorthService = zoneMgrNorthService;
    }

    public BatchOperationResult batchDelPacketTask(List<BatchOperation> boList, boolean isMsg, String forceDeletes) {
        if (null == boList || boList.isEmpty()) {
            logger.error((Object)"boList is null!");
            return new BatchOperationResult();
        }
        logger.info((Object)"enter batchDelPacketTask()");
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            String collectorIp = "";
            try {
                CapturePcapService client;
                PacketTaskForm packetTaskForm = this.findById(bo.getTargetId());
                if (null == packetTaskForm) {
                    ++fail;
                    bo.setErrorCode(571502L);
                    logger.error((Object)("packetTaskForm is null! pcap id:" + bo.getTargetId()));
                    continue;
                }
                int state = packetTaskForm.getPcapTaskState();
                if (1 == state && !isMsg) {
                    logger.error((Object)("the pcap state is start! pcapid:" + bo.getTargetId()));
                    boolean needUndo = true;
                    PacketTask task = this.packetTaskDao.get(bo.getTargetId());
                    if (null == task) {
                        logger.error((Object)"task is null!");
                        return new BatchOperationResult();
                    }
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(task.getPcapDeviceId().longValue());
                    int status = this.aticDeviceService.getStatusByMoid(task.getPcapDeviceId().longValue());
                    if (null == device) {
                        needUndo = false;
                    } else if (status == -1) {
                        needUndo = false;
                    } else if ((task.getPcapType() == 2 || task.getPcapType() == 3) && null == this.zoneService.getById(task.getZoneId())) {
                        needUndo = false;
                    }
                    if (null != device) {
                        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
                        if (null == collectorId) {
                            logger.error((Object)("collectorId is null! deviceId :" + device.getMoId()));
                        } else {
                            CollectorInfo collector = this.collectorService.getCollectorInfo(collectorId.longValue());
                            if (null == collector) {
                                logger.error((Object)("collector is null! collectorId :" + collectorId));
                            } else {
                                bo.setOptDetail(collector.getIpAddress());
                            }
                        }
                    }
                    collectorIp = bo.getOptDetail();
                    if (needUndo) {
                        ArrayList<BatchOperation> newList = new ArrayList<BatchOperation>();
                        newList.add(bo);
                        result = this.batchStopPacketTask(newList, forceDeletes, result, false);
                    }
                }
                if (Integer.valueOf(1).equals(packetTaskForm.getPcapType())) {
                    List<AclRule> aclRuleList = this.aclRuleDao.findAclRuleByPcapId(bo.getTargetId());
                    for (AclRule aclRule : aclRuleList) {
                        this.aclRuleDao.remove(aclRule.getId());
                    }
                }
                this.delById(bo.getTargetId());
                if ("no".equals(forceDeletes) && null != collectorIp && !collectorIp.equals("") && null != (client = this.packetCollectorRMIProxy.getCapturePcapService(collectorIp))) {
                    client.deletePcapFilesByTaskId(String.valueOf(bo.getTargetId()));
                }
                bo.setOptDetail("atic.bis.packetTask.delSummary");
                bo.setDetailParam(new String[]{bo.getTargetName()});
            }
            catch (LegoCheckedException e) {
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
            }
            catch (Exception e) {
                ++fail;
                bo.setErrorCode(570507L);
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
            }
        }
        for (BatchOperation batchOperation : boList) {
            long errorCode = batchOperation.getErrorCode();
            if (514L != errorCode) continue;
            batchOperation.setErrorCode(570659L);
        }
        result.setResult(boList);
        result.setFailCount(result.getFailCount() + fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        logger.info((Object)"leave batchDelPacketTask");
        return result;
    }

    public BatchOperationResult batchDelPacketTask(List<BatchOperation> boList, boolean isMsg, String forceDeletes, AticDeviceForm device) {
        if (null == boList || boList.isEmpty()) {
            logger.error((Object)"boList is null!");
            return new BatchOperationResult();
        }
        logger.info((Object)"enter batchDelPacketTask()");
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            String collectorIp = "";
            try {
                CapturePcapService client;
                PacketTaskForm packetTaskForm = this.findById(bo.getTargetId());
                if (null == packetTaskForm) {
                    ++fail;
                    bo.setErrorCode(571502L);
                    logger.error((Object)("packetTaskForm is null! pcap id:" + bo.getTargetId()));
                    continue;
                }
                int state = packetTaskForm.getPcapTaskState();
                if (1 == state && !isMsg) {
                    logger.error((Object)("the pcap state is start! pcapid:" + bo.getTargetId()));
                    boolean needUndo = true;
                    PacketTask task = this.packetTaskDao.get(bo.getTargetId());
                    if (null == task) {
                        logger.error((Object)"task is null!");
                        return new BatchOperationResult();
                    }
                    int status = this.aticDeviceService.getStatusByMoid(task.getPcapDeviceId().longValue());
                    if (null == device) {
                        needUndo = false;
                    } else if (status == -1) {
                        needUndo = false;
                    } else if ((task.getPcapType() == 2 || task.getPcapType() == 3) && null == this.zoneService.getById(task.getZoneId())) {
                        needUndo = false;
                    }
                    if (null != device) {
                        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(device.getMoId()));
                        if (null == collectorId) {
                            logger.error((Object)("collectorId is null! deviceId :" + device.getMoId()));
                        } else {
                            CollectorInfo collector = this.collectorService.getCollectorInfo(collectorId.longValue());
                            if (null == collector) {
                                logger.error((Object)("collector is null! collectorId :" + collectorId));
                            } else {
                                bo.setOptDetail(collector.getIpAddress());
                            }
                        }
                    }
                    collectorIp = bo.getOptDetail();
                    if (needUndo) {
                        ArrayList<BatchOperation> newList = new ArrayList<BatchOperation>();
                        newList.add(bo);
                        this.batchStopPacketTask(newList, forceDeletes, result, false);
                    }
                }
                if (Integer.valueOf(1).equals(packetTaskForm.getPcapType())) {
                    List<AclRule> aclRuleList = this.aclRuleDao.findAclRuleByPcapId(bo.getTargetId());
                    for (AclRule aclRule : aclRuleList) {
                        this.aclRuleDao.remove(aclRule.getId());
                    }
                }
                this.delById(bo.getTargetId());
                if ("no".equals(forceDeletes) && null != collectorIp && !collectorIp.equals("") && null != (client = this.packetCollectorRMIProxy.getCapturePcapService(collectorIp))) {
                    client.deletePcapFilesByTaskId(String.valueOf(bo.getTargetId()));
                }
                bo.setOptDetail("atic.bis.packetTask.delSummary");
                bo.setDetailParam(new String[]{bo.getTargetName()});
            }
            catch (LegoCheckedException e) {
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
            }
            catch (Exception e) {
                ++fail;
                bo.setErrorCode(570507L);
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        logger.info((Object)"leave batchDelPacketTask");
        return result;
    }

    public BatchOperationResult batchStartPacketTask(List<BatchOperation> boList) {
        logger.info((Object)"enter batchStartPacketTask()");
        if (null == boList || boList.isEmpty()) {
            logger.error((Object)"boList is null!");
            return new BatchOperationResult();
        }
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            PacketTaskForm packetTaskForm = this.findById(bo.getTargetId());
            if (null == packetTaskForm) {
                ++fail;
                bo.setErrorCode(571502L);
                logger.error((Object)("packetTaskForm is null! pcap id:" + bo.getTargetId()));
                continue;
            }
            AticDevice device = this.aticDeviceService.getDeviceByMoid(packetTaskForm.getPcapDeviceId().longValue());
            if (-1 == device.getStatus()) {
                packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                packetTaskForm.setStartTime(Long.valueOf(0L));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                bo.setErrorCode(571508L);
                continue;
            }
            if (bo.getOptDetail() == null) {
                ++fail;
                bo.setErrorCode(571601L);
                logger.error((Object)"bo.getOptDetail() is null");
                continue;
            }
            try {
                if (!this.validateStart(packetTaskForm, bo)) {
                    ++fail;
                    continue;
                }
                CapturePcapService client = this.packetCollectorRMIProxy.getCapturePcapService(bo.getOptDetail());
                if (null == client) {
                    packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                    packetTaskForm.setStartTime(Long.valueOf(0L));
                    packetTaskForm.setStopTime(Long.valueOf(0L));
                    this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                    ++fail;
                    logger.error((Object)("get collector service failed! collector ip:" + this.getcleanedMessage(bo.getOptDetail())));
                    bo.setErrorCode(570504L);
                    continue;
                }
                String deviceIp = device.getIpAddress();
                if (null == packetTaskForm.getZoneId()) {
                    packetTaskForm.setZoneId(Long.valueOf(0L));
                }
                String time = new SimpleDateFormat("yyyyMMdd_HHmmss").format(System.currentTimeMillis());
                PcapTask pcapTask = new PcapTask();
                pcapTask.setPcapId(packetTaskForm.getId());
                pcapTask.setDeviceIp(deviceIp);
                pcapTask.setPcapType(packetTaskForm.getPcapType());
                pcapTask.setZoneId(packetTaskForm.getZoneId());
                pcapTask.setCaptureNum(packetTaskForm.getPcapNumber());
                String fileName = null;
                if (device.getDdosType() == 2) {
                    fileName = packetTaskForm.getPcapTaskName() + "_" + time + "_CLEAN";
                    pcapTask.setFileName(fileName);
                    pcapTask.setDeviceType(0);
                    client.addPcapTask(pcapTask);
                    if (2 != pcapTask.getPcapType() && 0 != pcapTask.getPcapType()) {
                        fileName = packetTaskForm.getPcapTaskName() + "_" + time + "_DETECT";
                        pcapTask.setFileName(fileName);
                        pcapTask.setDeviceType(1);
                        client.addPcapTask(pcapTask);
                    }
                } else if (device.getDdosType() == 0) {
                    fileName = packetTaskForm.getPcapTaskName() + "_" + time + "_CLEAN";
                    pcapTask.setFileName(fileName);
                    pcapTask.setDeviceType(device.getDdosType());
                    client.addPcapTask(pcapTask);
                } else if (device.getDdosType() == 1) {
                    fileName = packetTaskForm.getPcapTaskName() + "_" + time + "_DETECT";
                    pcapTask.setFileName(fileName);
                    pcapTask.setDeviceType(1);
                    client.addPcapTask(pcapTask);
                }
                packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                packetTaskForm.setStartTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                if (!this.doTranslate(packetTaskForm, bo)) {
                    packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                    packetTaskForm.setStartTime(Long.valueOf(0L));
                    packetTaskForm.setStopTime(Long.valueOf(0L));
                    this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                    ++fail;
                    continue;
                }
                bo.setOptDetail("atic.bis.packetTask.runSummary");
                bo.setDetailParam(new String[]{bo.getTargetName()});
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
                packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                packetTaskForm.setStartTime(Long.valueOf(0L));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                bo.setErrorCode(e.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
                packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                packetTaskForm.setStartTime(Long.valueOf(0L));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                bo.setErrorCode(570507L);
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        logger.info((Object)"leave batchStartPacketTask()");
        return result;
    }

    private boolean doTranslate(PacketTaskForm packetTaskForm, BatchOperation bo) {
        if (null == packetTaskForm) {
            return false;
        }
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        int type = packetTaskForm.getPcapType();
        ArrayList<String> cmds = new ArrayList<String>();
        if (1 == type) {
            if (null != packetTaskForm.getForwardStatus() && packetTaskForm.getForwardStatus() == 1) {
                cmds.add("system-view");
                cmds.add("undo anti-ddos packet-capture acl");
                cmds.add("undo anti-ddos packet-capture mode acl cleaned");
                cmds.add("undo acl 3999");
                cmds.add("undo acl ipv6 3999");
            } else {
                cmds.add("system-view");
                cmds.add("undo anti-ddos packet-capture acl");
                cmds.add("undo acl 3999");
                cmds.add("undo acl ipv6 3999");
            }
            this.aticDeviceService.execCmdNoTransaction(cmds, packetTaskForm.getPcapDeviceId().longValue());
            cmds.clear();
            if (!this.aclRuleCmdDeploy(packetTaskForm, cmds, paramList, bo)) {
                return false;
            }
        } else if (0 == type ? !this.translatePacketTask(packetTaskForm, cmds, false, bo) : !this.translatePacketTask(packetTaskForm, cmds, true, bo)) {
            return false;
        }
        return true;
    }

    public boolean undoTranslate(PacketTaskForm packetTaskForm, BatchOperation bo) {
        int type = packetTaskForm.getPcapType();
        ArrayList<String> cmds = new ArrayList<String>();
        if (1 == type) {
            cmds.add("system-view");
            if (!this.undoTranslatePacketTask(packetTaskForm, cmds, false, bo)) {
                return false;
            }
        } else if (0 == type) {
            cmds.add("system-view");
            if (!this.undoTranslatePacketTask(packetTaskForm, cmds, false, bo)) {
                return false;
            }
        } else {
            cmds.add("system-view");
            if (!this.undoTranslatePacketTask(packetTaskForm, cmds, true, bo)) {
                return false;
            }
        }
        return true;
    }

    private boolean aclRuleCmdDeploy(PacketTaskForm packetTaskForm, List<String> cmds, List<CmdParam> paramList, BatchOperation bo) {
        cmds.add("system-view");
        for (int i = 0; i < packetTaskForm.getListAclRuleForm().size(); ++i) {
            AclRuleForm form = (AclRuleForm)packetTaskForm.getListAclRuleForm().get(i);
            if (i == 0) {
                if (packetTaskForm.getVpnName().equals("--") || packetTaskForm.getVpnName().equals("")) {
                    if ("IPV4".equals(form.getAclRuleIpType())) {
                        cmds.add("acl 3999");
                    } else {
                        cmds.add("acl ipv6 3999");
                    }
                } else if ("IPV4".equals(form.getAclRuleIpType())) {
                    cmds.add("acl 3999 vpn-instance " + packetTaskForm.getVpnName());
                } else {
                    cmds.add("acl ipv6 3999 vpn-instance " + packetTaskForm.getVpnName());
                }
            }
            CmdParam tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("ACL_RULE");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("AclRuleID", String.valueOf(form.getAclRuleId()));
            params.put("AclRuleType", form.getAclRuleType());
            if (this.validateEmptyString(form.getSourceIp()) && this.validateEmptyString(String.valueOf(form.getSourceIpMask()))) {
                params.put("SourceIP", form.getSourceIp());
                Integer sourceIpMask = form.getSourceIpMask();
                if (sourceIpMask != null) {
                    String srcWildcard = AticUtil.convertFromIntToWildcard((int)sourceIpMask, (String)form.getAclRuleIpType());
                    params.put("SourceIPMask", srcWildcard);
                }
            }
            if (this.validateEmptyString(String.valueOf(form.getSourcePort()))) {
                params.put("SourcePort", String.valueOf(form.getSourcePort()));
            }
            if (this.validateEmptyString(form.getDestIp()) && this.validateEmptyString(String.valueOf(form.getDestIpMask()))) {
                params.put("DestIP", form.getDestIp());
                Integer destIpMask = form.getDestIpMask();
                if (destIpMask != null) {
                    String destWildcard = AticUtil.convertFromIntToWildcard((int)destIpMask, (String)form.getAclRuleIpType());
                    params.put("DestIPMask", destWildcard);
                }
            }
            if (this.validateEmptyString(String.valueOf(form.getDestPort()))) {
                params.put("DestPort", String.valueOf(form.getDestPort()));
            }
            tmpCmdParam.setParams(params);
            paramList.clear();
            paramList.add(tmpCmdParam);
            CommandAPI cAPI = new CommandAPI();
            List list = cAPI.doTranslate(this.xmlPath, "packetTask", paramList);
            cmds.addAll(list);
        }
        cmds.add("quit");
        if ("IPV4".equals(((AclRuleForm)packetTaskForm.getListAclRuleForm().get(0)).getAclRuleIpType())) {
            cmds.add("anti-ddos packet-capture acl 3999");
        } else {
            cmds.add("anti-ddos packet-capture ipv6 acl 3999");
        }
        cmds.add("quit");
        return this.translatePacketTask(packetTaskForm, cmds, false, bo);
    }

    private boolean translatePacketTask(PacketTaskForm packetTaskForm, List<String> cmds, boolean isZoneTask, BatchOperation bo) {
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        cmds.add("system-view");
        if (isZoneTask) {
            CmdParam tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("ZONE");
            HashMap<String, String> params = new HashMap<String, String>();
            ZoneInfoForm zoneForm = this.zoneService.getById(packetTaskForm.getZoneId());
            if (1 == zoneForm.getZoneType()) {
                params.put("default", "default");
            } else {
                params.put("zoneName", zoneForm.getZoneName());
            }
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        }
        CmdParam tmpCmdParam1 = new CmdParam();
        tmpCmdParam1.setCmdID(isZoneTask ? "ZONE_MAX_COUNT" : "MAX_COUNT");
        HashMap<String, String> params1 = new HashMap<String, String>();
        if (!isZoneTask) {
            params1.put("KeyWord", "anti-ddos");
        }
        params1.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
        params1.put("PcapNumber", String.valueOf(packetTaskForm.getPcapNumber()));
        tmpCmdParam1.setParams(params1);
        paramList.add(tmpCmdParam1);
        CmdParam tmpCmdParam2 = new CmdParam();
        tmpCmdParam2.setCmdID(isZoneTask ? "ZONE_SAMPLE_RATE" : "SAMPLE_RATE");
        HashMap<String, String> params2 = new HashMap<String, String>();
        if (!isZoneTask) {
            params2.put("KeyWord", "anti-ddos");
        }
        params2.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
        params2.put("SamplingPercent", String.valueOf(packetTaskForm.getSamplingPercent()));
        tmpCmdParam2.setParams(params2);
        paramList.add(tmpCmdParam2);
        if (!isZoneTask && null != packetTaskForm.getPcapType() && 1 == packetTaskForm.getPcapType() && null != packetTaskForm.getForwardStatus() && 1 == packetTaskForm.getForwardStatus()) {
            CmdParam tmpCmdParam4 = new CmdParam();
            HashMap<String, String> params4 = new HashMap<String, String>();
            tmpCmdParam4.setCmdID("PACKET_TASK_FORWORD_FLOW_ENABLE");
            params4.put("KeyWord", "anti-ddos");
            params4.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
            tmpCmdParam4.setParams(params4);
            paramList.add(tmpCmdParam4);
        }
        CmdParam tmpCmdParam3 = new CmdParam();
        tmpCmdParam3.setCmdID(isZoneTask ? "ZONE_PCAP_ENABLE" : "PCAP_ENABLE");
        HashMap<String, String> params3 = new HashMap<String, String>();
        if (!isZoneTask) {
            params3.put("KeyWord", "anti-ddos");
        }
        params3.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
        tmpCmdParam3.setParams(params3);
        paramList.add(tmpCmdParam3);
        CommandAPI cAPI = new CommandAPI();
        try {
            List list = cAPI.doTranslate(this.xmlPath, "packetTask", paramList);
            cmds.addAll(list);
        }
        catch (Exception e) {
            bo.setErrorCode(570503L);
            logger.error((Object)("cAPI.doTranslate failed! paramList:" + this.getcleanedMessage(((Object)paramList).toString())));
            return false;
        }
        List results = null;
        logger.warn((Object)("cmds:" + cmds));
        results = this.aticDeviceService.execCmdNoTransaction(cmds, packetTaskForm.getPcapDeviceId().longValue());
        if (!AticUtil.isCmdSucess((List)results)) {
            bo.setErrorCode(570503L);
            String[] params = new String[2];
            for (int i = 0; i < results.size(); ++i) {
                if (!((String)results.get(i)).contains("Error:")) continue;
                String[] temp = ((String)results.get(i)).split("\r\n");
                params[0] = temp[0];
                params[1] = temp[1];
                break;
            }
            bo.setDetailParam(params);
            logger.error((Object)("execCmd failed! cmds :" + this.getcleanedMessage(cmds.toString()) + " results:" + this.getcleanedMessage(results.toString())));
            return false;
        }
        return true;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private boolean undoTranslatePacketTask(PacketTaskForm packetTaskForm, List<String> cmds, boolean isZoneTask, BatchOperation bo) {
        HashMap<String, String> params;
        CmdParam tmpCmdParam;
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        if (isZoneTask) {
            CmdParam tmpCmdParam2 = new CmdParam();
            tmpCmdParam2.setCmdID("ZONE");
            HashMap<String, String> params2 = new HashMap<String, String>();
            ZoneInfoForm zoneForm = this.zoneService.getById(packetTaskForm.getZoneId());
            if (1 == zoneForm.getZoneType()) {
                params2.put("default", "default");
            } else {
                params2.put("zoneName", zoneForm.getZoneName());
            }
            tmpCmdParam2.setParams(params2);
            paramList.add(tmpCmdParam2);
        }
        CmdParam tmpCmdParam1 = new CmdParam();
        tmpCmdParam1.setCmdID(isZoneTask ? "UNDO_ZONE_PACKET_TASK_ENABLE" : "UNDO_PACKET_TASK_ENABLE");
        HashMap<String, String> params1 = new HashMap<String, String>();
        if (!isZoneTask) {
            params1.put("KeyWord", "anti-ddos");
        }
        params1.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
        tmpCmdParam1.setParams(params1);
        paramList.add(tmpCmdParam1);
        if (!isZoneTask && null != packetTaskForm.getPcapType() && null != packetTaskForm.getForwardStatus() && 1 == packetTaskForm.getPcapType() && 1 == packetTaskForm.getForwardStatus()) {
            tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("UNDO_PACKET_TASK_FORWORD_FLOW_ENABLE");
            params = new HashMap();
            params.put("KeyWord", "anti-ddos");
            params.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        }
        if (1 == packetTaskForm.getPcapType()) {
            tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("UNDO_PACKET_TASK_ACL");
            params = new HashMap<String, String>();
            params.put("KeyWord", "anti-ddos");
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        }
        if (isZoneTask) {
            tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("UNDO_ZONE_PACKET_TASK_MAXCOUNT");
            params = new HashMap();
            params.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        } else {
            tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("UNDO_FULL_PACKET_TASK_MAXCOUNT");
            params = new HashMap();
            params.put("KeyWord", "anti-ddos");
            params.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        }
        if (isZoneTask) {
            tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("UNDO_ZONE_PACKET_TASK_SAMPLERATE");
            params = new HashMap();
            params.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        } else {
            tmpCmdParam = new CmdParam();
            tmpCmdParam.setCmdID("UNDO_FULL_PACKET_TASK_SAMPLERATE");
            params = new HashMap();
            params.put("KeyWord", "anti-ddos");
            params.put("pcapType", AticConstants.getPacketTaskTypeMap().get(packetTaskForm.getPcapType()));
            tmpCmdParam.setParams(params);
            paramList.add(tmpCmdParam);
        }
        CommandAPI cAPI = new CommandAPI();
        try {
            List list = cAPI.doTranslate(this.xmlPath, "packetTask", paramList);
            cmds.addAll(list);
        }
        catch (Exception e) {
            bo.setErrorCode(570503L);
            logger.error((Object)("cAPI.doTranslate failed! paramList:" + this.getcleanedMessage(((Object)paramList).toString())));
            return false;
        }
        if (1 == packetTaskForm.getPcapType()) {
            if ("IPV4".equals(((AclRuleForm)packetTaskForm.getListAclRuleForm().get(0)).getAclRuleIpType())) {
                cmds.add("undo acl 3999");
            } else {
                cmds.add("undo acl ipv6 3999");
            }
        }
        logger.info((Object)("cmds:" + this.getcleanedMessage(cmds.toString())));
        List results = null;
        results = this.aticDeviceService.execCmdNoTransaction(cmds, packetTaskForm.getPcapDeviceId().longValue());
        if (!AticUtil.isCmdSucess((List)results)) {
            bo.setErrorCode(570503L);
            logger.error((Object)("execCmd failed! cmds :" + this.getcleanedMessage(cmds.toString()) + " results:" + this.getcleanedMessage(results.toString())));
            return false;
        }
        return true;
    }

    private boolean validateEmptyString(String str) {
        return null != str && !"".equals(str) && !"null".equals(str);
    }

    public BatchOperationResult batchStopPacketTask(List<BatchOperation> boList, String forceDeletes, BatchOperationResult result, boolean isDeleteDevice) {
        if (null == boList || boList.isEmpty()) {
            return new BatchOperationResult();
        }
        int fail = result.getFailCount();
        for (BatchOperation bo : boList) {
            PacketTaskForm packetTaskForm = this.findById(bo.getTargetId());
            try {
                if (null == packetTaskForm) {
                    ++fail;
                    bo.setErrorCode(571502L);
                    logger.error((Object)("packetTaskForm is null! pcap id:" + bo.getTargetId()));
                    continue;
                }
                AticDevice device = this.aticDeviceService.getDeviceByMoid(packetTaskForm.getPcapDeviceId().longValue());
                if (-1 == device.getStatus()) {
                    packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                    packetTaskForm.setStartTime(Long.valueOf(0L));
                    packetTaskForm.setStopTime(Long.valueOf(0L));
                    this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                    ++fail;
                    bo.setErrorCode(571508L);
                    continue;
                }
                int state = packetTaskForm.getPcapTaskState();
                if (0 == state) {
                    ++fail;
                    bo.setErrorCode(571503L);
                    logger.error((Object)("pcap state is stop! id:" + packetTaskForm.getId()));
                    continue;
                }
                packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                packetTaskForm.setStopTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                if (!isDeleteDevice) {
                    if (!this.undoTranslate(packetTaskForm, bo)) {
                        packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                        packetTaskForm.setStopTime(Long.valueOf(0L));
                        this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                        ++fail;
                        continue;
                    }
                } else if (packetTaskForm.getPcapType() != 2 && packetTaskForm.getPcapType() != 3 && !this.undoTranslate(packetTaskForm, bo)) {
                    packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                    packetTaskForm.setStopTime(Long.valueOf(0L));
                    this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                    ++fail;
                    continue;
                }
                if ("no".equals(forceDeletes)) {
                    CapturePcapService client = this.packetCollectorRMIProxy.getCapturePcapService(bo.getOptDetail());
                    if (null == client) {
                        packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                        packetTaskForm.setStopTime(Long.valueOf(0L));
                        this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                        ++fail;
                        bo.setErrorCode(570504L);
                        logger.error((Object)("get collector service failed! collector ip:" + this.getcleanedMessage(bo.getOptDetail())));
                        continue;
                    }
                    client.cancelPcapTask(packetTaskForm.getId());
                }
                bo.setOptDetail("atic.bis.packetTask.stopSummary");
                bo.setDetailParam(new String[]{bo.getTargetName()});
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
                packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                bo.setErrorCode(e.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)("bo targetId:" + bo.getTargetId()), (Throwable)e);
                packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                bo.setErrorCode(570507L);
            }
        }
        for (BatchOperation batchOperation : boList) {
            long errorCode = batchOperation.getErrorCode();
            if (514L != errorCode) continue;
            batchOperation.setErrorCode(570659L);
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    private boolean validateStart(PacketTaskForm packetTaskForm, BatchOperation bo) {
        if (null == packetTaskForm) {
            bo.setErrorCode(571502L);
            logger.error((Object)("packetTaskForm is null! pcap id:" + bo.getTargetId()));
            return false;
        }
        int state = packetTaskForm.getPcapTaskState();
        if (1 == state) {
            bo.setErrorCode(571504L);
            logger.error((Object)("pcap state is start! id:" + bo.getTargetId()));
            return false;
        }
        if (null != packetTaskForm.getZoneId() && 0L != packetTaskForm.getZoneId()) {
            IZonePolicyApplyService zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
            ZonePolicyApplyForm zonePolicyApplyForm = zonePolicyApplyService.queryByZoneId(packetTaskForm.getZoneId());
            if (null == zonePolicyApplyForm) {
                bo.setErrorCode(571505L);
                logger.error((Object)("this zone policy is not exist" + bo.getTargetId()));
                return false;
            }
            if ("PART_SUCCESS".equals(zonePolicyApplyForm.getDeployState()) || "UNDEPLOY".equals(zonePolicyApplyForm.getDeployState())) {
                bo.setErrorCode(571505L);
                logger.error((Object)("this zone policy " + zonePolicyApplyForm.getDeployState() + "and the pcap id is :" + bo.getTargetId()));
                return false;
            }
        }
        if (this.packetTaskDao.isSameTypeTaskStart(packetTaskForm.getPcapDeviceId(), packetTaskForm.getPcapType(), packetTaskForm.getZoneId())) {
            bo.setErrorCode(571504L);
            logger.error((Object)("the same type pcap task has started! id:" + packetTaskForm.getId()));
            return false;
        }
        return true;
    }

    public void delById(Long id) {
        try {
            this.packetTaskDao.remove(id);
        }
        catch (DataAccessException e) {
            logger.error((Object)("packetTaskDao removed failed! id:" + id), (Throwable)e);
        }
    }

    public PacketTaskForm findById(Long id) {
        PacketTask packetTask = this.packetTaskDao.get(id);
        if (null == packetTask) {
            logger.info((Object)("packetTask is null! id:" + id));
            return null;
        }
        PacketTaskForm packetTaskForm = new PacketTaskForm();
        AticUtil.copyProperties((Object)packetTask, (Object)packetTaskForm);
        if (1 == packetTask.getPcapType()) {
            ArrayList<AclRuleForm> listAclForm = new ArrayList<AclRuleForm>();
            List listAclRule = this.aclRuleDao.findByHql("from AclRule where packetTaskId = ? ", id);
            for (AclRule aclRule : listAclRule) {
                AclRuleForm form = new AclRuleForm();
                AticUtil.copyProperties((Object)aclRule, (Object)form);
                listAclForm.add(form);
            }
            packetTaskForm.setListAclRuleForm(listAclForm);
        }
        return packetTaskForm;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        logger.info((Object)"enter queryByPage");
        Paging page = this.packetTaskDao.queryByPage(queryMap, start, pageSize);
        List list = page.getData();
        ArrayList<PacketTaskForm> formList = new ArrayList<PacketTaskForm>();
        for (PacketTask group : list) {
            PacketTaskForm form = new PacketTaskForm();
            AticUtil.copyProperties((Object)group, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        logger.info((Object)"leave queryByPage");
        return page;
    }

    public boolean isPacketTaskExists(String packetTaskName) {
        return this.packetTaskDao.isPacketTaskExists(packetTaskName);
    }

    public boolean isTaskExistByFuzzyQuery(String packetTaskName) {
        return this.packetTaskDao.isTaskExistByFuzzyQuery(packetTaskName);
    }

    public BatchOperationResult deployAndStartPacketTask(PacketTaskForm addPacketTaskForm, long userId, Boolean isAdmin, String terminalIp, String userName) {
        int i;
        logger.info((Object)"enter deployPacketTask");
        String zoneIds = addPacketTaskForm.getZoneIds();
        String neIds = addPacketTaskForm.getPcapDeviceIds();
        ArrayList<PacketTaskForm> deployList = new ArrayList<PacketTaskForm>();
        String[] arrNeId = neIds.split(",");
        ArrayList<String> neIdList = new ArrayList<String>();
        for (i = 0; i < arrNeId.length; ++i) {
            neIdList.add(arrNeId[i].split(";")[0]);
        }
        if (!"".equals(zoneIds) && null != zoneIds) {
            String[] arrZoneId = zoneIds.split(",");
            ArrayList<Long> lZoneIds = new ArrayList<Long>();
            for (int i2 = 0; i2 < arrZoneId.length; ++i2) {
                lZoneIds.add(Long.valueOf(arrZoneId[i2]));
                List lstDevId = this.zoneMgrNorthService.getDevByZone4Secutity(lZoneIds, isAdmin, Long.valueOf(userId));
                lZoneIds.clear();
                for (Long devId : lstDevId) {
                    if (!neIdList.contains(String.valueOf(devId))) continue;
                    PacketTaskForm deployForm = new PacketTaskForm();
                    deployForm.setListAclRuleForm(addPacketTaskForm.getListAclRuleForm());
                    deployForm.setPcapNumber(addPacketTaskForm.getPcapNumber());
                    deployForm.setPcapTaskState(addPacketTaskForm.getPcapTaskState());
                    deployForm.setPcapType(addPacketTaskForm.getPcapType());
                    deployForm.setSamplingPercent(addPacketTaskForm.getSamplingPercent());
                    deployForm.setStartTime(addPacketTaskForm.getStartTime());
                    deployForm.setStopTime(addPacketTaskForm.getStopTime());
                    deployForm.setPcapDeviceId(devId);
                    deployForm.setZoneId(Long.valueOf(arrZoneId[i2]));
                    deployForm.setPcapTaskName(addPacketTaskForm.getPcapTaskName());
                    deployForm.setFilterStatus(addPacketTaskForm.getFilterStatus());
                    deployForm.setFingerHitChance(addPacketTaskForm.getFingerHitChance());
                    deployForm.setFingerKeyword(addPacketTaskForm.getFingerKeyword());
                    deployForm.setFingerLength(addPacketTaskForm.getFingerLength());
                    deployForm.setForwardStatus(addPacketTaskForm.getForwardStatus());
                    deployList.add(deployForm);
                }
            }
        } else {
            for (i = 1; i <= arrNeId.length; ++i) {
                PacketTaskForm deployForm = new PacketTaskForm();
                deployForm.setListAclRuleForm(addPacketTaskForm.getListAclRuleForm());
                deployForm.setPcapNumber(addPacketTaskForm.getPcapNumber());
                deployForm.setPcapTaskState(addPacketTaskForm.getPcapTaskState());
                deployForm.setPcapType(addPacketTaskForm.getPcapType());
                deployForm.setSamplingPercent(addPacketTaskForm.getSamplingPercent());
                deployForm.setStartTime(addPacketTaskForm.getStartTime());
                deployForm.setStopTime(addPacketTaskForm.getStopTime());
                deployForm.setPcapDeviceId(Long.valueOf(Long.parseLong(arrNeId[i - 1].split(";")[0])));
                if (arrNeId[i - 1].split(";")[1].equals("-1") || arrNeId[i - 1].split(";")[1].equals("")) {
                    deployForm.setVpnName("--");
                } else {
                    deployForm.setVpnName(arrNeId[i - 1].split(";")[1]);
                }
                deployForm.setPcapTaskName(addPacketTaskForm.getPcapTaskName());
                deployForm.setFilterStatus(addPacketTaskForm.getFilterStatus());
                deployForm.setFingerHitChance(addPacketTaskForm.getFingerHitChance());
                deployForm.setFingerKeyword(addPacketTaskForm.getFingerKeyword());
                deployForm.setFingerLength(addPacketTaskForm.getFingerLength());
                deployForm.setForwardStatus(addPacketTaskForm.getForwardStatus());
                deployList.add(deployForm);
            }
        }
        int nameNumber = 1;
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        for (PacketTaskForm form : deployList) {
            try {
                BatchOperation bo = new BatchOperation();
                Long pkid = null;
                if (deployList.size() > 1) {
                    form.setPcapTaskName(form.getPcapTaskName() + "_" + nameNumber);
                    ++nameNumber;
                }
                PacketTask task = (PacketTask)AticUtil.copyProperties((Object)form, (Object)new PacketTask());
                pkid = (Long)this.packetTaskDao.save(task);
                if (null != form.getListAclRuleForm() && !form.getListAclRuleForm().isEmpty()) {
                    for (AclRuleForm aclForm : form.getListAclRuleForm()) {
                        aclForm.setPacketTaskId(task.getId());
                        this.aclRuleDao.save((AclRule)AticUtil.copyProperties((Object)aclForm, (Object)new AclRule()));
                    }
                }
                bo.setTargetId(pkid.longValue());
                bo.setTargetName(form.getPcapTaskName());
                Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(form.getPcapDeviceId());
                if (null == collectorId) {
                    bo.setOptDetail(null);
                } else {
                    String ipaddress = this.collectorService.getCollectorInfo(collectorId.longValue()).getIpAddress();
                    bo.setOptDetail(ipaddress);
                }
                boList.add(bo);
                this.addOperaLog(userName, terminalIp, null, form);
            }
            catch (Exception e) {
                logger.error((Object)("deploy packet task failed! " + e));
                this.addOperaLog(userName, terminalIp, e, form);
            }
        }
        return this.batchStartPacketTask(boList);
    }

    public void deployPacketTask(PacketTaskForm addPacketTaskForm, long userId, Boolean isAdmin, String terminalIp, String userName) {
        int i;
        logger.info((Object)"enter deployPacketTask");
        String zoneIds = addPacketTaskForm.getZoneIds();
        String neIds = addPacketTaskForm.getPcapDeviceIds();
        ArrayList<PacketTaskForm> deployList = new ArrayList<PacketTaskForm>();
        String[] arrNeId = neIds.split(",");
        ArrayList<String> neIdList = new ArrayList<String>();
        for (i = 0; i < arrNeId.length; ++i) {
            neIdList.add(arrNeId[i].split(";")[0]);
        }
        if (!"".equals(zoneIds) && null != zoneIds) {
            String[] arrZoneId = zoneIds.split(",");
            ArrayList<Long> lZoneIds = new ArrayList<Long>();
            for (int i2 = 0; i2 < arrZoneId.length; ++i2) {
                lZoneIds.add(Long.valueOf(arrZoneId[i2]));
                List lstDevId = this.zoneMgrNorthService.getDevByZone4Secutity(lZoneIds, isAdmin, Long.valueOf(userId));
                lZoneIds.clear();
                for (Long devId : lstDevId) {
                    if (!neIdList.contains(String.valueOf(devId))) continue;
                    PacketTaskForm deployForm = new PacketTaskForm();
                    deployForm.setListAclRuleForm(addPacketTaskForm.getListAclRuleForm());
                    deployForm.setPcapNumber(addPacketTaskForm.getPcapNumber());
                    deployForm.setPcapTaskState(addPacketTaskForm.getPcapTaskState());
                    deployForm.setPcapType(addPacketTaskForm.getPcapType());
                    deployForm.setSamplingPercent(addPacketTaskForm.getSamplingPercent());
                    deployForm.setStartTime(addPacketTaskForm.getStartTime());
                    deployForm.setStopTime(addPacketTaskForm.getStopTime());
                    deployForm.setPcapDeviceId(devId);
                    deployForm.setZoneId(Long.valueOf(arrZoneId[i2]));
                    deployForm.setPcapTaskName(addPacketTaskForm.getPcapTaskName());
                    deployForm.setFilterStatus(addPacketTaskForm.getFilterStatus());
                    deployForm.setFingerHitChance(addPacketTaskForm.getFingerHitChance());
                    deployForm.setFingerKeyword(addPacketTaskForm.getFingerKeyword());
                    deployForm.setFingerLength(addPacketTaskForm.getFingerLength());
                    deployForm.setForwardStatus(addPacketTaskForm.getForwardStatus());
                    deployList.add(deployForm);
                }
            }
        } else {
            for (i = 1; i <= arrNeId.length; ++i) {
                PacketTaskForm deployForm = new PacketTaskForm();
                deployForm.setListAclRuleForm(addPacketTaskForm.getListAclRuleForm());
                deployForm.setPcapNumber(addPacketTaskForm.getPcapNumber());
                deployForm.setPcapTaskState(addPacketTaskForm.getPcapTaskState());
                deployForm.setPcapType(addPacketTaskForm.getPcapType());
                deployForm.setSamplingPercent(addPacketTaskForm.getSamplingPercent());
                deployForm.setStartTime(addPacketTaskForm.getStartTime());
                deployForm.setStopTime(addPacketTaskForm.getStopTime());
                deployForm.setPcapDeviceId(Long.valueOf(Long.parseLong(arrNeId[i - 1].split(";")[0])));
                if (arrNeId[i - 1].split(";")[1].equals("-1") || arrNeId[i - 1].split(";")[1].equals("")) {
                    deployForm.setVpnName("--");
                } else {
                    deployForm.setVpnName(arrNeId[i - 1].split(";")[1]);
                }
                deployForm.setPcapTaskName(addPacketTaskForm.getPcapTaskName());
                deployForm.setFilterStatus(addPacketTaskForm.getFilterStatus());
                deployForm.setFingerHitChance(addPacketTaskForm.getFingerHitChance());
                deployForm.setFingerKeyword(addPacketTaskForm.getFingerKeyword());
                deployForm.setFingerLength(addPacketTaskForm.getFingerLength());
                deployForm.setForwardStatus(addPacketTaskForm.getForwardStatus());
                deployList.add(deployForm);
            }
        }
        int nameNumber = 1;
        for (PacketTaskForm form : deployList) {
            try {
                if (deployList.size() > 1) {
                    form.setPcapTaskName(form.getPcapTaskName() + "_" + nameNumber);
                    ++nameNumber;
                }
                PacketTask task = (PacketTask)AticUtil.copyProperties((Object)form, (Object)new PacketTask());
                this.packetTaskDao.saveOrUpdate(task);
                if (null != form.getListAclRuleForm() && !form.getListAclRuleForm().isEmpty()) {
                    for (AclRuleForm aclForm : form.getListAclRuleForm()) {
                        aclForm.setPacketTaskId(task.getId());
                        this.aclRuleDao.save((AclRule)AticUtil.copyProperties((Object)aclForm, (Object)new AclRule()));
                    }
                }
                this.addOperaLog(userName, terminalIp, null, form);
            }
            catch (Exception e) {
                logger.error((Object)("deploy packet task failed! " + e));
                this.addOperaLog(userName, terminalIp, e, form);
            }
        }
        logger.info((Object)"leave deployPacketTask");
    }

    public void deployPacketTask(PacketTaskForm addPacketTaskForm, List<AclRuleForm> listAclRuleForm) {
        logger.info((Object)"enter deployPacketTask");
        PacketTask task = (PacketTask)AticUtil.copyProperties((Object)addPacketTaskForm, (Object)new PacketTask());
        this.packetTaskDao.saveOrUpdate(task);
        if (null != listAclRuleForm && !listAclRuleForm.isEmpty()) {
            for (AclRuleForm form : listAclRuleForm) {
                form.setPacketTaskId(task.getId());
                this.aclRuleDao.save((AclRule)AticUtil.copyProperties((Object)form, (Object)new AclRule()));
            }
        }
        logger.info((Object)"leave deployPacketTask");
    }

    private void addOperaLog(String userName, String terminalIp, Exception e, PacketTaskForm addPacketTaskForm) {
        ISysOptLog sysOptLogMgr = this.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation("atic.bis.pcap.task.add");
        sysOptLogLego.setOperator(userName);
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        String packetTaskType = "atic.bis.pcap.task.type.acl";
        packetTaskType = 0 == addPacketTaskForm.getPcapType() ? "atic.bis.pcap.task.type.global" : (2 == addPacketTaskForm.getPcapType() ? "atic.bis.pcap.task.type.attack" : (3 == addPacketTaskForm.getPcapType() ? "atic.bis.pcap.task.type.abnormal" : "atic.bis.pcap.task.type.acl"));
        String samplingPercent = (int)Math.scalb(1.0f, (int)addPacketTaskForm.getSamplingPercent()) + ":1";
        AticDevice device = this.aticDeviceService.getDeviceByMoid(addPacketTaskForm.getPcapDeviceId().longValue());
        String deviceName = "";
        if (null == device) {
            throw new LegoCheckedException(570502L);
        }
        deviceName = device.getName();
        deviceName = this.processDeviceName(deviceName);
        if (e == null) {
            sysOptLogLego.setResult(1);
            if (null == addPacketTaskForm.getZoneId()) {
                sysOptLogLego.setDetail("atic.bis.packetTask.addSummary.noAcl");
                String[] paraDetail = new String[]{addPacketTaskForm.getPcapTaskName(), deviceName, packetTaskType, samplingPercent, addPacketTaskForm.getPcapNumber().toString()};
                sysOptLogLego.setDetailPara(paraDetail);
            } else {
                sysOptLogLego.setDetail("atic.bis.packetTask.addSummary.userPacket");
                String zoneDesc = this.zoneService.getById(addPacketTaskForm.getZoneId()).getZoneDesc();
                String[] paraDetail = new String[]{addPacketTaskForm.getPcapTaskName(), deviceName, packetTaskType, zoneDesc, samplingPercent, addPacketTaskForm.getPcapNumber().toString()};
                sysOptLogLego.setDetailPara(paraDetail);
            }
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail("atic.bis.packetTask.addSummary.fail");
            String[] paraDetail = new String[]{addPacketTaskForm.getPcapTaskName(), e.getMessage()};
            sysOptLogLego.setDetailPara(paraDetail);
        }
        sysOptLogLego.setTarget(addPacketTaskForm.getPcapTaskName());
        sysOptLogLego.setTargetLocal(Boolean.valueOf(false));
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }

    private String processDeviceName(String deviceName) {
        if (deviceName.indexOf("[") > -1 || deviceName.indexOf("]") > -1) {
            deviceName = deviceName.replace("[", " ");
            deviceName = deviceName.replace("]", " ");
        }
        return deviceName;
    }

    public ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            logger.error((Object)"get system/sysLogService service error");
        }
        logger.error((Object)"get system/sysLogService service error");
        return null;
    }

    public List<Long> getAllDeployDevice() {
        ArrayList<Long> listDeviceId = new ArrayList<Long>();
        List<Object> tmplist = this.packetTaskDao.getDistinctDeviceId();
        for (Object deviceId : tmplist) {
            Long id = (Long)deviceId;
            listDeviceId.add(id);
        }
        return listDeviceId;
    }

    public List<Long> getAllDeployZone() {
        ArrayList<Long> listZoneId = new ArrayList<Long>();
        List<Object> tmplist = this.packetTaskDao.getDistinctZoneId();
        for (Object zoneId : tmplist) {
            Long id = (Long)zoneId;
            listZoneId.add(id);
        }
        return listZoneId;
    }

    public PacketTaskDao getPacketTaskDao() {
        return this.packetTaskDao;
    }

    public void setPacketTaskDao(PacketTaskDao packetTaskDao) {
        this.packetTaskDao = packetTaskDao;
    }

    public AclRuleDao getAclRuleDao() {
        return this.aclRuleDao;
    }

    public void setAclRuleDao(AclRuleDao aclRuleDao) {
        this.aclRuleDao = aclRuleDao;
    }

    public void setPacketCollectorRMIProxy(PacketCollectorRMIProxy packetCollectorRMIProxy) {
        this.packetCollectorRMIProxy = packetCollectorRMIProxy;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respondMsgDelDevice(List<AticDeviceForm> deviceList) {
        if (null == deviceList || deviceList.isEmpty()) {
            logger.error((Object)"deviceList is null or empty");
            return;
        }
        ArrayList<BatchOperation> batchStopList = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> batchDelList = new ArrayList<BatchOperation>();
        for (AticDeviceForm device : deviceList) {
            List<PacketTask> packetTasks = this.packetTaskDao.findPacketTaskByDevId(device.getMoId());
            if (packetTasks.isEmpty()) continue;
            for (PacketTask packetTask : packetTasks) {
                CollectorInfo cInfo;
                CollectorInfo cInfo2;
                BatchOperation delBo = new BatchOperation();
                delBo.setExtTargetId((Object)packetTask.getPcapTaskState());
                delBo.setTargetId(packetTask.getId().longValue());
                Long collectId = this.collectorDeviceService.getCollectorIdByDevId(packetTask.getPcapDeviceId());
                if (null != collectId && null != (cInfo2 = this.collectorService.getCollectorInfo(collectId.longValue()))) {
                    delBo.setOptDetail(cInfo2.getIpAddress());
                }
                batchDelList.add(delBo);
                if (packetTask.getPcapTaskState() != 1) continue;
                BatchOperation stopBo = new BatchOperation();
                stopBo.setTargetId(packetTask.getId().longValue());
                if (null != collectId && null != (cInfo = this.collectorService.getCollectorInfo(collectId.longValue()))) {
                    stopBo.setOptDetail(cInfo.getIpAddress());
                }
                batchStopList.add(stopBo);
            }
            try {
                if (batchStopList.isEmpty()) continue;
                this.batchStopPacketTask(batchStopList, this.forceDelete, new BatchOperationResult(), true);
            }
            catch (Exception e) {
                logger.error((Object)"stop packet task failed! exception:", (Throwable)e);
            }
            finally {
                if (batchDelList.isEmpty()) continue;
                this.batchDelPacketTask(batchDelList, true, this.forceDelete, device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respondForDelZone(List<BatchOperation> bathOprLst) {
        if (null == bathOprLst || bathOprLst.isEmpty()) {
            logger.error((Object)"bathOprLst is null or empty");
            return;
        }
        ArrayList<BatchOperation> batchStopList = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> batchDelList = new ArrayList<BatchOperation>();
        for (BatchOperation bo : bathOprLst) {
            List<PacketTask> packetTasks;
            Long zoneId = bo.getTargetId();
            long errorCode = bo.getErrorCode();
            if (0L != errorCode || (packetTasks = this.packetTaskDao.findPacketTaskByZoneId(zoneId)).isEmpty()) continue;
            for (PacketTask packetTask : packetTasks) {
                CollectorInfo cInfo;
                BatchOperation delBo = new BatchOperation();
                delBo.setExtTargetId((Object)packetTask.getPcapTaskState());
                delBo.setTargetId(packetTask.getId().longValue());
                delBo.setOptDetail(packetTask.getPcapType().toString());
                batchDelList.add(delBo);
                if (packetTask.getPcapTaskState() != 1) continue;
                BatchOperation stopBo = new BatchOperation();
                stopBo.setTargetId(packetTask.getId().longValue());
                Long collectId = this.collectorDeviceService.getCollectorIdByDevId(packetTask.getPcapDeviceId());
                if (null != collectId && null != (cInfo = this.collectorService.getCollectorInfo(collectId.longValue()))) {
                    stopBo.setOptDetail(cInfo.getIpAddress());
                }
                batchStopList.add(stopBo);
            }
        }
        try {
            if (!batchStopList.isEmpty()) {
                this.batchStopPacketTask(batchStopList, this.forceDelete, new BatchOperationResult(), false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"stop packet task failed! exception:", (Throwable)e);
        }
        finally {
            if (!batchDelList.isEmpty()) {
                this.batchDelPacketTask(batchDelList, true, this.forceDelete);
            }
        }
    }

    public int getZoneCaputreStauts(long zoneId) {
        int pcapStatus = 0;
        List<PacketTask> tasks = this.packetTaskDao.findPacketTaskByZoneId(zoneId);
        if (!tasks.isEmpty()) {
            for (PacketTask each : tasks) {
                if (each.getPcapTaskState() != 1) continue;
                return 1;
            }
        } else {
            pcapStatus = -1;
        }
        return pcapStatus;
    }

    public List<PacketTaskForm> getAllStartPacketTaskByZoneId(long zoneId) {
        List<PacketTask> packetTaskList = this.packetTaskDao.findPacketTaskByZoneId(zoneId);
        ArrayList<PacketTaskForm> packetTaskFormReturnList = new ArrayList<PacketTaskForm>();
        if (!packetTaskList.isEmpty()) {
            for (PacketTask packetTask : packetTaskList) {
                if (packetTask.getPcapTaskState() != 1) continue;
                PacketTaskForm packetTaskFormTemp = new PacketTaskForm();
                AticUtil.copyProperties((Object)packetTask, (Object)packetTaskFormTemp);
                packetTaskFormReturnList.add(packetTaskFormTemp);
            }
        }
        return packetTaskFormReturnList;
    }

    public List<PacketTaskForm> getAllByZoneId(long zoneId) {
        List<PacketTask> packetTaskList = this.packetTaskDao.findPacketTaskByZoneId(zoneId);
        ArrayList<PacketTaskForm> packetTaskFormReturnList = new ArrayList<PacketTaskForm>();
        if (!packetTaskList.isEmpty()) {
            for (PacketTask packetTask : packetTaskList) {
                PacketTaskForm packetTaskFormTemp = new PacketTaskForm();
                AticUtil.copyProperties((Object)packetTask, (Object)packetTaskFormTemp);
                packetTaskFormReturnList.add(packetTaskFormTemp);
            }
        }
        return packetTaskFormReturnList;
    }

    public List<ZonePairCopy> getStartPacketTaskList(List<Long> zoneIdList) {
        ArrayList<ZonePairCopy> zonePairList = new ArrayList<ZonePairCopy>();
        for (Long zoneId : zoneIdList) {
            logger.info((Object)("get start packetTask by zoneId :" + zoneId));
            List<PacketTask> packetTaskList = this.packetTaskDao.findPacketTaskByZoneId(zoneId);
            if (packetTaskList.isEmpty()) continue;
            for (PacketTask packetTask : packetTaskList) {
                if (1 != packetTask.getPcapTaskState()) continue;
                ZonePairCopy zonePair = new ZonePairCopy();
                zonePair.setZoneId(packetTask.getZoneId());
                zonePair.setDeviceId(packetTask.getPcapDeviceId());
                logger.info((Object)("zonePair zoneId : " + zoneId + " deviceId : " + packetTask.getPcapDeviceId()));
                zonePairList.add(zonePair);
            }
        }
        return zonePairList;
    }

    public Map<ZonePairCopy, String> stopPacketTaskByPolicy(List<ZonePairCopy> zonePairList) {
        HashMap<ZonePairCopy, String> map = new HashMap<ZonePairCopy, String>();
        for (ZonePairCopy zonePairCopy : zonePairList) {
            logger.info((Object)("stop packetTask by zonePair zoneId : " + zonePairCopy.getZoneId() + " deviceId : " + zonePairCopy.getDeviceId()));
            String result = this.stopPacketTaskByZonePair(zonePairCopy);
            logger.info((Object)("stop packeTask result :" + result));
            map.put(zonePairCopy, result);
            logger.info((Object)("return map :" + map));
        }
        return map;
    }

    public String stopPacketTaskByZonePair(ZonePairCopy zonePair) {
        if (null != zonePair && null != zonePair.getZoneId() && null != zonePair.getDeviceId()) {
            List<PacketTask> packetTasksList = this.packetTaskDao.findPacketTaskByZoneIdAndDevId(zonePair.getZoneId(), zonePair.getDeviceId());
            BatchOperationResult boResult = this.stopPcapTask(packetTasksList);
            if (boResult.getFailCount() > 0 && boResult.getResult().size() > 0) {
                String resultString = String.valueOf(((BatchOperation)boResult.getResult().get(0)).getErrorCode());
                return resultString;
            }
            return "success";
        }
        return "success";
    }

    private BatchOperationResult stopPcapTask(List<PacketTask> packetTasksList) {
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (PacketTask packetTask : packetTasksList) {
            PacketTaskForm packetTaskForm = new PacketTaskForm();
            AticUtil.copyProperties((Object)packetTask, (Object)packetTaskForm);
            BatchOperation stopBo = new BatchOperation();
            try {
                int state = packetTaskForm.getPcapTaskState();
                if (0 == state) continue;
                stopBo.setTargetId(packetTaskForm.getId().longValue());
                Long collectId = this.collectorDeviceService.getCollectorIdByDevId(packetTaskForm.getPcapDeviceId());
                if (null == collectId) {
                    logger.error((Object)("The NE is not associated with a collector. NE id is " + packetTaskForm.getPcapDeviceId()));
                    stopBo.setErrorCode(571601L);
                    boList.add(stopBo);
                    ++fail;
                    continue;
                }
                CollectorInfo cInfo = this.collectorService.getCollectorInfo(collectId.longValue());
                if (null != cInfo) {
                    stopBo.setOptDetail(cInfo.getIpAddress());
                }
                packetTaskForm.setPcapTaskState(Integer.valueOf(0));
                packetTaskForm.setStopTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                if (!this.undoTranslate(packetTaskForm, stopBo)) {
                    packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                    packetTaskForm.setStopTime(Long.valueOf(0L));
                    this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                    boList.add(stopBo);
                    ++fail;
                    continue;
                }
                CapturePcapService client = this.packetCollectorRMIProxy.getCapturePcapService(stopBo.getOptDetail());
                if (null == client) {
                    packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                    packetTaskForm.setStopTime(Long.valueOf(0L));
                    this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                    ++fail;
                    stopBo.setErrorCode(570504L);
                    logger.error((Object)("get collector service failed! collector ip:" + this.getcleanedMessage(stopBo.getOptDetail())));
                    boList.add(stopBo);
                    continue;
                }
                client.cancelPcapTask(packetTaskForm.getId());
                stopBo.setOptDetail("atic.bis.packetTask.stopSummary");
                String[] names = new String[]{stopBo.getTargetName()};
                stopBo.setDetailParam(names);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("bo targetId:" + stopBo.getTargetId() + " bo optDetail:" + this.getcleanedMessage(stopBo.getOptDetail())), (Throwable)e);
                packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                stopBo.setErrorCode(e.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)("bo targetId:" + stopBo.getTargetId() + " bo optDetail:" + this.getcleanedMessage(stopBo.getOptDetail())), (Throwable)e);
                packetTaskForm.setPcapTaskState(Integer.valueOf(1));
                packetTaskForm.setStopTime(Long.valueOf(0L));
                this.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
                ++fail;
                stopBo.setErrorCode(570507L);
            }
            boList.add(stopBo);
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    public BatchOperationResult stopAndDelAllPacketTaskByZoneId(Long zoneId) {
        List<PacketTask> packetTaskList = this.packetTaskDao.findPacketTaskByZoneId(zoneId);
        if (!packetTaskList.isEmpty()) {
            ArrayList<BatchOperation> batchOperationDelList = new ArrayList<BatchOperation>();
            for (PacketTask packetTask : packetTaskList) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(packetTask.getId().longValue());
                bo.setTargetName(packetTask.getPcapTaskName());
                batchOperationDelList.add(bo);
            }
            return this.batchDelPacketTask(batchOperationDelList, false, this.forceDelete);
        }
        return null;
    }

    public Boolean hasStartPacketTaskList(List<Long> zoneIdList) {
        List<ZonePairCopy> zonePairCopys = this.getStartPacketTaskList(zoneIdList);
        if (!zonePairCopys.isEmpty()) {
            return true;
        }
        return false;
    }

    public BatchOperationResult stopAndDelPacketTaskByZonePair(ZonePairCopy zonePairCopy) {
        List<PacketTask> packetTaskList = this.packetTaskDao.findPacketTaskByZoneIdAndDevId(zonePairCopy.getZoneId(), zonePairCopy.getDeviceId());
        if (!packetTaskList.isEmpty()) {
            ArrayList<BatchOperation> batchOperationDelList = new ArrayList<BatchOperation>();
            for (PacketTask packetTask : packetTaskList) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(packetTask.getId().longValue());
                bo.setTargetName(packetTask.getPcapTaskName());
                batchOperationDelList.add(bo);
            }
            return this.batchDelPacketTask(batchOperationDelList, false, this.forceDelete);
        }
        return null;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

