/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.vsm.secservice.ddos.policy.util.ZoneConstants;
import java.util.Locale;

public final class PacketAticUtil {
    public static final int ZONE_IP_TYPE_EXCULDE = 1;
    public static final String PACKET_TASK_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.]*$";
    public static final String PACKET_FILE_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$";

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static Boolean isNum(String str) {
        return str.matches("^[0-9]+$");
    }

    public static Boolean isFileName(String fileName) {
        String fileNameReg = "^[\\u4e00-\\u9fa5a-zA-Z0-9\\@\\.\\_\\-]{1,}$";
        if (fileName.matches(fileNameReg) && !fileNameReg.contains("..")) {
            return true;
        }
        return false;
    }

    public static boolean checkFileName(String downFileName, String downFileType) {
        if (PacketAticUtil.isNull(downFileName)) {
            return false;
        }
        int index = downFileName.lastIndexOf(".");
        if (index > 0) {
            String onlyFileName = downFileName.substring(0, index);
            String fileRealType = downFileName.substring(index + 1, downFileName.length());
            if (PacketAticUtil.isFileName(onlyFileName).booleanValue() && (PacketAticUtil.isNull(downFileType) ? ZoneConstants.getFileTypeList().contains(fileRealType.toLowerCase(Locale.US)) : downFileType.equalsIgnoreCase(fileRealType))) {
                return true;
            }
        }
        return false;
    }

    public static Boolean isPcapFileName(String fileName) {
        if (fileName.matches(PACKET_FILE_NAME_REGEX) && !PACKET_FILE_NAME_REGEX.contains("..")) {
            return true;
        }
        return false;
    }

    public static boolean checkPacpFileName(String downFileName, String downFileType) {
        if (PacketAticUtil.isNull(downFileName)) {
            return false;
        }
        int index = downFileName.lastIndexOf(".");
        if (index > 0) {
            String onlyFileName = downFileName.substring(0, index);
            String fileRealType = downFileName.substring(index + 1, downFileName.length());
            if (PacketAticUtil.isPcapFileName(onlyFileName).booleanValue() && (PacketAticUtil.isNull(downFileType) ? ZoneConstants.getFileTypeList().contains(fileRealType.toLowerCase(Locale.US)) : downFileType.equalsIgnoreCase(fileRealType))) {
                return true;
            }
        }
        return false;
    }
}

