/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.sdk.bis.service.IPacketFileService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.service.impl.ZoneServiceImpl;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.vsm.secservice.sdk.common.service.ICheckUserSecurity;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.ServletActionContext;

public final class PacketBisUtil {
    private PacketBisUtil() {
    }

    public static ICollectorService getCollectorService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            return (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        }
        throw new LegoCheckedException(570506L);
    }

    public static IPacketTaskService getPacketTaskService() {
        return (IPacketTaskService)ServiceContext.getInstance().getService("packetTaskService", IPacketTaskService.class);
    }

    public static IZoneService getZoneService() {
        return (IZoneService)ServiceContext.getInstance().getService("zoneService", ZoneServiceImpl.class);
    }

    public static IAticDeviceService getIFirewallService() {
        return (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
    }

    public static ICollectorService getICollectorService() {
        return (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
    }

    public static ICollectorDeviceService getICollectorDeviceService() {
        return (ICollectorDeviceService)ServiceContext.getInstance().getService("collectorDeviceService", ICollectorDeviceService.class);
    }

    public static IPacketFileService getPacketFileService() {
        return (IPacketFileService)ServiceContext.getInstance().getService("packetFileService", IPacketFileService.class);
    }

    public static IFilterService getFilterService() {
        return (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
    }

    public static IZoneMgrNorthSerice getZoneMgrNorthSerice() {
        return (IZoneMgrNorthSerice)ServiceContext.getInstance().getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
    }

    public static IFWDefenceAbnormalService getIFWDefenceAbnormalService() {
        return (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
    }

    public static void checkUserSecurity(List<Long> moIdList) {
        ICheckUserSecurity checkUserSecurity = (ICheckUserSecurity)ServiceContext.getInstance().getService("checkUserSecurityService", ICheckUserSecurity.class);
        if (null == checkUserSecurity) {
            throw new LegoCheckedException(570506L);
        }
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        checkUserSecurity.checkUserSecurity(currentUser.getUserID(), Boolean.valueOf("true".equalsIgnoreCase(currentUser.getIsAdmin())), moIdList);
    }

    public static List<LangPair> getPcapTypeCombData(boolean hasAll) {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        if (hasAll) {
            LangPair all = new LangPair("", AticUtil.getText((String)"atic.bis.packet.task.all"));
            combData.add(all);
        }
        LangPair acl = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.pcap.task.type.acl"));
        LangPair global = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.pcap.task.type.global"));
        LangPair attack = new LangPair(String.valueOf(2), AticUtil.getText((String)"atic.bis.pcap.task.type.attack"));
        LangPair abnormal = new LangPair(String.valueOf(3), AticUtil.getText((String)"atic.bis.pcap.task.type.abnormal"));
        combData.add(acl);
        combData.add(global);
        combData.add(attack);
        combData.add(abnormal);
        return combData;
    }

    public static List<LangPair> getPacketTaskStateCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        LangPair data1 = new LangPair("", AticUtil.getText((String)"atic.bis.packet.task.all"));
        LangPair data2 = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.packet.task.state.start"));
        LangPair data3 = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.packet.task.state.stop"));
        combData.add(data1);
        combData.add(data2);
        combData.add(data3);
        return combData;
    }

    public static List<LangPair> getPacketFileStatusCombData() {
        ArrayList<LangPair> combData = new ArrayList<LangPair>();
        LangPair ld1 = new LangPair("", AticUtil.getText((String)"atic.bis.packet.file.all"));
        LangPair ld2 = new LangPair(String.valueOf(0), AticUtil.getText((String)"atic.bis.packet.file.status.learned"));
        LangPair ld3 = new LangPair(String.valueOf(1), AticUtil.getText((String)"atic.bis.packet.file.status.writing"));
        combData.add(ld1);
        combData.add(ld2);
        combData.add(ld3);
        return combData;
    }

    public static String getPcapTypeString(int pcapType) {
        String pcapTypeName = "-";
        if (0 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.discard");
        } else if (1 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.acl");
        } else if (2 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.attack");
        } else if (3 == pcapType) {
            pcapTypeName = AticUtil.getText((String)"atic.bis.packet.file.pcaptype.exception");
        }
        return pcapTypeName;
    }

    public static String getDsipalyAttackStatus(int attackStatus) {
        String attackStatusString = "-";
        if (0 == attackStatus) {
            attackStatusString = AticUtil.getText((String)"atic.bis.packet.file.event.attack.status.stop");
        } else if (1 == attackStatus) {
            attackStatusString = AticUtil.getText((String)"atic.bis.packet.file.event.attack.status.exception");
        } else if (2 == attackStatus) {
            attackStatusString = AticUtil.getText((String)"atic.bis.packet.file.event.attack.status.attacking");
        }
        return attackStatusString;
    }

    public static ICommonUtilService getICommonUtilService() {
        return (ICommonUtilService)ServiceContext.getInstance().getService("commonUtilService", ICommonUtilService.class);
    }

    public static Long getMoidByZoneid(Long zoneId) {
        Long moid = 0L;
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", ZoneServiceImpl.class);
        ZoneInfoForm zoneInfoForm = zoneService.getById(zoneId);
        if (null != zoneInfoForm) {
            moid = zoneInfoForm.getMoId();
        }
        return moid;
    }
}

