/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.util;

import com.hs.atic.bis.util.PacketBisUtil;
import com.hs.atic.bis.util.PacketSystemUtil;
import com.hs.atic.sdk.bis.service.IPacketFileService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.collector.service.ICollectorService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class PacketFileManager
extends Thread {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private IPacketFileService packetFileService;
    private ICollectorService collectorService;
    private PageSizeConfigService pageSizeConfigService;
    private boolean isAlive = true;
    private int beforeDay = 0;

    @Override
    public void run() {
        logger.info((Object)"DeletePacketDataThread run!");
        while (this.isAlive) {
            if (this.isTime2Run(this.getCurrentDay()).booleanValue()) {
                try {
                    this.deletePacketFile();
                }
                catch (Exception e) {
                    logger.error((Object)"packetFileManager some errors happend", (Throwable)e);
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)("DeletePacketDataThread InterruptedException error: " + e));
            }
        }
        logger.info((Object)"DeletePacketDataThread stop!");
    }

    private Boolean isTime2Run(int currentDay) {
        int hour;
        Calendar cal = Calendar.getInstance();
        if (currentDay > this.beforeDay && (hour = cal.get(11)) >= 3) {
            this.beforeDay = currentDay;
            return true;
        }
        return false;
    }

    private int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(6);
        return day;
    }

    public void setAlive(boolean isAliveBool) {
        logger.info((Object)("DeletePacketDataThread isAlive: " + isAliveBool));
        this.isAlive = isAliveBool;
    }

    public void deletePacketFile() {
        int packetFileDelayTime = 90;
        logger.info((Object)"start deletePacketFileData");
        this.pageSizeConfigService = (PageSizeConfigService)ServiceContext.getInstance().getService("pageSizeConfigService", PageSizeConfigService.class);
        this.collectorService = PacketBisUtil.getICollectorService();
        this.packetFileService = PacketBisUtil.getPacketFileService();
        if (null == this.pageSizeConfigService) {
            logger.error((Object)" deletePacketFileData by time is error, getting service is null");
            return;
        }
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("packetFile");
        if (null != sysConfigs && !sysConfigs.isEmpty()) {
            packetFileDelayTime = Integer.parseInt(((PageSizeConfig)sysConfigs.get(0)).getSysValue());
        }
        Long dataKeepTime = PacketSystemUtil.getDataKeepTime(1, packetFileDelayTime);
        long deleteTime = System.currentTimeMillis() / 1000L - dataKeepTime;
        List collectorInfos = this.collectorService.listCollector(null);
        int deleteNum = this.packetFileService.delPacketFilesByTime(deleteTime, collectorInfos);
        String logTime = AticUtil.convertTimeLong((Long)deleteTime);
        this.processOpeLog(deleteNum, true, logTime, "", "atic.pcap.tab.packet.file", true);
        logger.info((Object)("end deletePacketFileData, delete file number is :" + deleteNum));
    }

    private void processOpeLog(int num, Boolean sucess, String time, String errorInfo, String target, boolean targetLocal) {
        ISysOptLog sysOptLogMgr = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation("atic.bis.packet.file.del.time");
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        if (sucess.booleanValue()) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("atic.bis.packet.file.timeDel.success");
            String[] para = new String[]{time, String.valueOf(num)};
            sysOptLogLego.setDetailPara(para);
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(errorInfo);
        }
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }
}

