/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpResponse
implements Serializable {
    private static final int WELL_DEFINED_HEAD_SIZE = 3;
    private static final long serialVersionUID = 6758555638587901584L;
    private int typeCode;
    private String description;
    private String version;
    private Map<String, String> generalHead = new HashMap<String, String>();
    private Boolean isWellDefined;

    public HttpResponse(String startLine) {
        String[] array = startLine.split(" ");
        if (array.length >= 3) {
            this.version = array[0];
            String type = array[1];
            String regex = "^[\\d]+$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(type);
            this.typeCode = matcher.find() ? Integer.parseInt(type) : 0;
            this.description = startLine;
            this.isWellDefined = true;
        }
    }

    public Boolean getIsWellDefined() {
        return this.isWellDefined;
    }

    public void setIsWellDefined(Boolean isWellDefined) {
        this.isWellDefined = isWellDefined;
    }

    public void addHeadContent(String key, String value) {
        this.generalHead.put(key, value);
    }

    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        if (this.isWellDefined.booleanValue()) {
            content.put("Request Version", this.version);
            content.put("Response Code", this.typeCode + "");
            content.putAll(this.generalHead);
        }
        return content;
    }

    public String getDescription() {
        if (this.isWellDefined.booleanValue()) {
            return this.description;
        }
        return "Continuation or Non-HTTP Traffic";
    }
}

