/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class IcmpProtocol
implements Protocol,
Serializable {
    private static final long serialVersionUID = -2896650296874049926L;
    private SubProtocolType subTypeFlag;
    private byte[] headData = new byte[0];
    private byte[] loadData = new byte[0];
    private int type;
    private int code;
    private int checkSum;
    private Protocol subProtocol;
    private IcmpInnerType innerType;

    public int getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public IcmpInnerType getInnerType() {
        return this.innerType;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public void setInnerType(IcmpInnerType innerType) {
        this.innerType = innerType;
    }

    @Override
    public String getDescription() {
        return this.innerType.getDescription();
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Type", this.type + "");
        content.put("Code", this.code + "");
        content.put("Checksum", "0x" + Integer.toHexString(this.checkSum));
        if (null != this.innerType) {
            content.putAll(this.innerType.getHeadContent());
        }
        return content;
    }

    @Override
    public byte[] getHeadData() {
        byte[] copy = new byte[this.headData.length];
        System.arraycopy(this.headData, 0, copy, 0, this.headData.length);
        return copy;
    }

    @Override
    public byte[] getLoadData() {
        byte[] copy = new byte[this.loadData.length];
        System.arraycopy(this.loadData, 0, copy, 0, this.loadData.length);
        return copy;
    }

    @Override
    public String getProtocolName() {
        return "ICMP";
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subTypeFlag;
    }

    public void setSubTypeFlag(SubProtocolType subTypeFlag) {
        this.subTypeFlag = subTypeFlag;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(null != headData ? (byte[])headData.clone() : null);
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = new byte[loadData.length];
        System.arraycopy(loadData, 0, this.loadData, 0, this.loadData.length);
    }

    static class RedirectType
    implements IcmpInnerType {
        private static final long serialVersionUID = 1055277301163074626L;
        private String ip;
        private int code;
        private int dataLength;
        private int headLength = 8;

        RedirectType() {
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getIp() {
            return this.ip;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength - this.headLength;
        }

        @Override
        public String getDescription() {
            String description = "Redirect";
            switch (this.code) {
                case 0: {
                    description = "Network Redirect";
                    break;
                }
                case 1: {
                    description = "Host Redirect";
                    break;
                }
                case 2: {
                    description = "Service Type and Net Redirect";
                    break;
                }
                case 3: {
                    description = "Service Type and Host Redirect";
                    break;
                }
            }
            return description;
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Gateway Address", this.ip);
            content.put("Data", this.dataLength + " bytes");
            return content;
        }
    }

    static class FragmentUnreachableType
    implements IcmpInnerType {
        private static final long serialVersionUID = -4018887156561629096L;
        private int mtu;
        private int dataLength;
        private int headLength = 8;

        FragmentUnreachableType() {
        }

        public int getMtu() {
            return this.mtu;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setMtu(int mtu) {
            this.mtu = mtu;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength - this.headLength;
        }

        @Override
        public String getDescription() {
            return "Destination Unreachable";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Next Mtu", this.mtu + "");
            content.put("Data", this.dataLength + " bytes");
            return content;
        }
    }

    static class TimeOutType
    implements IcmpInnerType {
        private static final long serialVersionUID = 4848888339099047592L;
        private int dataLength;

        TimeOutType() {
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength;
        }

        @Override
        public String getDescription() {
            return "Time-to-live exceeded";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.dataLength + " bytes");
            return content;
        }
    }

    static class UnreachableType
    implements IcmpInnerType {
        private static final long serialVersionUID = 4848888339099047592L;
        private int dataLength;
        private int code;

        UnreachableType() {
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        @Override
        public String getDescription() {
            StringBuffer description = new StringBuffer("Destination Unreachable");
            HashMap<Integer, String> descMap = new HashMap<Integer, String>();
            descMap.put(0, "(Network Unreachable)");
            descMap.put(1, "(Host Unreachable)");
            descMap.put(2, "(Protocol Unreachable)");
            descMap.put(3, "(Port Unreachable)");
            descMap.put(4, "(Packet fragmentation is required but the DF bit in the IP header is set)");
            descMap.put(5, "(Source Route Failed) ");
            descMap.put(6, "(Destination Network Unknown)");
            descMap.put(7, "(Destination Port Unknown)");
            descMap.put(8, "(Source Host Isolated )");
            descMap.put(9, "(The destination network is administratively prohibited)");
            descMap.put(10, "(The destination host is administratively prohibited)");
            descMap.put(11, "(The network is unreachable for Type Of Service)");
            descMap.put(12, "(The host is unreachable for Type Of Service)");
            descMap.put(13, "(Communication Administratively Prohibited)");
            descMap.put(14, "(Host precedence violation)");
            descMap.put(15, "(Precedence cutoff in effect)");
            for (Map.Entry desc : descMap.entrySet()) {
                if (this.code != (Integer)desc.getKey()) continue;
                description.append((String)desc.getValue());
            }
            return description.toString();
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.dataLength + " bytes");
            return content;
        }
    }

    static class PingType
    implements IcmpInnerType {
        private static final long serialVersionUID = 4830899296790794309L;
        private int identifier;
        private int sequenceNumber;
        private int dataLength;
        private Boolean isReply;
        private int headLength = 8;

        PingType() {
        }

        public Boolean getIsReply() {
            return this.isReply;
        }

        public void setIsReply(Boolean isReply) {
            this.isReply = isReply;
        }

        @Override
        public String getDescription() {
            if (null != this.isReply && this.isReply.booleanValue()) {
                return "Echo(ping)Reply";
            }
            return "Echo(ping)Request";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Identifier", this.identifier + "");
            content.put("Sequence Number", this.sequenceNumber + "");
            content.put("Data", this.dataLength + " bytes");
            return content;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength - this.headLength;
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public int getSerialNumber() {
            return this.sequenceNumber;
        }

        public void setIdentifier(int identifier) {
            this.identifier = identifier;
        }

        public void setSerialNumber(int serialNumber) {
            this.sequenceNumber = serialNumber;
        }
    }

    static class RouterReplyType
    implements IcmpInnerType {
        private static final long serialVersionUID = 4814307122069980631L;
        private int addressNumber;
        private int addressLength;
        private int aliveTime;
        private long[][] addressPair;

        RouterReplyType() {
        }

        @Override
        public String getDescription() {
            return "Router Advertisement";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Number Of Address", this.addressNumber + "");
            content.put("Address Entry Size", this.addressLength + "");
            content.put("LifeTime", this.aliveTime + "");
            for (int i = 0; i < this.addressNumber; ++i) {
                if (null == this.addressPair) continue;
                content.put("Router Address", "0x" + Long.toHexString(this.addressPair[i][0]));
                content.put("Priority", this.addressPair[i][1] + "");
            }
            return content;
        }

        public int getAddressNumber() {
            return this.addressNumber;
        }

        public int getAddressLength() {
            return this.addressLength;
        }

        public int getAliveTime() {
            return this.aliveTime;
        }

        public long[][] getAddressPair() {
            return this.addressPair;
        }

        public void setAddressNumber(int addressNumber) {
            this.addressNumber = addressNumber;
        }

        public void setAddressLength(int addressLength) {
            this.addressLength = addressLength;
        }

        public void setAliveTime(int aliveTime) {
            this.aliveTime = aliveTime;
        }

        public void setAddressPair(long[][] addressPair) {
            this.addressPair = addressPair;
        }
    }

    static class RouterRequestType
    implements IcmpInnerType {
        private static final long serialVersionUID = -7597220862231283326L;

        RouterRequestType() {
        }

        @Override
        public String getDescription() {
            return "Router Solicitation";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            return content;
        }
    }

    static class TimeStampType
    implements IcmpInnerType {
        private static final long serialVersionUID = 3027122089889286577L;
        private int identifier;
        private int sequenceNumber;
        private long originalTime;
        private long receiveTime;
        private long transmitTime;
        private Boolean isReply;

        TimeStampType() {
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public long getOriginalTime() {
            return this.originalTime;
        }

        public long getReceiveTime() {
            return this.receiveTime;
        }

        public long getTransmitTime() {
            return this.transmitTime;
        }

        public void setIdentifier(int identifier) {
            this.identifier = identifier;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public void setOriginalTime(long originalTime) {
            this.originalTime = originalTime;
        }

        public void setReceiveTime(long receiveTime) {
            this.receiveTime = receiveTime;
        }

        public void setTransmitTime(long transmitTime) {
            this.transmitTime = transmitTime;
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Identifier", this.identifier + "");
            content.put("Sequence Number", this.sequenceNumber + "");
            content.put("Original TimeStamp", this.originalTime + "");
            content.put("Receive TimeStamp", this.receiveTime + "");
            content.put("Transmit TimeStamp", this.transmitTime + "");
            return content;
        }

        public Boolean getIsReply() {
            return this.isReply;
        }

        public void setIsReply(Boolean isReply) {
            this.isReply = isReply;
        }

        @Override
        public String getDescription() {
            if (null != this.isReply && this.isReply.booleanValue()) {
                return "TimeStamp Reply";
            }
            return "TimeStamp Request";
        }
    }

    static class MaskType
    implements IcmpInnerType {
        private static final long serialVersionUID = -7031237552911354376L;
        private int identifier;
        private int sequenceNumber;
        private long mark;
        private Boolean isReply;

        MaskType() {
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public int getSerialNumber() {
            return this.sequenceNumber;
        }

        public long getMark() {
            return this.mark;
        }

        public void setIdentifier(int identifier) {
            this.identifier = identifier;
        }

        public void setSerialNumber(int serialNumber) {
            this.sequenceNumber = serialNumber;
        }

        public void setMark(long mark) {
            this.mark = mark;
        }

        public Boolean getIsReply() {
            return this.isReply;
        }

        public void setIsReply(Boolean isReply) {
            this.isReply = isReply;
        }

        @Override
        public String getDescription() {
            if (null != this.isReply && this.isReply.booleanValue()) {
                return "Address Mark Reply";
            }
            return "Address Mark Request";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Identifier", this.identifier + "");
            content.put("Sequence Number", this.sequenceNumber + "");
            content.put("Address Mark", "0x" + Long.toHexString(this.mark));
            return content;
        }
    }

    static class OtherType
    implements IcmpInnerType {
        private static final long serialVersionUID = -8566038134377126083L;

        OtherType() {
        }

        @Override
        public String getDescription() {
            return "ICMP";
        }

        @Override
        public Map<String, String> getHeadContent() {
            return new LinkedHashMap<String, String>();
        }
    }

    static interface IcmpInnerType
    extends Serializable {
        public String getDescription();

        public Map<String, String> getHeadContent();
    }
}

