/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class IcmpProtocol4IpV6
implements Protocol,
Serializable {
    private static final long serialVersionUID = -354848209912484457L;
    private byte[] headData = new byte[0];
    private byte[] loadData = new byte[0];
    private int type;
    private int code;
    private int checkSum;
    private Protocol subProtocol;
    private SubProtocolType subTypeFlag;
    private transient IcmpIpV6InnerType innerType;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public IcmpIpV6InnerType getInnerType() {
        return this.innerType;
    }

    public void setInnerType(IcmpIpV6InnerType innerType) {
        this.innerType = innerType;
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(loadData != null ? (byte[])loadData.clone() : null);
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(headData != null ? (byte[])headData.clone() : null);
    }

    @Override
    public String getDescription() {
        if (null == this.innerType) {
            return "";
        }
        return this.innerType.getDescription();
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Type", this.type + "");
        content.put("Code", this.code + "");
        content.put("Checksum", "0x" + Integer.toHexString(this.checkSum));
        if (null != this.innerType) {
            content.putAll(this.innerType.getHeadContent());
        }
        return content;
    }

    @Override
    public byte[] getHeadData() {
        if (this.headData != null) {
            return (byte[])this.headData.clone();
        }
        return new byte[0];
    }

    @Override
    public byte[] getLoadData() {
        if (this.loadData != null) {
            return (byte[])this.loadData.clone();
        }
        return new byte[0];
    }

    @Override
    public String getProtocolName() {
        return "ICMPV6";
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subTypeFlag;
    }

    public void setSubTypeFlag(SubProtocolType subTypeFlag) {
        this.subTypeFlag = subTypeFlag;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }

    class IcmpIpV6UnresolvedType
    extends IcmpIpV6InnerType {
        IcmpIpV6UnresolvedType() {
        }

        @Override
        public String getDescription() {
            return "unknown(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6GroupMemberReferencesType
    extends IcmpIpV6InnerType {
        IcmpIpV6GroupMemberReferencesType() {
        }

        @Override
        public String getDescription() {
            switch (IcmpProtocol4IpV6.this.getType()) {
                case 130: {
                    return "GroupMember References Query(" + IcmpProtocol4IpV6.this.getType() + ")";
                }
                case 131: {
                    return "GroupMember References Report(" + IcmpProtocol4IpV6.this.getType() + ")";
                }
                case 132: {
                    return "GroupMember References TERMINATE(" + IcmpProtocol4IpV6.this.getType() + ")";
                }
            }
            return "GroupMember References(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6NeighborReplyType
    extends IcmpIpV6InnerType {
        IcmpIpV6NeighborReplyType() {
        }

        @Override
        public String getDescription() {
            return "Neighbor Advertisement(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6NeighborRequestType
    extends IcmpIpV6InnerType {
        IcmpIpV6NeighborRequestType() {
        }

        @Override
        public String getDescription() {
            return "Neighbor Solicitation(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6RouterReplyType
    extends IcmpIpV6InnerType {
        IcmpIpV6RouterReplyType() {
        }

        @Override
        public String getDescription() {
            return "Router Advertisement(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6RouterRequestType
    extends IcmpIpV6InnerType {
        IcmpIpV6RouterRequestType() {
        }

        @Override
        public String getDescription() {
            return "Router Solicitation(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6EchoMessageType
    extends IcmpIpV6InnerType {
        private int identifier;
        private Boolean isReply;
        private int sequenceNumber;

        IcmpIpV6EchoMessageType() {
        }

        public Boolean getIsReply() {
            return this.isReply;
        }

        public void setIsReply(Boolean isReply) {
            this.isReply = isReply;
        }

        public int getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(int identifier) {
            this.identifier = identifier;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public String getDescription() {
            if (null != this.isReply && this.isReply.booleanValue()) {
                return "TimeStamp Reply(" + IcmpProtocol4IpV6.this.getType() + ")";
            }
            return "TimeStamp Request(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Identifier", this.identifier + "");
            content.put("Sequence Number", this.sequenceNumber + "");
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpIpV6RouteChangeType
    extends IcmpIpV6InnerType {
        private String desRoutingIp;
        private String desIp;

        IcmpIpV6RouteChangeType() {
        }

        public String getDesRoutingIp() {
            return this.desRoutingIp;
        }

        public void setDesRoutingIp(String desRoutingIp) {
            this.desRoutingIp = desRoutingIp;
        }

        public String getDesIp() {
            return this.desIp;
        }

        public void setDesIp(String desIp) {
            this.desIp = desIp;
        }

        @Override
        public String getDescription() {
            return "Network Redirect(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Gateway Address", this.desRoutingIp);
            content.put("Destination Address", this.desIp);
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpV6ParameterProblemTyle
    extends IcmpIpV6InnerType {
        IcmpV6ParameterProblemTyle() {
        }

        @Override
        public String getDescription() {
            return "Parameter Problem(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpV6TimeOutType
    extends IcmpIpV6InnerType {
        IcmpV6TimeOutType() {
        }

        @Override
        public String getDescription() {
            return "Time-to-live exceeded(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpV6UnreachableType
    extends IcmpIpV6InnerType {
        IcmpV6UnreachableType() {
        }

        @Override
        public String getDescription() {
            StringBuffer description = new StringBuffer("Destination Unreachable");
            HashMap<Integer, String> descMap = new HashMap<Integer, String>();
            descMap.put(0, "(No route to destination)");
            descMap.put(1, "(Communication with destination administratively prohibited)");
            descMap.put(2, "(Beyond scope of source address)");
            descMap.put(3, "(Address unreachable)");
            descMap.put(4, "(Port Unreachable)");
            descMap.put(5, "(Source address failed)");
            for (Map.Entry desc : descMap.entrySet()) {
                if (IcmpProtocol4IpV6.this.getCode() != ((Integer)desc.getKey()).intValue()) continue;
                description.append((String)desc.getValue());
            }
            return description.toString();
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    class IcmpV6ToLargeGroupType
    extends IcmpIpV6InnerType {
        IcmpV6ToLargeGroupType() {
        }

        @Override
        public String getDescription() {
            return "Packet Too Big Message(" + IcmpProtocol4IpV6.this.getType() + ")";
        }

        @Override
        public Map<String, String> getHeadContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("Data", this.getDataLength() + " bytes");
            return content;
        }
    }

    abstract class IcmpIpV6InnerType {
        private int dataLength;

        IcmpIpV6InnerType() {
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength;
        }

        public abstract String getDescription();

        public abstract Map<String, String> getHeadContent();
    }
}

