/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.NetProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IpProtocol4IpV6
implements Serializable,
NetProtocol {
    private static final long serialVersionUID = 1038629789138585682L;
    private byte[] headData = new byte[0];
    private byte[] loadData = new byte[0];
    private int version;
    private int trafficClass;
    private long flowLabel;
    private int length;
    private int nextHeaderIp;
    private int hopLimit;
    private String source;
    private String destination;
    private Protocol subProtocol;
    private SubProtocolType subTypeFlag;
    private List<IpV6ExpanderHeader> expandHeaders;

    @Override
    public byte[] getHeadData() {
        if (null != this.headData) {
            return (byte[])this.headData.clone();
        }
        return new byte[0];
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(null != headData ? (byte[])headData.clone() : null);
    }

    @Override
    public byte[] getLoadData() {
        if (null != this.loadData) {
            return (byte[])this.loadData.clone();
        }
        return new byte[0];
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(null != loadData ? (byte[])loadData.clone() : null);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public long getFlowLabel() {
        return this.flowLabel;
    }

    public void setFlowLabel(long flowLabel) {
        this.flowLabel = flowLabel;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getNextHeaderIp() {
        return this.nextHeaderIp;
    }

    public void setNextHeaderIp(int nextHeader) {
        this.nextHeaderIp = nextHeader;
    }

    public int getHopLimit() {
        return this.hopLimit;
    }

    public void setHopLimit(int hopLimit) {
        this.hopLimit = hopLimit;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public List<IpV6ExpanderHeader> getExpandHeaders() {
        return this.expandHeaders;
    }

    public void setExpandHeaders(List<IpV6ExpanderHeader> expandHeaders) {
        this.expandHeaders = expandHeaders;
    }

    public void addExpandHeaders(IpV6ExpanderHeader expandHeader) {
        if (null == this.expandHeaders) {
            this.expandHeaders = new ArrayList<IpV6ExpanderHeader>();
        }
        this.expandHeaders.add(expandHeader);
    }

    @Override
    public String getDescription() {
        return "Src Addr:" + this.source + ", Dst Addr:" + this.destination;
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Version", this.version + "");
        content.put("Head Length", this.headData.length + "");
        content.put("Traffic Class", this.trafficClass + "");
        content.put("FlowLabel", this.flowLabel + "");
        content.put("Total Length", this.length + "");
        content.put("Next Header", IpV6ExpanderHeaderTool.getDescByCode(this.nextHeaderIp) + "(" + this.nextHeaderIp + ")");
        content.put("Hop Limit", this.hopLimit + "");
        content.put("Source", this.source);
        content.put("Destination", this.destination);
        if (this.expandHeaders != null) {
            for (IpV6ExpanderHeader header : this.expandHeaders) {
                content.put(IpV6ExpanderHeaderTool.getDescByCode(header.getHeader()), "");
                content.putAll(header.getContent());
            }
        }
        return content;
    }

    @Override
    public String getProtocolName() {
        return "Internet Protocol";
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subTypeFlag;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }

    public void setSubTypeFlag(SubProtocolType subTypeFlag) {
        this.subTypeFlag = subTypeFlag;
    }

    static class IpV6ExpanderHeader
    implements Serializable {
        private static final long serialVersionUID = -3747139869540130111L;
        private int nextheader;
        private int length;
        private int header;

        IpV6ExpanderHeader() {
        }

        public int getHeader() {
            return this.header;
        }

        public void setHeader(int header) {
            this.header = header;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getNextheader() {
            return this.nextheader;
        }

        public void setNextheader(int nextheader) {
            this.nextheader = nextheader;
        }

        public Map<String, String> getContent() {
            LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
            content.put("  Next Header:" + IpV6ExpanderHeaderTool.getDescByCode(this.nextheader) + "(" + this.nextheader + ")\r\n  Length:" + this.length + "" + "(" + (this.length + 1) * 8 + " bytes)", "");
            return content;
        }
    }

    static final class IpV6ExpanderHeaderTool {
        private static Map<Integer, String> resources = new HashMap<Integer, String>();

        private IpV6ExpanderHeaderTool() {
        }

        public static String getDescByCode(int code) {
            if (resources.containsKey(code)) {
                return resources.get(code);
            }
            return "unknown";
        }

        static {
            resources.put(0, "Hop-by-Hop option");
            resources.put(6, "TCP");
            resources.put(17, "UDP");
            resources.put(43, "Routing header");
            resources.put(44, "Fragment header");
            resources.put(50, "Encapsulating Security Payload header");
            resources.put(51, "Authentication header");
            resources.put(59, "");
            resources.put(58, "ICMP");
            resources.put(60, "(Destination options header");
        }
    }
}

