/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.rmi.CapturePcapService;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.CollectorSendSyslogService;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.FileTransService;
import com.hs.atic.rmi.PcapProtocolQueryService;
import com.hs.atic.rmi.ZonePacketService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import java.util.Map;

public class PacketCollectorRMIProxy
implements Serializable {
    private static final long serialVersionUID = 3859996055091097765L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private transient Map<String, Registry> map = new HashMap<String, Registry>();

    public DataStatService getDataStatService(String collectorIpStr) {
        DataStatService dataSta = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                dataSta = (DataStatService)registry.lookup("dataStatService");
            }
            catch (Exception e) {
                logger.error((Object)"Get DataStatService interface object failed !", (Throwable)e);
                dataSta = null;
            }
        }
        if (dataSta != null) {
            logger.info((Object)("Get dataSta success:" + this.getcleanedMessage(dataSta.toString())));
        }
        return dataSta;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public CapturePcapService getCapturePcapService(String collectorIpStr) {
        CapturePcapService capturePcapService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                capturePcapService = (CapturePcapService)registry.lookup("capturePcapService");
            }
            catch (Exception e) {
                logger.error((Object)"Get CapturePcapService interface object failed !", (Throwable)e);
                capturePcapService = null;
            }
        }
        return capturePcapService;
    }

    public ZonePacketService getZonePacketService(String collectorIpStr) {
        ZonePacketService zonePacketService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                zonePacketService = (ZonePacketService)registry.lookup("zonePacketService");
            }
            catch (Exception e) {
                logger.error((Object)"Get ZonePacketService interface object failed !", (Throwable)e);
                zonePacketService = null;
            }
        }
        return zonePacketService;
    }

    public PcapProtocolQueryService getPcapProtocolQueryService(String collectorIpStr) {
        PcapProtocolQueryService pcapProtocolQueryService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                pcapProtocolQueryService = (PcapProtocolQueryService)registry.lookup("pcapProtocolQueryService");
            }
            catch (Exception e) {
                logger.error((Object)"Get pcapProtocolQueryService interface object failed !", (Throwable)e);
                pcapProtocolQueryService = null;
            }
        }
        return pcapProtocolQueryService;
    }

    public CollectorSendSyslogService getCollectorSendSyslogService(String collectorIpStr) {
        CollectorSendSyslogService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (CollectorSendSyslogService)registry.lookup("collectorSendSyslogService");
            }
            catch (Exception e) {
                logger.error((Object)"Get CollectorSendSyslogService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get CollectorSendSyslogService success:" + service));
        }
        return service;
    }

    public FileTransService getFileTransService(String collectorIpStr) {
        FileTransService fileTransService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                fileTransService = (FileTransService)registry.lookup("fileTransService");
            }
            catch (Exception e) {
                logger.error((Object)"getFileTransService interface object failed !", (Throwable)e);
                fileTransService = null;
            }
        }
        return fileTransService;
    }

    private Registry getCollectorRegistry(String collectorIpStr) {
        logger.info((Object)("collectorIpStr:" + collectorIpStr));
        if (null != this.map.get(collectorIpStr)) {
            return this.map.get(collectorIpStr);
        }
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, 11099, (RMIClientSocketFactory)csf);
            this.map.put(collectorIpStr, registry);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("collectorIpStr:" + collectorIpStr + " have exist in the map"), (Throwable)e);
            return registry;
        }
        catch (Exception e) {
            logger.error((Object)"Regist failed !", (Throwable)e);
            registry = null;
        }
        return registry;
    }
}

