/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.NotifyCaptureTaskFinshedService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.sdk.bis.form.PacketFingerPrintInfoForm;
import com.hs.atic.sdk.bis.form.PacketTaskForm;
import com.hs.atic.sdk.bis.service.IPacketFileService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneFingerPrintForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotifyCaptureTaskFinshedServiceImpl
extends UnicastRemoteObject
implements NotifyCaptureTaskFinshedService {
    public static final int FINGER_MATCH_STATIC = 1;
    public static final int FINGER_CONTENT_HEX = 2;
    public static final String DNS_NO_SUCH_NAME = "DNS(No Such Name)";
    public static final String DNS_N = "DNS_N";
    private static final long serialVersionUID = -5005312674519542481L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private IPacketTaskService packetTaskService;

    public NotifyCaptureTaskFinshedServiceImpl() throws RemoteException {
    }

    public NotifyCaptureTaskFinshedServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
    }

    @Override
    public void notifyCaptureTaskFinshed(long pcapId) throws RemoteException {
        logger.info((Object)("notifyCaptureTaskFinshed get parameter,pcapId:" + pcapId));
        this.packetTaskService = (IPacketTaskService)ServiceContext.getInstance().getService("packetTaskService", IPacketTaskService.class);
        PacketTaskForm packetTaskForm = null;
        try {
            packetTaskForm = this.packetTaskService.findById(Long.valueOf(pcapId));
        }
        catch (Exception e) {
            logger.error((Object)("Query Pcap by id failed, pcapId:" + pcapId + e.toString()), (Throwable)e);
            return;
        }
        if (null == packetTaskForm) {
            logger.error((Object)"packetTaskForm is null");
            return;
        }
        try {
            packetTaskForm.setPcapTaskState(Integer.valueOf(0));
            packetTaskForm.setStopTime(Long.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L));
            this.packetTaskService.deployPacketTask(packetTaskForm, packetTaskForm.getListAclRuleForm());
        }
        catch (Exception e) {
            logger.error((Object)"notifyCaptureTaskFinshed execute failed.", (Throwable)e);
        }
    }

    @Override
    public void notifyCaptureFileFinshed(String fileName, long taskId, int attackType, int protocol, String collectorIp) {
        logger.info((Object)("enter notifyCaptureFileFinshed. fileName:" + this.getcleanedMessage(fileName) + " taskId:" + taskId + " attackType:" + attackType + " protocol:" + protocol + " collectorIp:" + collectorIp));
        if (fileName.length() > 100) {
            logger.error((Object)"notifyCaptureFileFinshed fileName too long");
            return;
        }
        this.packetTaskService = (IPacketTaskService)ServiceContext.getInstance().getService("packetTaskService", IPacketTaskService.class);
        PacketTaskForm taskForm = this.packetTaskService.findById(Long.valueOf(taskId));
        if (null == taskForm) {
            logger.error((Object)"taskForm is null");
            return;
        }
        String[] keywords = new String[]{};
        if (taskForm.getFingerKeyword() != null && !"".equals(taskForm.getFingerKeyword())) {
            keywords = taskForm.getFingerKeyword().split(",");
        }
        ArrayList<PacketFingerPrintInfoForm> availablyFingerPrintList = new ArrayList<PacketFingerPrintInfoForm>();
        if (taskForm.getFilterStatus() == 1) {
            IPacketFileService packetFileService = (IPacketFileService)ServiceContext.getInstance().getService("packetFileService", IPacketFileService.class);
            List<PacketFingerPrintInfoForm> attackFingerInfoList = packetFileService.getFingerPinrt(fileName, this.transformProtocol(this.getProtocolType(attackType, protocol)), collectorIp);
            for (PacketFingerPrintInfoForm fingerPrintForm : attackFingerInfoList) {
                int percent = fingerPrintForm.getPercent();
                String content = fingerPrintForm.getContent();
                if (percent < taskForm.getFingerHitChance() || content.length() < taskForm.getFingerLength()) continue;
                if (keywords.length > 0) {
                    boolean hasKeyWord = false;
                    for (int i = 0; i < keywords.length; ++i) {
                        if (!content.contains(keywords[i])) continue;
                        hasKeyWord = true;
                        break;
                    }
                    if (hasKeyWord) continue;
                    availablyFingerPrintList.add(fingerPrintForm);
                    continue;
                }
                availablyFingerPrintList.add(fingerPrintForm);
            }
            PacketFingerPrintInfoForm deployFingerForm = null;
            if (!availablyFingerPrintList.isEmpty()) {
                if (availablyFingerPrintList.size() > 1) {
                    Collections.sort(availablyFingerPrintList, new FingerPrintFormComparator());
                }
                deployFingerForm = (PacketFingerPrintInfoForm)availablyFingerPrintList.get(0);
            }
            if (null != deployFingerForm) {
                IZoneMgrNorthSerice service = (IZoneMgrNorthSerice)ServiceContext.getInstance().getService("zoneMgrNorthSerice", IZoneMgrNorthSerice.class);
                ZoneFingerPrintForm zoneFingerForm = new ZoneFingerPrintForm();
                zoneFingerForm.setContent(deployFingerForm.getContent());
                zoneFingerForm.setProtocol(this.transformProtocol(this.getProtocolType(attackType, protocol)));
                zoneFingerForm.setOffset(deployFingerForm.getOffset());
                zoneFingerForm.setZoneId(taskForm.getZoneId());
                zoneFingerForm.setDevId(taskForm.getPcapDeviceId());
                zoneFingerForm.setMatchType(Integer.valueOf(1));
                zoneFingerForm.setContentType(Integer.valueOf(2));
                logger.info((Object)("zoneFingerForm content:" + this.getcleanedMessage(zoneFingerForm.getContent())));
                Integer errorcode = service.addZoneFingerItem(taskForm.getZoneId(), taskForm.getPcapDeviceId(), zoneFingerForm);
                this.addOperaLog(errorcode, zoneFingerForm);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void addOperaLog(Integer errorcode, ZoneFingerPrintForm zoneFingerForm) {
        ISysOptLog sysOptLogMgr = this.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticBis");
        sysOptLogLego.setOperation("atic.bis.pcap.file.autofinger");
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        String zoneDesc = zoneService.getById(zoneFingerForm.getZoneId()).getZoneDesc();
        if (errorcode == 0) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("atic.bis.pcap.file.autofinger.deploy.success");
            String[] paraDetail = new String[]{zoneDesc, zoneFingerForm.getProtocol(), zoneFingerForm.getOffset(), zoneFingerForm.getContent()};
            sysOptLogLego.setDetailPara(paraDetail);
        } else {
            sysOptLogLego.setResult(0);
            if (630132 < errorcode && errorcode < 630137) {
                sysOptLogLego.setDetail("atic.bis.pcap.file.autofinger.deploy.fail." + errorcode);
            } else {
                sysOptLogLego.setDetail("atic.bis.pcap.file.autofinger.deploy.fail.other");
            }
            String[] paraDetail = new String[]{zoneDesc, zoneFingerForm.getProtocol(), zoneFingerForm.getOffset(), zoneFingerForm.getContent()};
            sysOptLogLego.setDetailPara(paraDetail);
        }
        sysOptLogLego.setTarget(zoneDesc);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(false));
        sysOptLogLego.setTerminalIp("127.0.0.1");
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }

    public ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            logger.error((Object)"get system/sysLogService service error");
        }
        logger.error((Object)"get system/sysLogService service error");
        return null;
    }

    private String transformProtocol(String protocol) {
        String protocolType = null;
        protocolType = DNS_NO_SUCH_NAME.equalsIgnoreCase(protocol) ? DNS_N : protocol;
        return protocolType;
    }

    public String getProtocolType(int attackType, int protocol) {
        String protocolType = "IP";
        HashMap<Integer, String> customServiceMap = new HashMap<Integer, String>();
        customServiceMap.put(1, "TCP");
        customServiceMap.put(2, "UDP");
        customServiceMap.put(3, "HTTP");
        HashMap<Integer, String> elseProtocolMap = new HashMap<Integer, String>();
        elseProtocolMap.put(10, "TCP");
        elseProtocolMap.put(11, "TCP");
        elseProtocolMap.put(12, "TCP");
        elseProtocolMap.put(13, "TCP");
        elseProtocolMap.put(14, "TCP");
        elseProtocolMap.put(15, "TCP");
        elseProtocolMap.put(16, "TCP");
        elseProtocolMap.put(17, "TCP");
        elseProtocolMap.put(18, "TCP");
        elseProtocolMap.put(19, "UDP");
        elseProtocolMap.put(20, "UDP");
        elseProtocolMap.put(21, "UDP");
        elseProtocolMap.put(22, "UDP");
        elseProtocolMap.put(23, "ICMP");
        elseProtocolMap.put(24, "IP");
        elseProtocolMap.put(25, "IP");
        elseProtocolMap.put(26, "TCP");
        elseProtocolMap.put(27, "HTTP");
        elseProtocolMap.put(29, "DNS");
        elseProtocolMap.put(30, "DNS");
        elseProtocolMap.put(31, "UDP");
        elseProtocolMap.put(32, "TCP");
        elseProtocolMap.put(33, "HTTP");
        elseProtocolMap.put(34, "TCP");
        elseProtocolMap.put(35, "TCP");
        elseProtocolMap.put(36, "UDP");
        elseProtocolMap.put(37, "UDP");
        elseProtocolMap.put(38, "ICMP");
        elseProtocolMap.put(39, "IP");
        elseProtocolMap.put(40, "TCP");
        elseProtocolMap.put(41, "HTTP");
        elseProtocolMap.put(42, "DNS");
        elseProtocolMap.put(43, "DNS");
        elseProtocolMap.put(44, "DNS");
        elseProtocolMap.put(45, "DNS");
        elseProtocolMap.put(46, "DNS");
        elseProtocolMap.put(47, "DNS");
        elseProtocolMap.put(48, "DNS");
        elseProtocolMap.put(49, "DNS");
        elseProtocolMap.put(50, "DNS");
        elseProtocolMap.put(51, "DNS");
        elseProtocolMap.put(52, "IP");
        elseProtocolMap.put(53, "TCP");
        elseProtocolMap.put(54, "TCP");
        elseProtocolMap.put(55, "UDP");
        elseProtocolMap.put(56, DNS_NO_SUCH_NAME);
        elseProtocolMap.put(57, "IP");
        elseProtocolMap.put(58, "IP");
        elseProtocolMap.put(59, "HTTP");
        elseProtocolMap.put(60, "IP");
        elseProtocolMap.put(61, "IP");
        elseProtocolMap.put(62, "HTTP");
        elseProtocolMap.put(63, "IP");
        elseProtocolMap.put(64, "UDP");
        try {
            if (attackType < 10) {
                for (Map.Entry customMap : customServiceMap.entrySet()) {
                    if (protocol != (Integer)customMap.getKey()) continue;
                    protocolType = (String)customMap.getValue();
                }
            } else {
                for (Map.Entry protocolMap : elseProtocolMap.entrySet()) {
                    if (attackType != (Integer)protocolMap.getKey()) continue;
                    protocolType = (String)protocolMap.getValue();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getProtocolType error !", (Throwable)e);
        }
        return protocolType;
    }

    static class FingerPrintFormComparator
    implements Comparator<PacketFingerPrintInfoForm>,
    Serializable {
        private static final long serialVersionUID = 8046742691828250494L;

        FingerPrintFormComparator() {
        }

        @Override
        public int compare(PacketFingerPrintInfoForm one, PacketFingerPrintInfoForm two) {
            if (one.getPercent() < two.getPercent()) {
                return -1;
            }
            if (one.getPercent() == two.getPercent()) {
                return 0;
            }
            return 1;
        }
    }
}

