/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.alarm.entity.PacketAlarmEntityBuffer;
import com.hs.atic.bis.service.IPacketCollectorRmiProxyService;
import com.hs.atic.collector.entity.alarm.CleanPcapAlarmEntity;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.PacketNotifyAlarmService;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class PacketNotifyAlarmServiceImpl
extends UnicastRemoteObject
implements PacketNotifyAlarmService {
    private static final long serialVersionUID = 7311956924104990848L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    transient PacketAlarmEntityBuffer packetAlarmEntityBuffer;

    protected PacketNotifyAlarmServiceImpl() throws RemoteException {
    }

    public PacketNotifyAlarmServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        IPacketCollectorRmiProxyService proxyService = (IPacketCollectorRmiProxyService)ServiceContext.getInstance().getService("packetCollectorRmiProxyServiceImpl", IPacketCollectorRmiProxyService.class);
        this.packetAlarmEntityBuffer = proxyService.getPacketAlarmEntityBuffer();
    }

    public PacketAlarmEntityBuffer getPacketAlarmEntityBuffer() {
        return this.packetAlarmEntityBuffer;
    }

    public void setPacketAlarmEntityBuffer(PacketAlarmEntityBuffer packetAlarmEntityBuffer) {
        this.packetAlarmEntityBuffer = packetAlarmEntityBuffer;
    }

    @Override
    public void notifyPcapFileCleaned(List<CleanPcapAlarmEntity> entities) throws RemoteException {
        if (null == entities || entities.isEmpty()) {
            logger.info((Object)"notifyPcapFileCleaned entities is null");
            return;
        }
        logger.info((Object)("notifyPcapFileCleaned data size : " + entities.size()));
        if (entities.size() > 10000) {
            logger.info((Object)"notifyPcapFileCleaned data size to long");
            return;
        }
        try {
            this.packetAlarmEntityBuffer.addCleanPcapList(entities);
        }
        catch (Exception e) {
            logger.error((Object)"notifyPcapFileCleaned error ", (Throwable)e);
        }
    }
}

