/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.portal.rmi.impl;

import com.hs.atic.analysis.report.flux.flowcompare.FlowCompareComparator;
import com.hs.atic.collector.entity.log.AttackExactLog;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DataStatService;
import com.hs.atic.rmi.ReportCollectorRMIProxy;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.sdk.analysis.form.AttackTrendForm;
import com.hs.atic.sdk.analysis.form.BaseConditionForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareConditionForm;
import com.hs.atic.sdk.analysis.form.FlowCompareForm;
import com.hs.atic.sdk.analysis.form.IpTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.bis.form.AttackDataForm;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.service.IAttackDataService;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.system.form.BasicInfoForm;
import com.hs.atic.sdk.util.BasicInfoUtil;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.IpLocationUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ManualDefendForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneFeatureStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IAttackTypeInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneFeatureStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import com.huawei.atic.util.CommonUtil;
import com.huawei.portal.model.AttackExactReportDataLog;
import com.huawei.portal.model.CurrentAttackDataLog;
import com.huawei.portal.model.DataBaseInfo;
import com.huawei.portal.model.DataCollection;
import com.huawei.portal.model.DataStatConditionQueryBean;
import com.huawei.portal.model.DeviceBean;
import com.huawei.portal.model.PortalReturnData;
import com.huawei.portal.model.SortByValue;
import com.huawei.portal.model.SortClass;
import com.huawei.portal.model.TopNcomparator;
import com.huawei.portal.rmi.AticPortalRmi;
import com.huawei.portal.service.ICollectorRmiProxyService;
import com.huawei.portal.util.AticPortalUtil;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AticPortalRmiImpl
extends UnicastRemoteObject
implements AticPortalRmi {
    public static final int ALL_CLEAN_DEVICE = -1;
    public static final int ALL_DETECT_DEVICE = -2;
    public static final int DEVICE_CLEAN = 0;
    public static final int DEVICE_DETECT = 1;
    public static final Long BIS_ALL = 0L;
    public static final String BIZ_TYPE_ALL = "-1";
    public static final int COLLECTOR_STATUS_OFFLINE = 2;
    public static final int DEFEND_GROUP_DETECT_MODE_REDUNDANCY = 0;
    public static final int DEVICE_SERVICE_TYPE_CLEAN = 0;
    public static final int DEVICE_SERVICE_TYPE_CLEAN_ADD_DETECT = 2;
    public static final int DEVICE_SERVICE_TYPE_DETECT = 1;
    public static final int PROTOCOL_ALL = 0;
    public static final int UNITTYPE_BPS = 0;
    public static final int UNITTYPE_PPS = 1;
    public static final Integer ONE_DAY_BY_SECOND = 86400;
    public static final Integer SEVEN_DAY_BY_SECOND = 604800;
    public static final Integer ATTACK_STATUS_UN_DEFEND = 0;
    public static final Integer ATTACK_STATUS_NOT_DEFEND = -1;
    public static final Integer ATTACK_STATUS_DEFEND = 2;
    public static final int FLUX_MAX = 1;
    public static final int FLUX_AVG = 2;
    public static final int FLUX_ATTACK_AVG = 3;
    public static final int REPORT_IP_FLUX_PPS = 1;
    public static final int REPORT_IP_FLUX_KBPS = 0;
    private static final int DEFEND_GROUP_DETECT_MODE_BALANCED = 1;
    private static final int FILTER_ATTACK_TYPE_INIT = 2000;
    private static final int NP_FILTER_ATTACK_TYPE_INIT = 80000;
    private static final Long SPAN_TIME_300 = 300L;
    private static final Long SPAN_TIME_3600 = 3600L;
    private static final Long SPAN_TIME_24_3600 = 86400L;
    private static final long serialVersionUID = -2614441325546785653L;
    private static transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PORTAL);
    private Map<String, List<String>> collectorDeviceMap = new HashMap<String, List<String>>();
    private List<AticDevice> flowFirewallList;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private IDataStatService dataStatService;
    private IDefendGroupService defendGroupService;
    private IAticDeviceService aticDeviceService;
    private IAttackTypeInfoService attackTypeInfoService;
    private IZoneDeviceService zoneDeviceService;
    private IAttackDataService attackDataService;
    private IZoneFeatureStatusService zoneFeatureStatusService;
    private ICommonUtilService commonUtilService;
    private IZoneServiceService zoneServiceService;
    private IZoneMgrNorthSerice zoneMgrNorthSerice;
    private IFilterService filterService;
    private IDivertTacticsService divertTacticsService;
    private ReportCollectorRMIProxy reportCollectorRMIProxy;

    public AticPortalRmiImpl() throws RemoteException {
    }

    public AticPortalRmiImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        ICollectorRmiProxyService proxyService = (ICollectorRmiProxyService)ServiceContext.getInstance().getService("collectorRmiProxyService", ICollectorRmiProxyService.class);
        this.reportCollectorRMIProxy = proxyService.getReportCollectorRMIProxy();
        this.divertTacticsService = proxyService.getDivertTacticsService();
        this.filterService = proxyService.getFilterService();
        this.zoneMgrNorthSerice = proxyService.getZoneMgrNorthSerice();
        this.zoneServiceService = proxyService.getZoneServiceService();
        this.commonUtilService = proxyService.getCommonUtilService();
        this.zoneFeatureStatusService = proxyService.getZoneFeatureStatusService();
        this.attackDataService = proxyService.getAttackDataService();
        this.zoneDeviceService = proxyService.getZoneDeviceService();
        this.attackTypeInfoService = proxyService.getAttackTypeInfoService();
        this.aticDeviceService = proxyService.getAticDeviceService();
        this.defendGroupService = proxyService.getDefendGroupService();
        this.dataStatService = proxyService.getDataStatService();
        this.collectorService = proxyService.getCollectorService();
        this.collectorDeviceService = proxyService.getCollectorDeviceService();
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public ReportCollectorRMIProxy getReportCollectorRMIProxy() {
        return this.reportCollectorRMIProxy;
    }

    public void setReportCollectorRMIProxy(ReportCollectorRMIProxy reportCollectorRMIProxy) {
        this.reportCollectorRMIProxy = reportCollectorRMIProxy;
    }

    public IAttackDataService getAttackDataService() {
        return this.attackDataService;
    }

    public void setAttackDataService(IAttackDataService attackDataService) {
        this.attackDataService = attackDataService;
    }

    public IZoneFeatureStatusService getZoneFeatureStatusService() {
        return this.zoneFeatureStatusService;
    }

    public void setZoneFeatureStatusService(IZoneFeatureStatusService zoneFeatureStatusService) {
        this.zoneFeatureStatusService = zoneFeatureStatusService;
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }

    public IZoneServiceService getZoneServiceService() {
        return this.zoneServiceService;
    }

    public void setZoneServiceService(IZoneServiceService zoneServiceService) {
        this.zoneServiceService = zoneServiceService;
    }

    public IZoneMgrNorthSerice getZoneMgrNorthSerice() {
        return this.zoneMgrNorthSerice;
    }

    public void setZoneMgrNorthSerice(IZoneMgrNorthSerice zoneMgrNorthSerice) {
        this.zoneMgrNorthSerice = zoneMgrNorthSerice;
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }

    @Override
    public int getUnit(Long zoneId) throws RemoteException {
        List deivceList = this.aticDeviceService.getDeviceByZoneId(zoneId.longValue());
        boolean incluesV1R1 = CommonUtil.includesV1R1((List)deivceList);
        return incluesV1R1 ? 1 : 0;
    }

    @Override
    public Map<String, List<PortalReturnData>> getFlowCompareData(DataStatConditionQueryBean queryBean) throws RemoteException {
        ArrayList<FlowCompareForm> cleanResult = new ArrayList();
        List<Object> detectResult = new ArrayList();
        if (null == queryBean.getDeviceIp()) {
            queryBean.setDeviceIp(BIZ_TYPE_ALL);
            queryBean.setDevSerType(0);
            FlowCompareConditionForm cleanCondition = this.prepareFlowData(queryBean);
            cleanResult = this.fetchFlowData(cleanCondition);
            queryBean.setDeviceIp("-2");
            queryBean.setDevSerType(1);
            FlowCompareConditionForm detectCondition = this.prepareFlowData(queryBean);
            detectResult = this.fetchFlowData(detectCondition);
        } else {
            FlowCompareConditionForm condition = this.prepareFlowData(queryBean);
            if (1 == queryBean.getDevSerType()) {
                detectResult = this.fetchFlowData(condition);
            } else {
                cleanResult = this.fetchFlowData(condition);
            }
        }
        Map<String, List<PortalReturnData>> result = this.handleFlowData(cleanResult, detectResult);
        this.sortData(result);
        return result;
    }

    @Override
    public Map<String, List<PortalReturnData>> getAttackTrendData(DataStatConditionQueryBean queryBean) throws RemoteException {
        if (null == queryBean.getDeviceIp()) {
            queryBean.setDeviceIp(BIZ_TYPE_ALL);
            queryBean.setDevSerType(0);
        }
        DataStatConditionForm cleanCondition = this.prepareAttackData(queryBean);
        List<AttackTrendForm> cleanResult = this.fetchAttackData(cleanCondition);
        Map<String, List<PortalReturnData>> result = this.handleAttackData(cleanResult, queryBean.getDataType());
        this.sortData(result);
        return result;
    }

    protected void sortData(Map<String, List<PortalReturnData>> result) {
        SortClass sort = new SortClass();
        for (Map.Entry<String, List<PortalReturnData>> entry : result.entrySet()) {
            Collections.sort(entry.getValue(), sort);
        }
    }

    protected List<PortalReturnData> sortDataByValue(Map<String, PortalReturnData> result) {
        ArrayList<PortalReturnData> allData = new ArrayList<PortalReturnData>();
        for (Map.Entry<String, PortalReturnData> entry : result.entrySet()) {
            allData.add(entry.getValue());
        }
        SortByValue sort = new SortByValue();
        Collections.sort(allData, sort);
        return allData;
    }

    private List<String> everyRedunDefendGroupIpList(DefendGroupForm form, List<AticDevice> deviceList) {
        ArrayList<String> ipList = new ArrayList<String>();
        if (null == form) {
            return ipList;
        }
        for (Long firewallId : form.getFirewallIds()) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(firewallId.longValue());
            Iterator<AticDevice> iter = deviceList.iterator();
            while (iter.hasNext()) {
                AticDevice fireallLoop = iter.next();
                if (fireallLoop.getMoId() != device.getMoId()) continue;
                String devIp = AticUtil.formatIpAddress((String)device.getIpAddress());
                ipList.add(devIp);
                iter.remove();
            }
        }
        return ipList;
    }

    private List<FlowCompareForm> fetchFlowData(FlowCompareConditionForm flowCompareConditionForm) {
        ArrayList<FlowCompareForm> allList = new ArrayList();
        try {
            allList = this.queryFlowCompare(flowCompareConditionForm);
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)legoException);
        }
        catch (Exception e) {
            logger.error((Object)"fetchFlowData error", (Throwable)e);
        }
        return allList;
    }

    protected void fillContinuousTime(List<FlowCompareForm> flowCompareFormList, int first, int next, int timeSpan) {
        if (next < flowCompareFormList.size()) {
            FlowCompareForm firstForm = flowCompareFormList.get(first);
            FlowCompareForm nextForm = flowCompareFormList.get(next);
            long timeGap = nextForm.getLogTime() - firstForm.getLogTime();
            if (timeGap > (long)timeSpan) {
                ArrayList<FlowCompareForm> flowCompareFormListGap = new ArrayList<FlowCompareForm>();
                int i = 1;
                while ((long)i < timeGap / (long)timeSpan) {
                    FlowCompareForm flowCompareFormGap = new FlowCompareForm();
                    flowCompareFormGap.setLogTime(firstForm.getLogTime() + (long)timeSpan);
                    flowCompareFormGap.setInFlow(Long.valueOf(0L));
                    flowCompareFormGap.setOutFlow(Long.valueOf(0L));
                    flowCompareFormGap.setAttackFlow(Long.valueOf(0L));
                    flowCompareFormGap.setMaxInFlow(Long.valueOf(0L));
                    flowCompareFormGap.setMaxAttackFlow(Long.valueOf(0L));
                    flowCompareFormGap.setReplyAttackFlow(Long.valueOf(0L));
                    flowCompareFormGap.setReplyInFlow(Long.valueOf(0L));
                    flowCompareFormGap.setReplyMaxAttackFlow(Long.valueOf(0L));
                    flowCompareFormGap.setReplyMaxInFlow(Long.valueOf(0L));
                    flowCompareFormGap.setReplyOutFlow(Long.valueOf(0L));
                    firstForm = flowCompareFormGap;
                    flowCompareFormListGap.add(flowCompareFormGap);
                    ++i;
                }
                flowCompareFormList.addAll(next, flowCompareFormListGap);
                int nextIndex = ++first + flowCompareFormListGap.size();
                this.fillContinuousTime(flowCompareFormList, nextIndex, nextIndex + 1, timeSpan);
            } else {
                this.fillContinuousTime(flowCompareFormList, ++first, ++next, timeSpan);
            }
        }
    }

    private Map<String, List<String>> generateCollectorDeviceMap(long deviceId, List<AticDevice> firewallList, Map<String, List<String>> collectorDeviceMaps) {
        for (AticDevice firewall : firewallList) {
            List<String> deviceIpList;
            if (deviceId != -1L && deviceId != -2L && null == firewall) {
                throw new LegoCheckedException(570502L);
            }
            CollectorInfo collectorInfo = null;
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
            if (null == collectorId || null == (collectorInfo = this.collectorService.getCollectorInfo(collectorId.longValue()))) {
                logger.info((Object)"collector is not exist ");
                continue;
            }
            if (2 == collectorInfo.getStatus()) {
                logger.info((Object)("collector is offline " + collectorId));
            }
            if (null == (deviceIpList = collectorDeviceMaps.get(collectorInfo.getIpAddress()))) {
                deviceIpList = new ArrayList<String>();
                collectorDeviceMaps.put(collectorInfo.getIpAddress(), deviceIpList);
            }
            if (deviceIpList.contains(firewall.getIpAddress())) continue;
            deviceIpList.add(firewall.getIpAddress());
        }
        return collectorDeviceMaps;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public IDataStatService getDataStatService() {
        return this.dataStatService;
    }

    public IDefendGroupService getDefendGroupService() {
        return this.defendGroupService;
    }

    public IAttackTypeInfoService getAttackTypeInfoService() {
        return this.attackTypeInfoService;
    }

    public void setAttackTypeInfoService(IAttackTypeInfoService attackTypeInfoService) {
        this.attackTypeInfoService = attackTypeInfoService;
    }

    private List<AticDevice> getFireWallOfCleanOrDetect(DataStatConditionForm datastatConditionForm) {
        ArrayList<AticDevice> firewallList = new ArrayList<AticDevice>();
        if (datastatConditionForm.getDeviceId() == -1L) {
            List firewallListTemp = null;
            firewallListTemp = this.aticDeviceService.getCleanDevice();
            if (null != firewallListTemp) {
                firewallList.addAll(firewallListTemp);
            }
        } else {
            List firewallListTemp = this.aticDeviceService.getDetectDevice();
            if (null != firewallListTemp) {
                firewallList.addAll(firewallListTemp);
            }
        }
        return firewallList;
    }

    private List<List<String>> getRedunFirewallIpList(List<AticDevice> firewallList) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        List defendGroupList = this.defendGroupService.getAll();
        for (DefendGroupForm form : defendGroupList) {
            if (form.getDetectMode() != 0) continue;
            List<Object> ipList = new ArrayList();
            if (null != firewallList) {
                ipList = this.everyRedunDefendGroupIpList(form, firewallList);
            }
            if (ipList.isEmpty()) continue;
            result.add(ipList);
        }
        return result;
    }

    private Map<String, List<PortalReturnData>> handleFlowData(List<FlowCompareForm> cleanResult, List<FlowCompareForm> detectResult) {
        HashMap<String, List<PortalReturnData>> resultMap = new HashMap<String, List<PortalReturnData>>();
        ArrayList<PortalReturnData> inCleanData = new ArrayList<PortalReturnData>();
        ArrayList<PortalReturnData> outCleanData = new ArrayList<PortalReturnData>();
        if (null != cleanResult && !cleanResult.isEmpty()) {
            for (FlowCompareForm eachClean : cleanResult) {
                PortalReturnData inEachBean = new PortalReturnData();
                inEachBean.setTime(eachClean.getLogTime());
                inEachBean.setValue(eachClean.getInFlow());
                inEachBean.setMaxValue(eachClean.getMaxInFlow());
                inCleanData.add(inEachBean);
                PortalReturnData outEachBean = new PortalReturnData();
                outEachBean.setTime(eachClean.getLogTime());
                outEachBean.setValue(eachClean.getOutFlow());
                outEachBean.setMaxValue(eachClean.getMaxOutFlow());
                outCleanData.add(outEachBean);
            }
        }
        resultMap.put("INFLOW", inCleanData);
        resultMap.put("OUTFLOW", outCleanData);
        ArrayList<PortalReturnData> detectData = new ArrayList<PortalReturnData>();
        if (null != detectResult && !detectResult.isEmpty()) {
            for (FlowCompareForm eachClean : detectResult) {
                PortalReturnData detectEachBean = new PortalReturnData();
                detectEachBean.setTime(eachClean.getLogTime());
                detectEachBean.setValue(eachClean.getInFlow());
                detectEachBean.setMaxValue(eachClean.getMaxInFlow());
                detectData.add(detectEachBean);
            }
        }
        resultMap.put("DETECTFLOW", detectData);
        return resultMap;
    }

    private FlowCompareConditionForm prepareFlowData(DataStatConditionQueryBean queryBean) {
        FlowCompareConditionForm flowCompareConditionForm = new FlowCompareConditionForm();
        this.processDeviceParam(queryBean, flowCompareConditionForm);
        if (null != queryBean.getZoneId()) {
            flowCompareConditionForm.setZoneId(queryBean.getZoneId());
        }
        flowCompareConditionForm.setZoneIp(AticUtil.isNull((String)queryBean.getZoneIp()) || "0".equals(queryBean.getZoneIp()) ? null : queryBean.getZoneIp());
        flowCompareConditionForm.setDirection(queryBean.getDirection());
        if (null != queryBean.getStartRow()) {
            flowCompareConditionForm.setStart((long)queryBean.getStartRow().intValue());
        }
        if (null != queryBean.getLimit()) {
            flowCompareConditionForm.setPageSize((long)queryBean.getLimit().intValue());
        }
        flowCompareConditionForm.setIsServiceGroup(Boolean.valueOf(false));
        flowCompareConditionForm.setBizType(Integer.valueOf(BIZ_TYPE_ALL));
        flowCompareConditionForm.setBizId(BIS_ALL);
        this.processFlowTimeParams(queryBean.getStartTime(), queryBean.getEndTime(), flowCompareConditionForm);
        if (null != queryBean.getProtocol()) {
            flowCompareConditionForm.setProtocol(queryBean.getProtocol());
        } else {
            flowCompareConditionForm.setProtocol(Integer.valueOf(0));
        }
        Integer unitTypeBPS = 0;
        flowCompareConditionForm.setUnit(queryBean.getDataType() == null ? unitTypeBPS : queryBean.getDataType());
        return flowCompareConditionForm;
    }

    private void processFlowTimeParams(long startTime, long endTime, FlowCompareConditionForm flowCompareConditionForm) {
        endTime = AticPortalUtil.compareSystemCurrentTime(endTime);
        flowCompareConditionForm.setEndTime(Long.valueOf(endTime));
        Long endTimes = endTime;
        Long startTimeTemp = AticPortalUtil.compareSystemCurrentTime(startTime);
        startTimeTemp = startTimeTemp > endTime ? endTimes : startTimeTemp;
        startTime = AticPortalUtil.getRealStartTime(startTimeTemp, endTime);
        flowCompareConditionForm.setStartTime(Long.valueOf(startTime));
        flowCompareConditionForm.setTimeSpanType(AticPortalUtil.getTimeSpanType(endTime, startTime));
    }

    private void processAttackTimeParams(long startTime, long endTime, DataStatConditionForm dataStatConditionForm) {
        Long endTim = AticPortalUtil.compareSystemCurrentTime(endTime);
        Long startTimeTemp = AticPortalUtil.compareSystemCurrentTime(startTime);
        startTimeTemp = startTimeTemp > endTim ? endTim : startTimeTemp;
        startTime = AticPortalUtil.getRealStartTime(startTimeTemp, endTim);
        dataStatConditionForm.setStartTime(Long.valueOf(startTime));
        dataStatConditionForm.setEndTime(endTim);
    }

    private List<FlowCompareForm> processAdd(List<FlowCompareForm> flowCompareList) {
        Collections.sort(flowCompareList, FlowCompareComparator.getComparatorByFieldName((String)"logTime", (String)"asc"));
        ListIterator<FlowCompareForm> iter = flowCompareList.listIterator();
        block0: while (iter.hasNext()) {
            FlowCompareForm first = iter.next();
            while (iter.hasNext()) {
                FlowCompareForm next = iter.next();
                if (next.getLogTime() == first.getLogTime()) {
                    first.setAttackFlow(Long.valueOf(first.getAttackFlow() + next.getAttackFlow()));
                    first.setInFlow(Long.valueOf(first.getInFlow() + next.getInFlow()));
                    first.setMaxAttackFlow(Long.valueOf(first.getMaxAttackFlow() + next.getMaxAttackFlow()));
                    first.setMaxInFlow(Long.valueOf(first.getMaxInFlow() + next.getMaxInFlow()));
                    first.setOutFlow(Long.valueOf(first.getOutFlow() + next.getOutFlow()));
                    if (null != first.getReplyAttackFlow()) {
                        first.setReplyAttackFlow(Long.valueOf(first.getReplyAttackFlow() + next.getReplyAttackFlow()));
                        first.setReplyInFlow(Long.valueOf(first.getReplyInFlow() + next.getReplyInFlow()));
                        first.setReplyMaxAttackFlow(Long.valueOf(first.getReplyMaxAttackFlow() + next.getReplyMaxAttackFlow()));
                        first.setReplyMaxInFlow(Long.valueOf(first.getReplyMaxInFlow() + next.getReplyMaxInFlow()));
                        first.setReplyOutFlow(Long.valueOf(first.getReplyOutFlow() + next.getReplyOutFlow()));
                    }
                    iter.remove();
                    continue;
                }
                iter = flowCompareList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return flowCompareList;
    }

    private void processDeviceParam(DataStatConditionQueryBean queryBean, FlowCompareConditionForm flowCompareConditionForm) {
        String devIp = queryBean.getDeviceIp();
        int devType = queryBean.getDevSerType();
        long deviceId = -1L;
        deviceId = devIp.equals(BIZ_TYPE_ALL) ? -1L : (devIp.equals("-2") ? -2L : this.aticDeviceService.getMoidByIP(devIp));
        this.flowFirewallList = this.processDeviceParams(deviceId, devType, (BaseConditionForm)flowCompareConditionForm);
        this.collectorDeviceMap.clear();
        this.generateCollectorDeviceMap(deviceId, this.flowFirewallList, this.collectorDeviceMap);
    }

    private List<AticDevice> processDeviceParams(long deviceId, int devType, BaseConditionForm conditionForm) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        datastatConditionForm.setDeviceId(Long.valueOf(deviceId));
        List<AticDevice> firewallList = null;
        if (deviceId == -1L) {
            conditionForm.setDeviceType(Integer.valueOf(0));
            firewallList = this.getFireWallOfCleanOrDetect(datastatConditionForm);
        } else if (deviceId == -2L) {
            conditionForm.setDeviceType(Integer.valueOf(1));
            firewallList = this.getFireWallOfCleanOrDetect(datastatConditionForm);
        } else {
            firewallList = new ArrayList<AticDevice>();
            AticDevice firewall = this.aticDeviceService.getDeviceByMoid(deviceId);
            firewallList.add(firewall);
            conditionForm.setDeviceType(Integer.valueOf(devType));
        }
        return firewallList;
    }

    private List<FlowCompareForm> processResult(List<FlowCompareForm> allList, int timeType) {
        List<FlowCompareForm> result = this.processAdd(allList);
        this.fillContinuousTime(result, 0, 1, AticPortalUtil.getGapTime(timeType));
        return result;
    }

    private List<FlowCompareForm> queryFlowCompare(FlowCompareConditionForm flowCompareConditionForm) {
        List flowCompareList = null;
        ArrayList<FlowCompareForm> allList = new ArrayList<FlowCompareForm>();
        for (Map.Entry<String, List<String>> entry : this.collectorDeviceMap.entrySet()) {
            flowCompareConditionForm.setDeviceIpList(entry.getValue());
            try {
                flowCompareList = this.dataStatService.queryFlowCompare(flowCompareConditionForm, entry.getKey());
                allList.addAll(flowCompareList);
            }
            catch (Exception e) {
                logger.error((Object)"queryFlowCompare error", (Throwable)e);
            }
        }
        this.getRedunFirewallIpList(this.flowFirewallList);
        return this.processResult(allList, flowCompareConditionForm.getTimeSpanType());
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public void setDataStatService(IDataStatService dataStatService) {
        this.dataStatService = dataStatService;
    }

    public void setDefendGroupService(IDefendGroupService defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    private Map<String, List<PortalReturnData>> handleAttackData(List<AttackTrendForm> cleanResult, Integer dataType) {
        HashMap<String, List<PortalReturnData>> resultMap = new HashMap<String, List<PortalReturnData>>();
        for (AttackTrendForm each : cleanResult) {
            String key = each.getAttackTypeName();
            PortalReturnData data = new PortalReturnData();
            data.setTime(each.getDateTime());
            if (1 == dataType) {
                data.setValue(each.getAttackTypePackagePps());
            } else {
                data.setValue(each.getAttackTypePackageKbps());
            }
            if (resultMap.containsKey(key)) {
                ((List)resultMap.get(key)).add(data);
                continue;
            }
            ArrayList<PortalReturnData> dataList = new ArrayList<PortalReturnData>();
            dataList.add(data);
            resultMap.put(key, dataList);
        }
        return resultMap;
    }

    private List<AttackTrendForm> fetchAttackData(DataStatConditionForm datastatConditionForm) {
        List<AttackTrendForm> attackTrendFormList = null;
        Map<String, List<AttackTrendForm>> allCollectorAttackTypeForm = null;
        if (datastatConditionForm.getDeviceId() > 0L) {
            allCollectorAttackTypeForm = this.getSingleDeviceData(datastatConditionForm);
        } else {
            List<AticDevice> allCleanDevList = this.getFireWallOfCleanOrDetect(datastatConditionForm);
            Map<Long, List<AticDevice>> collectDevMap = null;
            collectDevMap = this.getCollectDevMap(allCleanDevList);
            allCollectorAttackTypeForm = this.getAllAttackTrendData(collectDevMap, datastatConditionForm);
        }
        IFilterService filterServices = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        INpFilterService npfilterService = (INpFilterService)ServiceContext.getInstance().getService("npFilterService", INpFilterService.class);
        for (List<AttackTrendForm> forms : allCollectorAttackTypeForm.values()) {
            for (AttackTrendForm form : forms) {
                String attackTypeName;
                if (form.getAttackType() == 2000L) {
                    attackTypeName = AticUtil.getText((String)"atic.attack.type.62");
                    form.setAttackTypeName(attackTypeName);
                    continue;
                }
                if (form.getAttackType() >= 2000L && form.getAttackType() < 80000L) {
                    if (null != filterServices) {
                        FilterForm filterForm = filterServices.queryFilterName(Long.valueOf(form.getAttackType() - 2000L));
                        if (null != filterForm && null != filterForm.getFilterName()) {
                            form.setAttackTypeName(filterForm.getFilterName());
                            continue;
                        }
                        form.setAttackTypeName("unknownFilter" + (form.getAttackType() - 2000L));
                        continue;
                    }
                    logger.error((Object)("get filter service failed. filter attack type : " + form.getAttackType()));
                    continue;
                }
                if (form.getAttackType() < 80000L) continue;
                if (form.getAttackType() == 80000L) {
                    attackTypeName = AticUtil.getText((String)"atic.attack.type.80000");
                    form.setAttackTypeName(attackTypeName);
                    continue;
                }
                if (null != npfilterService) {
                    NPFilterForm npfilterTemp = npfilterService.queryNPFilterFormByfilterId(form.getAttackType() - 80000L);
                    if (null != npfilterTemp && null != npfilterTemp.getFilterName()) {
                        form.setAttackTypeName(npfilterTemp.getFilterName());
                        continue;
                    }
                    form.setAttackTypeName(AticUtil.getText((String)"atic.attack.type.80000"));
                    continue;
                }
                logger.error((Object)("get np filter service failed. filter attack type : " + form.getAttackType()));
            }
        }
        ArrayList<AttackTrendForm> allForm = new ArrayList<AttackTrendForm>();
        for (Map.Entry<String, List<AttackTrendForm>> entry : allCollectorAttackTypeForm.entrySet()) {
            allForm.addAll((Collection<AttackTrendForm>)entry.getValue());
        }
        attackTrendFormList = this.getTopNForm(allForm);
        attackTrendFormList = this.getAllTimeData(attackTrendFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
        return attackTrendFormList;
    }

    private Map<String, List<AttackTrendForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        AticDevice firewall = this.aticDeviceService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            throw new LegoCheckedException(570504L);
        }
        HashMap<String, List<AttackTrendForm>> allCollectorAttackTypeForm = new HashMap();
        try {
            allCollectorAttackTypeForm = this.dataStatService.getAttackTrend(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            logger.error((Object)"getSingleDeviceData error", (Throwable)e);
        }
        return allCollectorAttackTypeForm;
    }

    private DataStatConditionForm prepareAttackData(DataStatConditionQueryBean queryBean) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            String devIp = queryBean.getDeviceIp();
            int devType = queryBean.getDevSerType();
            long deviceId = -1L;
            deviceId = devIp.equals(BIZ_TYPE_ALL) ? -1L : (devIp.equals(BIZ_TYPE_ALL) ? -1L : this.aticDeviceService.getMoidByIP(devIp));
            datastatConditionForm.setDeviceId(Long.valueOf(deviceId));
            datastatConditionForm.setDevSerType(Integer.valueOf(devType));
            datastatConditionForm.setZoneId(queryBean.getZoneId());
            datastatConditionForm.setIsServiceGroup(Boolean.valueOf(false));
            datastatConditionForm.setBisId(BIS_ALL);
            datastatConditionForm.setZoneIp(queryBean.getZoneIp());
            datastatConditionForm.setDirection(queryBean.getDirection());
            long startTime = queryBean.getStartTime();
            long endTime = queryBean.getEndTime();
            this.processAttackTimeParams(startTime, endTime, datastatConditionForm);
            ArrayList<String> attackTypeKey = new ArrayList<String>();
            ArrayList attackTypeValue = new ArrayList();
            Map attackTypeMap = this.attackTypeInfoService.getAllAttackType();
            for (Map.Entry each : attackTypeMap.entrySet()) {
                attackTypeKey.add(each.getKey() + "");
                attackTypeValue.add(each.getValue());
            }
            datastatConditionForm.setAttackTypeKey(attackTypeKey);
            datastatConditionForm.setAttackTypeValue(attackTypeValue);
        }
        catch (Exception e) {
            logger.error((Object)"prepareAttackData error", (Throwable)e);
        }
        return datastatConditionForm;
    }

    private List<AttackTrendForm> getTopNForm(List<AttackTrendForm> allForm) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime()) || !allForm.get(i).getAttackTypeName().equals(allForm.get(j).getAttackTypeName())) continue;
                this.dealWithSame(allForm, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<AttackTrendForm> allForm, int i, int j) {
        allForm.get(i).setAttackTypePackagePps(Long.valueOf(allForm.get(i).getAttackTypePackagePps() + allForm.get(j).getAttackTypePackagePps()));
        allForm.remove(j);
    }

    private Map<String, List<AttackTrendForm>> getAllAttackTrendData(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<AttackTrendForm>> allCollectorRequestTrendForm = new HashMap<String, List<AttackTrendForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = this.collectorService.getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            Map tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getAttackTrend(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                logger.error((Object)"getAllAttackTrendData error", (Throwable)e);
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private Map<Long, List<AticDevice>> getCollectDevMap(List<AticDevice> firewallList) {
        HashMap<Long, List<AticDevice>> returnMap = new HashMap<Long, List<AticDevice>>();
        for (AticDevice firewall : firewallList) {
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
            if (null == collectorId || null == this.collectorService.getCollectorInfo(collectorId.longValue())) continue;
            if (2 == this.collectorService.getCollectorInfo(collectorId.longValue()).getStatus()) {
                throw new LegoCheckedException(570504L);
            }
            if (null != returnMap.get(collectorId)) {
                ((List)returnMap.get(collectorId)).add(firewall);
                continue;
            }
            ArrayList<AticDevice> tmpList = new ArrayList<AticDevice>();
            tmpList.add(firewall);
            returnMap.put(collectorId, tmpList);
        }
        return returnMap;
    }

    public static Long getTimeSpanType(long endTime, long startTime) {
        Long spanTime = endTime - startTime;
        if (spanTime < (long)ONE_DAY_BY_SECOND.intValue()) {
            return SPAN_TIME_300;
        }
        if (spanTime < (long)SEVEN_DAY_BY_SECOND.intValue() && spanTime >= (long)ONE_DAY_BY_SECOND.intValue()) {
            return SPAN_TIME_3600;
        }
        return SPAN_TIME_24_3600;
    }

    private List<AttackTrendForm> getAllTimeData(List<AttackTrendForm> attackTrendFormList, long startTime, long endTime) {
        startTime = AticPortalUtil.getRealStartTime(startTime, endTime);
        long timeSlot = AticPortalRmiImpl.getTimeSpanType(endTime, startTime);
        ArrayList<String> attackTypeNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < attackTrendFormList.size(); ++i) {
            AttackTrendForm form = attackTrendFormList.get(i);
            minTime = form.getDateTime() < minTime || minTime == 0L ? form.getDateTime() : minTime;
            maxTime = form.getDateTime() > maxTime ? form.getDateTime() : maxTime;
            this.getAttackTypeNameList(form, attackTypeNameList);
        }
        HashMap<Long, List<AttackTrendForm>> map = new HashMap<Long, List<AttackTrendForm>>();
        while (minTime <= maxTime) {
            ArrayList<AttackTrendForm> tmpList = new ArrayList<AttackTrendForm>();
            for (AttackTrendForm form : attackTrendFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        this.getAttackTrendFormList(map, attackTypeNameList, attackTrendFormList);
        return attackTrendFormList;
    }

    private void getAttackTrendFormList(Map<Long, List<AttackTrendForm>> map, List<String> attackTypeNameList, List<AttackTrendForm> attackTrendFormList) {
        for (Map.Entry<Long, List<AttackTrendForm>> entry : map.entrySet()) {
            for (int i = 0; i < attackTypeNameList.size(); ++i) {
                boolean hasData = false;
                for (AttackTrendForm form : entry.getValue()) {
                    if (!attackTypeNameList.get(i).equals(form.getAttackTypeName())) continue;
                    hasData = true;
                    break;
                }
                if (hasData) continue;
                AttackTrendForm form = new AttackTrendForm();
                form.setDateTime(entry.getKey());
                form.setAttackTypePackagePps(Long.valueOf(0L));
                form.setAttackTypePackageKbps(Long.valueOf(0L));
                form.setAttackTypeName(attackTypeNameList.get(i));
                attackTrendFormList.add(form);
            }
        }
    }

    private void getAttackTypeNameList(AttackTrendForm form, List<String> attackTypeNameList) {
        if (form.getAttackType() >= 2000L) {
            return;
        }
        boolean hasData = false;
        for (int j = 0; j < attackTypeNameList.size(); ++j) {
            if (!attackTypeNameList.get(j).equals(form.getAttackTypeName())) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            attackTypeNameList.add(form.getAttackTypeName());
        }
    }

    @Override
    public List<DeviceBean> getUserDevice(Long userId) throws RemoteException {
        ArrayList<DeviceBean> result = new ArrayList<DeviceBean>();
        List devIds = this.zoneDeviceService.getDeviceIdsByZoneId(userId);
        for (int i = 0; devIds != null && i < devIds.size(); ++i) {
            AticDevice ne = this.aticDeviceService.getDeviceByMoid(((Long)devIds.get(i)).longValue());
            if (null == ne) continue;
            DeviceBean bean = new DeviceBean();
            bean.setDevId((Long)devIds.get(i));
            bean.setDevIp(ne.getIpAddress());
            bean.setDevName(ne.getName());
            bean.setDevType(ne.getDdosType());
            result.add(bean);
        }
        return result;
    }

    @Override
    public DataCollection<List<AttackExactReportDataLog>, Integer> getAttackLog(DataStatConditionQueryBean cds, String sortField, String sortType, String language) throws RemoteException {
        AticDevice firewall = this.aticDeviceService.getDeviceByIp(cds.getDeviceIp());
        if (null == firewall) {
            return new DataCollection<List<AttackExactReportDataLog>, Integer>(new ArrayList(), 0);
        }
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId || 0L == collectorId) {
            return new DataCollection<List<AttackExactReportDataLog>, Integer>(new ArrayList(), 0);
        }
        CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            return new DataCollection<List<AttackExactReportDataLog>, Integer>(new ArrayList(), 0);
        }
        DataStatCondition dsc = new DataStatCondition();
        AticUtil.copyProperties((Object)cds, (Object)dsc);
        DataStatService client = this.reportCollectorRMIProxy.getDataStatService(collectorInfo.getIpAddress());
        if (null == client) {
            return new DataCollection<List<AttackExactReportDataLog>, Integer>(new ArrayList(), 0);
        }
        RmiTuple attackExactLogList = null;
        try {
            attackExactLogList = client.getAttackExactLog4Portal(dsc, sortField, sortType);
        }
        catch (Exception e) {
            return new DataCollection<List<AttackExactReportDataLog>, Integer>(new ArrayList(), 0);
        }
        DataCollection collections = null;
        if (null != attackExactLogList) {
            ArrayList<AttackExactReportDataLog> formList = new ArrayList<AttackExactReportDataLog>();
            int count = (Integer)attackExactLogList.getTotal();
            DecimalFormat df = new DecimalFormat("###,###");
            for (AttackExactLog attackLog : (List)attackExactLogList.getObjs()) {
                String attackTypeName;
                String currentValue;
                AttackExactReportDataLog log = new AttackExactReportDataLog();
                AticUtil.copyProperties((Object)attackLog, (Object)log);
                log.setSrcIp(this.trimData(log.getSrcIp()));
                if (AticConstants.LOCATION_ATTACK_ID.toString().equals(log.getAttackType()) || AticConstants.LOCATION_ATTACK_ID.compareTo(log.getAttackTypeValue()) == 0) {
                    String names = IpLocationUtil.getCountryName((String)log.getSrcIp(), (String)language, (String)log.getDeviceIp());
                    log.setSrcIp(names);
                }
                log.setDropPacketsDisplay(df.format(attackLog.getDropPackets()));
                log.setDropBytesDisplay(df.format(attackLog.getDropBytes()));
                String unit = AticConstants.attackLogThresholdTrans((int)attackLog.getPpsOrKbps());
                String limitValue = attackLog.getLimit() == 0L ? "-" : df.format(attackLog.getLimit()) + " " + unit;
                String string = currentValue = attackLog.getCurrent() == 0L ? "-" : df.format(attackLog.getCurrent()) + " " + unit;
                if (attackLog.isMultiCurrent()) {
                    unit = AticConstants.attackLogThresholdTrans((int)attackLog.getPpsOrKbps1());
                    limitValue = limitValue + "/" + (attackLog.getLimit1() == 0L ? "-" : df.format(attackLog.getLimit1()) + " " + unit);
                    currentValue = currentValue + "/" + (attackLog.getCurrent1() == 0L ? "-" : df.format(attackLog.getCurrent1()) + " " + unit);
                }
                log.setLimitDisplay(limitValue);
                log.setCurrentDisplay(currentValue);
                log.setDurationDisplay(df.format(attackLog.getDuration()));
                if (attackLog.getAttackTypeValue() >= 2000 && attackLog.getAttackTypeValue() < 80000) {
                    long filterId;
                    FilterForm filterTemp;
                    attackTypeName = "";
                    attackTypeName = 2000 == attackLog.getAttackTypeValue() ? "com.huawei.portal.attack.attackType.62" : (null != (filterTemp = this.filterService.queryFilterName(Long.valueOf(filterId = (long)(attackLog.getAttackTypeValue() - 2000)))) ? filterTemp.getFilterName() : "unknown Filter");
                    log.setAttackTypeStr(attackTypeName);
                }
                if (attackLog.getAttackTypeValue() >= 80000) {
                    long filterId;
                    INpFilterService npfilterService;
                    NPFilterForm npfilterTemp;
                    attackTypeName = "";
                    attackTypeName = 80000 == attackLog.getAttackTypeValue() ? AticUtil.getText((String)"atic.attack.type.80000") : (null != (npfilterTemp = (npfilterService = (INpFilterService)ServiceContext.getInstance().getService("npFilterService", INpFilterService.class)).queryNPFilterFormByfilterId(filterId = (long)(attackLog.getAttackTypeValue() - 80000))) ? npfilterTemp.getFilterName() : AticUtil.getText((String)"atic.attack.type.80000"));
                    log.setAttackTypeStr(attackTypeName);
                }
                formList.add(log);
            }
            collections = new DataCollection(formList, count);
        }
        return collections;
    }

    protected String trimData(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    @Override
    public DataCollection<List<CurrentAttackDataLog>, Integer> getCurrentAttackLog(Map<String, Object> queryMap) throws RemoteException {
        queryMap.put("interActive", BIZ_TYPE_ALL);
        queryMap.put("start", queryMap.get("start"));
        queryMap.put("pageSize", queryMap.get("pageSize"));
        ArrayList<CurrentAttackDataLog> datas = new ArrayList<CurrentAttackDataLog>();
        if (null == queryMap.get("deviceIp")) {
            return new DataCollection<List<CurrentAttackDataLog>, Integer>(datas, 0);
        }
        Paging page = this.attackDataService.getAttackData(queryMap);
        List attackForms = page.getData();
        AticDevice device = null;
        ZonePolicyApplyForm zonePolicyApplyForm = this.zoneMgrNorthSerice.getDivertMode(Long.valueOf(Long.parseLong(queryMap.get("zoneId").toString())));
        DecimalFormat df = new DecimalFormat("###,###");
        for (AttackDataForm form : attackForms) {
            long filterId;
            INpFilterService npFilterService;
            NPFilterForm npFilterTemp;
            String attackTypeName;
            String currentValue;
            CurrentAttackDataLog log = new CurrentAttackDataLog();
            AticUtil.copyProperties((Object)form, (Object)log);
            String unit = AticConstants.attackLogThresholdTrans((int)form.getPpsOrKbps());
            String limitValue = form.getLimitValue() == 0L ? "-" : df.format(form.getLimitValue()) + " " + unit;
            String string = currentValue = form.getCurrentValue() == 0L ? "-" : df.format(form.getCurrentValue()) + " " + unit;
            if (form.isIsMultiCurrent()) {
                unit = AticConstants.attackLogThresholdTrans((int)form.getPpsOrKbps1());
                limitValue = limitValue + "/" + (form.getLimitValue1() == 0L ? "-" : df.format(form.getLimitValue1()) + " " + unit);
                currentValue = currentValue + "/" + (form.getCurrentValue1() == 0L ? "-" : df.format(form.getCurrentValue1()) + " " + unit);
            }
            log.setLimitValueDisplay(limitValue);
            log.setCurrentValueDisplay(currentValue);
            log.setDropBytesDisplay(df.format(log.getDropBytes()));
            log.setAttackBytesDisplay(df.format(log.getAttackBytes()));
            device = this.aticDeviceService.getDeviceByIp(log.getDeviceIp());
            if (null != device) {
                log.setDeviceNameValue(device.getName());
            }
            log.setDivertMode(zonePolicyApplyForm.getDivertMode());
            log.setDefendMode(this.getDefendMode(log));
            if (this.isZoneDefendAttack(form)) {
                log.setInterActive(ATTACK_STATUS_NOT_DEFEND);
                log.setDivertIds("");
            } else if (log.getDeviceType() == 1) {
                this.setDivertLogIds(log);
            } else {
                this.setInterActive(log);
            }
            datas.add(log);
            if (log.getAttackType() >= 2000 && log.getAttackType() < 80000) {
                long filterId2;
                FilterForm filterTemp;
                attackTypeName = "";
                attackTypeName = 2000 == form.getAttackType() ? "com.huawei.portal.attack.attackType.62" : (null != (filterTemp = this.filterService.queryFilterName(Long.valueOf(filterId2 = (long)(form.getAttackType() - 2000)))) ? filterTemp.getFilterName() : "unknown Filter");
                log.setAttackTypeStr(attackTypeName);
            }
            if (log.getAttackType() < 80000) continue;
            attackTypeName = "";
            attackTypeName = 80000 == form.getAttackType() ? AticUtil.getText((String)"atic.attack.type.80000") : (null != (npFilterTemp = (npFilterService = (INpFilterService)ServiceContext.getInstance().getService("npFilterService", INpFilterService.class)).queryNPFilterFormByfilterId(filterId = (long)(form.getAttackType() - 80000))) ? npFilterTemp.getFilterName() : AticUtil.getText((String)"atic.attack.type.80000"));
            log.setAttackTypeStr(attackTypeName);
        }
        return new DataCollection<List<CurrentAttackDataLog>, Integer>(datas, page.getCount());
    }

    protected void setDivertLogIds(CurrentAttackDataLog log) {
        if (log.getDivertMode() != 1) {
            log.setInterActive(ATTACK_STATUS_DEFEND);
        } else {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("zoneId", log.getZoneId() + "");
            queryMap.put("divertIp", log.getZoneIp());
            queryMap.put("divertMode", "1");
            queryMap.put("divertStatus", "0");
            Paging page = this.divertTacticsService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
            List data = page.getData();
            if (data == null || data.isEmpty()) {
                log.setInterActive(ATTACK_STATUS_DEFEND);
            } else {
                StringBuffer ids = new StringBuffer();
                for (DivertTacticsForm form : data) {
                    ids.append(form.getId() + ",");
                }
                ids.deleteCharAt(ids.length() - 1);
                log.setDivertIds(ids.toString());
                log.setInterActive(ATTACK_STATUS_UN_DEFEND);
            }
        }
    }

    protected Integer getDefendMode(CurrentAttackDataLog log) {
        ZoneFeatureStatusForm featureStatusForm = this.zoneFeatureStatusService.getZoneFeatureByZoneIdAndDeviceId(log.getZoneId(), log.getDeviceIp(), "ZoneDefendModeFeature", log.getZoneId());
        if (featureStatusForm != null) {
            return featureStatusForm.getDefendMode();
        }
        return Constant.DEFENDMODE_DEFEND_AUTO;
    }

    protected void setInterActive(CurrentAttackDataLog log) {
        if (log.getDefendMode().intValue() == Constant.DEFENDMODE_DEFEND_MANUAL.intValue()) {
            if (!this.commonUtilService.isSuportInterActiveAttack(log.getAttackType(), log.getDeviceIp())) {
                log.setInterActive(ATTACK_STATUS_DEFEND);
            }
        } else {
            log.setInterActive(ATTACK_STATUS_DEFEND);
        }
    }

    protected boolean isZoneDefendAttack(AttackDataForm form) {
        return form.getBizId().equals(Long.parseLong("0")) && ("".equals(form.getZoneIp()) || "0".equals(form.getZoneIp()));
    }

    protected boolean shouDoDefend(AttackDataForm form) {
        if (this.isZoneDefendAttack(form)) {
            return false;
        }
        ZoneFeatureStatusForm featureStatusForm = this.zoneFeatureStatusService.getZoneFeatureByZoneIdAndDeviceId(form.getZoneId(), form.getDeviceIp(), "ZoneDefendModeFeature", form.getZoneId());
        Integer defendMode = Constant.DEFENDMODE_DEFEND_AUTO;
        if (featureStatusForm != null) {
            defendMode = featureStatusForm.getDefendMode();
        }
        if (defendMode.equals(Constant.DEFENDMODE_DEFEND_AUTO) || defendMode.equals(Constant.DEFENDMODE_DEFEND_UNDEFEND)) {
            return false;
        }
        if (!this.commonUtilService.isSuportInterActiveAttack(form.getAttackType(), form.getDeviceIp())) {
            return false;
        }
        return form.getInterActive().equals(ATTACK_STATUS_UN_DEFEND);
    }

    protected boolean deployDefendCommon(AttackDataForm form, String userName, AticDevice firewall, Map<String, String> map, String collectorIp) {
        boolean deployResult = true;
        try {
            ManualDefendForm manualDefendForm = new ManualDefendForm();
            manualDefendForm.setIp(form.getZoneIp());
            manualDefendForm.setZoneName(userName);
            manualDefendForm.setZoneId(form.getZoneId());
            manualDefendForm.setDeviceId(Long.valueOf(firewall.getMoId()));
            ZoneServiceForm service = this.zoneServiceService.queryByZoneServiceID(form.getBizId());
            if (null != service) {
                logger.info((Object)("service in manual defend transferObject : " + service.toString()));
                manualDefendForm.setServiceName(service.getServiceName());
                manualDefendForm.setServiceId(service.getPkid());
                manualDefendForm.setIsCustom(Boolean.valueOf(!"DEFAULT".equals(service.getProtocol())));
            }
            manualDefendForm.setAttackType(form.getAttackType());
            manualDefendForm.setPort(form.getPort());
            deployResult = this.zoneMgrNorthSerice.manualDefend(manualDefendForm);
            if (deployResult) {
                if (null == map.get(collectorIp)) {
                    map.put(collectorIp, form.getPkId() + ",");
                } else {
                    String ips = map.get(collectorIp).concat(form.getPkId() + ",");
                    map.put(collectorIp, ips);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"deployDefendCommon error", (Throwable)e);
            deployResult = false;
        }
        return deployResult;
    }

    protected Map<String, Boolean> modifyAttackDatas(Map<String, String> collectorIps) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map.Entry<String, String> entry : collectorIps.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            result.putAll(this.attackDataService.modifyAttackDatasForResult(value.substring(0, value.length() - 1), key));
        }
        return result;
    }

    public Map<String, Boolean> doDivertDefend(Long userId, List<String> pkids, String userName, String clientIp) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, String> pkIdmap = new HashMap<String, String>();
        for (String pkid : pkids) {
            String[] idArray = pkid.split(";");
            String[] divertIdArray = idArray[4].split(",");
            String firstPkId = idArray[0];
            for (String id : divertIdArray) {
                ids.add(id);
                pkIdmap.put(id, firstPkId);
            }
        }
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("zoneId", userId + "");
        queryMap.put("divertMode", "1");
        queryMap.put("divertStatus", "0");
        Paging page = this.divertTacticsService.queryByPage(queryMap, 0, Integer.MAX_VALUE);
        List datas = page.getData();
        if (null != datas && !datas.isEmpty()) {
            ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
            for (DivertTacticsForm form : datas) {
                if (!ids.contains(form.getId() + "")) continue;
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(form.getId().longValue());
                bo.setTargetName("");
                boList.add(bo);
            }
            BatchOperationResult batchRsult = this.divertTacticsService.startDivertTactics(boList, userName, clientIp);
            List res = batchRsult.getResult();
            for (BatchOperation each : res) {
                long divertId = each.getTargetId();
                String pkId = (String)pkIdmap.get(divertId + "");
                if (each.getErrorCode() != 0L) {
                    result.put(pkId, false);
                    continue;
                }
                if (null != result.get(pkId)) continue;
                result.put(pkId, true);
            }
        }
        return result;
    }

    @Override
    public Map<String, Boolean> doBatchDefend(Long userId, String userName, List<String> pkIds, String clientIp) throws RemoteException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (pkIds.isEmpty()) {
            return result;
        }
        ArrayList<String> defendList = new ArrayList<String>();
        ArrayList<String> divertList = new ArrayList<String>();
        for (String ids : pkIds) {
            if (this.isDivert(ids)) {
                divertList.add(ids);
            }
            if (!this.isDefend(ids)) continue;
            defendList.add(ids);
        }
        if (!defendList.isEmpty()) {
            result.putAll(this.doDefend(userId, userName, defendList));
        }
        if (!divertList.isEmpty()) {
            result.putAll(this.doDivertDefend(userId, divertList, userName, clientIp));
        }
        return result;
    }

    protected boolean isDivert(String ids) {
        String[] array = ids.split(";");
        return array.length == 5 && array[3].equals(String.valueOf(1));
    }

    protected boolean isDefend(String ids) {
        String[] array = ids.split(";");
        return array.length == 4 && array[3].equals(String.valueOf(0));
    }

    public Map<String, Boolean> doDefend(Long userId, String userName, List<String> pkIds) throws RemoteException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (pkIds.isEmpty()) {
            return result;
        }
        HashMap<String, AticDevice> neMap = new HashMap<String, AticDevice>();
        HashMap<String, String> collectorMap = new HashMap<String, String>();
        StringBuffer dIps = new StringBuffer("(");
        for (String str : pkIds) {
            String[] array = str.split(";");
            String devIp = array[1];
            AticDevice firewall = this.aticDeviceService.getDeviceByIp(devIp);
            neMap.put(devIp, firewall);
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
            if (null != collectorId) {
                CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(collectorId.longValue());
                String collectorIp = collectorInfo.getIpAddress();
                collectorMap.put(devIp, collectorIp);
            }
            dIps.append(devIp).append(String.valueOf(","));
        }
        dIps.deleteCharAt(dIps.length() - 1);
        dIps.append(String.valueOf(")"));
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("interActive", BIZ_TYPE_ALL);
        queryMap.put("start", 0);
        queryMap.put("pageSize", Integer.MAX_VALUE);
        queryMap.put("zoneId", userId + "");
        queryMap.put("deviceIp", dIps.toString());
        Paging page = this.attackDataService.getAttackData(queryMap);
        List attackForms = page.getData();
        HashMap<String, String> collectorData = new HashMap<String, String>();
        for (AttackDataForm form : attackForms) {
            boolean deployResult;
            String checkCrc = new StringBuffer(form.getPkId() == null ? "" : String.valueOf(form.getPkId())).append(";").append(form.getDeviceIp()).append(";").append(form.getInterActive()).append(";").append(form.getDeviceType()).append(";").toString();
            if (!pkIds.contains(checkCrc) || !this.shouDoDefend(form) || null == neMap.get(form.getDeviceIp()) || null == collectorMap.get(form.getDeviceIp()) || (deployResult = this.deployDefendCommon(form, userName, (AticDevice)neMap.get(form.getDeviceIp()), collectorData, (String)collectorMap.get(form.getDeviceIp())))) continue;
            result.put(form.getPkId() + "", false);
        }
        result.putAll(this.modifyAttackDatas(collectorData));
        return result;
    }

    @Override
    public DataBaseInfo getDataBaseInfo() throws RemoteException {
        BasicInfoForm form = BasicInfoUtil.getBasicInfo();
        DataBaseInfo info = null;
        if (null != form) {
            info = new DataBaseInfo();
            AticUtil.copyProperties((Object)form, (Object)info);
        }
        return info;
    }

    @Override
    public List<PortalReturnData> getIpTopNData(DataStatConditionQueryBean queryBean) throws RemoteException {
        try {
            DataStatConditionForm cleanCondition;
            ArrayList<IpTopNForm> cleanResult = new ArrayList();
            ArrayList<IpTopNForm> detectResult = new ArrayList();
            if (null == queryBean.getDeviceIp()) {
                queryBean.setDeviceIp(BIZ_TYPE_ALL);
                queryBean.setDevSerType(0);
                cleanCondition = this.prepareIpFlowTopNData(queryBean);
                cleanResult = this.fetchIpFlowTopNData(cleanCondition);
                queryBean.setDeviceIp("-2");
                queryBean.setDevSerType(1);
                DataStatConditionForm detectCondition = this.prepareIpFlowTopNData(queryBean);
                detectResult = this.fetchIpFlowTopNData(detectCondition);
            } else {
                cleanCondition = this.prepareIpFlowTopNData(queryBean);
                if (1 == queryBean.getDevSerType()) {
                    detectResult = this.fetchIpFlowTopNData(cleanCondition);
                } else {
                    cleanResult = this.fetchIpFlowTopNData(cleanCondition);
                }
            }
            logger.info((Object)("detectResult :" + detectResult + " , cleanResult : " + cleanResult));
            List<PortalReturnData> result = this.handleIpTopNData(cleanResult, detectResult);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"start getIpTopNData error", (Throwable)e);
            return new ArrayList<PortalReturnData>();
        }
    }

    private List<PortalReturnData> handleIpTopNData(List<IpTopNForm> cleanResult, List<IpTopNForm> detectResult) {
        ArrayList<IpTopNForm> allData = new ArrayList<IpTopNForm>();
        allData.addAll(cleanResult);
        allData.addAll(detectResult);
        HashMap<String, PortalReturnData> result = new HashMap<String, PortalReturnData>();
        for (IpTopNForm eachClean : allData) {
            PortalReturnData data = new PortalReturnData();
            String zoneIp = eachClean.getZoneIp();
            data.setKey(zoneIp);
            data.setValue(eachClean.getKbps());
            if (result.containsKey(zoneIp)) {
                PortalReturnData old = (PortalReturnData)result.get(zoneIp);
                if (old.getValue() >= data.getValue()) continue;
                result.put(zoneIp, data);
                continue;
            }
            result.put(zoneIp, data);
        }
        logger.info((Object)("result : " + result));
        return this.sortDataByValue(result);
    }

    private DataStatConditionForm prepareIpFlowTopNData(DataStatConditionQueryBean queryBean) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        String devIp = queryBean.getDeviceIp();
        long deviceId = -1L;
        if (devIp.equals(BIZ_TYPE_ALL)) {
            deviceId = -1L;
            datastatConditionForm.setDevSerType(Integer.valueOf(0));
        } else if (devIp.equals("-2")) {
            deviceId = -2L;
            datastatConditionForm.setDevSerType(Integer.valueOf(1));
        } else {
            deviceId = this.aticDeviceService.getMoidByIP(devIp);
            datastatConditionForm.setDevSerType(queryBean.getDevSerType());
        }
        datastatConditionForm.setDeviceId(Long.valueOf(deviceId));
        datastatConditionForm.setDirection(queryBean.getDirection());
        datastatConditionForm.setZoneId(queryBean.getZoneId());
        datastatConditionForm.setIsServiceGroup(Boolean.valueOf(false));
        datastatConditionForm.setBisId(BIS_ALL);
        long startTime = this.compareSystemCurrentTime(queryBean.getStartTime());
        datastatConditionForm.setStartTime(Long.valueOf(startTime));
        long endTime = this.compareSystemCurrentTime(queryBean.getEndTime());
        datastatConditionForm.setEndTime(Long.valueOf(endTime));
        datastatConditionForm.setAttackType(Integer.valueOf(1));
        datastatConditionForm.setAppType(Integer.valueOf(1));
        if (null != queryBean.getProtocol()) {
            datastatConditionForm.setProtocol(queryBean.getProtocol());
        } else {
            datastatConditionForm.setProtocol(Integer.valueOf(0));
        }
        if (null == queryBean.getDataType()) {
            datastatConditionForm.setUnit(Integer.valueOf(0));
        } else {
            datastatConditionForm.setUnit(queryBean.getDataType());
        }
        datastatConditionForm.setTopn(queryBean.getTopn());
        datastatConditionForm.setPortalQuery(true);
        return datastatConditionForm;
    }

    private Long compareSystemCurrentTime(Long time) {
        Date date = new Date();
        Long currentTime = date.getTime() / 1000L;
        if (time > currentTime) {
            return currentTime;
        }
        return time;
    }

    private List<IpTopNForm> fetchIpFlowTopNData(DataStatConditionForm datastatConditionForm) {
        List<IpTopNForm> ipTopNFormList = new ArrayList<IpTopNForm>();
        Map<String, List<IpTopNForm>> allCollectorIpTopNForm = null;
        try {
            allCollectorIpTopNForm = datastatConditionForm.getDeviceId() > 0L ? this.getSingleDeviceDataNew(datastatConditionForm) : this.getMultiDeviceData(datastatConditionForm);
            ipTopNFormList = 1 != datastatConditionForm.getAppType() ? (-2L == datastatConditionForm.getDeviceId() ? this.getAllDetectTopNForm(allCollectorIpTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit()) : this.getTopNForm(allCollectorIpTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit())) : this.getTopNForm(allCollectorIpTopNForm, datastatConditionForm.getTopn(), datastatConditionForm.getUnit());
        }
        catch (LegoCheckedException legoException) {
            throw new LegoCheckedException(legoException.getMessage(), (Throwable)legoException);
        }
        catch (Exception e) {
            logger.error((Object)"ZoneFluxTopNDataSet prepareData() unknow exception", (Throwable)e);
        }
        return ipTopNFormList;
    }

    private List<IpTopNForm> getTopNForm(Map<String, List<IpTopNForm>> inputMap, int topn, int unit) {
        logger.info((Object)("inputMap : " + inputMap));
        List<IpTopNForm> formList = new ArrayList<IpTopNForm>();
        for (Map.Entry<String, List<IpTopNForm>> entry : inputMap.entrySet()) {
            formList.addAll((Collection<IpTopNForm>)entry.getValue());
        }
        formList = this.getDistinctForm(formList, 1, unit);
        logger.info((Object)("formList : " + formList));
        TopNcomparator comp = new TopNcomparator(unit);
        Collections.sort(formList, comp);
        List<IpTopNForm> orderformList = null;
        orderformList = this.processDataSortByIp(formList, unit);
        if (orderformList.size() > topn) {
            for (int i = orderformList.size() - 1; i >= topn; --i) {
                orderformList.remove(i);
            }
        }
        logger.info((Object)("orderformList : " + orderformList));
        return orderformList;
    }

    private List<IpTopNForm> getAllDetectTopNForm(Map<String, List<IpTopNForm>> inputMap, int topn, int unit) {
        logger.info((Object)("inputMap : " + inputMap));
        List<IpTopNForm> distinctForm = new ArrayList<IpTopNForm>();
        List listDefendGroupForm = this.defendGroupService.getAll();
        logger.info((Object)("DefendGroupForm : " + listDefendGroupForm));
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<IpTopNForm> listForm = new ArrayList<IpTopNForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = this.aticDeviceService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                devIp = AticUtil.formatIpAddress((String)devIp);
                logger.info((Object)("devIp : " + devIp));
                if (!inputMap.containsKey(devIp)) continue;
                listForm.addAll((Collection<IpTopNForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getDistinctForm(listForm, defendGroupForm.getDetectMode(), unit));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getDistinctForm(distinctForm, 1, unit);
        logger.info((Object)("distinctForm : " + distinctForm));
        TopNcomparator comp = new TopNcomparator(unit);
        Collections.sort(distinctForm, comp);
        Object var7_10 = null;
        List<IpTopNForm> list = this.processDataSortByIp(distinctForm, unit);
        if (list.size() > topn) {
            for (int i = list.size() - 1; i >= topn; --i) {
                list.remove(i);
            }
        }
        logger.info((Object)("orderformList : " + list));
        return list;
    }

    private List<IpTopNForm> processDataSortByIp(List<IpTopNForm> formList, int unit) {
        List<IpTopNForm> orderformList = new ArrayList<IpTopNForm>();
        if (null == formList || formList.isEmpty()) {
            return orderformList;
        }
        orderformList = formList;
        if (unit == 0) {
            this.processData4Kbps(orderformList);
        } else {
            this.processData4Pps(orderformList);
        }
        return orderformList;
    }

    private void processData4Kbps(List<IpTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getKbps().equals(orderformList.get(j).getKbps()) || orderformList.get(i).getZoneIp().compareTo(orderformList.get(j).getZoneIp()) <= 0) continue;
                IpTopNForm temp = null;
                temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    private void processData4Pps(List<IpTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getPps().equals(orderformList.get(j).getPps()) || orderformList.get(i).getZoneIp().compareTo(orderformList.get(j).getZoneIp()) <= 0) continue;
                IpTopNForm temp = null;
                temp = orderformList.get(i);
                orderformList.set(i, orderformList.get(j));
                orderformList.set(j, temp);
            }
        }
    }

    private List<IpTopNForm> getDistinctForm(List<IpTopNForm> allForm, int netMode, int unit) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getZoneIp().equals(allForm.get(j).getZoneIp()) || !allForm.get(i).getZoneId().equals(allForm.get(j).getZoneId())) continue;
                this.dealWithSame(allForm, netMode, unit, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<IpTopNForm> allForm, int netMode, int unit, int i, int j) {
        if (netMode == 0) {
            if (unit == 0) {
                if (allForm.get(i).getKbps() > allForm.get(j).getKbps()) {
                    allForm.get(i).setKbps(allForm.get(i).getKbps());
                    allForm.get(i).setPps(allForm.get(i).getPps());
                } else {
                    allForm.get(i).setKbps(allForm.get(j).getKbps());
                    allForm.get(i).setPps(allForm.get(j).getPps());
                }
            } else if (allForm.get(i).getPps() > allForm.get(j).getPps()) {
                allForm.get(i).setKbps(allForm.get(i).getKbps());
                allForm.get(i).setPps(allForm.get(i).getPps());
            } else {
                allForm.get(i).setKbps(allForm.get(j).getKbps());
                allForm.get(i).setPps(allForm.get(j).getPps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setKbps(Long.valueOf(allForm.get(i).getKbps() + allForm.get(j).getKbps()));
            allForm.get(i).setPps(Long.valueOf(allForm.get(i).getPps() + allForm.get(j).getPps()));
            allForm.remove(j);
        }
    }

    private Map<String, List<IpTopNForm>> getMultiDeviceData(DataStatConditionForm datastatConditionForm) {
        Map<Long, List<AticDevice>> collectDevMap = null;
        HashMap<String, List<IpTopNForm>> allCollectorIpTopNForm = new HashMap<String, List<IpTopNForm>>();
        List<AticDevice> firewallList = this.getFireWallOfCleanOrDetect(datastatConditionForm);
        collectDevMap = this.getCollectDevMap(firewallList);
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            CollectorInfo collector = this.collectorService.getCollectorInfo(entry.getKey().longValue());
            if (null == collector) continue;
            String collectorIp = collector.getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            Map tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getIPFlux(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            for (Map.Entry entryTemp : tempMap.entrySet()) {
                if (allCollectorIpTopNForm.containsKey(entryTemp.getKey())) {
                    ((List)allCollectorIpTopNForm.get(entryTemp.getKey())).addAll((Collection)entryTemp.getValue());
                    continue;
                }
                allCollectorIpTopNForm.put((String)entryTemp.getKey(), (List<IpTopNForm>)entryTemp.getValue());
            }
        }
        return allCollectorIpTopNForm;
    }

    private Map<String, List<IpTopNForm>> getSingleDeviceDataNew(DataStatConditionForm datastatConditionForm) {
        AticDevice firewall = this.aticDeviceService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            logger.error((Object)("no collector exist,collectorId = " + null));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorInfo.getIpAddress()));
            throw new LegoCheckedException(570504L);
        }
        HashMap<String, List<IpTopNForm>> allCollectorIpTopNForm = new HashMap();
        try {
            allCollectorIpTopNForm = this.dataStatService.getIPFlux(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorIpTopNForm;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    @Override
    public String encryptByKMCDynamic(String str) throws RemoteException {
        String result = DataProtectServiceConst.sdpEncryptLocal((StringBuffer)new StringBuffer(str));
        return result;
    }

    @Override
    public String decryptByKMCDynamic(String str) throws RemoteException {
        return DataProtectServiceConst.sdpDecryptLocal((String)str);
    }

    @Override
    public boolean verifyPwd(String srcStr, String destStr) throws RemoteException {
        boolean result = DataProtectServiceConst.sdpVerifyPwdLocal((StringBuffer)new StringBuffer(srcStr), (String)destStr);
        return result;
    }
}

