/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.portal.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class AticPortalUtil {
    public static final Integer MORE_THAN_SEVEN_DAYS = 2;
    public static final Integer LESS_THAN_ONE_DAY = 0;
    public static final Integer LESS_THAN_SEVEN_DAYS = 1;
    public static final int GAP_TIME_FIVE_MINUTE_IN_MILLISECOND = 300000;
    public static final int GAP_TIME_ONE_DAY_MILLISECOND = 86400000;
    public static final int GAP_TIME_ONE_HOUR_IN_MILLISECOND = 3600000;
    public static final Integer ONE_DAY_BY_SECOND = 86400;
    private static final Integer SEVEN_DAY_BY_SECOND = 604800;
    private static final long NUM_300L = 300L;
    private static final long NUM_3600L = 3600L;

    private AticPortalUtil() {
    }

    public static long getRealStartTime(long start, long end) {
        long span = end - start;
        long gra = 0L;
        if (span < (long)ONE_DAY_BY_SECOND.intValue() && span >= 0L) {
            gra = 300L;
        } else if (span < (long)SEVEN_DAY_BY_SECOND.intValue() && span >= (long)ONE_DAY_BY_SECOND.intValue()) {
            gra = 3600L;
        } else if (span >= (long)SEVEN_DAY_BY_SECOND.intValue()) {
            return AticPortalUtil.processStartTime(start);
        }
        return start - start % gra;
    }

    public static Long compareSystemCurrentTime(Long time) {
        if (null != time) {
            Date date = new Date();
            Long currentTime = date.getTime() / 1000L;
            if (time > currentTime) {
                return currentTime;
            }
            return time;
        }
        return 0L;
    }

    public static long processStartTime(long startTime) {
        if (Long.valueOf(startTime) == null) {
            return 0L;
        }
        long timeLong = 0L;
        try {
            SimpleDateFormat fromate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date(startTime * 1000L);
            String timeString = fromate.format(date);
            StringBuffer bufferTime = new StringBuffer(timeString.split(" ")[0]);
            bufferTime.append(" 00:00:00");
            Date startDate = fromate.parse(bufferTime.toString().trim());
            timeLong = startDate.getTime() / 1000L;
        }
        catch (ParseException e) {
            return 0L;
        }
        return timeLong;
    }

    public static int getGapTime(int spanTimeType) {
        if (spanTimeType == LESS_THAN_ONE_DAY) {
            return 300000;
        }
        if (spanTimeType == LESS_THAN_SEVEN_DAYS) {
            return 3600000;
        }
        return 86400000;
    }

    public static long convertTimeString(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static Integer getTimeSpanType(long endTime, long startTime) {
        Long spanTime = endTime - startTime;
        if (spanTime < (long)ONE_DAY_BY_SECOND.intValue()) {
            return LESS_THAN_ONE_DAY;
        }
        if (spanTime < (long)SEVEN_DAY_BY_SECOND.intValue() && spanTime >= (long)ONE_DAY_BY_SECOND.intValue()) {
            return LESS_THAN_SEVEN_DAYS;
        }
        return MORE_THAN_SEVEN_DAYS;
    }
}

