/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.config;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.config.ConfigurationException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class Configuration {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private Properties config = new Properties();
    private String fn = null;

    public Configuration() {
    }

    public Configuration(String fileName) throws ConfigurationException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fileName);
            this.config.load(fin);
        }
        catch (IOException ex) {
            throw new ConfigurationException("Can't read config file:" + fileName);
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        this.fn = fileName;
    }

    public String getValue(String itemName) {
        return this.config.getProperty(itemName);
    }

    public String getValue(String itemName, String defaultValue) {
        return this.config.getProperty(itemName, defaultValue);
    }

    public void setValue(String itemName, String value) {
        this.config.setProperty(itemName, value);
    }

    public void saveFile(String fileName, String description) throws ConfigurationException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            this.config.store(fout, description);
        }
        catch (IOException ex) {
            throw new ConfigurationException("Can't read config file:" + fileName);
        }
        finally {
            this.closeOutputStream(fout);
        }
    }

    private void closeOutputStream(OutputStream outPut) {
        if (null != outPut) {
            try {
                outPut.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            try {
                outPut.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public void saveFile(String fileName) throws ConfigurationException {
        this.saveFile(fileName, "");
    }

    public void saveFile() throws ConfigurationException {
        if (this.fn.length() == 0) {
            throw new ConfigurationException("Config file name is null");
        }
        this.saveFile(this.fn);
    }
}

