/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.config;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.unicom.sdk.model.UnicomSpConfig;
import com.hs.lego.sp.unicom.config.Configuration;
import com.hs.lego.sp.unicom.config.ConfigurationException;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class SGIPConfig {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final String PATH = File.separator + "LegoRuntime" + File.separator + "spconfig\\sgip\\sgipConf.properties";
    private static String unicomIp;
    private static String unicomPort;
    private static String loginName;
    private static String loginPassword;
    private static String chargeNumber;
    private static String corpId;
    private static String serviceType;
    private static String linkID;
    private static String spNumber;
    private static String localIp;
    private static String nodeID;
    private static String testPhone;
    private static boolean isReadOver;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readConfFile() {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.setReadOver(false);
            try {
                String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + PATH;
                Configuration conf = new Configuration(currentPath);
                SGIPConfig.setLocalIp(conf.getValue("localIp"));
                SGIPConfig.setUnicomIp(conf.getValue("unicomIp"));
                SGIPConfig.setUnicomPort(conf.getValue("unicomPort"));
                SGIPConfig.setSpNumber(conf.getValue("SPNumber"));
                SGIPConfig.setServiceType(conf.getValue("serviceType"));
                SGIPConfig.setNodeID(conf.getValue("NodeID"));
                SGIPConfig.setLoginName(conf.getValue("loginName"));
                SGIPConfig.setCorpId(conf.getValue("corpId"));
                SGIPConfig.setChargeNumber(conf.getValue("ChargeNumber"));
                SGIPConfig.setTestPhone(conf.getValue("testPhone"));
                SGIPConfig.setLoginPassword(DataProtectServiceConst.sdpDecryptLocal((String)conf.getValue("loginPassword")));
                SGIPConfig.setReadOver(true);
                LOGGER.info((Object)"read SGIP configure complete.");
            }
            catch (ConfigurationException e) {
                SGIPConfig.setReadOver(true);
                LOGGER.error((Object)"Loading SGIP configure file failed. The configure file doesn't exist or parameter format error.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfFile(UnicomSpConfig unicomConfig) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            Properties properties = new Properties();
            properties.put("localIp", unicomConfig.getLocalIp());
            properties.put("ChargeNumber", unicomConfig.getChargeNumber());
            properties.put("corpId", unicomConfig.getCorpId());
            properties.put("loginName", unicomConfig.getLoginName());
            properties.put("loginPassword", DataProtectServiceConst.sdpEncryptLocal((String)unicomConfig.getLoginPassword()));
            properties.put("NodeID", unicomConfig.getNodeId());
            properties.put("serviceType", unicomConfig.getServiceType());
            properties.put("SPNumber", unicomConfig.getSpNumber());
            properties.put("unicomIp", unicomConfig.getUnicomIp());
            properties.put("unicomPort", String.valueOf(unicomConfig.getUnicomPort()));
            properties.put("testPhone", unicomConfig.getTestPhone());
            SGIPConfig.setReadOver(false);
            FileOutputStream fos = null;
            try {
                File file = new File(AticInstallUtil.getInstance().getAticInstallPath() + PATH);
                if (!file.exists() && file.createNewFile()) {
                    LOGGER.info((Object)"file.createNewFile() is success");
                }
                fos = new FileOutputStream(AticInstallUtil.getInstance().getAticInstallPath() + PATH);
                properties.store(fos, "");
                SGIPConfig.updateConfig(unicomConfig);
                SGIPConfig.setReadOver(true);
                LOGGER.info((Object)"write SGIP configure complete.");
                SGIPConfig.closeOutputStream(fos);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Write SGIP configure file failed.");
                SGIPConfig.writeConfFile();
                SGIPConfig.setReadOver(true);
            }
            finally {
                SGIPConfig.closeOutputStream(fos);
            }
        }
    }

    private static void writeConfFile() throws Exception {
        Properties properties = new Properties();
        properties.put("ChargeNumber", SGIPConfig.getChargeNumber());
        properties.put("corpId", SGIPConfig.getCorpId());
        properties.put("loginName", SGIPConfig.getLoginName());
        properties.put("loginPassword", DataProtectServiceConst.sdpEncryptLocal((String)SGIPConfig.getLoginPassword()));
        properties.put("NodeID", SGIPConfig.getNodeID());
        properties.put("serviceType", SGIPConfig.getServiceType());
        properties.put("SPNumber", SGIPConfig.getSpNumber());
        properties.put("unicomIp", SGIPConfig.getUnicomIp());
        properties.put("unicomPort", String.valueOf(SGIPConfig.getUnicomPort()));
        FileOutputStream fos = null;
        try {
            File file = new File(AticInstallUtil.getInstance().getAticInstallPath() + PATH);
            if (!file.exists() && file.createNewFile()) {
                LOGGER.info((Object)"file.createNewFile() is success");
            }
            fos = new FileOutputStream(AticInstallUtil.getInstance().getAticInstallPath() + PATH);
            properties.store(fos, "");
            LOGGER.info((Object)"back write SGIP configure complete.");
            SGIPConfig.closeOutputStream(fos);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Back write SGIP configure file failed.");
        }
        finally {
            SGIPConfig.closeOutputStream(fos);
        }
    }

    private static void closeOutputStream(OutputStream outPut) {
        if (null != outPut) {
            try {
                outPut.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
            try {
                outPut.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    private static void updateConfig(UnicomSpConfig unicomConfig) {
        SGIPConfig.setLocalIp(unicomConfig.getLocalIp());
        SGIPConfig.setUnicomIp(unicomConfig.getUnicomIp());
        SGIPConfig.setUnicomPort(unicomConfig.getUnicomPort());
        SGIPConfig.setSpNumber(unicomConfig.getSpNumber());
        SGIPConfig.setServiceType(unicomConfig.getServiceType());
        SGIPConfig.setNodeID(unicomConfig.getNodeId());
        SGIPConfig.setLoginName(unicomConfig.getLoginName());
        SGIPConfig.setLoginPassword(unicomConfig.getLoginPassword());
        SGIPConfig.setCorpId(unicomConfig.getCorpId());
        SGIPConfig.setChargeNumber(unicomConfig.getChargeNumber());
        SGIPConfig.setTestPhone(unicomConfig.getTestPhone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnicomIp() {
        Object object = LOCK;
        synchronized (object) {
            return unicomIp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUnicomIp(String unicomIp) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.unicomIp = unicomIp;
        }
    }

    public static String getUnicomPort() {
        return unicomPort;
    }

    public static void setUnicomPort(String unicomPort) {
        SGIPConfig.unicomPort = unicomPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLoginName() {
        Object object = LOCK;
        synchronized (object) {
            return loginName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoginName(String loginName) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.loginName = loginName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLoginPassword() {
        Object object = LOCK;
        synchronized (object) {
            return loginPassword;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoginPassword(String loginPassword) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.loginPassword = loginPassword;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getChargeNumber() {
        Object object = LOCK;
        synchronized (object) {
            return chargeNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setChargeNumber(String chargeNum) {
        Object object = LOCK;
        synchronized (object) {
            chargeNumber = chargeNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCorpId() {
        Object object = LOCK;
        synchronized (object) {
            return corpId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCorpId(String corpId) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.corpId = corpId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServiceType() {
        Object object = LOCK;
        synchronized (object) {
            return serviceType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServiceType(String serviceType) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.serviceType = serviceType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinkID() {
        Object object = LOCK;
        synchronized (object) {
            return linkID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLinkID(String linkID) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.linkID = linkID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpNumber() {
        Object object = LOCK;
        synchronized (object) {
            return spNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSpNumber(String spNumbers) {
        Object object = LOCK;
        synchronized (object) {
            spNumber = spNumbers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalIp() {
        Object object = LOCK;
        synchronized (object) {
            return localIp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocalIp(String localIp) {
        Object object = LOCK;
        synchronized (object) {
            SGIPConfig.localIp = localIp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNodeID() {
        Object object = LOCK;
        synchronized (object) {
            return nodeID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNodeID(String nodID) {
        Object object = LOCK;
        synchronized (object) {
            nodeID = nodID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReadOver() {
        Object object = LOCK;
        synchronized (object) {
            return isReadOver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setReadOver(boolean isReadOvers) {
        Object object = LOCK;
        synchronized (object) {
            isReadOver = isReadOvers;
        }
    }

    public static String getTestPhone() {
        return testPhone;
    }

    public static void setTestPhone(String testPhone) {
        SGIPConfig.testPhone = testPhone;
    }

    static {
        isReadOver = false;
        LOCK = new Object();
    }
}

