/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.protocol;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.protocol.SGIPCommand;
import com.hs.lego.sp.unicom.protocol.SGIPCommandDefine;
import com.hs.lego.sp.unicom.protocol.SGIPHeader;
import java.io.UnsupportedEncodingException;

public class Bind
extends SGIPCommand {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private String reserve = "";
    private byte loginType = 1;
    private String loginName;
    private String loginPassword;

    public Bind() {
        this.header = new SGIPHeader(SGIPCommandDefine.SGIP_BIND);
        this.bodybytes = new byte[41];
        byte[] reserveByte = new byte[8];
        try {
            System.arraycopy(this.reserve.getBytes("UTF-8"), 0, reserveByte, 0, this.reserve.length());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        System.arraycopy(reserveByte, 0, this.bodybytes, 33, 8);
    }

    public Bind(SGIPCommand command) {
        try {
            this.header = command.header;
            this.bodybytes = command.bodybytes;
            this.loginType = command.bodybytes[0];
            byte[] loginNameBytes = new byte[16];
            System.arraycopy(command.bodybytes, 1, loginNameBytes, 0, 16);
            this.loginName = new String(loginNameBytes, "UTF-8").trim();
            byte[] loginpwdBytes = new byte[16];
            System.arraycopy(command.bodybytes, 17, loginpwdBytes, 0, 16);
            this.loginPassword = new String(loginpwdBytes, "UTF-8").trim();
            byte[] reserveByte = new byte[8];
            System.arraycopy(command.bodybytes, 33, reserveByte, 0, 8);
            this.reserve = new String(reserveByte, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
    }

    public byte getLoginType() {
        return this.loginType;
    }

    public void setLoginType(byte loginType) {
        this.loginType = loginType;
        this.bodybytes[0] = SGIPCommand.intToByte(loginType);
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
        byte[] loginNameByte = new byte[16];
        try {
            System.arraycopy(loginName.getBytes("UTF-8"), 0, loginNameByte, 0, loginName.length());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        System.arraycopy(loginNameByte, 0, this.bodybytes, 1, 16);
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
        byte[] loginpwd = new byte[16];
        try {
            System.arraycopy(loginPassword.getBytes("UTF-8"), 0, loginpwd, 0, loginPassword.length());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        System.arraycopy(loginpwd, 0, this.bodybytes, 17, 16);
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
        byte[] reserveByte = new byte[8];
        try {
            System.arraycopy(reserve.getBytes("UTF-8"), 0, reserveByte, 0, reserve.length());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        System.arraycopy(reserveByte, 0, this.bodybytes, 33, 8);
    }
}

