/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.protocol;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.protocol.SGIPCommand;
import com.hs.lego.sp.unicom.protocol.SGIPCommandDefine;
import com.hs.lego.sp.unicom.protocol.SGIPHeader;
import java.io.UnsupportedEncodingException;

public class BindResp
extends SGIPCommand {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private byte result;
    private String reserve = "";

    public BindResp(byte[] unicomSN) {
        this.header = new SGIPHeader(SGIPCommandDefine.SGIP_BIND_RESP);
        this.header.setUnicomSN(unicomSN);
        this.bodybytes = new byte[9];
        byte[] reserveByte = new byte[8];
        try {
            System.arraycopy(this.reserve.getBytes("UTF-8"), 0, reserveByte, 0, this.reserve.length());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        System.arraycopy(reserveByte, 0, this.bodybytes, 1, 8);
    }

    public BindResp(SGIPCommand command) {
        this.header = command.header;
        this.bodybytes = command.bodybytes;
        this.result = command.bodybytes[0];
        byte[] reserveBytes = new byte[8];
        System.arraycopy(command.bodybytes, 1, reserveBytes, 0, 8);
        try {
            this.reserve = new String(reserveBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
    }

    public int getResult() {
        return this.result;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setResult(byte result) {
        this.result = result;
        this.bodybytes[0] = result;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }
}

