/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.protocol;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.protocol.Bind;
import com.hs.lego.sp.unicom.protocol.BindResp;
import com.hs.lego.sp.unicom.protocol.SGIPCommandDefine;
import com.hs.lego.sp.unicom.protocol.SGIPHeader;
import com.hs.lego.sp.unicom.protocol.SubmitResp;
import com.hs.lego.sp.unicom.protocol.Unbind;
import com.hs.lego.sp.unicom.protocol.UnbindResp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Locale;

public class SGIPCommand {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    protected SGIPHeader header = new SGIPHeader();
    protected byte[] bodybytes = new byte[0];

    public byte[] getCommandBodybytes(String nodeId) {
        byte[] commandbytes = new byte[20 + this.bodybytes.length];
        System.arraycopy(this.header.getCommandHeadBytes(nodeId), 0, commandbytes, 0, 20);
        System.arraycopy(this.bodybytes, 0, commandbytes, 20, this.header.getTotalmsglen() - 20);
        return commandbytes;
    }

    public void write(OutputStream out, String nodeId) {
        byte[] commandBytes = this.getCommandBodybytes(nodeId);
        try {
            out.write(commandBytes);
            out.flush();
        }
        catch (SocketException e) {
            throw new LegoCheckedException("", (Throwable)e);
        }
        catch (IOException e) {
            throw new LegoCheckedException("", (Throwable)e);
        }
        LOGGER.info((Object)("[" + Thread.currentThread().getName() + "send SP " + SGIPCommandDefine.getCommandName(this.header.getCommandId()) + " command],{length=" + this.header.getTotalmsglen() + ",type= " + SGIPCommand.bytes4ToInt(this.header.getCommandId()) + ",sequence=" + this.header.getSequenceNumber() + "}"));
    }

    public SGIPCommand read(InputStream in) {
        try {
            this.header.readHead(in);
            this.readDataIntoBody(in);
        }
        catch (SocketException e) {
            LOGGER.error((Object)"SGIPCommand read(InputStream in) SocketException", (Throwable)e);
            throw new LegoCheckedException("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"SGIPCommand read(InputStream in) IOException", (Throwable)e);
            throw new LegoCheckedException("", (Throwable)e);
        }
        switch (SGIPCommand.bytes4ToInt(this.header.getCommandId())) {
            case 1: {
                return new Bind(this);
            }
            case -2147483647: {
                return new BindResp(this);
            }
            case 2: {
                return new Unbind(this);
            }
            case -2147483646: {
                return new UnbindResp(this);
            }
            case -2147483645: {
                return new SubmitResp(this);
            }
        }
        return null;
    }

    public void readDataIntoBody(InputStream in) throws IOException {
        this.bodybytes = new byte[this.header.getTotalmsglen() - 20];
        int re = in.read(this.bodybytes);
        LOGGER.info((Object)re);
    }

    public static int byteToInt(byte mybyte) {
        return mybyte;
    }

    public static byte intToByte(int i) {
        return (byte)i;
    }

    public static int bytesToInt(byte[] mybytes) {
        return ((0xFF & mybytes[0]) << 8) + (mybytes[1] & 0xFF);
    }

    public static byte[] intToBytes(int i) {
        byte[] mybytes = new byte[2];
        mybytes[1] = (byte)(0xFF & i);
        mybytes[0] = (byte)((0xFF00 & i) >> 8);
        return mybytes;
    }

    public static byte[] intToBytes4(int i) {
        byte[] mybytes = new byte[4];
        mybytes[3] = (byte)(0xFF & i);
        mybytes[2] = (byte)((0xFF00 & i) >> 8);
        mybytes[1] = (byte)((0xFF0000 & i) >> 16);
        mybytes[0] = (byte)((0xFF000000 & i) >> 24);
        return mybytes;
    }

    public static byte[] longToBytes4(long i) {
        byte[] mybytes = new byte[4];
        mybytes[3] = (byte)(0xFFL & i);
        mybytes[2] = (byte)((0xFF00L & i) >> 8);
        mybytes[1] = (byte)((0xFF0000L & i) >> 16);
        mybytes[0] = (byte)((0xFFFFFFFFFF000000L & i) >> 24);
        return mybytes;
    }

    public static void longToBytes4(long i, byte[] mybytes) {
        mybytes[3] = (byte)(0xFFL & i);
        mybytes[2] = (byte)((0xFF00L & i) >> 8);
        mybytes[1] = (byte)((0xFF0000L & i) >> 16);
        mybytes[0] = (byte)((0xFFFFFFFFFF000000L & i) >> 24);
    }

    public static void intToBytes(int i, byte[] mybytes) {
        mybytes[1] = (byte)(0xFF & i);
        mybytes[0] = (byte)((0xFF00 & i) >> 8);
    }

    public static final String bytesToHexString(byte[] byteArray) {
        StringBuffer sBuffer = new StringBuffer(byteArray.length);
        String sTemp = "";
        for (int i = 0; i < byteArray.length; ++i) {
            sTemp = Integer.toHexString(0xFF & byteArray[i]);
            if (sTemp.length() < 2) {
                sBuffer.append(0);
            }
            sBuffer.append(sTemp.toUpperCase(Locale.US));
        }
        return sBuffer.toString();
    }

    public static void intToBytes4(int i, byte[] mybytes) {
        mybytes[3] = (byte)(0xFF & i);
        mybytes[2] = (byte)((0xFF00 & i) >> 8);
        mybytes[1] = (byte)((0xFF0000 & i) >> 16);
        mybytes[0] = (byte)((0xFF000000 & i) >> 24);
    }

    public static int bytes4ToInt(byte[] mybytes) {
        int flag1 = (0xFF & mybytes[0]) << 24;
        int flag2 = (0xFF & mybytes[1]) << 16;
        int flag3 = (0xFF & mybytes[2]) << 8;
        int flag4 = 0xFF & mybytes[3];
        return flag1 | flag2 | flag3 | flag4;
    }

    public static long bytes4ToLong(byte[] mybytes) {
        int flag1 = (0xFF & mybytes[0]) << 24;
        int flag2 = (0xFF & mybytes[1]) << 16;
        int flag3 = (0xFF & mybytes[2]) << 8;
        int flag4 = 0xFF & mybytes[3];
        return flag1 | flag2 | flag3 | flag4;
    }

    public static void bytesCopy(byte[] source, byte[] dest, int sourcebegin, int sourceend, int destbegin) {
        int j = 0;
        for (int i = sourcebegin; i <= sourceend; ++i) {
            dest[destbegin + j] = source[i];
            ++j;
        }
    }

    public SGIPHeader getHeader() {
        return this.header;
    }

    public void setHeader(SGIPHeader header) {
        this.header = header;
    }

    public byte[] getBodybytes() {
        if (null != this.bodybytes) {
            return (byte[])this.bodybytes.clone();
        }
        return new byte[0];
    }

    public void setBodybytes(byte[] bodybytes) {
        this.bodybytes = (byte[])(null != bodybytes ? (byte[])bodybytes.clone() : null);
    }
}

