/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.protocol;

import com.hs.lego.sp.unicom.protocol.SGIPCommand;

public class SGIPCommandDefine {
    public static final int LEN_SGIP_HEADER = 20;
    public static final int LEN_SGIP_BIND = 41;
    public static final int LEN_SGIP_BIND_RESP = 9;
    public static final int LEN_SGIP_UNBIND = 0;
    public static final int LEN_SGIP_UNBIND_RESP = 0;
    public static final int LEN_SGIP_SUBMIT = 123;
    public static final int LEN_SGIP_SUBMIT_RESP = 9;
    public static final int LEN_SGIP_DELIVER = 57;
    public static final int LEN_SGIP_DELIVER_RESP = 9;
    public static final int LEN_SGIP_REPORT = 44;
    public static final int LEN_SGIP_REPORT_RESP = 9;
    public static final int LEN_SGIP_USERRPT = 51;
    public static final int LEN_SGIP_USERRPT_RESP = 9;
    public static final int LEN_SGIP_TRACE = 41;
    public static final int LEN_SGIP_TRACE_RESP = 48;
    static final byte[] SGIP_BIND = new byte[]{0, 0, 0, 1};
    static final byte[] SGIP_BIND_RESP = new byte[]{-128, 0, 0, 1};
    static final byte[] SGIP_UNBIND = new byte[]{0, 0, 0, 2};
    static final byte[] SGIP_UNBIND_RESP = new byte[]{-128, 0, 0, 2};
    static final byte[] SGIP_SUBMIT = new byte[]{0, 0, 0, 3};
    static final byte[] SGIP_SUBMIT_RESP = new byte[]{-128, 0, 0, 3};
    static final byte[] SGIP_DELIVER = new byte[]{0, 0, 0, 4};
    static final byte[] SGIP_DELIVER_RESP = new byte[]{-128, 0, 0, 4};
    static final byte[] SGIOP_REPORT = new byte[]{0, 0, 0, 5};
    static final byte[] SGIP_REPORT_RESP = new byte[]{-128, 0, 0, 5};
    static final byte[] SGIP_ADDSP = new byte[]{0, 0, 0, 6};
    static final byte[] SGIP_ADDSP_RESP = new byte[]{-128, 0, 0, 6};
    static final byte[] SGIP_MODIFYSP = new byte[]{0, 0, 0, 7};
    static final byte[] SGIP_MODIFYSP_RESP = new byte[]{-128, 0, 0, 7};
    static final byte[] SGIP_DELETESP = new byte[]{0, 0, 0, 8};
    static final byte[] SGIP_DELETESP_RESP = new byte[]{-128, 0, 0, 8};
    static final byte[] SGIP_QUERYROUTE = new byte[]{0, 0, 0, 9};
    static final byte[] SGIP_QUERYROUTE_RESP = new byte[]{-128, 0, 0, 9};
    static final byte[] SGIP_ADDTELESEG = new byte[]{0, 0, 0, 10};
    static final byte[] SGIP_ADDTELESEG_RESP = new byte[]{-128, 0, 0, 10};
    static final byte[] SGIP_MODIFYTELESEG = new byte[]{0, 0, 0, 11};
    static final byte[] SGIP_MODIFYTELESEG_RESP = new byte[]{-128, 0, 0, 11};
    static final byte[] SGIP_DELETETELESEG = new byte[]{0, 0, 0, 12};
    static final byte[] SGIP_DELETETELESEG_RESP = new byte[]{-128, 0, 0, 12};
    static final byte[] SGIP_ADDSMG = new byte[]{0, 0, 0, 13};
    static final byte[] SGIP_ADDSMG_RESP = new byte[]{-128, 0, 0, 13};
    static final byte[] SGIP_MODIFYSMG = new byte[]{0, 0, 0, 14};
    static final byte[] SGIP_MODIFYSMG_RESP = new byte[]{-128, 0, 0, 14};
    static final byte[] SGIP_DELETESMG = new byte[]{0, 0, 0, 15};
    static final byte[] SGIP_DELETESMG_RESP = new byte[]{-128, 0, 0, 15};
    static final byte[] SGIP_CHECKUSER = new byte[]{0, 0, 0, 16};
    static final byte[] SGIP_CHECKUSER_RESP = new byte[]{-128, 0, 0, 16};
    static final byte[] SGIP_USERRPT = new byte[]{0, 0, 0, 17};
    static final byte[] SGIP_USERRPT_RESP = new byte[]{-128, 0, 0, 17};
    static final byte[] SGIP_TRACE = new byte[]{0, 0, 16, 0};
    static final byte[] SGIP_TRACE_RESP = new byte[]{-128, 0, 16, 0};

    public static final String getCommandName(byte[] commandId) {
        switch (SGIPCommand.bytes4ToInt(commandId)) {
            case 1: {
                return "Bind";
            }
            case -2147483647: {
                return "Bind_Resp";
            }
            case 2: {
                return "Unbind";
            }
            case -2147483646: {
                return "Unbind_Resp";
            }
            case 3: {
                return "Submit";
            }
            case -2147483645: {
                return "Submit_Resp";
            }
            case 4: {
                return "Deliver";
            }
            case -2147483644: {
                return "Deliver_Resp";
            }
            case 5: {
                return "Report";
            }
            case -2147483643: {
                return "Report_Resp";
            }
            case 17: {
                return "UserRpt";
            }
            case -2147483631: {
                return "UserRpt_Resp";
            }
        }
        return null;
    }

    public static byte[] getSgipUnbindResp() {
        return (byte[])SGIP_UNBIND_RESP.clone();
    }
}

