/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.protocol;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.protocol.SGIPCommand;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SGIPHeader {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static volatile int sn = 0;
    private static final Object LOCK = new Object();
    private byte[] commandId;
    private int totalmsglen = 0;
    private String sequenceNumber;
    private byte[] unicomSN = null;

    public SGIPHeader(byte[] commandId) {
        if (null != commandId) {
            this.commandId = (byte[])commandId.clone();
            int headLen = 20;
            switch (SGIPCommand.bytes4ToInt(commandId)) {
                case 1: {
                    this.totalmsglen = 61;
                    break;
                }
                case -2147483647: 
                case -2147483645: 
                case -2147483644: 
                case -2147483643: {
                    this.totalmsglen = 29;
                    break;
                }
                case -2147483646: 
                case 2: {
                    this.totalmsglen = 20;
                    break;
                }
                case 3: {
                    this.totalmsglen = 143;
                    break;
                }
                case 4: {
                    this.totalmsglen = 77;
                    break;
                }
                case 5: {
                    this.totalmsglen = 64;
                    break;
                }
                default: {
                    this.totalmsglen = -1;
                    break;
                }
            }
        } else {
            LOGGER.error((Object)"SGIPHeader() error, commandId is null.");
        }
    }

    public SGIPHeader() {
    }

    public void setTotalmsglen(int totalmsglen) {
        this.totalmsglen = totalmsglen;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getTotalmsglen() {
        return this.totalmsglen;
    }

    public void setUnicomSN(byte[] unicomSN) {
        this.unicomSN = (byte[])SGIPHeader.deepClone(unicomSN);
    }

    public byte[] getUnicomSN() {
        return (byte[])SGIPHeader.deepClone(this.unicomSN);
    }

    public byte[] getCommandId() {
        return (byte[])SGIPHeader.deepClone(this.commandId);
    }

    public void setCommandId(byte[] commandId) {
        this.commandId = (byte[])SGIPHeader.deepClone(commandId);
    }

    public byte[] getCommandHeadBytes(String nodeId) {
        int srcnode = new BigInteger(nodeId).intValue();
        byte[] spsrc = SGIPCommand.intToBytes4(srcnode);
        byte[] datecmd = SGIPCommand.intToBytes4(this.getDateCmd());
        byte[] seqnum = SGIPCommand.intToBytes4(this.getSeqNumber());
        byte[] messageLength = SGIPCommand.intToBytes4(this.totalmsglen);
        this.sequenceNumber = nodeId + SGIPCommand.bytes4ToInt(datecmd) + SGIPCommand.bytes4ToInt(seqnum);
        byte[] commandHeadbytes = new byte[20];
        byte[] cmdseq = new byte[12];
        System.arraycopy(messageLength, 0, commandHeadbytes, 0, 4);
        System.arraycopy(this.commandId, 0, commandHeadbytes, 4, 4);
        if (this.unicomSN != null) {
            System.arraycopy(this.unicomSN, 0, cmdseq, 0, 12);
            byte[] tempbytes = new byte[4];
            System.arraycopy(this.unicomSN, 0, tempbytes, 0, 4);
            byte[] srcnodeByte = new byte[5];
            System.arraycopy(tempbytes, 0, srcnodeByte, 1, 4);
            BigInteger src = new BigInteger(srcnodeByte);
            System.arraycopy(this.unicomSN, 4, tempbytes, 0, 4);
            String date = SGIPCommand.bytes4ToInt(tempbytes) + "";
            System.arraycopy(this.unicomSN, 8, tempbytes, 0, 4);
            String num = SGIPCommand.bytes4ToInt(tempbytes) + "";
            this.sequenceNumber = src + date + num;
        } else {
            System.arraycopy(spsrc, 0, cmdseq, 0, 4);
            System.arraycopy(datecmd, 0, cmdseq, 4, 4);
            System.arraycopy(seqnum, 0, cmdseq, 8, 4);
        }
        System.arraycopy(cmdseq, 0, commandHeadbytes, 8, 12);
        return commandHeadbytes;
    }

    public void readHead(InputStream in) throws IOException {
        byte[] tempbytes = new byte[4];
        LOGGER.info((Object)in.read(tempbytes));
        this.totalmsglen = SGIPCommand.bytes4ToInt(tempbytes);
        byte[] commandIdByte = new byte[4];
        LOGGER.info((Object)in.read(commandIdByte));
        this.commandId = commandIdByte;
        this.unicomSN = new byte[12];
        LOGGER.info((Object)in.read(tempbytes));
        byte[] srcnodeByte = new byte[5];
        System.arraycopy(tempbytes, 0, srcnodeByte, 1, 4);
        BigInteger src = new BigInteger(srcnodeByte);
        System.arraycopy(tempbytes, 0, this.unicomSN, 0, 4);
        LOGGER.info((Object)in.read(tempbytes));
        String date = SGIPCommand.bytes4ToInt(tempbytes) + "";
        System.arraycopy(tempbytes, 0, this.unicomSN, 4, 4);
        LOGGER.info((Object)in.read(tempbytes));
        String seqnum = SGIPCommand.bytes4ToInt(tempbytes) + "";
        this.sequenceNumber = src + date + seqnum;
        System.arraycopy(tempbytes, 0, this.unicomSN, 8, 4);
    }

    private int getDateCmd() {
        SimpleDateFormat formate = new SimpleDateFormat("MMddHHmmss");
        String currTime = formate.format(new Date());
        int cmd = new BigInteger(currTime).intValue();
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSeqNumber() {
        Object object = LOCK;
        synchronized (object) {
            if (sn == Integer.MAX_VALUE) {
                sn = 0;
            }
            return ++sn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deepClone(Object obj) {
        Object o = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            if (obj != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ois = new ObjectInputStream(bais);
                o = ois.readObject();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        return o;
    }
}

