/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.protocol;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.protocol.SGIPCommand;
import com.hs.lego.sp.unicom.protocol.SGIPCommandDefine;
import com.hs.lego.sp.unicom.protocol.SGIPException;
import com.hs.lego.sp.unicom.protocol.SGIPHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;

public class Submit
extends SGIPCommand {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private String spNumber;
    private String chargeNumber;
    private byte userCoun;
    private String[] userNumber;
    private String corpId;
    private String serviceType;
    private byte feeType;
    private String feeValue;
    private String givenValue;
    private byte agentFlag;
    private byte morelatetoMTFlag;
    private byte priority;
    private String expireTime;
    private String scheduleTime;
    private byte reportFlag;
    private byte tpPid;
    private byte tpUdhi;
    private byte messageCoding;
    private byte messageType;
    private int messageLength;
    private String messageContent;
    private String linkID;

    public Submit() {
    }

    public Submit(int contentLen) {
    }

    public String getSpNumber() {
        return this.spNumber;
    }

    public void setSpNumber(String spNumbers) {
        this.spNumber = spNumbers;
    }

    public String getChargeNumber() {
        return this.chargeNumber;
    }

    public void setChargeNumber(String chargeNumber) {
        this.chargeNumber = chargeNumber;
    }

    public byte getUserCoun() {
        return this.userCoun;
    }

    public void setUserCoun(byte userCoun) {
        this.userCoun = userCoun;
    }

    public String[] getUserNumber() {
        return (String[])Submit.deepClone(this.userNumber);
    }

    public void setUserNumber(String[] userNumber) {
        this.userNumber = (String[])Submit.deepClone(userNumber);
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public byte getFeeType() {
        return this.feeType;
    }

    public void setFeeType(byte feeType) {
        this.feeType = feeType;
    }

    public String getFeeValue() {
        return this.feeValue;
    }

    public void setFeeValue(String feeValue) {
        this.feeValue = feeValue;
    }

    public String getGivenValue() {
        return this.givenValue;
    }

    public void setGivenValue(String givenValue) {
        this.givenValue = givenValue;
    }

    public byte getAgentFlag() {
        return this.agentFlag;
    }

    public void setAgentFlag(byte agentFlag) {
        this.agentFlag = agentFlag;
    }

    public byte getMorelatetoMTFlag() {
        return this.morelatetoMTFlag;
    }

    public void setMorelatetoMTFlag(byte morelatetoMTFlag) {
        this.morelatetoMTFlag = morelatetoMTFlag;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getScheduleTime() {
        return this.scheduleTime;
    }

    public void setScheduleTime(String scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    public byte getReportFlag() {
        return this.reportFlag;
    }

    public void setReportFlag(byte reportFlag) {
        this.reportFlag = reportFlag;
    }

    public byte getTpPid() {
        return this.tpPid;
    }

    public void setTpPid(byte tpPid) {
        this.tpPid = tpPid;
    }

    public byte getTpUdhi() {
        return this.tpUdhi;
    }

    public void setTpUdhi(byte tpUdhi) {
        this.tpUdhi = tpUdhi;
    }

    public byte getMessageCoding() {
        return this.messageCoding;
    }

    public void setMessageCoding(byte messageCoding) {
        this.messageCoding = messageCoding;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public void setMessageType(byte messageType) {
        this.messageType = messageType;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public String getLinkID() {
        return this.linkID;
    }

    public void setLinkID(String linkID) {
        this.linkID = linkID;
    }

    @Override
    public byte[] getCommandBodybytes(String nodeId) {
        byte[] tempChn = null;
        if (this.messageCoding == 15) {
            try {
                tempChn = this.messageContent.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)e);
            }
            if (null != tempChn) {
                this.messageLength = tempChn.length;
            }
        } else {
            this.messageLength = this.messageContent.length();
        }
        this.header = new SGIPHeader(SGIPCommandDefine.SGIP_SUBMIT);
        this.header.setTotalmsglen(143 + 21 * this.userCoun + this.messageLength);
        this.bodybytes = new byte[this.header.getTotalmsglen() - 20];
        byte[] tempbytes = new byte[21];
        if (this.spNumber.length() > 21) {
            throw new SGIPException(String.valueOf("spNumber Longer than 21 bytes:").concat(String.valueOf(this.spNumber)));
        }
        this.spNumber.getBytes(0, this.spNumber.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 20, 0);
        tempbytes = new byte[21];
        if (this.chargeNumber.length() > 21) {
            throw new SGIPException(String.valueOf("ChargeNumber longer than 21 bytes:").concat(String.valueOf(this.chargeNumber)));
        }
        this.chargeNumber.getBytes(0, this.chargeNumber.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 20, 21);
        this.bodybytes[42] = this.userCoun;
        int currentPos = 43;
        for (int i = 0; i < this.userCoun; ++i) {
            tempbytes = new byte[21];
            String mobile = String.valueOf(this.userNumber[i]);
            if (mobile.length() > 21) {
                throw new SGIPException(String.valueOf("UserNumber longer than 21 bytes:").concat(String.valueOf(mobile)));
            }
            mobile.getBytes(0, mobile.length(), tempbytes, 0);
            Submit.bytesCopy(tempbytes, this.bodybytes, 0, 20, currentPos);
            currentPos += 21;
        }
        tempbytes = new byte[5];
        if (this.corpId.length() > 5) {
            throw new SGIPException(String.valueOf("CorpId longer than 5 bytes:").concat(String.valueOf(this.corpId)));
        }
        this.corpId.getBytes(0, this.corpId.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 4, currentPos);
        currentPos += 5;
        tempbytes = new byte[10];
        if (this.serviceType.length() > 10) {
            throw new SGIPException(String.valueOf("ServiceType longer than 10 bytes:").concat(String.valueOf(this.serviceType)));
        }
        this.serviceType.getBytes(0, this.serviceType.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 9, currentPos);
        this.bodybytes[currentPos += 10] = this.feeType;
        ++currentPos;
        tempbytes = new byte[6];
        if (this.feeValue.length() > 6) {
            throw new SGIPException(String.valueOf("feeValue longer than 6 bytes:").concat(String.valueOf(this.feeValue)));
        }
        this.feeValue.getBytes(0, this.feeValue.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 5, currentPos);
        currentPos += 6;
        tempbytes = new byte[6];
        if (this.givenValue.length() > 6) {
            throw new SGIPException(String.valueOf("GivenValue longer than 6 bytes:").concat(String.valueOf(this.givenValue)));
        }
        this.givenValue.getBytes(0, this.givenValue.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 5, currentPos);
        this.bodybytes[currentPos += 6] = this.agentFlag;
        this.bodybytes[++currentPos] = this.morelatetoMTFlag;
        this.bodybytes[++currentPos] = this.priority;
        ++currentPos;
        tempbytes = new byte[16];
        if (this.expireTime.length() > 16) {
            throw new SGIPException(String.valueOf("EXpireTime longer than 16 bytes:").concat(String.valueOf(this.expireTime)));
        }
        this.expireTime.getBytes(0, this.expireTime.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 15, currentPos);
        currentPos += 16;
        tempbytes = new byte[16];
        if (this.scheduleTime.length() > 16) {
            throw new SGIPException(String.valueOf("ScheduleTime longer than 16 bytes:").concat(String.valueOf(this.scheduleTime)));
        }
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 15, currentPos);
        this.bodybytes[currentPos += 16] = this.reportFlag;
        this.bodybytes[++currentPos] = this.tpPid;
        this.bodybytes[++currentPos] = this.tpUdhi;
        this.bodybytes[++currentPos] = this.messageCoding;
        this.bodybytes[++currentPos] = this.messageType;
        Submit.bytesCopy(Submit.intToBytes4(this.messageLength), this.bodybytes, 0, 3, ++currentPos);
        currentPos += 4;
        if (this.messageCoding == 15) {
            Submit.bytesCopy(tempChn, this.bodybytes, 0, this.messageLength - 1, currentPos);
        } else {
            this.messageContent.getBytes(0, this.messageLength, this.bodybytes, currentPos);
        }
        currentPos += this.messageLength;
        tempbytes = new byte[8];
        if (this.linkID.length() > 8) {
            throw new SGIPException(String.valueOf("linkid longer than 8 bytes:").concat(String.valueOf(this.linkID)));
        }
        this.linkID.getBytes(0, this.linkID.length(), tempbytes, 0);
        Submit.bytesCopy(tempbytes, this.bodybytes, 0, 7, currentPos);
        return super.getCommandBodybytes(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deepClone(Object obj) {
        Object o = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            if (obj != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ois = new ObjectInputStream(bais);
                o = ois.readObject();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        return o;
    }
}

