/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.sdk.service.IAticSmsService;
import com.hs.lego.sp.unicom.config.SGIPConfig;
import com.hs.lego.sp.unicom.util.SGIPXmlQueue;
import com.hs.lego.sp.unicom.util.WriteOptLog;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public class AticSmsSgipServiceImpl
implements IAticSmsService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    @Override
    public void send(String[] smsTo, String message) {
        this.sendSms(smsTo, message, 0L);
    }

    @Override
    public void sendTestSms(String[] smsTo, String message, long smsId) {
        this.sendSms(smsTo, message, smsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSms(String[] smsTo, String message, long smsId) {
        AticSmsSgipServiceImpl aticSmsSgipServiceImpl = this;
        synchronized (aticSmsSgipServiceImpl) {
            while (!SGIPConfig.isReadOver()) {
                LOGGER.info((Object)"send message waiting read config file over \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7");
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"wait exception.", (Throwable)e);
                }
            }
        }
        if (null == smsTo || smsTo.length <= 0) {
            LOGGER.info((Object)"smsTo is null or empty.");
            return;
        }
        try {
            String commandId = String.valueOf(System.currentTimeMillis());
            StringBuffer msgBodyXml = new StringBuffer("");
            msgBodyXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            msgBodyXml.append("<gwsmip>\n");
            msgBodyXml.append("<message_header>\n");
            msgBodyXml.append("<command_id>" + commandId + "</command_id>\n");
            msgBodyXml.append("<sequence_number/>\n");
            msgBodyXml.append("</message_header>\n");
            msgBodyXml.append("<message_body>\n");
            msgBodyXml.append("<sms_id>\n");
            msgBodyXml.append(smsId);
            msgBodyXml.append("</sms_id>\n");
            msgBodyXml.append("<pk_total>1</pk_total>\n");
            msgBodyXml.append("<pk_number>1</pk_number>\n");
            msgBodyXml.append("<user_numbers>\n");
            int j = smsTo.length;
            for (int i = 0; i < j; ++i) {
                String phoneNum = "";
                phoneNum = smsTo[i].startsWith("+") ? smsTo[i].substring(1, smsTo[i].length()) : smsTo[i];
                msgBodyXml.append("<user_number>" + phoneNum + "</user_number>\n");
            }
            msgBodyXml.append("</user_numbers>\n");
            msgBodyXml.append("<sp_number>" + SGIPConfig.getSpNumber() + "</sp_number>\n");
            msgBodyXml.append("<service_type>" + SGIPConfig.getServiceType() + "</service_type>\n");
            msgBodyXml.append("<message_content>" + new String(Base64.encodeBase64((byte[])message.getBytes("GB2312")), "GB2312") + "</message_content>\n");
            msgBodyXml.append("<report_flag>2</report_flag>\n");
            msgBodyXml.append("</message_body>\n");
            msgBodyXml.append("</gwsmip>\n");
            LOGGER.debug((Object)("greate a new sgip msgBodyXml : " + msgBodyXml.toString()));
            SGIPXmlQueue.addSGIPXml(msgBodyXml.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"UnsupportedEncodingException", (Throwable)e);
        }
        catch (RuntimeException e) {
            WriteOptLog.writeLog(smsTo, 0, 1, -1);
            LOGGER.error((Object)"OutputStream message to local exception-------------------------------------------", (Throwable)e);
        }
    }

    @Override
    public boolean disConnect() {
        return false;
    }

    @Override
    public int getSpType() {
        return 3;
    }
}

