/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.unicom.sdk.model.UnicomSpConfig;
import com.hs.lego.core.sp.unicom.sdk.service.IUnicomSmsService;
import com.hs.lego.nem.fault.sdk.service.ISmsServerService;
import com.hs.lego.sp.unicom.config.SGIPConfig;

public class UnicomSmsServiceImpl
implements IUnicomSmsService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    @Override
    public UnicomSpConfig getUnicomSpConfig() {
        UnicomSpConfig unicomSpConfig = new UnicomSpConfig();
        unicomSpConfig.setChargeNumber(SGIPConfig.getChargeNumber());
        unicomSpConfig.setCorpId(SGIPConfig.getCorpId());
        unicomSpConfig.setLinkId(SGIPConfig.getLinkID());
        unicomSpConfig.setLocalIp(SGIPConfig.getLocalIp());
        unicomSpConfig.setLoginName(SGIPConfig.getLoginName());
        unicomSpConfig.setLoginPassword(SGIPConfig.getLoginPassword());
        unicomSpConfig.setNodeId(SGIPConfig.getNodeID());
        unicomSpConfig.setServiceType(SGIPConfig.getServiceType());
        unicomSpConfig.setSpNumber(SGIPConfig.getSpNumber());
        unicomSpConfig.setUnicomIp(SGIPConfig.getUnicomIp());
        unicomSpConfig.setUnicomPort(SGIPConfig.getUnicomPort());
        unicomSpConfig.setTestPhone(SGIPConfig.getTestPhone());
        return unicomSpConfig;
    }

    @Override
    public boolean modifyUnicomSpConfig(UnicomSpConfig unicomConfig) {
        try {
            SGIPConfig.writeConfFile(unicomConfig);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"modifyUnicomSpConfig exception.", (Throwable)e);
            return false;
        }
    }

    @Override
    public int testSendSms(UnicomSpConfig unicomConfig) {
        ServiceContext context = ServiceContext.getInstance();
        ISmsServerService smsServerService = (ISmsServerService)context.getService("smsServerService", ISmsServerService.class);
        if (null == smsServerService) {
            return -1;
        }
        return smsServerService.testSendSms(unicomConfig);
    }
}

