/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.util;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.sp.unicom.protocol.Submit;
import com.hs.lego.sp.unicom.util.MTReq;
import com.hs.lego.sp.unicom.util.SPSender;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class ClientReqMonitor {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final int LISTEN_PORT = 8805;
    private static List<String> commandIdList = new ArrayList<String>();
    private ServerSocket reqsvrSocket = null;
    private SPSender sender;

    public ClientReqMonitor(Map<String, Submit> savedMap) {
        try {
            this.reqsvrSocket = ServerSocketFactory.getDefault().createServerSocket(8805);
            this.sender = SPSender.getInstance(savedMap);
            LOGGER.info((Object)"the sgip server start , listen port :8805");
        }
        catch (IOException e) {
            LOGGER.error((Object)"launch local server error!", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }

    public void recsvr() {
        while (true) {
            Socket reqSocket = null;
            try {
                reqSocket = this.reqsvrSocket.accept();
                LOGGER.info((Object)("New connection accepted" + reqSocket.getInetAddress() + ":" + reqSocket.getPort()));
                Thread workThread = new Thread(new Handler(reqSocket));
                workThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                workThread.start();
                continue;
            }
            catch (IOException e) {
                LOGGER.error((Object)"wait client socket error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static boolean isMsgSended(String commandId) {
        if (!commandIdList.isEmpty()) {
            int j = commandIdList.size();
            for (int i = 0; i < j; ++i) {
                if (!commandIdList.get(i).equals(commandId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeCommandId(String commandId) {
        commandIdList.remove(commandId);
    }

    class Handler
    implements Runnable {
        private Socket socket;
        private InputStream socketIn;
        private OutputStream socketout;

        public Handler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                LOGGER.info((Object)"--------------------ClientReqMonitor-----------------------");
                this.socketIn = this.socket.getInputStream();
                this.socketout = this.socket.getOutputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.socketIn, "UTF-8"));
                int character = 0;
                StringBuffer xmlBuffer = new StringBuffer();
                ArrayList<String> mtreqList = new ArrayList<String>();
                boolean startFlag = false;
                boolean endFlag = false;
                while (this.socket.isConnected() && !this.socket.isClosed()) {
                    if (!reader.ready()) {
                        TimeUnit.MILLISECONDS.sleep(5L);
                        continue;
                    }
                    while (reader.ready() && (character = reader.read()) != -1) {
                        char c = (char)character;
                        if (c == '{') {
                            startFlag = true;
                            continue;
                        }
                        if (c == '}') {
                            LOGGER.info((Object)(xmlBuffer.toString() + "---------------------xmlBuffer"));
                            endFlag = true;
                            mtreqList.add(xmlBuffer.toString());
                            startFlag = false;
                            endFlag = false;
                            xmlBuffer.setLength(0);
                        }
                        if (!startFlag || endFlag) continue;
                        xmlBuffer.append(c);
                    }
                    if (mtreqList.size() <= 0) continue;
                    SAXReader sax = new SAXReader();
                    Document doc = null;
                    for (int i = 0; i < mtreqList.size(); ++i) {
                        String xmldoc = (String)mtreqList.get(i);
                        try {
                            LOGGER.debug((Object)("MT request package :\n" + xmldoc));
                            doc = sax.read((InputStream)new ByteArrayInputStream(xmldoc.getBytes("UTF-8")));
                        }
                        catch (IOException e) {
                            throw new LegoCheckedException("", (Throwable)e);
                        }
                        catch (DocumentException e) {
                            this.sendDocerr(e.getMessage());
                            throw new LegoCheckedException("", (Throwable)e);
                        }
                        MTReq mtreq = new MTReq(doc);
                        int j = commandIdList.size();
                        for (int m = 0; m < j; ++m) {
                            LOGGER.info((Object)("commandIdList " + m + "--------------------------" + (String)commandIdList.get(m)));
                        }
                        if (ClientReqMonitor.isMsgSended(mtreq.getCommandId())) continue;
                        ClientReqMonitor.this.sender.addTask(mtreq);
                        commandIdList.add(mtreq.getCommandId());
                        LOGGER.info((Object)"sender.addTask(mtreq)");
                    }
                    mtreqList.clear();
                }
                LOGGER.info((Object)("ClientReqMonitor socket.isClosed-------------------------" + this.socket.isClosed()));
                LOGGER.info((Object)("ClientReqMonitor socket.isConnected-------------------------" + this.socket.isConnected()));
            }
            catch (IOException e) {
                LOGGER.error((Object)"take over client MT request IOStream exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"take over client MT request thread exception", (Throwable)e);
            }
        }

        public void sendDocerr(String errorInfo) {
            if (null == this.socketout) {
                return;
            }
            try {
                this.socketout.write(errorInfo.getBytes("UTF-8"));
                this.socketout.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)"send xml doc format error", (Throwable)e);
            }
        }
    }
}

