/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.sp.unicom.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.Element;

public class MTReq {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private String spNumber;
    private String serviceType;
    private ArrayList<String> phoneList;
    private String messageContent;
    private String reportFlag;
    private String linkId;
    private String commandId;
    private String smsId;

    public MTReq() {
    }

    public MTReq(Document doc) {
        Element root = doc.getRootElement();
        Element messageHeader = root.element("message_header");
        this.setCommandId(messageHeader.element("command_id").getTextTrim());
        Element messageBody = root.element("message_body");
        this.setSmsId(messageBody.element("sms_id").getTextTrim());
        this.setSpNumber(messageBody.element("sp_number").getTextTrim());
        this.setServiceType(messageBody.element("service_type").getTextTrim());
        this.setReportFlag(messageBody.element("report_flag").getTextTrim());
        String messageContents = messageBody.element("message_content").getTextTrim();
        try {
            this.setMessageContent(new String(Base64.decodeBase64((byte[])messageContents.getBytes("GB2312")), "GB2312"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        List list = messageBody.element("user_numbers").elements();
        ArrayList<String> phoneLists = new ArrayList<String>();
        for (Element element : list) {
            if (element.getTextTrim().length() < 2 || !element.getTextTrim().substring(0, 2).equals("86")) {
                phoneLists.add("86" + element.getTextTrim());
                continue;
            }
            phoneLists.add(element.getTextTrim());
        }
        this.setPhoneList(phoneLists);
        this.setLinkId("00000000");
        if (messageBody.elementText("link_id") != null) {
            this.setLinkId(messageBody.element("link_id").getTextTrim());
        }
    }

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getSpNumber() {
        return this.spNumber;
    }

    public void setSpNumber(String spNumber) {
        this.spNumber = spNumber;
    }

    public ArrayList<String> getPhoneList() {
        return this.phoneList;
    }

    public void setPhoneList(ArrayList<String> phoneList) {
        this.phoneList = phoneList;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public String getReportFlag() {
        return this.reportFlag;
    }

    public void setReportFlag(String reportFlag) {
        if (reportFlag.equals("0")) {
            this.reportFlag = "2";
        }
        this.reportFlag = reportFlag;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getSmsId() {
        return this.smsId;
    }

    public void setSmsId(String smsId) {
        this.smsId = smsId;
    }

    public String toXmlstr() {
        String phonexml = "";
        StringBuffer buf = new StringBuffer();
        buf.append(phonexml);
        for (int i = 0; i < this.getPhoneList().size(); ++i) {
            buf.append("       <user_number>" + this.getPhoneList().get(i) + "</user_number>\n");
        }
        phonexml = buf.toString();
        String xmlbody = "";
        try {
            xmlbody = "{<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gwsmip>\n  <message_header>\n    <command_id>0x3</command_id>\n    <sequence_number/>\n  </message_header>\n  <message_body>\n    <pk_total>1</pk_total>\n    <pk_number>1</pk_number>\n    <user_numbers>\n" + phonexml + "    </user_numbers>\n" + "    <sp_number>" + this.getSpNumber() + "</sp_number>\n" + "    <service_type>" + this.getServiceType() + "</service_type>\n" + (this.getLinkId() != null ? "    <link_id>" + this.getLinkId() + "</link_id>\n" : "") + "    <message_content>" + Arrays.toString(Base64.decodeBase64((byte[])this.getMessageContent().getBytes("UTF-8"))) + "</message_content>\n" + "    <report_flag>" + this.getReportFlag() + "</report_flag>\n" + "   </message_body>\n" + "</gwsmip>\n}";
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e);
        }
        return xmlbody;
    }
}

